/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator;

import org.apache.druid.server.coordinator.AutoCompactionSnapshot;
import org.junit.Assert;
import org.junit.Test;

public class AutoCompactionSnapshotTest {
    @Test
    public void testAutoCompactionSnapshotBuilder() {
        String expectedDataSource = "data";
        AutoCompactionSnapshot.AutoCompactionScheduleStatus expectedStatus = AutoCompactionSnapshot.AutoCompactionScheduleStatus.RUNNING;
        AutoCompactionSnapshot.Builder builder = new AutoCompactionSnapshot.Builder("data", expectedStatus);
        for (int i = 0; i < 2; ++i) {
            builder.incrementIntervalCountSkipped(13L);
            builder.incrementBytesSkipped(13L);
            builder.incrementSegmentCountSkipped(13L);
            builder.incrementIntervalCountCompacted(13L);
            builder.incrementBytesCompacted(13L);
            builder.incrementSegmentCountCompacted(13L);
            builder.incrementIntervalCountAwaitingCompaction(13L);
            builder.incrementBytesAwaitingCompaction(13L);
            builder.incrementSegmentCountAwaitingCompaction(13L);
        }
        AutoCompactionSnapshot actual = builder.build();
        Assert.assertNotNull((Object)actual);
        Assert.assertEquals((long)26L, (long)actual.getSegmentCountSkipped());
        Assert.assertEquals((long)26L, (long)actual.getIntervalCountSkipped());
        Assert.assertEquals((long)26L, (long)actual.getBytesSkipped());
        Assert.assertEquals((long)26L, (long)actual.getBytesCompacted());
        Assert.assertEquals((long)26L, (long)actual.getIntervalCountCompacted());
        Assert.assertEquals((long)26L, (long)actual.getSegmentCountCompacted());
        Assert.assertEquals((long)26L, (long)actual.getBytesAwaitingCompaction());
        Assert.assertEquals((long)26L, (long)actual.getIntervalCountAwaitingCompaction());
        Assert.assertEquals((long)26L, (long)actual.getSegmentCountAwaitingCompaction());
        Assert.assertEquals((Object)AutoCompactionSnapshot.AutoCompactionScheduleStatus.RUNNING, (Object)actual.getScheduleStatus());
        Assert.assertEquals((Object)"data", (Object)actual.getDataSource());
        AutoCompactionSnapshot expected = new AutoCompactionSnapshot("data", AutoCompactionSnapshot.AutoCompactionScheduleStatus.RUNNING, 26L, 26L, 26L, 26L, 26L, 26L, 26L, 26L, 26L);
        Assert.assertEquals((Object)expected, (Object)actual);
    }
}

