/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.partition.NumberedShardSpec;
import org.apache.druid.timeline.partition.ShardSpec;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class CreateDataSegments {
    private static final DateTime DEFAULT_START = DateTimes.of((String)"2012-10-24");
    private final String datasource;
    private DateTime startTime = DEFAULT_START;
    private Granularity granularity = Granularities.DAY;
    private int numPartitions = 1;
    private int numIntervals = 1;

    public static CreateDataSegments ofDatasource(String datasource) {
        return new CreateDataSegments(datasource);
    }

    private CreateDataSegments(String datasource) {
        this.datasource = datasource;
    }

    public CreateDataSegments forIntervals(int numIntervals, Granularity intervalSize) {
        this.numIntervals = numIntervals;
        this.granularity = intervalSize;
        return this;
    }

    public CreateDataSegments startingAt(String startOfFirstInterval) {
        this.startTime = DateTimes.of((String)startOfFirstInterval);
        return this;
    }

    public CreateDataSegments startingAt(long startOfFirstInterval) {
        this.startTime = DateTimes.utc((long)startOfFirstInterval);
        return this;
    }

    public CreateDataSegments withNumPartitions(int numPartitions) {
        this.numPartitions = numPartitions;
        return this;
    }

    public List<DataSegment> eachOfSizeInMb(long sizeMb) {
        boolean isEternityInterval = Objects.equals(this.granularity, Granularities.ALL);
        if (isEternityInterval) {
            this.numIntervals = 1;
        }
        int uniqueIdInInterval = 0;
        DateTime nextStart = this.startTime;
        ArrayList<NumberedDataSegment> segments = new ArrayList<NumberedDataSegment>();
        for (int numInterval = 0; numInterval < this.numIntervals; ++numInterval) {
            Interval nextInterval = isEternityInterval ? Intervals.ETERNITY : new Interval((ReadableInstant)nextStart, (ReadableInstant)this.granularity.increment(nextStart));
            for (int numPartition = 0; numPartition < this.numPartitions; ++numPartition) {
                segments.add(new NumberedDataSegment(this.datasource, nextInterval, new NumberedShardSpec(numPartition, this.numPartitions), ++uniqueIdInInterval, sizeMb << 20));
            }
            nextStart = this.granularity.increment(nextStart);
        }
        return Collections.unmodifiableList(segments);
    }

    private static class NumberedDataSegment
    extends DataSegment {
        private static final DateTimeFormatter FORMATTER = DateTimeFormat.forPattern((String)"yyyyMMdd");
        private final int uniqueId;

        private NumberedDataSegment(String datasource, Interval interval, NumberedShardSpec shardSpec, int uinqueId, long size) {
            super(datasource, interval, "1", Collections.emptyMap(), Collections.emptyList(), Collections.emptyList(), (ShardSpec)shardSpec, Integer.valueOf(9), size);
            this.uniqueId = uinqueId;
        }

        public String toString() {
            return "{" + this.getDataSource() + "::" + this.getInterval().getStart().toString(FORMATTER) + "::" + this.uniqueId + "}";
        }
    }
}

