/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator;

import org.apache.druid.server.coordinator.CoordinatorCompactionConfig;
import org.apache.druid.server.coordinator.DataSourceCompactionConfigAuditEntry;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class DataSourceCompactionConfigAuditEntryTest {
    private static final double COMPACTION_TASK_SLOT_RATIO = 0.1;
    private static final int MAX_COMPACTION_SLOTS = 9;
    private static final boolean USE_AUTO_SCALE_SLOTS = true;
    @Mock
    private CoordinatorCompactionConfig coordinatorCompactionConfig;

    @Before
    public void setUp() {
        Mockito.when((Object)this.coordinatorCompactionConfig.getCompactionTaskSlotRatio()).thenReturn((Object)0.1);
        Mockito.when((Object)this.coordinatorCompactionConfig.getMaxCompactionTaskSlots()).thenReturn((Object)9);
        Mockito.when((Object)this.coordinatorCompactionConfig.isUseAutoScaleSlots()).thenReturn((Object)true);
    }

    @Test
    public void testhasSameConfigWithSameBaseConfigShouldReturnTrue() {
        DataSourceCompactionConfigAuditEntry.GlobalCompactionConfig config = new DataSourceCompactionConfigAuditEntry.GlobalCompactionConfig(0.1, 9, true);
        Assert.assertTrue((boolean)config.hasSameConfig(this.coordinatorCompactionConfig));
    }

    @Test
    public void testhasSameConfigWithDifferentUseAutoScaleSlotsShouldReturnFalse() {
        DataSourceCompactionConfigAuditEntry.GlobalCompactionConfig config = new DataSourceCompactionConfigAuditEntry.GlobalCompactionConfig(0.1, 9, false);
        Assert.assertFalse((boolean)config.hasSameConfig(this.coordinatorCompactionConfig));
    }

    @Test
    public void testhasSameConfigWithDifferentMaxCompactionSlotsShouldReturnFalse() {
        DataSourceCompactionConfigAuditEntry.GlobalCompactionConfig config = new DataSourceCompactionConfigAuditEntry.GlobalCompactionConfig(0.1, 10, true);
        Assert.assertFalse((boolean)config.hasSameConfig(this.coordinatorCompactionConfig));
    }

    @Test
    public void testhasSameConfigWithDifferentCompactionSlotRatioShouldReturnFalse() {
        DataSourceCompactionConfigAuditEntry.GlobalCompactionConfig config = new DataSourceCompactionConfigAuditEntry.GlobalCompactionConfig(0.07, 9, true);
        Assert.assertFalse((boolean)config.hasSameConfig(this.coordinatorCompactionConfig));
    }
}

