/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator;

import com.google.common.collect.ImmutableList;
import org.apache.druid.audit.AuditInfo;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.server.coordinator.CoordinatorCompactionConfig;
import org.apache.druid.server.coordinator.DataSourceCompactionConfig;
import org.apache.druid.server.coordinator.DataSourceCompactionConfigAuditEntry;
import org.apache.druid.server.coordinator.DataSourceCompactionConfigHistory;
import org.joda.time.DateTime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class DataSourceCompactionConfigHistoryTest {
    private static final String DATASOURCE = "DATASOURCE";
    private static final String DATASOURCE_2 = "DATASOURCE_2";
    private static final String DATASOURCE_NOT_EXISTS = "DATASOURCE_NOT_EXISTS";
    private static final double COMPACTION_TASK_SLOT_RATIO = 0.1;
    private static final int MAX_COMPACTION_TASK_SLOTS = 9;
    private static final boolean USE_AUTO_SCALE_SLOTS = false;
    private static final DateTime AUDIT_TIME = DateTimes.of((int)2023, (int)1, (int)13, (int)9, (int)0);
    private static final DateTime AUDIT_TIME_2 = DateTimes.of((int)2023, (int)1, (int)13, (int)9, (int)30);
    private static final DateTime AUDIT_TIME_3 = DateTimes.of((int)2023, (int)1, (int)13, (int)10, (int)0);
    @Mock
    private CoordinatorCompactionConfig compactionConfig;
    @Mock(answer=Answers.RETURNS_MOCKS)
    private DataSourceCompactionConfig configForDataSource;
    @Mock(answer=Answers.RETURNS_MOCKS)
    private DataSourceCompactionConfig configForDataSourceWithChange;
    @Mock(answer=Answers.RETURNS_MOCKS)
    private DataSourceCompactionConfig configForDataSource2;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private AuditInfo auditInfo;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private AuditInfo auditInfo2;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private AuditInfo auditInfo3;
    private DataSourceCompactionConfigHistory target;

    @Before
    public void setUp() {
        Mockito.when((Object)this.compactionConfig.getCompactionTaskSlotRatio()).thenReturn((Object)0.1);
        Mockito.when((Object)this.compactionConfig.getMaxCompactionTaskSlots()).thenReturn((Object)9);
        Mockito.when((Object)this.compactionConfig.isUseAutoScaleSlots()).thenReturn((Object)false);
        Mockito.when((Object)this.configForDataSource.getDataSource()).thenReturn((Object)DATASOURCE);
        Mockito.when((Object)this.configForDataSourceWithChange.getDataSource()).thenReturn((Object)DATASOURCE);
        Mockito.when((Object)this.configForDataSource2.getDataSource()).thenReturn((Object)DATASOURCE_2);
        Mockito.when((Object)this.compactionConfig.getCompactionConfigs()).thenReturn((Object)ImmutableList.of((Object)this.configForDataSource, (Object)this.configForDataSource2));
        this.target = new DataSourceCompactionConfigHistory(DATASOURCE);
    }

    @Test
    public void testAddCompactionConfigShouldAddToHistory() {
        this.target.add(this.compactionConfig, this.auditInfo, AUDIT_TIME);
        Assert.assertEquals((long)1L, (long)this.target.getHistory().size());
        DataSourceCompactionConfigAuditEntry auditEntry = (DataSourceCompactionConfigAuditEntry)this.target.getHistory().get(0);
        Assert.assertEquals((Object)DATASOURCE, (Object)auditEntry.getCompactionConfig().getDataSource());
        Assert.assertEquals((Object)this.auditInfo, (Object)auditEntry.getAuditInfo());
        Assert.assertEquals((Object)AUDIT_TIME, (Object)auditEntry.getAuditTime());
    }

    @Test
    public void testAddAndDeleteCompactionConfigShouldAddBothToHistory() {
        this.target.add(this.compactionConfig, this.auditInfo, AUDIT_TIME);
        Mockito.when((Object)this.compactionConfig.getCompactionConfigs()).thenReturn((Object)ImmutableList.of((Object)this.configForDataSource2));
        this.target.add(this.compactionConfig, this.auditInfo2, AUDIT_TIME_2);
        Assert.assertEquals((long)2L, (long)this.target.getHistory().size());
        DataSourceCompactionConfigAuditEntry auditEntry = (DataSourceCompactionConfigAuditEntry)this.target.getHistory().get(0);
        Assert.assertEquals((Object)DATASOURCE, (Object)auditEntry.getCompactionConfig().getDataSource());
        Assert.assertEquals((Object)this.auditInfo, (Object)auditEntry.getAuditInfo());
        Assert.assertEquals((Object)AUDIT_TIME, (Object)auditEntry.getAuditTime());
        auditEntry = (DataSourceCompactionConfigAuditEntry)this.target.getHistory().get(1);
        Assert.assertEquals(null, (Object)auditEntry.getCompactionConfig());
        Assert.assertEquals((Object)this.auditInfo2, (Object)auditEntry.getAuditInfo());
        Assert.assertEquals((Object)AUDIT_TIME_2, (Object)auditEntry.getAuditTime());
    }

    @Test
    public void testAddAndDeleteAnotherCompactionConfigShouldNotAddToHistory() {
        this.target.add(this.compactionConfig, this.auditInfo, AUDIT_TIME);
        Mockito.when((Object)this.compactionConfig.getCompactionConfigs()).thenReturn((Object)ImmutableList.of((Object)this.configForDataSource));
        this.target.add(this.compactionConfig, this.auditInfo2, AUDIT_TIME_2);
        Assert.assertEquals((long)1L, (long)this.target.getHistory().size());
        DataSourceCompactionConfigAuditEntry auditEntry = (DataSourceCompactionConfigAuditEntry)this.target.getHistory().get(0);
        Assert.assertEquals((Object)DATASOURCE, (Object)auditEntry.getCompactionConfig().getDataSource());
        Assert.assertEquals((Object)this.auditInfo, (Object)auditEntry.getAuditInfo());
        Assert.assertEquals((Object)AUDIT_TIME, (Object)auditEntry.getAuditTime());
    }

    @Test
    public void testAddDeletedAddCompactionConfigShouldAddAllToHistory() {
        this.target.add(this.compactionConfig, this.auditInfo, AUDIT_TIME);
        Mockito.when((Object)this.compactionConfig.getCompactionConfigs()).thenReturn((Object)ImmutableList.of((Object)this.configForDataSource2));
        this.target.add(this.compactionConfig, this.auditInfo2, AUDIT_TIME_2);
        Mockito.when((Object)this.compactionConfig.getCompactionConfigs()).thenReturn((Object)ImmutableList.of((Object)this.configForDataSourceWithChange, (Object)this.configForDataSource2));
        this.target.add(this.compactionConfig, this.auditInfo3, AUDIT_TIME_3);
        Assert.assertEquals((long)3L, (long)this.target.getHistory().size());
        DataSourceCompactionConfigAuditEntry auditEntry = (DataSourceCompactionConfigAuditEntry)this.target.getHistory().get(0);
        Assert.assertEquals((Object)DATASOURCE, (Object)auditEntry.getCompactionConfig().getDataSource());
        Assert.assertEquals((Object)this.auditInfo, (Object)auditEntry.getAuditInfo());
        Assert.assertEquals((Object)AUDIT_TIME, (Object)auditEntry.getAuditTime());
        auditEntry = (DataSourceCompactionConfigAuditEntry)this.target.getHistory().get(2);
        Assert.assertEquals((Object)this.configForDataSourceWithChange, (Object)auditEntry.getCompactionConfig());
        Assert.assertEquals((Object)this.auditInfo3, (Object)auditEntry.getAuditInfo());
        Assert.assertEquals((Object)AUDIT_TIME_3, (Object)auditEntry.getAuditTime());
    }

    @Test
    public void testAddAndChangeCompactionConfigShouldAddBothToHistory() {
        this.target.add(this.compactionConfig, this.auditInfo, AUDIT_TIME);
        Mockito.when((Object)this.compactionConfig.getCompactionConfigs()).thenReturn((Object)ImmutableList.of((Object)this.configForDataSourceWithChange));
        this.target.add(this.compactionConfig, this.auditInfo2, AUDIT_TIME_2);
        Assert.assertEquals((long)2L, (long)this.target.getHistory().size());
        DataSourceCompactionConfigAuditEntry auditEntry = (DataSourceCompactionConfigAuditEntry)this.target.getHistory().get(0);
        Assert.assertEquals((Object)DATASOURCE, (Object)auditEntry.getCompactionConfig().getDataSource());
        Assert.assertEquals((Object)this.auditInfo, (Object)auditEntry.getAuditInfo());
        Assert.assertEquals((Object)AUDIT_TIME, (Object)auditEntry.getAuditTime());
        auditEntry = (DataSourceCompactionConfigAuditEntry)this.target.getHistory().get(1);
        Assert.assertEquals((Object)DATASOURCE, (Object)auditEntry.getCompactionConfig().getDataSource());
        Assert.assertEquals((Object)this.auditInfo2, (Object)auditEntry.getAuditInfo());
        Assert.assertEquals((Object)AUDIT_TIME_2, (Object)auditEntry.getAuditTime());
    }

    @Test
    public void testAddAndChangeGlobalSettingsShouldAddTwice() {
        this.target.add(this.compactionConfig, this.auditInfo, AUDIT_TIME);
        int newMaxTaskSlots = 8;
        Mockito.when((Object)this.compactionConfig.getMaxCompactionTaskSlots()).thenReturn((Object)newMaxTaskSlots);
        this.target.add(this.compactionConfig, this.auditInfo2, AUDIT_TIME_2);
        Assert.assertEquals((long)2L, (long)this.target.getHistory().size());
        DataSourceCompactionConfigAuditEntry auditEntry = (DataSourceCompactionConfigAuditEntry)this.target.getHistory().get(0);
        Assert.assertEquals((Object)DATASOURCE, (Object)auditEntry.getCompactionConfig().getDataSource());
        Assert.assertEquals((Object)this.auditInfo, (Object)auditEntry.getAuditInfo());
        Assert.assertEquals((Object)AUDIT_TIME, (Object)auditEntry.getAuditTime());
        Assert.assertEquals((long)9L, (long)auditEntry.getGlobalConfig().getMaxCompactionTaskSlots());
        auditEntry = (DataSourceCompactionConfigAuditEntry)this.target.getHistory().get(1);
        Assert.assertEquals((Object)DATASOURCE, (Object)auditEntry.getCompactionConfig().getDataSource());
        Assert.assertEquals((Object)this.auditInfo2, (Object)auditEntry.getAuditInfo());
        Assert.assertEquals((Object)AUDIT_TIME_2, (Object)auditEntry.getAuditTime());
        Assert.assertEquals((long)newMaxTaskSlots, (long)auditEntry.getGlobalConfig().getMaxCompactionTaskSlots());
    }

    @Test
    public void testAddCompactionConfigDoesNotHaveDataSourceWithNoHistoryShouldNotAdd() {
        this.target = new DataSourceCompactionConfigHistory(DATASOURCE_NOT_EXISTS);
        this.target.add(this.compactionConfig, this.auditInfo, AUDIT_TIME);
        Assert.assertTrue((boolean)this.target.getHistory().isEmpty());
    }
}

