/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import org.apache.curator.framework.api.ChildrenDeletable;
import org.apache.curator.framework.recipes.cache.PathChildrenCache;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheEvent;
import org.apache.druid.client.BatchServerInventoryView;
import org.apache.druid.client.DataSourcesSnapshot;
import org.apache.druid.client.DruidDataSource;
import org.apache.druid.client.DruidServer;
import org.apache.druid.client.ImmutableDruidDataSource;
import org.apache.druid.client.ImmutableDruidServer;
import org.apache.druid.client.ServerInventoryView;
import org.apache.druid.common.config.JacksonConfigManager;
import org.apache.druid.curator.CuratorTestBase;
import org.apache.druid.curator.CuratorUtils;
import org.apache.druid.curator.discovery.LatchableServiceAnnouncer;
import org.apache.druid.curator.discovery.ServiceAnnouncer;
import org.apache.druid.discovery.DruidLeaderSelector;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.java.util.common.concurrent.ScheduledExecutorFactory;
import org.apache.druid.java.util.common.concurrent.ScheduledExecutors;
import org.apache.druid.java.util.emitter.core.Event;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.metadata.MetadataRuleManager;
import org.apache.druid.metadata.SegmentsMetadataManager;
import org.apache.druid.server.DruidNode;
import org.apache.druid.server.coordination.ServerType;
import org.apache.druid.server.coordinator.CoordinatorCompactionConfig;
import org.apache.druid.server.coordinator.CoordinatorConfigManager;
import org.apache.druid.server.coordinator.CoordinatorDynamicConfig;
import org.apache.druid.server.coordinator.DruidCoordinator;
import org.apache.druid.server.coordinator.DruidCoordinatorConfig;
import org.apache.druid.server.coordinator.MetadataManager;
import org.apache.druid.server.coordinator.TestDruidCoordinatorConfig;
import org.apache.druid.server.coordinator.balancer.BalancerStrategyFactory;
import org.apache.druid.server.coordinator.balancer.CostBalancerStrategyFactory;
import org.apache.druid.server.coordinator.compact.CompactionSegmentSearchPolicy;
import org.apache.druid.server.coordinator.compact.NewestSegmentFirstPolicy;
import org.apache.druid.server.coordinator.duty.CompactSegments;
import org.apache.druid.server.coordinator.duty.CoordinatorCustomDuty;
import org.apache.druid.server.coordinator.duty.CoordinatorCustomDutyGroup;
import org.apache.druid.server.coordinator.duty.CoordinatorCustomDutyGroups;
import org.apache.druid.server.coordinator.duty.KillSupervisorsCustomDuty;
import org.apache.druid.server.coordinator.loading.CuratorLoadQueuePeon;
import org.apache.druid.server.coordinator.loading.LoadQueuePeon;
import org.apache.druid.server.coordinator.loading.LoadQueueTaskMaster;
import org.apache.druid.server.coordinator.loading.SegmentLoadQueueManager;
import org.apache.druid.server.coordinator.rules.ForeverBroadcastDistributionRule;
import org.apache.druid.server.coordinator.rules.ForeverLoadRule;
import org.apache.druid.server.coordinator.rules.IntervalLoadRule;
import org.apache.druid.server.lookup.cache.LookupCoordinatorManager;
import org.apache.druid.timeline.DataSegment;
import org.easymock.EasyMock;
import org.joda.time.Duration;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DruidCoordinatorTest
extends CuratorTestBase {
    private static final String LOADPATH = "/druid/loadqueue/localhost:1234";
    private static final long COORDINATOR_START_DELAY = 1L;
    private static final long COORDINATOR_PERIOD = 100L;
    private DruidCoordinator coordinator;
    private SegmentsMetadataManager segmentsMetadataManager;
    private DataSourcesSnapshot dataSourcesSnapshot;
    private BatchServerInventoryView serverInventoryView;
    private ScheduledExecutorFactory scheduledExecutorFactory;
    private DruidServer druidServer;
    private LoadQueuePeon loadQueuePeon;
    private LoadQueueTaskMaster loadQueueTaskMaster;
    private MetadataRuleManager metadataRuleManager;
    private CountDownLatch leaderAnnouncerLatch;
    private CountDownLatch leaderUnannouncerLatch;
    private PathChildrenCache pathChildrenCache;
    private DruidCoordinatorConfig druidCoordinatorConfig;
    private ObjectMapper objectMapper;
    private DruidNode druidNode;
    private NewestSegmentFirstPolicy newestSegmentFirstPolicy;
    private final LatchableServiceEmitter serviceEmitter = new LatchableServiceEmitter();

    @Before
    public void setUp() throws Exception {
        this.druidServer = new DruidServer("from", "from", null, 5L, ServerType.HISTORICAL, "tier1", 0);
        this.serverInventoryView = (BatchServerInventoryView)EasyMock.createMock(BatchServerInventoryView.class);
        this.segmentsMetadataManager = (SegmentsMetadataManager)EasyMock.createNiceMock(SegmentsMetadataManager.class);
        this.dataSourcesSnapshot = (DataSourcesSnapshot)EasyMock.createNiceMock(DataSourcesSnapshot.class);
        this.metadataRuleManager = (MetadataRuleManager)EasyMock.createNiceMock(MetadataRuleManager.class);
        this.loadQueueTaskMaster = (LoadQueueTaskMaster)EasyMock.createMock(LoadQueueTaskMaster.class);
        JacksonConfigManager configManager = (JacksonConfigManager)EasyMock.createNiceMock(JacksonConfigManager.class);
        EasyMock.expect((Object)configManager.watch((String)EasyMock.eq((Object)"coordinator.config"), (Class)EasyMock.anyObject(Class.class), EasyMock.anyObject())).andReturn(new AtomicReference<CoordinatorDynamicConfig>(CoordinatorDynamicConfig.builder().build())).anyTimes();
        EasyMock.expect((Object)configManager.watch((String)EasyMock.eq((Object)"coordinator.compaction.config"), (Class)EasyMock.anyObject(Class.class), EasyMock.anyObject())).andReturn(new AtomicReference<CoordinatorCompactionConfig>(CoordinatorCompactionConfig.empty())).anyTimes();
        EasyMock.replay((Object[])new Object[]{configManager});
        this.setupServerAndCurator();
        this.curator.start();
        this.curator.blockUntilConnected();
        this.curator.create().creatingParentsIfNeeded().forPath(LOADPATH);
        this.objectMapper = new DefaultObjectMapper();
        this.newestSegmentFirstPolicy = new NewestSegmentFirstPolicy(this.objectMapper);
        this.druidCoordinatorConfig = new TestDruidCoordinatorConfig.Builder().withCoordinatorStartDelay(new Duration(1L)).withCoordinatorPeriod(new Duration(100L)).build();
        this.pathChildrenCache = new PathChildrenCache(this.curator, LOADPATH, true, true, Execs.singleThreaded((String)"coordinator_test_path_children_cache-%d"));
        this.loadQueuePeon = new CuratorLoadQueuePeon(this.curator, LOADPATH, this.objectMapper, Execs.scheduledSingleThreaded((String)"coordinator_test_load_queue_peon_scheduled-%d"), Execs.singleThreaded((String)"coordinator_test_load_queue_peon-%d"), this.druidCoordinatorConfig);
        this.loadQueuePeon.start();
        this.druidNode = new DruidNode("hey", "what", false, Integer.valueOf(1234), null, true, false);
        this.scheduledExecutorFactory = ScheduledExecutors::fixed;
        this.leaderAnnouncerLatch = new CountDownLatch(1);
        this.leaderUnannouncerLatch = new CountDownLatch(1);
        this.coordinator = new DruidCoordinator(this.druidCoordinatorConfig, this.createMetadataManager(configManager), (ServerInventoryView)this.serverInventoryView, (ServiceEmitter)this.serviceEmitter, this.scheduledExecutorFactory, null, this.loadQueueTaskMaster, new SegmentLoadQueueManager((ServerInventoryView)this.serverInventoryView, this.loadQueueTaskMaster), (ServiceAnnouncer)new LatchableServiceAnnouncer(this.leaderAnnouncerLatch, this.leaderUnannouncerLatch), this.druidNode, new CoordinatorCustomDutyGroups((Set)ImmutableSet.of()), (BalancerStrategyFactory)new CostBalancerStrategyFactory(), (LookupCoordinatorManager)EasyMock.createNiceMock(LookupCoordinatorManager.class), (DruidLeaderSelector)new TestDruidLeaderSelector(), null);
    }

    private MetadataManager createMetadataManager(JacksonConfigManager configManager) {
        return new MetadataManager(null, new CoordinatorConfigManager(configManager, null, null), this.segmentsMetadataManager, null, this.metadataRuleManager, null);
    }

    @After
    public void tearDown() throws Exception {
        this.loadQueuePeon.stop();
        this.pathChildrenCache.close();
        this.tearDownServerAndCurator();
    }

    @Test(timeout=60000L)
    public void testCoordinatorRun() throws Exception {
        String dataSource = "dataSource1";
        String tier = "hot";
        ForeverLoadRule foreverLoadRule = new ForeverLoadRule((Map)ImmutableMap.of((Object)tier, (Object)2), null);
        EasyMock.expect((Object)this.metadataRuleManager.getRulesWithDefault(EasyMock.anyString())).andReturn((Object)ImmutableList.of((Object)foreverLoadRule)).atLeastOnce();
        this.metadataRuleManager.stop();
        EasyMock.expectLastCall().once();
        EasyMock.replay((Object[])new Object[]{this.metadataRuleManager});
        DruidDataSource[] dataSources = new DruidDataSource[]{new DruidDataSource(dataSource, Collections.emptyMap())};
        DataSegment dataSegment = new DataSegment(dataSource, Intervals.of((String)"2010-01-01/P1D"), "v1", null, null, null, null, Integer.valueOf(9), 0L);
        dataSources[0].addSegment(dataSegment);
        this.setupSegmentsMetadataMock(dataSources[0]);
        ImmutableDruidDataSource immutableDruidDataSource = (ImmutableDruidDataSource)EasyMock.createNiceMock(ImmutableDruidDataSource.class);
        EasyMock.expect((Object)immutableDruidDataSource.getSegments()).andReturn((Object)ImmutableSet.of((Object)dataSegment)).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{immutableDruidDataSource});
        this.druidServer = new DruidServer("server1", "localhost", null, 5L, ServerType.HISTORICAL, tier, 0);
        this.setupPeons(Collections.singletonMap("server1", this.loadQueuePeon));
        EasyMock.expect((Object)this.serverInventoryView.getInventory()).andReturn((Object)ImmutableList.of((Object)this.druidServer)).atLeastOnce();
        EasyMock.expect((Object)this.serverInventoryView.isStarted()).andReturn((Object)true).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.serverInventoryView, this.loadQueueTaskMaster});
        this.coordinator.start();
        Assert.assertNull((Object)this.coordinator.getReplicationFactor(dataSegment.getId()));
        this.leaderAnnouncerLatch.await();
        Assert.assertTrue((boolean)this.coordinator.isLeader());
        Assert.assertEquals((Object)this.druidNode.getHostAndPort(), (Object)this.coordinator.getCurrentLeader());
        this.pathChildrenCache.start();
        CountDownLatch assignSegmentLatch = this.createCountDownLatchAndSetPathChildrenCacheListenerWithLatch(1, this.pathChildrenCache, (Map<String, DataSegment>)ImmutableMap.of((Object)"2010-01-01T00:00:00.000Z_2010-01-02T00:00:00.000Z", (Object)dataSegment), this.druidServer);
        assignSegmentLatch.await();
        CountDownLatch coordinatorRunLatch = new CountDownLatch(2);
        this.serviceEmitter.latch = coordinatorRunLatch;
        coordinatorRunLatch.await();
        Assert.assertEquals((Object)ImmutableMap.of((Object)dataSource, (Object)100.0), (Object)this.coordinator.getDatasourceToLoadStatus());
        Object2IntMap numsUnavailableUsedSegmentsPerDataSource = this.coordinator.getDatasourceToUnavailableSegmentCount();
        Assert.assertEquals((long)1L, (long)numsUnavailableUsedSegmentsPerDataSource.size());
        Assert.assertEquals((long)0L, (long)numsUnavailableUsedSegmentsPerDataSource.getInt((Object)dataSource));
        Map underReplicationCountsPerDataSourcePerTier = this.coordinator.getTierToDatasourceToUnderReplicatedCount(false);
        Assert.assertNotNull((Object)underReplicationCountsPerDataSourcePerTier);
        Assert.assertEquals((long)1L, (long)underReplicationCountsPerDataSourcePerTier.size());
        Object2LongMap underRepliicationCountsPerDataSource = (Object2LongMap)underReplicationCountsPerDataSourcePerTier.get(tier);
        Assert.assertNotNull((Object)underRepliicationCountsPerDataSource);
        Assert.assertEquals((long)1L, (long)underRepliicationCountsPerDataSource.size());
        Assert.assertNotNull((Object)underRepliicationCountsPerDataSource.get((Object)dataSource));
        Assert.assertEquals((long)1L, (long)underRepliicationCountsPerDataSource.getLong((Object)dataSource));
        Map underReplicationCountsPerDataSourcePerTierUsingClusterView = this.coordinator.getTierToDatasourceToUnderReplicatedCount(true);
        Assert.assertNotNull((Object)underReplicationCountsPerDataSourcePerTier);
        Assert.assertEquals((long)1L, (long)underReplicationCountsPerDataSourcePerTier.size());
        Object2LongMap underRepliicationCountsPerDataSourceUsingClusterView = (Object2LongMap)underReplicationCountsPerDataSourcePerTierUsingClusterView.get(tier);
        Assert.assertNotNull((Object)underRepliicationCountsPerDataSourceUsingClusterView);
        Assert.assertEquals((long)1L, (long)underRepliicationCountsPerDataSourceUsingClusterView.size());
        Assert.assertNotNull((Object)underRepliicationCountsPerDataSourceUsingClusterView.get((Object)dataSource));
        Assert.assertEquals((long)0L, (long)underRepliicationCountsPerDataSourceUsingClusterView.getLong((Object)dataSource));
        Assert.assertEquals((Object)2, (Object)this.coordinator.getReplicationFactor(dataSegment.getId()));
        this.coordinator.stop();
        this.leaderUnannouncerLatch.await();
        Assert.assertFalse((boolean)this.coordinator.isLeader());
        Assert.assertNull((Object)this.coordinator.getCurrentLeader());
        EasyMock.verify((Object[])new Object[]{this.serverInventoryView});
        EasyMock.verify((Object[])new Object[]{this.metadataRuleManager});
    }

    @Test(timeout=60000L)
    public void testCoordinatorTieredRun() throws Exception {
        String dataSource = "dataSource";
        String hotTierName = "hot";
        String coldTierName = "cold";
        IntervalLoadRule hotTier = new IntervalLoadRule(Intervals.of((String)"2018-01-01/P1M"), (Map)ImmutableMap.of((Object)"hot", (Object)1), null);
        ForeverLoadRule coldTier = new ForeverLoadRule((Map)ImmutableMap.of((Object)"cold", (Object)1), null);
        String loadPathCold = "/druid/loadqueue/cold:1234";
        DruidServer hotServer = new DruidServer("hot", "hot", null, 5L, ServerType.HISTORICAL, "hot", 0);
        DruidServer coldServer = new DruidServer("cold", "cold", null, 5L, ServerType.HISTORICAL, "cold", 0);
        ImmutableMap dataSegments = ImmutableMap.of((Object)"2018-01-02T00:00:00.000Z_2018-01-03T00:00:00.000Z", (Object)new DataSegment("dataSource", Intervals.of((String)"2018-01-02/P1D"), "v1", null, null, null, null, Integer.valueOf(9), 0L), (Object)"2018-01-03T00:00:00.000Z_2018-01-04T00:00:00.000Z", (Object)new DataSegment("dataSource", Intervals.of((String)"2018-01-03/P1D"), "v1", null, null, null, null, Integer.valueOf(9), 0L), (Object)"2017-01-01T00:00:00.000Z_2017-01-02T00:00:00.000Z", (Object)new DataSegment("dataSource", Intervals.of((String)"2017-01-01/P1D"), "v1", null, null, null, null, Integer.valueOf(9), 0L));
        CuratorLoadQueuePeon loadQueuePeonCold = new CuratorLoadQueuePeon(this.curator, "/druid/loadqueue/cold:1234", this.objectMapper, Execs.scheduledSingleThreaded((String)"coordinator_test_load_queue_peon_cold_scheduled-%d"), Execs.singleThreaded((String)"coordinator_test_load_queue_peon_cold-%d"), this.druidCoordinatorConfig);
        PathChildrenCache pathChildrenCacheCold = new PathChildrenCache(this.curator, "/druid/loadqueue/cold:1234", true, true, Execs.singleThreaded((String)"coordinator_test_path_children_cache_cold-%d"));
        this.setupPeons((Map<String, LoadQueuePeon>)ImmutableMap.of((Object)"hot", (Object)this.loadQueuePeon, (Object)"cold", (Object)loadQueuePeonCold));
        loadQueuePeonCold.start();
        this.pathChildrenCache.start();
        pathChildrenCacheCold.start();
        DruidDataSource[] druidDataSources = new DruidDataSource[]{new DruidDataSource("dataSource", Collections.emptyMap())};
        dataSegments.values().forEach(arg_0 -> ((DruidDataSource)druidDataSources[0]).addSegment(arg_0));
        this.setupSegmentsMetadataMock(druidDataSources[0]);
        EasyMock.expect((Object)this.metadataRuleManager.getRulesWithDefault(EasyMock.anyString())).andReturn((Object)ImmutableList.of((Object)hotTier, (Object)coldTier)).atLeastOnce();
        EasyMock.expect((Object)this.serverInventoryView.getInventory()).andReturn((Object)ImmutableList.of((Object)hotServer, (Object)coldServer)).atLeastOnce();
        EasyMock.expect((Object)this.serverInventoryView.isStarted()).andReturn((Object)true).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.metadataRuleManager, this.serverInventoryView, this.loadQueueTaskMaster});
        this.coordinator.start();
        this.leaderAnnouncerLatch.await();
        CountDownLatch assignSegmentLatchHot = this.createCountDownLatchAndSetPathChildrenCacheListenerWithLatch(2, this.pathChildrenCache, (Map<String, DataSegment>)dataSegments, hotServer);
        CountDownLatch assignSegmentLatchCold = this.createCountDownLatchAndSetPathChildrenCacheListenerWithLatch(1, pathChildrenCacheCold, (Map<String, DataSegment>)dataSegments, coldServer);
        assignSegmentLatchHot.await();
        assignSegmentLatchCold.await();
        CountDownLatch coordinatorRunLatch = new CountDownLatch(2);
        this.serviceEmitter.latch = coordinatorRunLatch;
        coordinatorRunLatch.await();
        Assert.assertEquals((Object)ImmutableMap.of((Object)"dataSource", (Object)100.0), (Object)this.coordinator.getDatasourceToLoadStatus());
        Map underReplicationCountsPerDataSourcePerTier = this.coordinator.getTierToDatasourceToUnderReplicatedCount(false);
        Assert.assertEquals((long)2L, (long)underReplicationCountsPerDataSourcePerTier.size());
        Assert.assertEquals((long)0L, (long)((Object2LongMap)underReplicationCountsPerDataSourcePerTier.get("hot")).getLong((Object)"dataSource"));
        Assert.assertEquals((long)0L, (long)((Object2LongMap)underReplicationCountsPerDataSourcePerTier.get("cold")).getLong((Object)"dataSource"));
        Map underReplicationCountsPerDataSourcePerTierUsingClusterView = this.coordinator.getTierToDatasourceToUnderReplicatedCount(true);
        Assert.assertEquals((long)2L, (long)underReplicationCountsPerDataSourcePerTierUsingClusterView.size());
        Assert.assertEquals((long)0L, (long)((Object2LongMap)underReplicationCountsPerDataSourcePerTierUsingClusterView.get("hot")).getLong((Object)"dataSource"));
        Assert.assertEquals((long)0L, (long)((Object2LongMap)underReplicationCountsPerDataSourcePerTierUsingClusterView.get("cold")).getLong((Object)"dataSource"));
        dataSegments.values().forEach(dataSegment -> Assert.assertEquals((Object)1, (Object)this.coordinator.getReplicationFactor(dataSegment.getId())));
        this.coordinator.stop();
        this.leaderUnannouncerLatch.await();
        EasyMock.verify((Object[])new Object[]{this.serverInventoryView});
        EasyMock.verify((Object[])new Object[]{this.segmentsMetadataManager});
        EasyMock.verify((Object[])new Object[]{this.metadataRuleManager});
    }

    @Test(timeout=60000L)
    public void testComputeUnderReplicationCountsPerDataSourcePerTierForSegmentsWithBroadcastRule() throws Exception {
        String dataSource = "dataSource";
        String hotTierName = "hot";
        String coldTierName = "cold";
        String tierName1 = "tier1";
        String tierName2 = "tier2";
        String loadPathCold = "/druid/loadqueue/cold:1234";
        String loadPathBroker1 = "/druid/loadqueue/broker1:1234";
        String loadPathBroker2 = "/druid/loadqueue/broker2:1234";
        String loadPathPeon = "/druid/loadqueue/peon:1234";
        DruidServer hotServer = new DruidServer("hot", "hot", null, 5L, ServerType.HISTORICAL, "hot", 0);
        DruidServer coldServer = new DruidServer("cold", "cold", null, 5L, ServerType.HISTORICAL, "cold", 0);
        DruidServer brokerServer1 = new DruidServer("broker1", "broker1", null, 5L, ServerType.BROKER, "tier1", 0);
        DruidServer brokerServer2 = new DruidServer("broker2", "broker2", null, 5L, ServerType.BROKER, "tier2", 0);
        DruidServer peonServer = new DruidServer("peon", "peon", null, 5L, ServerType.INDEXER_EXECUTOR, "tier2", 0);
        ImmutableMap dataSegments = ImmutableMap.of((Object)"2018-01-02T00:00:00.000Z_2018-01-03T00:00:00.000Z", (Object)new DataSegment("dataSource", Intervals.of((String)"2018-01-02/P1D"), "v1", null, null, null, null, Integer.valueOf(9), 0L), (Object)"2018-01-03T00:00:00.000Z_2018-01-04T00:00:00.000Z", (Object)new DataSegment("dataSource", Intervals.of((String)"2018-01-03/P1D"), "v1", null, null, null, null, Integer.valueOf(9), 0L), (Object)"2017-01-01T00:00:00.000Z_2017-01-02T00:00:00.000Z", (Object)new DataSegment("dataSource", Intervals.of((String)"2017-01-01/P1D"), "v1", null, null, null, null, Integer.valueOf(9), 0L));
        CuratorLoadQueuePeon loadQueuePeonCold = new CuratorLoadQueuePeon(this.curator, "/druid/loadqueue/cold:1234", this.objectMapper, Execs.scheduledSingleThreaded((String)"coordinator_test_load_queue_peon_cold_scheduled-%d"), Execs.singleThreaded((String)"coordinator_test_load_queue_peon_cold-%d"), this.druidCoordinatorConfig);
        CuratorLoadQueuePeon loadQueuePeonBroker1 = new CuratorLoadQueuePeon(this.curator, "/druid/loadqueue/broker1:1234", this.objectMapper, Execs.scheduledSingleThreaded((String)"coordinator_test_load_queue_peon_broker1_scheduled-%d"), Execs.singleThreaded((String)"coordinator_test_load_queue_peon_broker1-%d"), this.druidCoordinatorConfig);
        CuratorLoadQueuePeon loadQueuePeonBroker2 = new CuratorLoadQueuePeon(this.curator, "/druid/loadqueue/broker2:1234", this.objectMapper, Execs.scheduledSingleThreaded((String)"coordinator_test_load_queue_peon_broker2_scheduled-%d"), Execs.singleThreaded((String)"coordinator_test_load_queue_peon_broker2-%d"), this.druidCoordinatorConfig);
        CuratorLoadQueuePeon loadQueuePeonPoenServer = new CuratorLoadQueuePeon(this.curator, "/druid/loadqueue/peon:1234", this.objectMapper, Execs.scheduledSingleThreaded((String)"coordinator_test_load_queue_peon_peon_scheduled-%d"), Execs.singleThreaded((String)"coordinator_test_load_queue_peon_peon-%d"), this.druidCoordinatorConfig);
        PathChildrenCache pathChildrenCacheCold = new PathChildrenCache(this.curator, "/druid/loadqueue/cold:1234", true, true, Execs.singleThreaded((String)"coordinator_test_path_children_cache_cold-%d"));
        PathChildrenCache pathChildrenCacheBroker1 = new PathChildrenCache(this.curator, "/druid/loadqueue/broker1:1234", true, true, Execs.singleThreaded((String)"coordinator_test_path_children_cache_broker1-%d"));
        PathChildrenCache pathChildrenCacheBroker2 = new PathChildrenCache(this.curator, "/druid/loadqueue/broker2:1234", true, true, Execs.singleThreaded((String)"coordinator_test_path_children_cache_broker2-%d"));
        PathChildrenCache pathChildrenCachePeon = new PathChildrenCache(this.curator, "/druid/loadqueue/peon:1234", true, true, Execs.singleThreaded((String)"coordinator_test_path_children_cache_peon-%d"));
        this.setupPeons((Map<String, LoadQueuePeon>)ImmutableMap.of((Object)"hot", (Object)this.loadQueuePeon, (Object)"cold", (Object)loadQueuePeonCold, (Object)"broker1", (Object)loadQueuePeonBroker1, (Object)"broker2", (Object)loadQueuePeonBroker2, (Object)"peon", (Object)loadQueuePeonPoenServer));
        loadQueuePeonCold.start();
        loadQueuePeonBroker1.start();
        loadQueuePeonBroker2.start();
        loadQueuePeonPoenServer.start();
        this.pathChildrenCache.start();
        pathChildrenCacheCold.start();
        pathChildrenCacheBroker1.start();
        pathChildrenCacheBroker2.start();
        pathChildrenCachePeon.start();
        DruidDataSource druidDataSource = new DruidDataSource("dataSource", Collections.emptyMap());
        dataSegments.values().forEach(arg_0 -> ((DruidDataSource)druidDataSource).addSegment(arg_0));
        this.setupSegmentsMetadataMock(druidDataSource);
        ForeverBroadcastDistributionRule broadcastDistributionRule = new ForeverBroadcastDistributionRule();
        EasyMock.expect((Object)this.metadataRuleManager.getRulesWithDefault(EasyMock.anyString())).andReturn((Object)ImmutableList.of((Object)broadcastDistributionRule)).atLeastOnce();
        EasyMock.expect((Object)this.serverInventoryView.getInventory()).andReturn((Object)ImmutableList.of((Object)hotServer, (Object)coldServer, (Object)brokerServer1, (Object)brokerServer2, (Object)peonServer)).atLeastOnce();
        EasyMock.expect((Object)this.serverInventoryView.isStarted()).andReturn((Object)true).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.metadataRuleManager, this.serverInventoryView, this.loadQueueTaskMaster});
        this.coordinator.start();
        this.leaderAnnouncerLatch.await();
        CountDownLatch assignSegmentLatchHot = this.createCountDownLatchAndSetPathChildrenCacheListenerWithLatch(3, this.pathChildrenCache, (Map<String, DataSegment>)dataSegments, hotServer);
        CountDownLatch assignSegmentLatchCold = this.createCountDownLatchAndSetPathChildrenCacheListenerWithLatch(3, pathChildrenCacheCold, (Map<String, DataSegment>)dataSegments, coldServer);
        CountDownLatch assignSegmentLatchBroker1 = this.createCountDownLatchAndSetPathChildrenCacheListenerWithLatch(3, pathChildrenCacheBroker1, (Map<String, DataSegment>)dataSegments, brokerServer1);
        CountDownLatch assignSegmentLatchBroker2 = this.createCountDownLatchAndSetPathChildrenCacheListenerWithLatch(3, pathChildrenCacheBroker2, (Map<String, DataSegment>)dataSegments, brokerServer2);
        CountDownLatch assignSegmentLatchPeon = this.createCountDownLatchAndSetPathChildrenCacheListenerWithLatch(3, pathChildrenCachePeon, (Map<String, DataSegment>)dataSegments, peonServer);
        assignSegmentLatchHot.await();
        assignSegmentLatchCold.await();
        assignSegmentLatchBroker1.await();
        assignSegmentLatchBroker2.await();
        assignSegmentLatchPeon.await();
        CountDownLatch coordinatorRunLatch = new CountDownLatch(2);
        this.serviceEmitter.latch = coordinatorRunLatch;
        coordinatorRunLatch.await();
        Assert.assertEquals((Object)ImmutableMap.of((Object)"dataSource", (Object)100.0), (Object)this.coordinator.getDatasourceToLoadStatus());
        Map underReplicationCountsPerDataSourcePerTier = this.coordinator.getTierToDatasourceToUnderReplicatedCount(false);
        Assert.assertEquals((long)4L, (long)underReplicationCountsPerDataSourcePerTier.size());
        Assert.assertEquals((long)0L, (long)((Object2LongMap)underReplicationCountsPerDataSourcePerTier.get("hot")).getLong((Object)"dataSource"));
        Assert.assertEquals((long)0L, (long)((Object2LongMap)underReplicationCountsPerDataSourcePerTier.get("cold")).getLong((Object)"dataSource"));
        Assert.assertEquals((long)0L, (long)((Object2LongMap)underReplicationCountsPerDataSourcePerTier.get("tier1")).getLong((Object)"dataSource"));
        Assert.assertEquals((long)0L, (long)((Object2LongMap)underReplicationCountsPerDataSourcePerTier.get("tier2")).getLong((Object)"dataSource"));
        Map underReplicationCountsPerDataSourcePerTierUsingClusterView = this.coordinator.getTierToDatasourceToUnderReplicatedCount(true);
        Assert.assertEquals((long)4L, (long)underReplicationCountsPerDataSourcePerTierUsingClusterView.size());
        Assert.assertEquals((long)0L, (long)((Object2LongMap)underReplicationCountsPerDataSourcePerTierUsingClusterView.get("hot")).getLong((Object)"dataSource"));
        Assert.assertEquals((long)0L, (long)((Object2LongMap)underReplicationCountsPerDataSourcePerTierUsingClusterView.get("cold")).getLong((Object)"dataSource"));
        Assert.assertEquals((long)0L, (long)((Object2LongMap)underReplicationCountsPerDataSourcePerTierUsingClusterView.get("tier1")).getLong((Object)"dataSource"));
        Assert.assertEquals((long)0L, (long)((Object2LongMap)underReplicationCountsPerDataSourcePerTierUsingClusterView.get("tier2")).getLong((Object)"dataSource"));
        this.coordinator.stop();
        this.leaderUnannouncerLatch.await();
        EasyMock.verify((Object[])new Object[]{this.serverInventoryView});
        EasyMock.verify((Object[])new Object[]{this.segmentsMetadataManager});
        EasyMock.verify((Object[])new Object[]{this.metadataRuleManager});
    }

    @Test
    public void testCompactSegmentsDutyWhenCustomDutyGroupEmpty() {
        CoordinatorCustomDutyGroups emptyCustomDutyGroups = new CoordinatorCustomDutyGroups((Set)ImmutableSet.of());
        this.coordinator = new DruidCoordinator(this.druidCoordinatorConfig, this.createMetadataManager(null), (ServerInventoryView)this.serverInventoryView, (ServiceEmitter)this.serviceEmitter, this.scheduledExecutorFactory, null, this.loadQueueTaskMaster, null, (ServiceAnnouncer)new LatchableServiceAnnouncer(this.leaderAnnouncerLatch, this.leaderUnannouncerLatch), this.druidNode, emptyCustomDutyGroups, (BalancerStrategyFactory)new CostBalancerStrategyFactory(), (LookupCoordinatorManager)EasyMock.createNiceMock(LookupCoordinatorManager.class), (DruidLeaderSelector)new TestDruidLeaderSelector(), null);
        List indexingDuties = this.coordinator.makeIndexingServiceDuties();
        Assert.assertTrue((boolean)indexingDuties.stream().anyMatch(coordinatorDuty -> coordinatorDuty instanceof CompactSegments));
        List compactSegmentsDutyFromCustomGroups = this.coordinator.getCompactSegmentsDutyFromCustomGroups();
        Assert.assertTrue((boolean)compactSegmentsDutyFromCustomGroups.isEmpty());
        CompactSegments duty = this.coordinator.initializeCompactSegmentsDuty((CompactionSegmentSearchPolicy)this.newestSegmentFirstPolicy);
        Assert.assertNotNull((Object)duty);
    }

    @Test
    public void testInitializeCompactSegmentsDutyWhenCustomDutyGroupDoesNotContainsCompactSegments() {
        CoordinatorCustomDutyGroup group = new CoordinatorCustomDutyGroup("group1", Duration.standardSeconds((long)1L), (List)ImmutableList.of((Object)new KillSupervisorsCustomDuty(new Duration((Object)"PT1S"), null, this.druidCoordinatorConfig)));
        CoordinatorCustomDutyGroups customDutyGroups = new CoordinatorCustomDutyGroups((Set)ImmutableSet.of((Object)group));
        this.coordinator = new DruidCoordinator(this.druidCoordinatorConfig, this.createMetadataManager(null), (ServerInventoryView)this.serverInventoryView, (ServiceEmitter)this.serviceEmitter, this.scheduledExecutorFactory, null, this.loadQueueTaskMaster, null, (ServiceAnnouncer)new LatchableServiceAnnouncer(this.leaderAnnouncerLatch, this.leaderUnannouncerLatch), this.druidNode, customDutyGroups, (BalancerStrategyFactory)new CostBalancerStrategyFactory(), (LookupCoordinatorManager)EasyMock.createNiceMock(LookupCoordinatorManager.class), (DruidLeaderSelector)new TestDruidLeaderSelector(), null);
        List indexingDuties = this.coordinator.makeIndexingServiceDuties();
        Assert.assertTrue((boolean)indexingDuties.stream().anyMatch(coordinatorDuty -> coordinatorDuty instanceof CompactSegments));
        List compactSegmentsDutyFromCustomGroups = this.coordinator.getCompactSegmentsDutyFromCustomGroups();
        Assert.assertTrue((boolean)compactSegmentsDutyFromCustomGroups.isEmpty());
        CompactSegments duty = this.coordinator.initializeCompactSegmentsDuty((CompactionSegmentSearchPolicy)this.newestSegmentFirstPolicy);
        Assert.assertNotNull((Object)duty);
    }

    @Test
    public void testInitializeCompactSegmentsDutyWhenCustomDutyGroupContainsCompactSegments() {
        CoordinatorCustomDutyGroup compactSegmentCustomGroup = new CoordinatorCustomDutyGroup("group1", Duration.standardSeconds((long)1L), (List)ImmutableList.of((Object)new CompactSegments(null, null)));
        CoordinatorCustomDutyGroups customDutyGroups = new CoordinatorCustomDutyGroups((Set)ImmutableSet.of((Object)compactSegmentCustomGroup));
        this.coordinator = new DruidCoordinator(this.druidCoordinatorConfig, this.createMetadataManager(null), (ServerInventoryView)this.serverInventoryView, (ServiceEmitter)this.serviceEmitter, this.scheduledExecutorFactory, null, this.loadQueueTaskMaster, null, (ServiceAnnouncer)new LatchableServiceAnnouncer(this.leaderAnnouncerLatch, this.leaderUnannouncerLatch), this.druidNode, customDutyGroups, (BalancerStrategyFactory)new CostBalancerStrategyFactory(), (LookupCoordinatorManager)EasyMock.createNiceMock(LookupCoordinatorManager.class), (DruidLeaderSelector)new TestDruidLeaderSelector(), null);
        List indexingDuties = this.coordinator.makeIndexingServiceDuties();
        Assert.assertTrue((boolean)indexingDuties.stream().noneMatch(coordinatorDuty -> coordinatorDuty instanceof CompactSegments));
        List compactSegmentsDutyFromCustomGroups = this.coordinator.getCompactSegmentsDutyFromCustomGroups();
        Assert.assertFalse((boolean)compactSegmentsDutyFromCustomGroups.isEmpty());
        Assert.assertEquals((long)1L, (long)compactSegmentsDutyFromCustomGroups.size());
        Assert.assertNotNull(compactSegmentsDutyFromCustomGroups.get(0));
        CompactSegments duty = this.coordinator.initializeCompactSegmentsDuty((CompactionSegmentSearchPolicy)this.newestSegmentFirstPolicy);
        Assert.assertNotNull((Object)duty);
    }

    @Test(timeout=3000L)
    public void testCoordinatorCustomDutyGroupsRunAsExpected() throws Exception {
        this.setupPeons(Collections.emptyMap());
        JacksonConfigManager configManager = (JacksonConfigManager)EasyMock.createNiceMock(JacksonConfigManager.class);
        EasyMock.expect((Object)configManager.watch((String)EasyMock.eq((Object)"coordinator.config"), (Class)EasyMock.anyObject(Class.class), EasyMock.anyObject())).andReturn(new AtomicReference<CoordinatorDynamicConfig>(CoordinatorDynamicConfig.builder().build())).anyTimes();
        EasyMock.expect((Object)configManager.watch((String)EasyMock.eq((Object)"coordinator.compaction.config"), (Class)EasyMock.anyObject(Class.class), EasyMock.anyObject())).andReturn(new AtomicReference<CoordinatorCompactionConfig>(CoordinatorCompactionConfig.empty())).anyTimes();
        EasyMock.replay((Object[])new Object[]{configManager});
        DruidDataSource dataSource = new DruidDataSource("dataSource1", Collections.emptyMap());
        DataSegment dataSegment = new DataSegment("dataSource1", Intervals.of((String)"2010-01-01/P1D"), "v1", null, null, null, null, Integer.valueOf(9), 0L);
        dataSource.addSegment(dataSegment);
        DataSourcesSnapshot dataSourcesSnapshot = new DataSourcesSnapshot((Map)ImmutableMap.of((Object)dataSource.getName(), (Object)dataSource.toImmutableDruidDataSource()));
        EasyMock.expect((Object)this.segmentsMetadataManager.getSnapshotOfDataSourcesWithAllUsedSegments()).andReturn((Object)dataSourcesSnapshot).anyTimes();
        EasyMock.expect((Object)this.segmentsMetadataManager.isPollingDatabasePeriodically()).andReturn((Object)true).anyTimes();
        EasyMock.expect((Object)this.segmentsMetadataManager.iterateAllUsedSegments()).andReturn(Collections.singletonList(dataSegment)).anyTimes();
        EasyMock.expect((Object)this.serverInventoryView.isStarted()).andReturn((Object)true).anyTimes();
        EasyMock.expect((Object)this.serverInventoryView.getInventory()).andReturn(Collections.emptyList()).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.serverInventoryView, this.loadQueueTaskMaster, this.segmentsMetadataManager});
        CountDownLatch latch1 = new CountDownLatch(1);
        CoordinatorCustomDuty duty1 = params -> {
            latch1.countDown();
            return params;
        };
        CoordinatorCustomDutyGroup group1 = new CoordinatorCustomDutyGroup("group1", Duration.standardSeconds((long)1L), (List)ImmutableList.of((Object)duty1));
        CountDownLatch latch2 = new CountDownLatch(1);
        CoordinatorCustomDuty duty2 = params -> {
            latch2.countDown();
            return params;
        };
        CoordinatorCustomDutyGroup group2 = new CoordinatorCustomDutyGroup("group2", Duration.standardSeconds((long)1L), (List)ImmutableList.of((Object)duty2));
        CoordinatorCustomDutyGroups groups = new CoordinatorCustomDutyGroups((Set)ImmutableSet.of((Object)group1, (Object)group2));
        this.coordinator = new DruidCoordinator(this.druidCoordinatorConfig, this.createMetadataManager(configManager), (ServerInventoryView)this.serverInventoryView, (ServiceEmitter)this.serviceEmitter, this.scheduledExecutorFactory, null, this.loadQueueTaskMaster, new SegmentLoadQueueManager((ServerInventoryView)this.serverInventoryView, this.loadQueueTaskMaster), (ServiceAnnouncer)new LatchableServiceAnnouncer(this.leaderAnnouncerLatch, this.leaderUnannouncerLatch), this.druidNode, groups, (BalancerStrategyFactory)new CostBalancerStrategyFactory(), (LookupCoordinatorManager)EasyMock.createNiceMock(LookupCoordinatorManager.class), (DruidLeaderSelector)new TestDruidLeaderSelector(), null);
        this.coordinator.start();
        latch1.await();
        latch2.await();
    }

    private CountDownLatch createCountDownLatchAndSetPathChildrenCacheListenerWithLatch(int latchCount, PathChildrenCache pathChildrenCache, Map<String, DataSegment> segments, DruidServer server) {
        CountDownLatch countDownLatch = new CountDownLatch(latchCount);
        pathChildrenCache.getListenable().addListener((client, event) -> {
            DataSegment segment;
            if (CuratorUtils.isChildAdded((PathChildrenCacheEvent)event) && (segment = DruidCoordinatorTest.findSegmentRelatedToCuratorEvent(segments, event)) != null && server.getSegment(segment.getId()) == null) {
                if (countDownLatch.getCount() > 0L) {
                    server.addDataSegment(segment);
                    ((ChildrenDeletable)this.curator.delete().guaranteed()).forPath(event.getData().getPath());
                    countDownLatch.countDown();
                } else {
                    Assert.fail((String)("The segment path " + event.getData().getPath() + " is not expected"));
                }
            }
        });
        return countDownLatch;
    }

    private void setupSegmentsMetadataMock(DruidDataSource dataSource) {
        EasyMock.expect((Object)this.segmentsMetadataManager.isPollingDatabasePeriodically()).andReturn((Object)true).anyTimes();
        EasyMock.expect((Object)this.segmentsMetadataManager.iterateAllUsedSegments()).andReturn((Object)dataSource.getSegments()).anyTimes();
        EasyMock.expect((Object)this.segmentsMetadataManager.getImmutableDataSourcesWithAllUsedSegments()).andReturn(Collections.singleton(dataSource.toImmutableDruidDataSource())).anyTimes();
        DataSourcesSnapshot dataSourcesSnapshot = new DataSourcesSnapshot((Map)ImmutableMap.of((Object)dataSource.getName(), (Object)dataSource.toImmutableDruidDataSource()));
        EasyMock.expect((Object)this.segmentsMetadataManager.getSnapshotOfDataSourcesWithAllUsedSegments()).andReturn((Object)dataSourcesSnapshot).anyTimes();
        EasyMock.expect((Object)this.segmentsMetadataManager.retrieveAllDataSourceNames()).andReturn(Collections.singleton(dataSource.getName())).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.segmentsMetadataManager});
        EasyMock.expect((Object)this.dataSourcesSnapshot.iterateAllUsedSegmentsInSnapshot()).andReturn((Object)dataSource.getSegments()).anyTimes();
        EasyMock.expect((Object)this.dataSourcesSnapshot.getDataSourcesWithAllUsedSegments()).andReturn(Collections.singleton(dataSource.toImmutableDruidDataSource())).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.dataSourcesSnapshot});
    }

    @Nullable
    private static DataSegment findSegmentRelatedToCuratorEvent(Map<String, DataSegment> dataSegments, PathChildrenCacheEvent event) {
        return dataSegments.entrySet().stream().filter(x -> event.getData().getPath().contains((CharSequence)x.getKey())).map(Map.Entry::getValue).findFirst().orElse(null);
    }

    private void setupPeons(Map<String, LoadQueuePeon> peonMap) {
        this.loadQueueTaskMaster.resetPeonsForNewServers((List)EasyMock.anyObject());
        EasyMock.expectLastCall().anyTimes();
        this.loadQueueTaskMaster.onLeaderStart();
        EasyMock.expectLastCall().anyTimes();
        this.loadQueueTaskMaster.onLeaderStop();
        EasyMock.expectLastCall().anyTimes();
        EasyMock.expect((Object)this.loadQueueTaskMaster.getAllPeons()).andReturn(peonMap).anyTimes();
        EasyMock.expect((Object)this.loadQueueTaskMaster.getPeonForServer((ImmutableDruidServer)EasyMock.anyObject())).andAnswer(() -> (LoadQueuePeon)peonMap.get(((ImmutableDruidServer)EasyMock.getCurrentArgument((int)0)).getName())).anyTimes();
    }

    private static class LatchableServiceEmitter
    extends ServiceEmitter {
        private CountDownLatch latch;

        private LatchableServiceEmitter() {
            super("", "", null);
        }

        public void emit(Event event) {
            if (this.latch != null && "segment/count".equals(event.toMap().get((Object)"metric"))) {
                this.latch.countDown();
            }
        }
    }

    private static class TestDruidLeaderSelector
    implements DruidLeaderSelector {
        private volatile DruidLeaderSelector.Listener listener;
        private volatile String leader;

        private TestDruidLeaderSelector() {
        }

        public String getCurrentLeader() {
            return this.leader;
        }

        public boolean isLeader() {
            return this.leader != null;
        }

        public int localTerm() {
            return 0;
        }

        public void registerListener(DruidLeaderSelector.Listener listener) {
            this.listener = listener;
            this.leader = "what:1234";
            listener.becomeLeader();
        }

        public void unregisterListener() {
            this.leader = null;
            this.listener.stopBeingLeader();
        }
    }
}

