/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator.duty;

import com.google.common.collect.ImmutableMap;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.server.coordinator.DruidCluster;
import org.apache.druid.server.coordinator.DruidCoordinatorRuntimeParams;
import org.apache.druid.server.coordinator.balancer.BalancerStrategy;
import org.apache.druid.server.coordinator.balancer.RandomBalancerStrategy;
import org.apache.druid.server.coordinator.duty.CollectSegmentAndServerStats;
import org.apache.druid.server.coordinator.loading.LoadQueueTaskMaster;
import org.apache.druid.server.coordinator.loading.SegmentLoadQueueManager;
import org.apache.druid.server.coordinator.loading.TestLoadQueuePeon;
import org.apache.druid.server.coordinator.stats.CoordinatorRunStats;
import org.apache.druid.server.coordinator.stats.Stats;
import org.apache.druid.timeline.DataSegment;
import org.joda.time.DateTime;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class CollectSegmentAndServerStatsTest {
    @Mock
    private LoadQueueTaskMaster mockTaskMaster;

    @Test
    public void testCollectedSegmentStats() {
        DruidCoordinatorRuntimeParams runtimeParams = DruidCoordinatorRuntimeParams.newBuilder((DateTime)DateTimes.nowUtc()).withDruidCluster(DruidCluster.EMPTY).withUsedSegments(new DataSegment[0]).withBalancerStrategy((BalancerStrategy)new RandomBalancerStrategy()).withSegmentAssignerUsing(new SegmentLoadQueueManager(null, null)).build();
        Mockito.when((Object)this.mockTaskMaster.getAllPeons()).thenReturn((Object)ImmutableMap.of((Object)"server1", (Object)new TestLoadQueuePeon()));
        CollectSegmentAndServerStats duty = new CollectSegmentAndServerStats(this.mockTaskMaster);
        DruidCoordinatorRuntimeParams params = duty.run(runtimeParams);
        CoordinatorRunStats stats = params.getCoordinatorStats();
        Assert.assertTrue((boolean)stats.hasStat(Stats.SegmentQueue.NUM_TO_LOAD));
        Assert.assertTrue((boolean)stats.hasStat(Stats.SegmentQueue.NUM_TO_DROP));
    }
}

