/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator.duty;

import org.apache.druid.audit.AuditManager;
import org.apache.druid.server.coordinator.DruidCoordinatorConfig;
import org.apache.druid.server.coordinator.DruidCoordinatorRuntimeParams;
import org.apache.druid.server.coordinator.TestDruidCoordinatorConfig;
import org.apache.druid.server.coordinator.duty.KillAuditLog;
import org.apache.druid.server.coordinator.stats.CoordinatorRunStats;
import org.apache.druid.server.coordinator.stats.Stats;
import org.joda.time.Duration;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class KillAuditLogTest {
    @Mock
    private AuditManager mockAuditManager;
    @Mock
    private DruidCoordinatorRuntimeParams mockDruidCoordinatorRuntimeParams;
    private KillAuditLog killAuditLog;
    private CoordinatorRunStats runStats;

    @Before
    public void setup() {
        this.runStats = new CoordinatorRunStats();
        Mockito.when((Object)this.mockDruidCoordinatorRuntimeParams.getCoordinatorStats()).thenReturn((Object)this.runStats);
    }

    @Test
    public void testRunSkipIfLastRunLessThanPeriod() {
        TestDruidCoordinatorConfig druidCoordinatorConfig = new TestDruidCoordinatorConfig.Builder().withMetadataStoreManagementPeriod(new Duration((Object)"PT5s")).withCoordianatorAuditKillPeriod(new Duration(Long.MAX_VALUE)).withCoordinatorAuditKillDurationToRetain(new Duration((Object)"PT1S")).withCoordinatorKillMaxSegments(10).withCoordinatorKillIgnoreDurationToRetain(false).build();
        this.killAuditLog = new KillAuditLog((DruidCoordinatorConfig)druidCoordinatorConfig, this.mockAuditManager);
        this.killAuditLog.run(this.mockDruidCoordinatorRuntimeParams);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.mockAuditManager});
    }

    @Test
    public void testRunNotSkipIfLastRunMoreThanPeriod() {
        TestDruidCoordinatorConfig druidCoordinatorConfig = new TestDruidCoordinatorConfig.Builder().withMetadataStoreManagementPeriod(new Duration((Object)"PT5s")).withCoordianatorAuditKillPeriod(new Duration((Object)"PT6S")).withCoordinatorAuditKillDurationToRetain(new Duration((Object)"PT1S")).withCoordinatorKillMaxSegments(10).withCoordinatorKillIgnoreDurationToRetain(false).build();
        this.killAuditLog = new KillAuditLog((DruidCoordinatorConfig)druidCoordinatorConfig, this.mockAuditManager);
        this.killAuditLog.run(this.mockDruidCoordinatorRuntimeParams);
        ((AuditManager)Mockito.verify((Object)this.mockAuditManager)).removeAuditLogsOlderThan(ArgumentMatchers.anyLong());
        Assert.assertTrue((boolean)this.runStats.hasStat(Stats.Kill.AUDIT_LOGS));
    }

    @Test
    public void testConstructorFailIfInvalidPeriod() {
        TestDruidCoordinatorConfig druidCoordinatorConfig = new TestDruidCoordinatorConfig.Builder().withMetadataStoreManagementPeriod(new Duration((Object)"PT5s")).withCoordianatorAuditKillPeriod(new Duration((Object)"PT3S")).withCoordinatorAuditKillDurationToRetain(new Duration((Object)"PT1S")).withCoordinatorKillMaxSegments(10).withCoordinatorKillIgnoreDurationToRetain(false).build();
        IllegalArgumentException exception = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> {
            this.killAuditLog = new KillAuditLog((DruidCoordinatorConfig)druidCoordinatorConfig, this.mockAuditManager);
        });
        Assert.assertEquals((Object)"[druid.coordinator.kill.audit.period] must be greater than [druid.coordinator.period.metadataStoreManagementPeriod]", (Object)exception.getMessage());
    }

    @Test
    public void testConstructorFailIfInvalidRetainDuration() {
        TestDruidCoordinatorConfig druidCoordinatorConfig = new TestDruidCoordinatorConfig.Builder().withMetadataStoreManagementPeriod(new Duration((Object)"PT5S")).withCoordianatorAuditKillPeriod(new Duration((Object)"PT6S")).withCoordinatorAuditKillDurationToRetain(new Duration((Object)"PT-1S")).withCoordinatorKillMaxSegments(10).withCoordinatorKillIgnoreDurationToRetain(false).build();
        IllegalArgumentException exception = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> {
            this.killAuditLog = new KillAuditLog((DruidCoordinatorConfig)druidCoordinatorConfig, this.mockAuditManager);
        });
        Assert.assertEquals((Object)"[druid.coordinator.kill.audit.durationToRetain] must be 0 milliseconds or higher", (Object)exception.getMessage());
    }
}

