/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator.duty;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.apache.druid.indexing.overlord.IndexerMetadataStorageCoordinator;
import org.apache.druid.metadata.MetadataSupervisorManager;
import org.apache.druid.server.coordinator.DruidCoordinatorConfig;
import org.apache.druid.server.coordinator.DruidCoordinatorRuntimeParams;
import org.apache.druid.server.coordinator.TestDruidCoordinatorConfig;
import org.apache.druid.server.coordinator.duty.KillDatasourceMetadata;
import org.apache.druid.server.coordinator.stats.CoordinatorRunStats;
import org.apache.druid.server.coordinator.stats.Stats;
import org.joda.time.Duration;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class KillDatasourceMetadataTest {
    @Mock
    private IndexerMetadataStorageCoordinator mockIndexerMetadataStorageCoordinator;
    @Mock
    private MetadataSupervisorManager mockMetadataSupervisorManager;
    @Mock
    private DruidCoordinatorRuntimeParams mockDruidCoordinatorRuntimeParams;
    private KillDatasourceMetadata killDatasourceMetadata;
    private CoordinatorRunStats runStats;

    @Before
    public void setup() {
        this.runStats = new CoordinatorRunStats();
        Mockito.when((Object)this.mockDruidCoordinatorRuntimeParams.getCoordinatorStats()).thenReturn((Object)this.runStats);
    }

    @Test
    public void testRunSkipIfLastRunLessThanPeriod() {
        TestDruidCoordinatorConfig druidCoordinatorConfig = new TestDruidCoordinatorConfig.Builder().withMetadataStoreManagementPeriod(new Duration((Object)"PT5S")).withCoordinatorDatasourceKillPeriod(new Duration(Long.MAX_VALUE)).withCoordinatorDatasourceKillDurationToRetain(new Duration((Object)"PT1S")).withCoordinatorKillMaxSegments(10).withCoordinatorKillIgnoreDurationToRetain(false).build();
        this.killDatasourceMetadata = new KillDatasourceMetadata((DruidCoordinatorConfig)druidCoordinatorConfig, this.mockIndexerMetadataStorageCoordinator, this.mockMetadataSupervisorManager);
        this.killDatasourceMetadata.run(this.mockDruidCoordinatorRuntimeParams);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.mockIndexerMetadataStorageCoordinator});
        Mockito.verifyNoInteractions((Object[])new Object[]{this.mockMetadataSupervisorManager});
    }

    @Test
    public void testRunNotSkipIfLastRunMoreThanPeriod() {
        Mockito.when((Object)this.mockDruidCoordinatorRuntimeParams.getCoordinatorStats()).thenReturn((Object)this.runStats);
        TestDruidCoordinatorConfig druidCoordinatorConfig = new TestDruidCoordinatorConfig.Builder().withMetadataStoreManagementPeriod(new Duration((Object)"PT5S")).withCoordinatorDatasourceKillPeriod(new Duration((Object)"PT6S")).withCoordinatorDatasourceKillDurationToRetain(new Duration((Object)"PT1S")).withCoordinatorKillMaxSegments(10).withCoordinatorKillIgnoreDurationToRetain(false).build();
        this.killDatasourceMetadata = new KillDatasourceMetadata((DruidCoordinatorConfig)druidCoordinatorConfig, this.mockIndexerMetadataStorageCoordinator, this.mockMetadataSupervisorManager);
        this.killDatasourceMetadata.run(this.mockDruidCoordinatorRuntimeParams);
        ((IndexerMetadataStorageCoordinator)Mockito.verify((Object)this.mockIndexerMetadataStorageCoordinator)).removeDataSourceMetadataOlderThan(ArgumentMatchers.anyLong(), ArgumentMatchers.anySet());
        Assert.assertTrue((boolean)this.runStats.hasStat(Stats.Kill.DATASOURCES));
    }

    @Test
    public void testConstructorFailIfInvalidPeriod() {
        TestDruidCoordinatorConfig druidCoordinatorConfig = new TestDruidCoordinatorConfig.Builder().withMetadataStoreManagementPeriod(new Duration((Object)"PT5S")).withCoordinatorDatasourceKillPeriod(new Duration((Object)"PT3S")).withCoordinatorDatasourceKillDurationToRetain(new Duration((Object)"PT1S")).withCoordinatorKillMaxSegments(10).withCoordinatorKillIgnoreDurationToRetain(false).build();
        IllegalArgumentException exception = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> {
            this.killDatasourceMetadata = new KillDatasourceMetadata((DruidCoordinatorConfig)druidCoordinatorConfig, this.mockIndexerMetadataStorageCoordinator, this.mockMetadataSupervisorManager);
        });
        Assert.assertEquals((Object)"[druid.coordinator.kill.datasource.period] must be greater than [druid.coordinator.period.metadataStoreManagementPeriod]", (Object)exception.getMessage());
    }

    @Test
    public void testConstructorFailIfInvalidRetainDuration() {
        TestDruidCoordinatorConfig druidCoordinatorConfig = new TestDruidCoordinatorConfig.Builder().withMetadataStoreManagementPeriod(new Duration((Object)"PT5S")).withCoordinatorDatasourceKillPeriod(new Duration((Object)"PT6S")).withCoordinatorDatasourceKillDurationToRetain(new Duration((Object)"PT-1S")).withCoordinatorKillMaxSegments(10).withCoordinatorKillIgnoreDurationToRetain(false).build();
        IllegalArgumentException exception = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> {
            this.killDatasourceMetadata = new KillDatasourceMetadata((DruidCoordinatorConfig)druidCoordinatorConfig, this.mockIndexerMetadataStorageCoordinator, this.mockMetadataSupervisorManager);
        });
        Assert.assertEquals((Object)"[druid.coordinator.kill.datasource.durationToRetain] must be 0 milliseconds or higher", (Object)exception.getMessage());
    }

    @Test
    public void testRunWithEmptyFilterExcludedDatasource() {
        TestDruidCoordinatorConfig druidCoordinatorConfig = new TestDruidCoordinatorConfig.Builder().withMetadataStoreManagementPeriod(new Duration((Object)"PT5S")).withCoordinatorDatasourceKillPeriod(new Duration((Object)"PT6S")).withCoordinatorDatasourceKillDurationToRetain(new Duration((Object)"PT1S")).withCoordinatorKillMaxSegments(10).withCoordinatorKillIgnoreDurationToRetain(false).build();
        this.killDatasourceMetadata = new KillDatasourceMetadata((DruidCoordinatorConfig)druidCoordinatorConfig, this.mockIndexerMetadataStorageCoordinator, this.mockMetadataSupervisorManager);
        this.killDatasourceMetadata.run(this.mockDruidCoordinatorRuntimeParams);
        ((IndexerMetadataStorageCoordinator)Mockito.verify((Object)this.mockIndexerMetadataStorageCoordinator)).removeDataSourceMetadataOlderThan(ArgumentMatchers.anyLong(), (Set)ArgumentMatchers.eq((Object)ImmutableSet.of()));
        Assert.assertTrue((boolean)this.runStats.hasStat(Stats.Kill.DATASOURCES));
    }
}

