/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator.duty;

import org.apache.druid.metadata.MetadataSupervisorManager;
import org.apache.druid.server.coordinator.DruidCoordinatorConfig;
import org.apache.druid.server.coordinator.DruidCoordinatorRuntimeParams;
import org.apache.druid.server.coordinator.duty.KillSupervisorsCustomDuty;
import org.apache.druid.server.coordinator.stats.CoordinatorRunStats;
import org.apache.druid.server.coordinator.stats.Stats;
import org.joda.time.Duration;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class KillSupervisorsCustomDutyTest {
    @Mock
    private MetadataSupervisorManager mockMetadataSupervisorManager;
    @Mock
    private DruidCoordinatorRuntimeParams mockDruidCoordinatorRuntimeParams;
    @Mock
    private DruidCoordinatorConfig coordinatorConfig;
    private KillSupervisorsCustomDuty killSupervisors;

    @Before
    public void setup() {
        Mockito.when((Object)this.coordinatorConfig.getCoordinatorMetadataStoreManagementPeriod()).thenReturn((Object)new Duration(3600000L));
    }

    @Test
    public void testConstructorFailIfRetainDurationNull() {
        IllegalArgumentException exception = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> {
            this.killSupervisors = new KillSupervisorsCustomDuty(null, this.mockMetadataSupervisorManager, this.coordinatorConfig);
        });
        Assert.assertEquals((Object)"[KillSupervisorsCustomDuty.durationToRetain] must be 0 milliseconds or higher", (Object)exception.getMessage());
    }

    @Test
    public void testConstructorFailIfRetainDurationInvalid() {
        IllegalArgumentException exception = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> {
            this.killSupervisors = new KillSupervisorsCustomDuty(new Duration((Object)"PT-1S"), this.mockMetadataSupervisorManager, this.coordinatorConfig);
        });
        Assert.assertEquals((Object)"[KillSupervisorsCustomDuty.durationToRetain] must be 0 milliseconds or higher", (Object)exception.getMessage());
    }

    @Test
    public void testConstructorSuccess() {
        this.killSupervisors = new KillSupervisorsCustomDuty(new Duration((Object)"PT1S"), this.mockMetadataSupervisorManager, this.coordinatorConfig);
        Assert.assertNotNull((Object)this.killSupervisors);
    }

    @Test
    public void testRun() {
        CoordinatorRunStats runStats = new CoordinatorRunStats();
        Mockito.when((Object)this.mockDruidCoordinatorRuntimeParams.getCoordinatorStats()).thenReturn((Object)runStats);
        this.killSupervisors = new KillSupervisorsCustomDuty(new Duration((Object)"PT1S"), this.mockMetadataSupervisorManager, this.coordinatorConfig);
        this.killSupervisors.run(this.mockDruidCoordinatorRuntimeParams);
        ((MetadataSupervisorManager)Mockito.verify((Object)this.mockMetadataSupervisorManager)).removeTerminatedSupervisorsOlderThan(ArgumentMatchers.anyLong());
        Assert.assertTrue((boolean)runStats.hasStat(Stats.Kill.SUPERVISOR_SPECS));
    }
}

