/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator.rules;

import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.server.coordinator.rules.PeriodDropRule;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.partition.NoneShardSpec;
import org.apache.druid.timeline.partition.ShardSpec;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.Period;
import org.joda.time.ReadableInstant;
import org.junit.Assert;
import org.junit.Test;

public class PeriodDropRuleTest {
    private static final DataSegment.Builder BUILDER = DataSegment.builder().dataSource("test").version(DateTimes.of((String)"2012-12-31T01:00:00").toString()).shardSpec((ShardSpec)NoneShardSpec.instance()).size(0L);

    @Test
    public void testAppliesToAll() {
        DateTime now = DateTimes.of((String)"2012-12-31T01:00:00");
        PeriodDropRule rule = new PeriodDropRule(new Period((Object)"P5000Y"), Boolean.valueOf(false));
        Assert.assertTrue((boolean)rule.appliesTo(BUILDER.interval(new Interval((ReadableInstant)now.minusDays(2), (ReadableInstant)now.minusDays(1))).build(), now));
        Assert.assertTrue((boolean)rule.appliesTo(BUILDER.interval(new Interval((ReadableInstant)now.minusYears(100), (ReadableInstant)now.minusDays(1))).build(), now));
    }

    @Test
    public void testAppliesToPeriod() {
        DateTime now = DateTimes.of((String)"2012-12-31T01:00:00");
        PeriodDropRule rule = new PeriodDropRule(new Period((Object)"P1M"), Boolean.valueOf(false));
        Assert.assertTrue((boolean)rule.appliesTo(BUILDER.interval(new Interval((ReadableInstant)now.minusWeeks(1), (ReadableInstant)now.minusDays(1))).build(), now));
        Assert.assertTrue((boolean)rule.appliesTo(BUILDER.interval(new Interval((ReadableInstant)now.minusDays(1), (ReadableInstant)now)).build(), now));
        Assert.assertFalse((boolean)rule.appliesTo(BUILDER.interval(new Interval((ReadableInstant)now.minusYears(1), (ReadableInstant)now.minusDays(1))).build(), now));
        Assert.assertFalse((boolean)rule.appliesTo(BUILDER.interval(new Interval((ReadableInstant)now.minusMonths(2), (ReadableInstant)now.minusDays(1))).build(), now));
    }

    @Test
    public void testIncludeFuture() {
        DateTime now = DateTimes.of((String)"2012-12-31T01:00:00");
        PeriodDropRule includeFutureRule = new PeriodDropRule(new Period((Object)"P2D"), Boolean.valueOf(true));
        PeriodDropRule notIncludeFutureRule = new PeriodDropRule(new Period((Object)"P2D"), Boolean.valueOf(false));
        Assert.assertTrue((boolean)includeFutureRule.appliesTo(BUILDER.interval(new Interval((ReadableInstant)now.plusDays(1), (ReadableInstant)now.plusDays(2))).build(), now));
        Assert.assertFalse((boolean)notIncludeFutureRule.appliesTo(BUILDER.interval(new Interval((ReadableInstant)now.plusDays(1), (ReadableInstant)now.plusDays(2))).build(), now));
    }
}

