/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.http;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.ByteSource;
import com.google.common.net.HostAndPort;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Response;
import org.apache.druid.audit.AuditInfo;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.query.lookup.LookupsState;
import org.apache.druid.server.http.LookupCoordinatorResource;
import org.apache.druid.server.lookup.cache.LookupCoordinatorManager;
import org.apache.druid.server.lookup.cache.LookupExtractorFactoryMapContainer;
import org.apache.druid.server.security.AuthenticationResult;
import org.easymock.Capture;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;

public class LookupCoordinatorResourceTest {
    private static final ObjectMapper MAPPER = new DefaultObjectMapper();
    private static final String LOOKUP_TIER = "lookupTier";
    private static final String LOOKUP_NAME = "lookupName";
    private static final LookupExtractorFactoryMapContainer SINGLE_LOOKUP = new LookupExtractorFactoryMapContainer("v0", (Map)ImmutableMap.of());
    private static final Map<String, LookupExtractorFactoryMapContainer> SINGLE_LOOKUP_MAP = ImmutableMap.of((Object)"lookupName", (Object)SINGLE_LOOKUP);
    private static final Map<String, Map<String, LookupExtractorFactoryMapContainer>> SINGLE_TIER_MAP = ImmutableMap.of((Object)"lookupTier", SINGLE_LOOKUP_MAP);
    private static final ByteSource SINGLE_TIER_MAP_SOURCE = new ByteSource(){

        public InputStream openStream() throws IOException {
            return new ByteArrayInputStream(StringUtils.toUtf8((String)MAPPER.writeValueAsString((Object)SINGLE_TIER_MAP)));
        }
    };
    private static final ByteSource EMPTY_MAP_SOURCE = new ByteSource(){

        public InputStream openStream() throws IOException {
            return new ByteArrayInputStream(StringUtils.toUtf8((String)MAPPER.writeValueAsString((Object)SINGLE_LOOKUP)));
        }
    };
    private static final HostAndPort LOOKUP_NODE = HostAndPort.fromParts((String)"localhost", (int)1111);
    private static final LookupsState<LookupExtractorFactoryMapContainer> LOOKUP_STATE = new LookupsState((Map)ImmutableMap.of((Object)"lookupName", (Object)SINGLE_LOOKUP), null, null);
    private static final Map<HostAndPort, LookupsState<LookupExtractorFactoryMapContainer>> NODES_LOOKUP_STATE = ImmutableMap.of((Object)LOOKUP_NODE, LOOKUP_STATE);
    private static final AuthenticationResult AUTH_RESULT = new AuthenticationResult("id", "authorizer", "authBy", Collections.emptyMap());
    private final AuditInfo auditInfo = new AuditInfo("some author", "id", "some comment", "127.0.0.1");

    @Test
    public void testSimpleGet() {
        LookupCoordinatorManager lookupCoordinatorManager = (LookupCoordinatorManager)EasyMock.createStrictMock(LookupCoordinatorManager.class);
        HashMap retVal = new HashMap();
        EasyMock.expect((Object)lookupCoordinatorManager.getKnownLookups()).andReturn(retVal).once();
        EasyMock.replay((Object[])new Object[]{lookupCoordinatorManager});
        LookupCoordinatorResource lookupCoordinatorResource = new LookupCoordinatorResource(lookupCoordinatorManager, MAPPER, MAPPER);
        Response response = lookupCoordinatorResource.getTiers(false);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals(retVal.keySet(), (Object)response.getEntity());
        EasyMock.verify((Object[])new Object[]{lookupCoordinatorManager});
    }

    @Test
    public void testMissingGet() {
        LookupCoordinatorManager lookupCoordinatorManager = (LookupCoordinatorManager)EasyMock.createStrictMock(LookupCoordinatorManager.class);
        EasyMock.expect((Object)lookupCoordinatorManager.getKnownLookups()).andReturn(null).once();
        EasyMock.replay((Object[])new Object[]{lookupCoordinatorManager});
        LookupCoordinatorResource lookupCoordinatorResource = new LookupCoordinatorResource(lookupCoordinatorManager, MAPPER, MAPPER);
        Response response = lookupCoordinatorResource.getTiers(false);
        Assert.assertEquals((long)404L, (long)response.getStatus());
        EasyMock.verify((Object[])new Object[]{lookupCoordinatorManager});
    }

    @Test
    public void testExceptionalGet() {
        String errMsg = "some error";
        LookupCoordinatorManager lookupCoordinatorManager = (LookupCoordinatorManager)EasyMock.createStrictMock(LookupCoordinatorManager.class);
        EasyMock.expect((Object)lookupCoordinatorManager.getKnownLookups()).andThrow((Throwable)new RuntimeException("some error")).once();
        EasyMock.replay((Object[])new Object[]{lookupCoordinatorManager});
        LookupCoordinatorResource lookupCoordinatorResource = new LookupCoordinatorResource(lookupCoordinatorManager, MAPPER, MAPPER);
        Response response = lookupCoordinatorResource.getTiers(false);
        Assert.assertEquals((long)500L, (long)response.getStatus());
        Assert.assertEquals((Object)ImmutableMap.of((Object)"error", (Object)"some error"), (Object)response.getEntity());
        EasyMock.verify((Object[])new Object[]{lookupCoordinatorManager});
    }

    @Test
    public void testDiscoveryGet() {
        ImmutableSet tiers = ImmutableSet.of((Object)"discoveredLookupTier");
        LookupCoordinatorManager lookupCoordinatorManager = (LookupCoordinatorManager)EasyMock.createStrictMock(LookupCoordinatorManager.class);
        EasyMock.expect((Object)lookupCoordinatorManager.getKnownLookups()).andReturn(SINGLE_TIER_MAP).once();
        EasyMock.expect((Object)lookupCoordinatorManager.discoverTiers()).andReturn((Object)tiers).once();
        EasyMock.replay((Object[])new Object[]{lookupCoordinatorManager});
        LookupCoordinatorResource lookupCoordinatorResource = new LookupCoordinatorResource(lookupCoordinatorManager, MAPPER, MAPPER);
        Response response = lookupCoordinatorResource.getTiers(true);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)ImmutableSet.of((Object)LOOKUP_TIER, (Object)"discoveredLookupTier"), (Object)response.getEntity());
        EasyMock.verify((Object[])new Object[]{lookupCoordinatorManager});
    }

    @Test
    public void testDiscoveryExceptionalGet() {
        String errMsg = "some error";
        RuntimeException ex = new RuntimeException("some error");
        LookupCoordinatorManager lookupCoordinatorManager = (LookupCoordinatorManager)EasyMock.createStrictMock(LookupCoordinatorManager.class);
        EasyMock.expect((Object)lookupCoordinatorManager.getKnownLookups()).andReturn(SINGLE_TIER_MAP).once();
        EasyMock.expect((Object)lookupCoordinatorManager.discoverTiers()).andThrow((Throwable)ex).once();
        EasyMock.replay((Object[])new Object[]{lookupCoordinatorManager});
        LookupCoordinatorResource lookupCoordinatorResource = new LookupCoordinatorResource(lookupCoordinatorManager, MAPPER, MAPPER);
        Response response = lookupCoordinatorResource.getTiers(true);
        Assert.assertEquals((long)500L, (long)response.getStatus());
        Assert.assertEquals((Object)ImmutableMap.of((Object)"error", (Object)"some error"), (Object)response.getEntity());
        EasyMock.verify((Object[])new Object[]{lookupCoordinatorManager});
    }

    @Test
    public void testSimpleGetLookup() {
        LookupExtractorFactoryMapContainer container = new LookupExtractorFactoryMapContainer("v0", new HashMap());
        LookupCoordinatorManager lookupCoordinatorManager = (LookupCoordinatorManager)EasyMock.createStrictMock(LookupCoordinatorManager.class);
        EasyMock.expect((Object)lookupCoordinatorManager.getLookup((String)EasyMock.eq((Object)LOOKUP_TIER), (String)EasyMock.eq((Object)LOOKUP_NAME))).andReturn((Object)container).once();
        EasyMock.replay((Object[])new Object[]{lookupCoordinatorManager});
        LookupCoordinatorResource lookupCoordinatorResource = new LookupCoordinatorResource(lookupCoordinatorManager, MAPPER, MAPPER);
        Response response = lookupCoordinatorResource.getSpecificLookup(LOOKUP_TIER, LOOKUP_NAME);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)container, (Object)response.getEntity());
        EasyMock.verify((Object[])new Object[]{lookupCoordinatorManager});
    }

    @Test
    public void testDetailedGetLookup() {
        LookupCoordinatorManager lookupCoordinatorManager = (LookupCoordinatorManager)EasyMock.createStrictMock(LookupCoordinatorManager.class);
        EasyMock.expect((Object)lookupCoordinatorManager.getKnownLookups()).andReturn(SINGLE_TIER_MAP).once();
        EasyMock.replay((Object[])new Object[]{lookupCoordinatorManager});
        LookupCoordinatorResource lookupCoordinatorResource = new LookupCoordinatorResource(lookupCoordinatorManager, MAPPER, MAPPER);
        Response response = lookupCoordinatorResource.getSpecificTier(LOOKUP_TIER, true);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals(SINGLE_TIER_MAP.get(LOOKUP_TIER), (Object)response.getEntity());
        EasyMock.verify((Object[])new Object[]{lookupCoordinatorManager});
    }

    @Test
    public void testMissingGetLookup() {
        LookupCoordinatorManager lookupCoordinatorManager = (LookupCoordinatorManager)EasyMock.createStrictMock(LookupCoordinatorManager.class);
        EasyMock.expect((Object)lookupCoordinatorManager.getLookup((String)EasyMock.eq((Object)LOOKUP_TIER), (String)EasyMock.eq((Object)LOOKUP_NAME))).andReturn(null).once();
        EasyMock.replay((Object[])new Object[]{lookupCoordinatorManager});
        LookupCoordinatorResource lookupCoordinatorResource = new LookupCoordinatorResource(lookupCoordinatorManager, MAPPER, MAPPER);
        Response response = lookupCoordinatorResource.getSpecificLookup(LOOKUP_TIER, LOOKUP_NAME);
        Assert.assertEquals((long)404L, (long)response.getStatus());
        EasyMock.verify((Object[])new Object[]{lookupCoordinatorManager});
    }

    @Test
    public void testInvalidGetLookup() {
        LookupCoordinatorManager lookupCoordinatorManager = (LookupCoordinatorManager)EasyMock.createStrictMock(LookupCoordinatorManager.class);
        EasyMock.replay((Object[])new Object[]{lookupCoordinatorManager});
        LookupCoordinatorResource lookupCoordinatorResource = new LookupCoordinatorResource(lookupCoordinatorManager, MAPPER, MAPPER);
        Assert.assertEquals((long)400L, (long)lookupCoordinatorResource.getSpecificLookup("foo", null).getStatus());
        Assert.assertEquals((long)400L, (long)lookupCoordinatorResource.getSpecificLookup("foo", "").getStatus());
        Assert.assertEquals((long)400L, (long)lookupCoordinatorResource.getSpecificLookup("", "foo").getStatus());
        Assert.assertEquals((long)400L, (long)lookupCoordinatorResource.getSpecificLookup(null, "foo").getStatus());
        EasyMock.verify((Object[])new Object[]{lookupCoordinatorManager});
    }

    @Test
    public void testExceptionalGetLookup() {
        String errMsg = "some message";
        LookupCoordinatorManager lookupCoordinatorManager = (LookupCoordinatorManager)EasyMock.createStrictMock(LookupCoordinatorManager.class);
        EasyMock.expect((Object)lookupCoordinatorManager.getLookup((String)EasyMock.eq((Object)LOOKUP_TIER), (String)EasyMock.eq((Object)LOOKUP_NAME))).andThrow((Throwable)new RuntimeException("some message")).once();
        EasyMock.replay((Object[])new Object[]{lookupCoordinatorManager});
        LookupCoordinatorResource lookupCoordinatorResource = new LookupCoordinatorResource(lookupCoordinatorManager, MAPPER, MAPPER);
        Response response = lookupCoordinatorResource.getSpecificLookup(LOOKUP_TIER, LOOKUP_NAME);
        Assert.assertEquals((long)500L, (long)response.getStatus());
        Assert.assertEquals((Object)ImmutableMap.of((Object)"error", (Object)"some message"), (Object)response.getEntity());
        EasyMock.verify((Object[])new Object[]{lookupCoordinatorManager});
    }

    @Test
    public void testSimpleDeleteTier() {
        HttpServletRequest request = this.createMockRequest(false);
        Capture auditInfoCapture = Capture.newInstance();
        LookupCoordinatorManager lookupCoordinatorManager = (LookupCoordinatorManager)EasyMock.createStrictMock(LookupCoordinatorManager.class);
        EasyMock.expect((Object)lookupCoordinatorManager.deleteTier((String)EasyMock.eq((Object)LOOKUP_TIER), (AuditInfo)EasyMock.capture((Capture)auditInfoCapture))).andReturn((Object)true).once();
        EasyMock.replay((Object[])new Object[]{lookupCoordinatorManager, request});
        LookupCoordinatorResource lookupCoordinatorResource = new LookupCoordinatorResource(lookupCoordinatorManager, MAPPER, MAPPER);
        Response response = lookupCoordinatorResource.deleteTier(LOOKUP_TIER, request);
        Assert.assertEquals((long)202L, (long)response.getStatus());
        Assert.assertTrue((boolean)auditInfoCapture.hasCaptured());
        Assert.assertEquals((Object)this.auditInfo, (Object)auditInfoCapture.getValue());
        EasyMock.verify((Object[])new Object[]{lookupCoordinatorManager, request});
    }

    @Test
    public void testSimpleDelete() {
        HttpServletRequest request = this.createMockRequest(false);
        Capture auditInfoCapture = Capture.newInstance();
        LookupCoordinatorManager lookupCoordinatorManager = (LookupCoordinatorManager)EasyMock.createStrictMock(LookupCoordinatorManager.class);
        EasyMock.expect((Object)lookupCoordinatorManager.deleteLookup((String)EasyMock.eq((Object)LOOKUP_TIER), (String)EasyMock.eq((Object)LOOKUP_NAME), (AuditInfo)EasyMock.capture((Capture)auditInfoCapture))).andReturn((Object)true).once();
        EasyMock.replay((Object[])new Object[]{lookupCoordinatorManager, request});
        LookupCoordinatorResource lookupCoordinatorResource = new LookupCoordinatorResource(lookupCoordinatorManager, MAPPER, MAPPER);
        Response response = lookupCoordinatorResource.deleteLookup(LOOKUP_TIER, LOOKUP_NAME, request);
        Assert.assertEquals((long)202L, (long)response.getStatus());
        Assert.assertTrue((boolean)auditInfoCapture.hasCaptured());
        Assert.assertEquals((Object)this.auditInfo, (Object)auditInfoCapture.getValue());
        EasyMock.verify((Object[])new Object[]{lookupCoordinatorManager, request});
    }

    @Test
    public void testMissingDelete() {
        HttpServletRequest request = this.createMockRequest(false);
        Capture auditInfoCapture = Capture.newInstance();
        LookupCoordinatorManager lookupCoordinatorManager = (LookupCoordinatorManager)EasyMock.createStrictMock(LookupCoordinatorManager.class);
        EasyMock.expect((Object)lookupCoordinatorManager.deleteLookup((String)EasyMock.eq((Object)LOOKUP_TIER), (String)EasyMock.eq((Object)LOOKUP_NAME), (AuditInfo)EasyMock.capture((Capture)auditInfoCapture))).andReturn((Object)false).once();
        EasyMock.replay((Object[])new Object[]{lookupCoordinatorManager, request});
        LookupCoordinatorResource lookupCoordinatorResource = new LookupCoordinatorResource(lookupCoordinatorManager, MAPPER, MAPPER);
        Response response = lookupCoordinatorResource.deleteLookup(LOOKUP_TIER, LOOKUP_NAME, request);
        Assert.assertEquals((long)404L, (long)response.getStatus());
        Assert.assertTrue((boolean)auditInfoCapture.hasCaptured());
        Assert.assertEquals((Object)this.auditInfo, (Object)auditInfoCapture.getValue());
        EasyMock.verify((Object[])new Object[]{lookupCoordinatorManager, request});
    }

    @Test
    public void testExceptionalDelete() {
        String errMsg = "some error";
        HttpServletRequest request = this.createMockRequest(false);
        Capture auditInfoCapture = Capture.newInstance();
        LookupCoordinatorManager lookupCoordinatorManager = (LookupCoordinatorManager)EasyMock.createStrictMock(LookupCoordinatorManager.class);
        EasyMock.expect((Object)lookupCoordinatorManager.deleteLookup((String)EasyMock.eq((Object)LOOKUP_TIER), (String)EasyMock.eq((Object)LOOKUP_NAME), (AuditInfo)EasyMock.capture((Capture)auditInfoCapture))).andThrow((Throwable)new RuntimeException("some error")).once();
        EasyMock.replay((Object[])new Object[]{lookupCoordinatorManager, request});
        LookupCoordinatorResource lookupCoordinatorResource = new LookupCoordinatorResource(lookupCoordinatorManager, MAPPER, MAPPER);
        Response response = lookupCoordinatorResource.deleteLookup(LOOKUP_TIER, LOOKUP_NAME, request);
        Assert.assertEquals((long)500L, (long)response.getStatus());
        Assert.assertEquals((Object)ImmutableMap.of((Object)"error", (Object)"some error"), (Object)response.getEntity());
        Assert.assertTrue((boolean)auditInfoCapture.hasCaptured());
        Assert.assertEquals((Object)this.auditInfo, (Object)auditInfoCapture.getValue());
        EasyMock.verify((Object[])new Object[]{lookupCoordinatorManager, request});
    }

    @Test
    public void testInvalidDelete() {
        LookupCoordinatorManager lookupCoordinatorManager = (LookupCoordinatorManager)EasyMock.createStrictMock(LookupCoordinatorManager.class);
        EasyMock.replay((Object[])new Object[]{lookupCoordinatorManager});
        LookupCoordinatorResource lookupCoordinatorResource = new LookupCoordinatorResource(lookupCoordinatorManager, MAPPER, MAPPER);
        Assert.assertEquals((long)400L, (long)lookupCoordinatorResource.deleteLookup("foo", null, null).getStatus());
        Assert.assertEquals((long)400L, (long)lookupCoordinatorResource.deleteLookup(null, null, null).getStatus());
        Assert.assertEquals((long)400L, (long)lookupCoordinatorResource.deleteLookup(null, "foo", null).getStatus());
        Assert.assertEquals((long)400L, (long)lookupCoordinatorResource.deleteLookup("foo", "", null).getStatus());
        Assert.assertEquals((long)400L, (long)lookupCoordinatorResource.deleteLookup("", "foo", null).getStatus());
        EasyMock.verify((Object[])new Object[]{lookupCoordinatorManager});
    }

    @Test
    public void testSimpleNew() throws Exception {
        HttpServletRequest request = this.createMockRequest(true);
        Capture auditInfoCapture = Capture.newInstance();
        LookupCoordinatorManager lookupCoordinatorManager = (LookupCoordinatorManager)EasyMock.createStrictMock(LookupCoordinatorManager.class);
        EasyMock.expect((Object)lookupCoordinatorManager.updateLookups((Map)EasyMock.eq(SINGLE_TIER_MAP), (AuditInfo)EasyMock.capture((Capture)auditInfoCapture))).andReturn((Object)true).once();
        EasyMock.replay((Object[])new Object[]{lookupCoordinatorManager, request});
        LookupCoordinatorResource lookupCoordinatorResource = new LookupCoordinatorResource(lookupCoordinatorManager, MAPPER, MAPPER);
        Response response = lookupCoordinatorResource.updateAllLookups(SINGLE_TIER_MAP_SOURCE.openStream(), request);
        Assert.assertEquals((long)202L, (long)response.getStatus());
        Assert.assertTrue((boolean)auditInfoCapture.hasCaptured());
        Assert.assertEquals((Object)this.auditInfo, (Object)auditInfoCapture.getValue());
        EasyMock.verify((Object[])new Object[]{lookupCoordinatorManager, request});
    }

    @Test
    public void testExceptionalNew() throws Exception {
        String errMsg = "some error";
        HttpServletRequest request = this.createMockRequest(true);
        Capture auditInfoCapture = Capture.newInstance();
        LookupCoordinatorManager lookupCoordinatorManager = (LookupCoordinatorManager)EasyMock.createStrictMock(LookupCoordinatorManager.class);
        EasyMock.expect((Object)lookupCoordinatorManager.updateLookups((Map)EasyMock.eq(SINGLE_TIER_MAP), (AuditInfo)EasyMock.capture((Capture)auditInfoCapture))).andThrow((Throwable)new RuntimeException("some error")).once();
        EasyMock.replay((Object[])new Object[]{lookupCoordinatorManager, request});
        LookupCoordinatorResource lookupCoordinatorResource = new LookupCoordinatorResource(lookupCoordinatorManager, MAPPER, MAPPER);
        Response response = lookupCoordinatorResource.updateAllLookups(SINGLE_TIER_MAP_SOURCE.openStream(), request);
        Assert.assertEquals((long)500L, (long)response.getStatus());
        Assert.assertEquals((Object)ImmutableMap.of((Object)"error", (Object)"some error"), (Object)response.getEntity());
        Assert.assertTrue((boolean)auditInfoCapture.hasCaptured());
        Assert.assertEquals((Object)this.auditInfo, (Object)auditInfoCapture.getValue());
        EasyMock.verify((Object[])new Object[]{lookupCoordinatorManager, request});
    }

    @Test
    public void testFailedNew() throws Exception {
        HttpServletRequest request = this.createMockRequest(true);
        Capture auditInfoCapture = Capture.newInstance();
        LookupCoordinatorManager lookupCoordinatorManager = (LookupCoordinatorManager)EasyMock.createStrictMock(LookupCoordinatorManager.class);
        EasyMock.expect((Object)lookupCoordinatorManager.updateLookups((Map)EasyMock.eq(SINGLE_TIER_MAP), (AuditInfo)EasyMock.capture((Capture)auditInfoCapture))).andReturn((Object)false).once();
        EasyMock.replay((Object[])new Object[]{lookupCoordinatorManager, request});
        LookupCoordinatorResource lookupCoordinatorResource = new LookupCoordinatorResource(lookupCoordinatorManager, MAPPER, MAPPER);
        Response response = lookupCoordinatorResource.updateAllLookups(SINGLE_TIER_MAP_SOURCE.openStream(), request);
        Assert.assertEquals((long)500L, (long)response.getStatus());
        Assert.assertEquals((Object)ImmutableMap.of((Object)"error", (Object)"Unknown error updating configuration"), (Object)response.getEntity());
        Assert.assertTrue((boolean)auditInfoCapture.hasCaptured());
        Assert.assertEquals((Object)this.auditInfo, (Object)auditInfoCapture.getValue());
        EasyMock.verify((Object[])new Object[]{lookupCoordinatorManager, request});
    }

    @Test
    public void testSimpleNewLookup() throws Exception {
        HttpServletRequest request = this.createMockRequest(true);
        Capture auditInfoCapture = Capture.newInstance();
        LookupCoordinatorManager lookupCoordinatorManager = (LookupCoordinatorManager)EasyMock.createStrictMock(LookupCoordinatorManager.class);
        EasyMock.expect((Object)lookupCoordinatorManager.updateLookup((String)EasyMock.eq((Object)LOOKUP_TIER), (String)EasyMock.eq((Object)LOOKUP_NAME), (LookupExtractorFactoryMapContainer)EasyMock.eq((Object)SINGLE_LOOKUP), (AuditInfo)EasyMock.capture((Capture)auditInfoCapture))).andReturn((Object)true).once();
        EasyMock.replay((Object[])new Object[]{lookupCoordinatorManager, request});
        LookupCoordinatorResource lookupCoordinatorResource = new LookupCoordinatorResource(lookupCoordinatorManager, MAPPER, MAPPER);
        Response response = lookupCoordinatorResource.createOrUpdateLookup(LOOKUP_TIER, LOOKUP_NAME, EMPTY_MAP_SOURCE.openStream(), request);
        Assert.assertEquals((long)202L, (long)response.getStatus());
        Assert.assertTrue((boolean)auditInfoCapture.hasCaptured());
        Assert.assertEquals((Object)this.auditInfo, (Object)auditInfoCapture.getValue());
        EasyMock.verify((Object[])new Object[]{lookupCoordinatorManager, request});
    }

    @Test
    public void testDBErrNewLookup() throws Exception {
        HttpServletRequest request = this.createMockRequest(true);
        Capture auditInfoCapture = Capture.newInstance();
        LookupCoordinatorManager lookupCoordinatorManager = (LookupCoordinatorManager)EasyMock.createStrictMock(LookupCoordinatorManager.class);
        EasyMock.expect((Object)lookupCoordinatorManager.updateLookup((String)EasyMock.eq((Object)LOOKUP_TIER), (String)EasyMock.eq((Object)LOOKUP_NAME), (LookupExtractorFactoryMapContainer)EasyMock.eq((Object)SINGLE_LOOKUP), (AuditInfo)EasyMock.capture((Capture)auditInfoCapture))).andReturn((Object)false).once();
        EasyMock.replay((Object[])new Object[]{lookupCoordinatorManager, request});
        LookupCoordinatorResource lookupCoordinatorResource = new LookupCoordinatorResource(lookupCoordinatorManager, MAPPER, MAPPER);
        Response response = lookupCoordinatorResource.createOrUpdateLookup(LOOKUP_TIER, LOOKUP_NAME, EMPTY_MAP_SOURCE.openStream(), request);
        Assert.assertEquals((long)500L, (long)response.getStatus());
        Assert.assertEquals((Object)ImmutableMap.of((Object)"error", (Object)"Unknown error updating configuration"), (Object)response.getEntity());
        Assert.assertTrue((boolean)auditInfoCapture.hasCaptured());
        Assert.assertEquals((Object)this.auditInfo, (Object)auditInfoCapture.getValue());
        EasyMock.verify((Object[])new Object[]{lookupCoordinatorManager, request});
    }

    @Test
    public void testExceptionalNewLookup() throws Exception {
        String errMsg = "error message";
        HttpServletRequest request = this.createMockRequest(true);
        Capture auditInfoCapture = Capture.newInstance();
        LookupCoordinatorManager lookupCoordinatorManager = (LookupCoordinatorManager)EasyMock.createStrictMock(LookupCoordinatorManager.class);
        EasyMock.expect((Object)lookupCoordinatorManager.updateLookup((String)EasyMock.eq((Object)LOOKUP_TIER), (String)EasyMock.eq((Object)LOOKUP_NAME), (LookupExtractorFactoryMapContainer)EasyMock.eq((Object)SINGLE_LOOKUP), (AuditInfo)EasyMock.capture((Capture)auditInfoCapture))).andThrow((Throwable)new RuntimeException("error message")).once();
        EasyMock.replay((Object[])new Object[]{lookupCoordinatorManager, request});
        LookupCoordinatorResource lookupCoordinatorResource = new LookupCoordinatorResource(lookupCoordinatorManager, MAPPER, MAPPER);
        Response response = lookupCoordinatorResource.createOrUpdateLookup(LOOKUP_TIER, LOOKUP_NAME, EMPTY_MAP_SOURCE.openStream(), request);
        Assert.assertEquals((long)500L, (long)response.getStatus());
        Assert.assertEquals((Object)ImmutableMap.of((Object)"error", (Object)"error message"), (Object)response.getEntity());
        Assert.assertTrue((boolean)auditInfoCapture.hasCaptured());
        Assert.assertEquals((Object)this.auditInfo, (Object)auditInfoCapture.getValue());
        EasyMock.verify((Object[])new Object[]{lookupCoordinatorManager, request});
    }

    @Test
    public void testNullValsNewLookup() throws Exception {
        HttpServletRequest request = (HttpServletRequest)EasyMock.createStrictMock(HttpServletRequest.class);
        LookupCoordinatorManager lookupCoordinatorManager = (LookupCoordinatorManager)EasyMock.createStrictMock(LookupCoordinatorManager.class);
        LookupCoordinatorResource lookupCoordinatorResource = new LookupCoordinatorResource(lookupCoordinatorManager, MAPPER, MAPPER);
        EasyMock.replay((Object[])new Object[]{lookupCoordinatorManager, request});
        Assert.assertEquals((long)400L, (long)lookupCoordinatorResource.createOrUpdateLookup(null, LOOKUP_NAME, EMPTY_MAP_SOURCE.openStream(), request).getStatus());
        Assert.assertEquals((long)400L, (long)lookupCoordinatorResource.createOrUpdateLookup(LOOKUP_TIER, null, EMPTY_MAP_SOURCE.openStream(), request).getStatus());
        Assert.assertEquals((long)400L, (long)lookupCoordinatorResource.createOrUpdateLookup(LOOKUP_TIER, "", EMPTY_MAP_SOURCE.openStream(), request).getStatus());
        Assert.assertEquals((long)400L, (long)lookupCoordinatorResource.createOrUpdateLookup("", LOOKUP_NAME, EMPTY_MAP_SOURCE.openStream(), request).getStatus());
        EasyMock.verify((Object[])new Object[]{lookupCoordinatorManager, request});
    }

    @Test
    public void testSimpleGetTier() {
        LookupCoordinatorManager lookupCoordinatorManager = (LookupCoordinatorManager)EasyMock.createStrictMock(LookupCoordinatorManager.class);
        EasyMock.expect((Object)lookupCoordinatorManager.getKnownLookups()).andReturn(SINGLE_TIER_MAP).once();
        EasyMock.replay((Object[])new Object[]{lookupCoordinatorManager});
        LookupCoordinatorResource lookupCoordinatorResource = new LookupCoordinatorResource(lookupCoordinatorManager, MAPPER, MAPPER);
        Response response = lookupCoordinatorResource.getSpecificTier(LOOKUP_TIER, false);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals(SINGLE_TIER_MAP.get(LOOKUP_TIER).keySet(), (Object)response.getEntity());
        EasyMock.verify((Object[])new Object[]{lookupCoordinatorManager});
    }

    @Test
    public void testMissingGetTier() {
        String tier = "some tier";
        LookupCoordinatorManager lookupCoordinatorManager = (LookupCoordinatorManager)EasyMock.createStrictMock(LookupCoordinatorManager.class);
        ImmutableMap retVal = ImmutableMap.of();
        EasyMock.expect((Object)lookupCoordinatorManager.getKnownLookups()).andReturn(SINGLE_TIER_MAP).once();
        EasyMock.replay((Object[])new Object[]{lookupCoordinatorManager});
        LookupCoordinatorResource lookupCoordinatorResource = new LookupCoordinatorResource(lookupCoordinatorManager, MAPPER, MAPPER);
        Response response = lookupCoordinatorResource.getSpecificTier("some tier", false);
        Assert.assertEquals((long)404L, (long)response.getStatus());
        EasyMock.verify((Object[])new Object[]{lookupCoordinatorManager});
    }

    @Test
    public void testNullGetTier() {
        String tier = null;
        LookupCoordinatorManager lookupCoordinatorManager = (LookupCoordinatorManager)EasyMock.createStrictMock(LookupCoordinatorManager.class);
        EasyMock.replay((Object[])new Object[]{lookupCoordinatorManager});
        LookupCoordinatorResource lookupCoordinatorResource = new LookupCoordinatorResource(lookupCoordinatorManager, MAPPER, MAPPER);
        Response response = lookupCoordinatorResource.getSpecificTier(tier, false);
        Assert.assertEquals((long)400L, (long)response.getStatus());
        Assert.assertEquals((Object)ImmutableMap.of((Object)"error", (Object)"`tier` required"), (Object)response.getEntity());
        EasyMock.verify((Object[])new Object[]{lookupCoordinatorManager});
    }

    @Test
    public void testNullLookupsGetTier() {
        String tier = "some tier";
        LookupCoordinatorManager lookupCoordinatorManager = (LookupCoordinatorManager)EasyMock.createStrictMock(LookupCoordinatorManager.class);
        EasyMock.expect((Object)lookupCoordinatorManager.getKnownLookups()).andReturn(null).once();
        EasyMock.replay((Object[])new Object[]{lookupCoordinatorManager});
        LookupCoordinatorResource lookupCoordinatorResource = new LookupCoordinatorResource(lookupCoordinatorManager, MAPPER, MAPPER);
        Response response = lookupCoordinatorResource.getSpecificTier("some tier", false);
        Assert.assertEquals((long)404L, (long)response.getStatus());
        Assert.assertEquals((Object)ImmutableMap.of((Object)"error", (Object)"No lookups found"), (Object)response.getEntity());
        EasyMock.verify((Object[])new Object[]{lookupCoordinatorManager});
    }

    @Test
    public void testExceptionalGetTier() {
        String tier = "some tier";
        String errMsg = "some error";
        LookupCoordinatorManager lookupCoordinatorManager = (LookupCoordinatorManager)EasyMock.createStrictMock(LookupCoordinatorManager.class);
        EasyMock.expect((Object)lookupCoordinatorManager.getKnownLookups()).andThrow((Throwable)new RuntimeException("some error")).once();
        EasyMock.replay((Object[])new Object[]{lookupCoordinatorManager});
        LookupCoordinatorResource lookupCoordinatorResource = new LookupCoordinatorResource(lookupCoordinatorManager, MAPPER, MAPPER);
        Response response = lookupCoordinatorResource.getSpecificTier("some tier", false);
        Assert.assertEquals((long)500L, (long)response.getStatus());
        Assert.assertEquals((Object)ImmutableMap.of((Object)"error", (Object)"some error"), (Object)response.getEntity());
        EasyMock.verify((Object[])new Object[]{lookupCoordinatorManager});
    }

    @Test
    public void testGetAllLookupsStatus() {
        LookupCoordinatorManager lookupCoordinatorManager = (LookupCoordinatorManager)EasyMock.createStrictMock(LookupCoordinatorManager.class);
        EasyMock.expect((Object)lookupCoordinatorManager.getKnownLookups()).andReturn(SINGLE_TIER_MAP);
        EasyMock.expect((Object)lookupCoordinatorManager.getLastKnownLookupsStateOnNodes()).andReturn(NODES_LOOKUP_STATE);
        EasyMock.expect((Object)lookupCoordinatorManager.discoverNodesInTier(LOOKUP_TIER)).andReturn((Object)ImmutableList.of((Object)LOOKUP_NODE));
        EasyMock.replay((Object[])new Object[]{lookupCoordinatorManager});
        LookupCoordinatorResource lookupCoordinatorResource = new LookupCoordinatorResource(lookupCoordinatorManager, MAPPER, MAPPER);
        Response response = lookupCoordinatorResource.getAllLookupsStatus(false);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)ImmutableMap.of((Object)LOOKUP_TIER, (Object)ImmutableMap.of((Object)LOOKUP_NAME, (Object)new LookupCoordinatorResource.LookupStatus(true, null))), (Object)response.getEntity());
        EasyMock.verify((Object[])new Object[]{lookupCoordinatorManager});
    }

    @Test
    public void testGetLookupStatusForTier() {
        LookupCoordinatorManager lookupCoordinatorManager = (LookupCoordinatorManager)EasyMock.createStrictMock(LookupCoordinatorManager.class);
        EasyMock.expect((Object)lookupCoordinatorManager.getKnownLookups()).andReturn(SINGLE_TIER_MAP);
        EasyMock.expect((Object)lookupCoordinatorManager.discoverNodesInTier(LOOKUP_TIER)).andReturn((Object)ImmutableList.of((Object)LOOKUP_NODE));
        EasyMock.expect((Object)lookupCoordinatorManager.getLastKnownLookupsStateOnNodes()).andReturn(NODES_LOOKUP_STATE);
        EasyMock.replay((Object[])new Object[]{lookupCoordinatorManager});
        LookupCoordinatorResource lookupCoordinatorResource = new LookupCoordinatorResource(lookupCoordinatorManager, MAPPER, MAPPER);
        Response response = lookupCoordinatorResource.getLookupStatusForTier(LOOKUP_TIER, false);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)ImmutableMap.of((Object)LOOKUP_NAME, (Object)new LookupCoordinatorResource.LookupStatus(true, null)), (Object)response.getEntity());
        EasyMock.verify((Object[])new Object[]{lookupCoordinatorManager});
    }

    @Test
    public void testGetSpecificLookupStatus() {
        LookupCoordinatorManager lookupCoordinatorManager = (LookupCoordinatorManager)EasyMock.createStrictMock(LookupCoordinatorManager.class);
        EasyMock.expect((Object)lookupCoordinatorManager.getKnownLookups()).andReturn(SINGLE_TIER_MAP);
        EasyMock.expect((Object)lookupCoordinatorManager.discoverNodesInTier(LOOKUP_TIER)).andReturn((Object)ImmutableList.of((Object)LOOKUP_NODE));
        EasyMock.expect((Object)lookupCoordinatorManager.getLastKnownLookupsStateOnNodes()).andReturn(NODES_LOOKUP_STATE);
        EasyMock.replay((Object[])new Object[]{lookupCoordinatorManager});
        LookupCoordinatorResource lookupCoordinatorResource = new LookupCoordinatorResource(lookupCoordinatorManager, MAPPER, MAPPER);
        Response response = lookupCoordinatorResource.getSpecificLookupStatus(LOOKUP_TIER, LOOKUP_NAME, false);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)new LookupCoordinatorResource.LookupStatus(true, null), (Object)response.getEntity());
        EasyMock.verify((Object[])new Object[]{lookupCoordinatorManager});
    }

    @Test
    public void testGetLookupStatusDetailedTrue() {
        LookupCoordinatorResource lookupCoordinatorResource = new LookupCoordinatorResource((LookupCoordinatorManager)EasyMock.createStrictMock(LookupCoordinatorManager.class), MAPPER, MAPPER);
        HostAndPort newNode = HostAndPort.fromParts((String)"localhost", (int)4352);
        Assert.assertEquals((Object)new LookupCoordinatorResource.LookupStatus(false, (List)ImmutableList.of((Object)newNode)), (Object)lookupCoordinatorResource.getLookupStatus(LOOKUP_NAME, SINGLE_LOOKUP, (Collection)ImmutableList.of((Object)LOOKUP_NODE, (Object)newNode), NODES_LOOKUP_STATE, true));
    }

    @Test
    public void testGetLookupStatusDetailedFalse() {
        LookupCoordinatorResource lookupCoordinatorResource = new LookupCoordinatorResource((LookupCoordinatorManager)EasyMock.createStrictMock(LookupCoordinatorManager.class), MAPPER, MAPPER);
        HostAndPort newNode = HostAndPort.fromParts((String)"localhost", (int)4352);
        Assert.assertEquals((Object)new LookupCoordinatorResource.LookupStatus(false, null), (Object)lookupCoordinatorResource.getLookupStatus(LOOKUP_NAME, SINGLE_LOOKUP, (Collection)ImmutableList.of((Object)LOOKUP_NODE, (Object)newNode), NODES_LOOKUP_STATE, false));
    }

    @Test
    public void testGetAllNodesStatus() {
        LookupCoordinatorManager lookupCoordinatorManager = (LookupCoordinatorManager)EasyMock.createStrictMock(LookupCoordinatorManager.class);
        EasyMock.expect((Object)lookupCoordinatorManager.getKnownLookups()).andReturn(SINGLE_TIER_MAP);
        EasyMock.expect((Object)lookupCoordinatorManager.getLastKnownLookupsStateOnNodes()).andReturn(NODES_LOOKUP_STATE);
        EasyMock.expect((Object)lookupCoordinatorManager.discoverNodesInTier(LOOKUP_TIER)).andReturn((Object)ImmutableList.of((Object)LOOKUP_NODE));
        EasyMock.replay((Object[])new Object[]{lookupCoordinatorManager});
        LookupCoordinatorResource lookupCoordinatorResource = new LookupCoordinatorResource(lookupCoordinatorManager, MAPPER, MAPPER);
        Response response = lookupCoordinatorResource.getAllNodesStatus(false, null);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)ImmutableMap.of((Object)LOOKUP_TIER, (Object)ImmutableMap.of((Object)LOOKUP_NODE, LOOKUP_STATE)), (Object)response.getEntity());
        EasyMock.verify((Object[])new Object[]{lookupCoordinatorManager});
    }

    @Test
    public void testGetAllNodesStatusDetailedFalse() {
        LookupCoordinatorManager lookupCoordinatorManager = (LookupCoordinatorManager)EasyMock.createStrictMock(LookupCoordinatorManager.class);
        EasyMock.expect((Object)lookupCoordinatorManager.getKnownLookups()).andReturn(SINGLE_TIER_MAP);
        EasyMock.expect((Object)lookupCoordinatorManager.getLastKnownLookupsStateOnNodes()).andReturn(NODES_LOOKUP_STATE);
        EasyMock.expect((Object)lookupCoordinatorManager.discoverNodesInTier(LOOKUP_TIER)).andReturn((Object)ImmutableList.of((Object)LOOKUP_NODE));
        EasyMock.replay((Object[])new Object[]{lookupCoordinatorManager});
        LookupCoordinatorResource lookupCoordinatorResource = new LookupCoordinatorResource(lookupCoordinatorManager, MAPPER, MAPPER);
        Response response = lookupCoordinatorResource.getAllNodesStatus(false, Boolean.valueOf(false));
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)ImmutableMap.of((Object)LOOKUP_TIER, (Object)ImmutableMap.of((Object)LOOKUP_NODE, (Object)new LookupsState((Map)ImmutableMap.of((Object)LOOKUP_NAME, (Object)SINGLE_LOOKUP.getVersion()), null, null))), (Object)response.getEntity());
        EasyMock.verify((Object[])new Object[]{lookupCoordinatorManager});
    }

    @Test
    public void testGetNodesStatusInTier() {
        LookupCoordinatorManager lookupCoordinatorManager = (LookupCoordinatorManager)EasyMock.createStrictMock(LookupCoordinatorManager.class);
        EasyMock.expect((Object)lookupCoordinatorManager.getLastKnownLookupsStateOnNodes()).andReturn(NODES_LOOKUP_STATE);
        EasyMock.expect((Object)lookupCoordinatorManager.discoverNodesInTier(LOOKUP_TIER)).andReturn((Object)ImmutableList.of((Object)LOOKUP_NODE));
        EasyMock.replay((Object[])new Object[]{lookupCoordinatorManager});
        LookupCoordinatorResource lookupCoordinatorResource = new LookupCoordinatorResource(lookupCoordinatorManager, MAPPER, MAPPER);
        Response response = lookupCoordinatorResource.getNodesStatusInTier(LOOKUP_TIER);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)ImmutableMap.of((Object)LOOKUP_NODE, LOOKUP_STATE), (Object)response.getEntity());
        EasyMock.verify((Object[])new Object[]{lookupCoordinatorManager});
    }

    @Test
    public void testGetSpecificNodeStatus() {
        LookupCoordinatorManager lookupCoordinatorManager = (LookupCoordinatorManager)EasyMock.createStrictMock(LookupCoordinatorManager.class);
        EasyMock.expect((Object)lookupCoordinatorManager.getLastKnownLookupsStateOnNodes()).andReturn(NODES_LOOKUP_STATE);
        EasyMock.replay((Object[])new Object[]{lookupCoordinatorManager});
        LookupCoordinatorResource lookupCoordinatorResource = new LookupCoordinatorResource(lookupCoordinatorManager, MAPPER, MAPPER);
        Response response = lookupCoordinatorResource.getSpecificNodeStatus(LOOKUP_TIER, LOOKUP_NODE);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals(LOOKUP_STATE, (Object)response.getEntity());
        EasyMock.verify((Object[])new Object[]{lookupCoordinatorManager});
    }

    @Test
    public void testGetAllLookupSpecs() {
        ImmutableMap lookups = ImmutableMap.of((Object)"tier1", (Object)ImmutableMap.of((Object)"lookup1", (Object)new LookupExtractorFactoryMapContainer("v0", (Map)ImmutableMap.of((Object)"k1", (Object)"v2")), (Object)"lookup2", (Object)new LookupExtractorFactoryMapContainer("v1", (Map)ImmutableMap.of((Object)"k", (Object)"v"))), (Object)"tier2", (Object)ImmutableMap.of((Object)"lookup1", (Object)new LookupExtractorFactoryMapContainer("v0", (Map)ImmutableMap.of((Object)"k1", (Object)"v2"))));
        LookupCoordinatorManager lookupCoordinatorManager = (LookupCoordinatorManager)EasyMock.createStrictMock(LookupCoordinatorManager.class);
        EasyMock.expect((Object)lookupCoordinatorManager.getKnownLookups()).andReturn((Object)lookups).once();
        EasyMock.replay((Object[])new Object[]{lookupCoordinatorManager});
        LookupCoordinatorResource lookupCoordinatorResource = new LookupCoordinatorResource(lookupCoordinatorManager, MAPPER, MAPPER);
        Response response = lookupCoordinatorResource.getAllLookupSpecs();
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        Assert.assertEquals((Object)lookups, (Object)response.getEntity());
        EasyMock.verify((Object[])new Object[]{lookupCoordinatorManager});
    }

    @Test
    public void testGetEmptyAllLookupSpecs() {
        LookupCoordinatorManager lookupCoordinatorManager = (LookupCoordinatorManager)EasyMock.createStrictMock(LookupCoordinatorManager.class);
        EasyMock.expect((Object)lookupCoordinatorManager.getKnownLookups()).andReturn(null).once();
        EasyMock.replay((Object[])new Object[]{lookupCoordinatorManager});
        LookupCoordinatorResource lookupCoordinatorResource = new LookupCoordinatorResource(lookupCoordinatorManager, MAPPER, MAPPER);
        Response response = lookupCoordinatorResource.getAllLookupSpecs();
        Assert.assertEquals((long)Response.Status.NOT_FOUND.getStatusCode(), (long)response.getStatus());
        EasyMock.verify((Object[])new Object[]{lookupCoordinatorManager});
    }

    private HttpServletRequest createMockRequest(boolean hasJsonPayload) {
        HttpServletRequest request = (HttpServletRequest)EasyMock.createStrictMock(HttpServletRequest.class);
        if (hasJsonPayload) {
            EasyMock.expect((Object)request.getContentType()).andReturn((Object)"application/json").once();
        }
        EasyMock.expect((Object)request.getHeader("X-Druid-Author")).andReturn((Object)"some author").once();
        EasyMock.expect((Object)request.getHeader("X-Druid-Comment")).andReturn((Object)"some comment").once();
        EasyMock.expect((Object)request.getAttribute("Druid-Authentication-Result")).andReturn((Object)AUTH_RESULT).once();
        EasyMock.expect((Object)request.getRemoteAddr()).andReturn((Object)"127.0.0.1").once();
        return request;
    }
}

