/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.http;

import com.google.common.util.concurrent.Futures;
import java.net.URI;
import java.net.URISyntaxException;
import javax.servlet.http.HttpServletRequest;
import org.apache.druid.rpc.indexing.OverlordClient;
import org.apache.druid.server.http.OverlordProxyServlet;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;

public class OverlordProxyServletTest {
    @Test
    public void testRewriteURI() throws URISyntaxException {
        OverlordClient overlordClient = (OverlordClient)EasyMock.createMock(OverlordClient.class);
        EasyMock.expect((Object)overlordClient.findCurrentLeader()).andReturn((Object)Futures.immediateFuture((Object)new URI("https://overlord:port")));
        HttpServletRequest request = (HttpServletRequest)EasyMock.createMock(HttpServletRequest.class);
        EasyMock.expect((Object)request.getQueryString()).andReturn((Object)"param1=test&param2=test2").anyTimes();
        EasyMock.expect((Object)request.getRequestURI()).andReturn((Object)"/druid/over%3Alord/worker").anyTimes();
        EasyMock.replay((Object[])new Object[]{overlordClient, request});
        URI uri = URI.create(new OverlordProxyServlet(overlordClient, null, null).rewriteTarget(request));
        Assert.assertEquals((Object)"https://overlord:port/druid/over%3Alord/worker?param1=test&param2=test2", (Object)uri.toString());
        EasyMock.verify((Object[])new Object[]{overlordClient, request});
    }
}

