/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.http.security;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.server.metrics.NoopServiceEmitter;
import org.apache.druid.server.mocks.MockHttpServletRequest;
import org.apache.druid.server.mocks.MockHttpServletResponse;
import org.apache.druid.server.security.AllowAllAuthenticator;
import org.apache.druid.server.security.AuthenticationResult;
import org.apache.druid.server.security.Authenticator;
import org.apache.druid.server.security.PreResponseAuthorizationCheckFilter;
import org.junit.Assert;
import org.junit.Test;

public class PreResponseAuthorizationCheckFilterTest {
    private static final List<Authenticator> authenticators = Collections.singletonList(new AllowAllAuthenticator());

    @Test
    public void testValidRequest() throws Exception {
        AuthenticationResult authenticationResult = new AuthenticationResult("so-very-valid", "so-very-valid", null, null);
        MockHttpServletRequest req = new MockHttpServletRequest();
        MockHttpServletResponse resp = new MockHttpServletResponse();
        req.attributes.put("Druid-Authentication-Result", authenticationResult);
        req.attributes.put("Druid-Authorization-Checked", true);
        PreResponseAuthorizationCheckFilter filter = new PreResponseAuthorizationCheckFilter(authenticators, (ObjectMapper)new DefaultObjectMapper());
        filter.doFilter((ServletRequest)req, (ServletResponse)resp, (request, response) -> {});
    }

    @Test
    public void testAuthenticationFailedRequest() throws Exception {
        MockHttpServletRequest req = new MockHttpServletRequest();
        MockHttpServletResponse resp = new MockHttpServletResponse();
        PreResponseAuthorizationCheckFilter filter = new PreResponseAuthorizationCheckFilter(authenticators, (ObjectMapper)new DefaultObjectMapper());
        filter.doFilter((ServletRequest)req, (ServletResponse)resp, (request, response) -> {});
        Assert.assertEquals((long)401L, (long)resp.getStatus());
        Assert.assertEquals((Object)"application/json", (Object)resp.getContentType());
        Assert.assertEquals((Object)"UTF-8", (Object)resp.getCharacterEncoding());
    }

    @Test
    public void testMissingAuthorizationCheckAndNotCommitted() throws ServletException, IOException {
        EmittingLogger.registerEmitter((ServiceEmitter)new NoopServiceEmitter());
        AuthenticationResult authenticationResult = new AuthenticationResult("so-very-valid", "so-very-valid", null, null);
        MockHttpServletRequest req = new MockHttpServletRequest();
        req.requestUri = "uri";
        req.method = "GET";
        req.remoteAddr = "1.2.3.4";
        req.remoteHost = "aHost";
        MockHttpServletResponse resp = new MockHttpServletResponse();
        resp.setStatus(200);
        req.attributes.put("Druid-Authentication-Result", authenticationResult);
        PreResponseAuthorizationCheckFilter filter = new PreResponseAuthorizationCheckFilter(authenticators, (ObjectMapper)new DefaultObjectMapper());
        filter.doFilter((ServletRequest)req, (ServletResponse)resp, (request, response) -> {});
        Assert.assertEquals((long)403L, (long)resp.getStatus());
    }

    @Test
    public void testMissingAuthorizationCheck401ResponseAndNotCommitted() throws ServletException, IOException {
        EmittingLogger.registerEmitter((ServiceEmitter)new NoopServiceEmitter());
        AuthenticationResult authenticationResult = new AuthenticationResult("so-very-valid", "so-very-valid", null, null);
        MockHttpServletRequest req = new MockHttpServletRequest();
        req.requestUri = "uri";
        req.method = "GET";
        req.remoteAddr = "1.2.3.4";
        req.remoteHost = "aHost";
        MockHttpServletResponse resp = new MockHttpServletResponse();
        resp.setStatus(401);
        req.attributes.put("Druid-Authentication-Result", authenticationResult);
        PreResponseAuthorizationCheckFilter filter = new PreResponseAuthorizationCheckFilter(authenticators, (ObjectMapper)new DefaultObjectMapper());
        filter.doFilter((ServletRequest)req, (ServletResponse)resp, (request, response) -> {});
        Assert.assertEquals((long)401L, (long)resp.getStatus());
    }

    @Test
    public void testMissingAuthorizationCheckWithForbidden() throws Exception {
        EmittingLogger.registerEmitter((ServiceEmitter)new NoopServiceEmitter());
        AuthenticationResult authenticationResult = new AuthenticationResult("so-very-valid", "so-very-valid", null, null);
        MockHttpServletRequest req = new MockHttpServletRequest();
        req.attributes.put("Druid-Authentication-Result", authenticationResult);
        MockHttpServletResponse resp = new MockHttpServletResponse();
        resp.setStatus(403);
        PreResponseAuthorizationCheckFilter filter = new PreResponseAuthorizationCheckFilter(authenticators, (ObjectMapper)new DefaultObjectMapper());
        filter.doFilter((ServletRequest)req, (ServletResponse)resp, (request, response) -> {});
        Assert.assertEquals((long)403L, (long)resp.getStatus());
    }

    @Test
    public void testMissingAuthorizationCheckWith404Keeps404() throws Exception {
        EmittingLogger.registerEmitter((ServiceEmitter)new NoopServiceEmitter());
        AuthenticationResult authenticationResult = new AuthenticationResult("so-very-valid", "so-very-valid", null, null);
        MockHttpServletRequest req = new MockHttpServletRequest();
        req.attributes.put("Druid-Authentication-Result", authenticationResult);
        MockHttpServletResponse resp = new MockHttpServletResponse();
        resp.setStatus(404);
        PreResponseAuthorizationCheckFilter filter = new PreResponseAuthorizationCheckFilter(authenticators, (ObjectMapper)new DefaultObjectMapper());
        filter.doFilter((ServletRequest)req, (ServletResponse)resp, (request, response) -> {});
        Assert.assertEquals((long)404L, (long)resp.getStatus());
    }

    @Test
    public void testMissingAuthorizationCheckWith307Keeps307() throws Exception {
        EmittingLogger.registerEmitter((ServiceEmitter)new NoopServiceEmitter());
        AuthenticationResult authenticationResult = new AuthenticationResult("so-very-valid", "so-very-valid", null, null);
        MockHttpServletRequest req = new MockHttpServletRequest();
        req.attributes.put("Druid-Authentication-Result", authenticationResult);
        MockHttpServletResponse resp = new MockHttpServletResponse();
        resp.setStatus(307);
        PreResponseAuthorizationCheckFilter filter = new PreResponseAuthorizationCheckFilter(authenticators, (ObjectMapper)new DefaultObjectMapper());
        filter.doFilter((ServletRequest)req, (ServletResponse)resp, (request, response) -> {});
        Assert.assertEquals((long)307L, (long)resp.getStatus());
    }
}

