/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.initialization;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Guice;
import com.google.inject.Injector;
import java.util.Properties;
import javax.validation.Validation;
import javax.validation.Validator;
import org.apache.druid.guice.DruidGuiceExtensions;
import org.apache.druid.guice.JsonConfigurator;
import org.apache.druid.guice.LazySingleton;
import org.apache.druid.server.initialization.ExternalStorageAccessSecurityModule;
import org.apache.druid.server.initialization.JdbcAccessSecurityConfig;
import org.junit.Assert;
import org.junit.Test;

public class ExternalStorageAccessSecurityModuleTest {
    @Test
    public void testSecurityConfigDefault() {
        JdbcAccessSecurityConfig securityConfig = (JdbcAccessSecurityConfig)ExternalStorageAccessSecurityModuleTest.makeInjectorWithProperties(new Properties()).getInstance(JdbcAccessSecurityConfig.class);
        Assert.assertNotNull((Object)securityConfig);
        Assert.assertEquals((Object)JdbcAccessSecurityConfig.DEFAULT_ALLOWED_PROPERTIES, (Object)securityConfig.getAllowedProperties());
        Assert.assertTrue((boolean)securityConfig.isAllowUnknownJdbcUrlFormat());
        Assert.assertTrue((boolean)securityConfig.isEnforceAllowedProperties());
    }

    @Test
    public void testSecurityConfigOverride() {
        Properties properties = new Properties();
        properties.setProperty("druid.access.jdbc.allowedProperties", "[\"valid1\", \"valid2\", \"valid3\"]");
        properties.setProperty("druid.access.jdbc.allowUnknownJdbcUrlFormat", "false");
        properties.setProperty("druid.access.jdbc.enforceAllowedProperties", "true");
        JdbcAccessSecurityConfig securityConfig = (JdbcAccessSecurityConfig)ExternalStorageAccessSecurityModuleTest.makeInjectorWithProperties(properties).getInstance(JdbcAccessSecurityConfig.class);
        Assert.assertNotNull((Object)securityConfig);
        Assert.assertEquals((Object)ImmutableSet.of((Object)"valid1", (Object)"valid2", (Object)"valid3"), (Object)securityConfig.getAllowedProperties());
        Assert.assertFalse((boolean)securityConfig.isAllowUnknownJdbcUrlFormat());
        Assert.assertTrue((boolean)securityConfig.isEnforceAllowedProperties());
    }

    private static Injector makeInjectorWithProperties(Properties props) {
        return Guice.createInjector((Iterable)ImmutableList.of((Object)new DruidGuiceExtensions(), binder -> {
            binder.bind(Validator.class).toInstance((Object)Validation.buildDefaultValidatorFactory().getValidator());
            binder.bind(JsonConfigurator.class).in(LazySingleton.class);
            binder.bind(Properties.class).toInstance((Object)props);
        }, (Object)new ExternalStorageAccessSecurityModule()));
    }
}

