/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.log;

import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.ProvisionException;
import java.util.Properties;
import javax.validation.Validation;
import org.apache.druid.guice.JsonConfigurator;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.server.log.NoopRequestLoggerProvider;
import org.apache.druid.server.log.RequestLoggerProvider;
import org.apache.druid.server.log.TestRequestLoggerProvider;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class RequestLoggerProviderTest {
    private final DefaultObjectMapper mapper = new DefaultObjectMapper();
    @Rule
    public final ExpectedException expectedException = ExpectedException.none();

    public RequestLoggerProviderTest() {
        this.mapper.registerSubtypes(new Class[]{NoopRequestLoggerProvider.class, TestRequestLoggerProvider.class});
        InjectableValues.Std injectableValues = new InjectableValues.Std();
        injectableValues.addValue(ObjectMapper.class, (Object)this.mapper);
        this.mapper.setInjectableValues((InjectableValues)injectableValues);
    }

    @Test
    public void testNoLoggerAtAll() {
        Properties properties = new Properties();
        properties.setProperty("dummy", "unrelated");
        JsonConfigurator configurator = new JsonConfigurator((ObjectMapper)this.mapper, Validation.buildDefaultValidatorFactory().getValidator());
        RequestLoggerProvider provider = (RequestLoggerProvider)configurator.configurate(properties, "log", RequestLoggerProvider.class, NoopRequestLoggerProvider.class);
        Assert.assertThat((Object)provider, (Matcher)CoreMatchers.instanceOf(NoopRequestLoggerProvider.class));
    }

    @Test
    public void testLoggerPropertiesWithNoType() {
        Properties properties = new Properties();
        properties.setProperty("dummy", "unrelated");
        properties.setProperty("log.foo", "bar");
        JsonConfigurator configurator = new JsonConfigurator((ObjectMapper)this.mapper, Validation.buildDefaultValidatorFactory().getValidator());
        this.expectedException.expect(ProvisionException.class);
        this.expectedException.expectMessage("missing type id property 'type'");
        configurator.configurate(properties, "log", RequestLoggerProvider.class, NoopRequestLoggerProvider.class);
    }
}

