/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.security;

import com.google.common.base.Function;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import org.apache.druid.server.mocks.MockHttpServletRequest;
import org.apache.druid.server.security.Action;
import org.apache.druid.server.security.AllowAllAuthorizer;
import org.apache.druid.server.security.AuthenticationResult;
import org.apache.druid.server.security.AuthorizationUtils;
import org.apache.druid.server.security.AuthorizerMapper;
import org.apache.druid.server.security.Resource;
import org.apache.druid.server.security.ResourceAction;
import org.apache.druid.server.security.ResourceType;
import org.junit.Assert;
import org.junit.Test;

public class AuthorizationUtilsTest {
    @Test
    public void testFilterResourcesWithAllowAllAuthorizer() {
        String authorizerName = "allowAll";
        AuthenticationResult authenticationResult = new AuthenticationResult("identity", authorizerName, "authenticator", null);
        ArrayList<String> resources = new ArrayList<String>();
        resources.add("duplicate");
        resources.add("duplicate");
        resources.add("filteredResource");
        resources.add("hello");
        Function<String, Iterable<ResourceAction>> resourceActionGenerator = new Function<String, Iterable<ResourceAction>>(){

            @Nullable
            public Iterable<ResourceAction> apply(@Nullable String input) {
                if ("filteredResource".equals(input)) {
                    return null;
                }
                return Collections.singletonList(new ResourceAction(Resource.STATE_RESOURCE, Action.READ));
            }
        };
        HashMap<String, AllowAllAuthorizer> authorizerMap = new HashMap<String, AllowAllAuthorizer>();
        authorizerMap.put(authorizerName, new AllowAllAuthorizer());
        AuthorizerMapper mapper = new AuthorizerMapper(authorizerMap);
        Iterable filteredResults = AuthorizationUtils.filterAuthorizedResources((AuthenticationResult)authenticationResult, resources, (Function)resourceActionGenerator, (AuthorizerMapper)mapper);
        Iterator itr = filteredResults.iterator();
        Assert.assertTrue((boolean)itr.hasNext());
        Assert.assertEquals((Object)"duplicate", itr.next());
        Assert.assertEquals((Object)"duplicate", itr.next());
        Assert.assertEquals((Object)"hello", itr.next());
        Assert.assertFalse((boolean)itr.hasNext());
    }

    @Test
    public void testMakeSuperuserPermissions() {
        String customType = "CUSTOM";
        ResourceType.registerResourceType((String)"CUSTOM");
        List permissions = AuthorizationUtils.makeSuperUserPermissions();
        for (String type : ResourceType.knownTypes()) {
            for (Action action : Action.values()) {
                Assert.assertTrue((boolean)permissions.stream().filter(ra -> Objects.equals(type, ra.getResource().getType())).anyMatch(ra -> action == ra.getAction() && ".*".equals(ra.getResource().getName())));
            }
        }
        for (Action action : Action.values()) {
            Assert.assertTrue((boolean)permissions.stream().filter(ra -> Objects.equals("CUSTOM", ra.getResource().getType())).anyMatch(ra -> action == ra.getAction() && ".*".equals(ra.getResource().getName())));
        }
    }

    @Test
    public void testAuthorizationAttributeIfNeeded() {
        MockHttpServletRequest request = new MockHttpServletRequest();
        AuthorizationUtils.setRequestAuthorizationAttributeIfNeeded((HttpServletRequest)request);
        Assert.assertEquals((Object)true, (Object)request.getAttribute("Druid-Authorization-Checked"));
    }
}

