/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.client.indexing;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.client.indexing.ClientTaskQuery;
import org.apache.druid.error.InvalidInput;
import org.joda.time.DateTime;
import org.joda.time.Interval;

public class ClientKillUnusedSegmentsTaskQuery
implements ClientTaskQuery {
    public static final String TYPE = "kill";
    private final String id;
    private final String dataSource;
    private final Interval interval;
    private final Boolean markAsUnused;
    private final Integer batchSize;
    @Nullable
    private final Integer limit;
    @Nullable
    private final DateTime maxUsedStatusLastUpdatedTime;

    @JsonCreator
    public ClientKillUnusedSegmentsTaskQuery(@JsonProperty(value="id") String id, @JsonProperty(value="dataSource") String dataSource, @JsonProperty(value="interval") Interval interval, @JsonProperty(value="markAsUnused") @Deprecated Boolean markAsUnused, @JsonProperty(value="batchSize") Integer batchSize, @JsonProperty(value="limit") @Nullable Integer limit, @JsonProperty(value="maxUsedStatusLastUpdatedTime") @Nullable DateTime maxUsedStatusLastUpdatedTime) {
        if (id == null) {
            throw InvalidInput.exception((String)"kill task id cannot be null", (Object[])new Object[0]);
        }
        if (limit != null && limit <= 0) {
            throw InvalidInput.exception((String)"limit[%d] must be a positive integer.", (Object[])new Object[]{limit});
        }
        this.id = id;
        this.dataSource = dataSource;
        this.interval = interval;
        this.markAsUnused = markAsUnused;
        this.batchSize = batchSize;
        this.limit = limit;
        this.maxUsedStatusLastUpdatedTime = maxUsedStatusLastUpdatedTime;
    }

    @Override
    @JsonProperty
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty
    public String getType() {
        return TYPE;
    }

    @Override
    @JsonProperty
    public String getDataSource() {
        return this.dataSource;
    }

    @JsonProperty
    public Interval getInterval() {
        return this.interval;
    }

    @Deprecated
    @JsonProperty
    public Boolean getMarkAsUnused() {
        return this.markAsUnused;
    }

    @JsonProperty
    public Integer getBatchSize() {
        return this.batchSize;
    }

    @JsonProperty
    @Nullable
    public Integer getLimit() {
        return this.limit;
    }

    @JsonProperty
    @Nullable
    public DateTime getMaxUsedStatusLastUpdatedTime() {
        return this.maxUsedStatusLastUpdatedTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClientKillUnusedSegmentsTaskQuery that = (ClientKillUnusedSegmentsTaskQuery)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.dataSource, that.dataSource) && Objects.equals(this.interval, that.interval) && Objects.equals(this.markAsUnused, that.markAsUnused) && Objects.equals(this.batchSize, that.batchSize) && Objects.equals(this.limit, that.limit) && Objects.equals(this.maxUsedStatusLastUpdatedTime, that.maxUsedStatusLastUpdatedTime);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.dataSource, this.interval, this.markAsUnused, this.batchSize, this.limit, this.maxUsedStatusLastUpdatedTime);
    }
}

