/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.guice;

import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.Module;
import com.google.common.collect.ImmutableList;
import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.multibindings.MapBinder;
import java.util.List;
import org.apache.druid.data.SearchableVersionedDataFinder;
import org.apache.druid.guice.Binders;
import org.apache.druid.guice.JsonConfigProvider;
import org.apache.druid.guice.LazySingleton;
import org.apache.druid.guice.PolyBind;
import org.apache.druid.initialization.DruidModule;
import org.apache.druid.segment.loading.DataSegmentKiller;
import org.apache.druid.segment.loading.DataSegmentPusher;
import org.apache.druid.segment.loading.LocalDataSegmentKiller;
import org.apache.druid.segment.loading.LocalDataSegmentPusher;
import org.apache.druid.segment.loading.LocalDataSegmentPusherConfig;
import org.apache.druid.segment.loading.LocalFileTimestampVersionFinder;
import org.apache.druid.segment.loading.LocalLoadSpec;
import org.apache.druid.segment.loading.SegmentCacheManager;
import org.apache.druid.segment.loading.SegmentLoader;
import org.apache.druid.segment.loading.SegmentLocalCacheLoader;
import org.apache.druid.segment.loading.SegmentLocalCacheManager;

public class LocalDataStorageDruidModule
implements DruidModule {
    public static final String SCHEME = "local";

    public void configure(Binder binder) {
        binder.bind(SegmentCacheManager.class).to(SegmentLocalCacheManager.class).in(LazySingleton.class);
        binder.bind(SegmentLoader.class).to(SegmentLocalCacheLoader.class).in(LazySingleton.class);
        LocalDataStorageDruidModule.bindDeepStorageLocal(binder);
        PolyBind.createChoice((Binder)binder, (String)"druid.storage.type", (Key)Key.get(DataSegmentPusher.class), (Key)Key.get(LocalDataSegmentPusher.class));
        PolyBind.createChoice((Binder)binder, (String)"druid.storage.type", (Key)Key.get(DataSegmentKiller.class), (Key)Key.get(LocalDataSegmentKiller.class));
    }

    private static void bindDeepStorageLocal(Binder binder) {
        MapBinder.newMapBinder((Binder)binder, String.class, SearchableVersionedDataFinder.class).addBinding((Object)"file").to(LocalFileTimestampVersionFinder.class).in(LazySingleton.class);
        Binders.dataSegmentKillerBinder((Binder)binder).addBinding((Object)SCHEME).to(LocalDataSegmentKiller.class).in(LazySingleton.class);
        PolyBind.optionBinder((Binder)binder, (Key)Key.get(DataSegmentPusher.class)).addBinding((Object)SCHEME).to(LocalDataSegmentPusher.class).in(LazySingleton.class);
        JsonConfigProvider.bind((Binder)binder, (String)"druid.storage", LocalDataSegmentPusherConfig.class);
    }

    public List<? extends Module> getJacksonModules() {
        return ImmutableList.of((Object)new Module(){

            public String getModuleName() {
                return "DruidLocalStorage-" + System.identityHashCode((Object)this);
            }

            public Version version() {
                return Version.unknownVersion();
            }

            public void setupModule(Module.SetupContext context) {
                context.registerSubtypes(new Class[]{LocalLoadSpec.class});
            }
        });
    }
}

