/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.metadata;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.inject.Inject;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.metadata.MetadataSegmentPublisher;
import org.apache.druid.metadata.MetadataStorageTablesConfig;
import org.apache.druid.metadata.SQLMetadataConnector;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.partition.NoneShardSpec;
import org.skife.jdbi.v2.DBI;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.Query;
import org.skife.jdbi.v2.Update;
import org.skife.jdbi.v2.tweak.HandleCallback;

public class SQLMetadataSegmentPublisher
implements MetadataSegmentPublisher {
    private static final Logger log = new Logger(SQLMetadataSegmentPublisher.class);
    private final ObjectMapper jsonMapper;
    private final MetadataStorageTablesConfig config;
    private final SQLMetadataConnector connector;
    private final String statement;

    @Inject
    public SQLMetadataSegmentPublisher(ObjectMapper jsonMapper, MetadataStorageTablesConfig config, SQLMetadataConnector connector) {
        this.jsonMapper = jsonMapper;
        this.config = config;
        this.connector = connector;
        this.statement = StringUtils.format((String)"INSERT INTO %1$s (id, dataSource, created_date, start, %2$send%2$s, partitioned, version, used, payload, used_status_last_updated) VALUES (:id, :dataSource, :created_date, :start, :end, :partitioned, :version, :used, :payload, :used_status_last_updated)", (Object[])new Object[]{config.getSegmentsTable(), connector.getQuoteString()});
    }

    @Override
    public void publishSegment(DataSegment segment) throws IOException {
        String now = DateTimes.nowUtc().toString();
        this.publishSegment(segment.getId().toString(), segment.getDataSource(), now, segment.getInterval().getStart().toString(), segment.getInterval().getEnd().toString(), !(segment.getShardSpec() instanceof NoneShardSpec), segment.getVersion(), true, this.jsonMapper.writeValueAsBytes((Object)segment), now);
    }

    @VisibleForTesting
    void publishSegment(final String segmentId, final String dataSource, final String createdDate, final String start, final String end, final boolean partitioned, final String version, final boolean used, final byte[] payload, final String usedFlagLastUpdated) {
        try {
            DBI dbi = this.connector.getDBI();
            List exists = (List)dbi.withHandle((HandleCallback)new HandleCallback<List<Map<String, Object>>>(){

                public List<Map<String, Object>> withHandle(Handle handle) {
                    return ((Query)handle.createQuery(StringUtils.format((String)"SELECT id FROM %s WHERE id=:id", (Object[])new Object[]{SQLMetadataSegmentPublisher.this.config.getSegmentsTable()})).bind("id", segmentId)).list();
                }
            });
            if (!exists.isEmpty()) {
                log.info("Found [%s] in DB, not updating DB", new Object[]{segmentId});
                return;
            }
            dbi.withHandle((HandleCallback)new HandleCallback<Void>(){

                public Void withHandle(Handle handle) {
                    ((Update)((Update)((Update)((Update)((Update)((Update)((Update)((Update)((Update)((Update)handle.createStatement(SQLMetadataSegmentPublisher.this.statement).bind("id", segmentId)).bind("dataSource", dataSource)).bind("created_date", createdDate)).bind("start", start)).bind("end", end)).bind("partitioned", partitioned)).bind("version", version)).bind("used", used)).bind("payload", payload)).bind("used_status_last_updated", usedFlagLastUpdated)).execute();
                    return null;
                }
            });
        }
        catch (Exception e) {
            log.error((Throwable)e, "Exception inserting into DB", new Object[0]);
            throw new RuntimeException(e);
        }
    }
}

