/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.metadata;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.UnmodifiableIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.CloseableIterators;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.jackson.JacksonUtils;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.java.util.common.parsers.CloseableIterator;
import org.apache.druid.metadata.MetadataStorageTablesConfig;
import org.apache.druid.metadata.SQLMetadataConnector;
import org.apache.druid.metadata.SortOrder;
import org.apache.druid.server.http.DataSegmentPlus;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.SegmentId;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInterval;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.PreparedBatch;
import org.skife.jdbi.v2.Query;
import org.skife.jdbi.v2.ResultIterator;
import org.skife.jdbi.v2.Update;

public class SqlSegmentsMetadataQuery {
    private static final Logger log = new Logger(SqlSegmentsMetadataQuery.class);
    private static final int MAX_INTERVALS_PER_BATCH = 100;
    private final Handle handle;
    private final SQLMetadataConnector connector;
    private final MetadataStorageTablesConfig dbTables;
    private final ObjectMapper jsonMapper;

    private SqlSegmentsMetadataQuery(Handle handle, SQLMetadataConnector connector, MetadataStorageTablesConfig dbTables, ObjectMapper jsonMapper) {
        this.handle = handle;
        this.connector = connector;
        this.dbTables = dbTables;
        this.jsonMapper = jsonMapper;
    }

    public static SqlSegmentsMetadataQuery forHandle(Handle handle, SQLMetadataConnector connector, MetadataStorageTablesConfig dbTables, ObjectMapper jsonMapper) {
        return new SqlSegmentsMetadataQuery(handle, connector, dbTables, jsonMapper);
    }

    public CloseableIterator<DataSegment> retrieveUsedSegments(String dataSource, Collection<Interval> intervals) {
        return this.retrieveSegments(dataSource, intervals, IntervalMode.OVERLAPS, true, null, null, null, null);
    }

    public CloseableIterator<DataSegment> retrieveUnusedSegments(String dataSource, Collection<Interval> intervals, @Nullable Integer limit, @Nullable String lastSegmentId, @Nullable SortOrder sortOrder, @Nullable DateTime maxUsedStatusLastUpdatedTime) {
        return this.retrieveSegments(dataSource, intervals, IntervalMode.CONTAINS, false, limit, lastSegmentId, sortOrder, maxUsedStatusLastUpdatedTime);
    }

    public CloseableIterator<DataSegmentPlus> retrieveUnusedSegmentsPlus(String dataSource, Collection<Interval> intervals, @Nullable Integer limit, @Nullable String lastSegmentId, @Nullable SortOrder sortOrder, @Nullable DateTime maxUsedStatusLastUpdatedTime) {
        return this.retrieveSegmentsPlus(dataSource, intervals, IntervalMode.CONTAINS, false, limit, lastSegmentId, sortOrder, maxUsedStatusLastUpdatedTime);
    }

    public int markSegments(Collection<SegmentId> segmentIds, boolean used) {
        if (segmentIds.isEmpty()) {
            return 0;
        }
        String dataSource = segmentIds.iterator().next().getDataSource();
        if (segmentIds.stream().anyMatch(segment -> !dataSource.equals(segment.getDataSource()))) {
            throw new IAE("Segments to drop must all be part of the same datasource", new Object[0]);
        }
        PreparedBatch batch = this.handle.prepareBatch(StringUtils.format((String)"UPDATE %s SET used = ?, used_status_last_updated = ? WHERE datasource = ? AND id = ?", (Object[])new Object[]{this.dbTables.getSegmentsTable()}));
        for (SegmentId segmentId : segmentIds) {
            batch.add(new Object[]{used, DateTimes.nowUtc().toString(), dataSource, segmentId.toString()});
        }
        int[] segmentChanges = batch.execute();
        return SqlSegmentsMetadataQuery.computeNumChangedSegments(segmentIds.stream().map(SegmentId::toString).collect(Collectors.toList()), segmentChanges);
    }

    public int markSegmentsUnused(String dataSource, Interval interval) {
        if (Intervals.isEternity((Interval)interval)) {
            return ((Update)((Update)((Update)this.handle.createStatement(StringUtils.format((String)"UPDATE %s SET used=:used, used_status_last_updated = :used_status_last_updated WHERE dataSource = :dataSource AND used = true", (Object[])new Object[]{this.dbTables.getSegmentsTable()})).bind("dataSource", dataSource)).bind("used", false)).bind("used_status_last_updated", DateTimes.nowUtc().toString())).execute();
        }
        if (Intervals.canCompareEndpointsAsStrings((Interval)interval) && interval.getStart().getYear() == interval.getEnd().getYear()) {
            return ((Update)((Update)((Update)((Update)((Update)this.handle.createStatement(StringUtils.format((String)"UPDATE %s SET used=:used, used_status_last_updated = :used_status_last_updated WHERE dataSource = :dataSource AND used = true AND %s", (Object[])new Object[]{this.dbTables.getSegmentsTable(), IntervalMode.CONTAINS.makeSqlCondition(this.connector.getQuoteString(), ":start", ":end")})).bind("dataSource", dataSource)).bind("used", false)).bind("start", interval.getStart().toString())).bind("end", interval.getEnd().toString())).bind("used_status_last_updated", DateTimes.nowUtc().toString())).execute();
        }
        ImmutableList segments = ImmutableList.copyOf((Iterator)Iterators.transform(this.retrieveSegments(dataSource, Collections.singletonList(interval), IntervalMode.CONTAINS, true, null, null, null, null), DataSegment::getId));
        return this.markSegments((Collection<SegmentId>)segments, false);
    }

    public DataSegment retrieveUsedSegmentForId(String id) {
        String query = "SELECT payload FROM %s WHERE used = true AND id = :id";
        Query sql = (Query)this.handle.createQuery(StringUtils.format((String)"SELECT payload FROM %s WHERE used = true AND id = :id", (Object[])new Object[]{this.dbTables.getSegmentsTable()})).bind("id", id);
        ResultIterator resultIterator = sql.map((index, r, ctx) -> (DataSegment)JacksonUtils.readValue((ObjectMapper)this.jsonMapper, (byte[])r.getBytes(1), DataSegment.class)).iterator();
        if (resultIterator.hasNext()) {
            return (DataSegment)resultIterator.next();
        }
        return null;
    }

    public DataSegment retrieveSegmentForId(String id) {
        String query = "SELECT payload FROM %s WHERE id = :id";
        Query sql = (Query)this.handle.createQuery(StringUtils.format((String)"SELECT payload FROM %s WHERE id = :id", (Object[])new Object[]{this.dbTables.getSegmentsTable()})).bind("id", id);
        ResultIterator resultIterator = sql.map((index, r, ctx) -> (DataSegment)JacksonUtils.readValue((ObjectMapper)this.jsonMapper, (byte[])r.getBytes(1), DataSegment.class)).iterator();
        if (resultIterator.hasNext()) {
            return (DataSegment)resultIterator.next();
        }
        return null;
    }

    public static void appendConditionForIntervalsAndMatchMode(StringBuilder sb, Collection<Interval> intervals, IntervalMode matchMode, SQLMetadataConnector connector) {
        if (intervals.isEmpty()) {
            return;
        }
        sb.append(" AND (");
        for (int i = 0; i < intervals.size(); ++i) {
            sb.append(matchMode.makeSqlCondition(connector.getQuoteString(), StringUtils.format((String)":start%d", (Object[])new Object[]{i}), StringUtils.format((String)":end%d", (Object[])new Object[]{i})));
            if (matchMode.equals((Object)IntervalMode.OVERLAPS)) {
                sb.append(StringUtils.format((String)" OR (start = '%s' AND \"end\" != '%s' AND \"end\" > :start%d)", (Object[])new Object[]{Intervals.ETERNITY.getStart(), Intervals.ETERNITY.getEnd(), i}));
                sb.append(StringUtils.format((String)" OR (start != '%s' AND \"end\" = '%s' AND start < :end%d)", (Object[])new Object[]{Intervals.ETERNITY.getStart(), Intervals.ETERNITY.getEnd(), i}));
            }
            if (i == intervals.size() - 1) continue;
            sb.append(" OR ");
        }
        if (matchMode.equals((Object)IntervalMode.OVERLAPS)) {
            sb.append(StringUtils.format((String)" OR (start = '%s' AND \"end\" = '%s')", (Object[])new Object[]{Intervals.ETERNITY.getStart(), Intervals.ETERNITY.getEnd()}));
        }
        sb.append(")");
    }

    public static void bindQueryIntervals(Query<Map<String, Object>> query, Collection<Interval> intervals) {
        if (intervals.isEmpty()) {
            return;
        }
        Iterator<Interval> iterator = intervals.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            Interval interval = iterator.next();
            ((Query)query.bind(StringUtils.format((String)"start%d", (Object[])new Object[]{i}), interval.getStart().toString())).bind(StringUtils.format((String)"end%d", (Object[])new Object[]{i}), interval.getEnd().toString());
            ++i;
        }
    }

    private CloseableIterator<DataSegment> retrieveSegments(String dataSource, Collection<Interval> intervals, IntervalMode matchMode, boolean used, @Nullable Integer limit, @Nullable String lastSegmentId, @Nullable SortOrder sortOrder, @Nullable DateTime maxUsedStatusLastUpdatedTime) {
        if (intervals.isEmpty() || intervals.size() <= 100) {
            return CloseableIterators.withEmptyBaggage(this.retrieveSegmentsInIntervalsBatch(dataSource, intervals, matchMode, used, limit, lastSegmentId, sortOrder, maxUsedStatusLastUpdatedTime));
        }
        List intervalsLists = Lists.partition(new ArrayList<Interval>(intervals), (int)100);
        ArrayList<Iterator<Object>> resultingIterators = new ArrayList<Iterator<Object>>();
        Integer limitPerBatch = limit;
        for (List intervalList : intervalsLists) {
            UnmodifiableIterator<DataSegment> iterator = this.retrieveSegmentsInIntervalsBatch(dataSource, intervalList, matchMode, used, limitPerBatch, lastSegmentId, sortOrder, maxUsedStatusLastUpdatedTime);
            if (limitPerBatch != null) {
                ImmutableList dataSegments = ImmutableList.copyOf(iterator);
                resultingIterators.add(dataSegments.iterator());
                if (dataSegments.size() >= limitPerBatch) break;
                limitPerBatch = limitPerBatch - dataSegments.size();
                continue;
            }
            resultingIterators.add((Iterator<Object>)iterator);
        }
        return CloseableIterators.withEmptyBaggage((Iterator)Iterators.concat(resultingIterators.iterator()));
    }

    private CloseableIterator<DataSegmentPlus> retrieveSegmentsPlus(String dataSource, Collection<Interval> intervals, IntervalMode matchMode, boolean used, @Nullable Integer limit, @Nullable String lastSegmentId, @Nullable SortOrder sortOrder, @Nullable DateTime maxUsedStatusLastUpdatedTime) {
        if (intervals.isEmpty() || intervals.size() <= 100) {
            return CloseableIterators.withEmptyBaggage(this.retrieveSegmentsPlusInIntervalsBatch(dataSource, intervals, matchMode, used, limit, lastSegmentId, sortOrder, maxUsedStatusLastUpdatedTime));
        }
        List intervalsLists = Lists.partition(new ArrayList<Interval>(intervals), (int)100);
        ArrayList<Iterator<Object>> resultingIterators = new ArrayList<Iterator<Object>>();
        Integer limitPerBatch = limit;
        for (List intervalList : intervalsLists) {
            UnmodifiableIterator<DataSegmentPlus> iterator = this.retrieveSegmentsPlusInIntervalsBatch(dataSource, intervalList, matchMode, used, limitPerBatch, lastSegmentId, sortOrder, maxUsedStatusLastUpdatedTime);
            if (limitPerBatch != null) {
                ImmutableList dataSegments = ImmutableList.copyOf(iterator);
                resultingIterators.add(dataSegments.iterator());
                if (dataSegments.size() >= limitPerBatch) break;
                limitPerBatch = limitPerBatch - dataSegments.size();
                continue;
            }
            resultingIterators.add((Iterator<Object>)iterator);
        }
        return CloseableIterators.withEmptyBaggage((Iterator)Iterators.concat(resultingIterators.iterator()));
    }

    private UnmodifiableIterator<DataSegment> retrieveSegmentsInIntervalsBatch(String dataSource, Collection<Interval> intervals, IntervalMode matchMode, boolean used, @Nullable Integer limit, @Nullable String lastSegmentId, @Nullable SortOrder sortOrder, @Nullable DateTime maxUsedStatusLastUpdatedTime) {
        Query<Map<String, Object>> sql = this.buildSegmentsTableQuery(dataSource, intervals, matchMode, used, limit, lastSegmentId, sortOrder, maxUsedStatusLastUpdatedTime, false);
        ResultIterator<DataSegment> resultIterator = this.getDataSegmentResultIterator(sql);
        return this.filterDataSegmentIteratorByInterval(resultIterator, intervals, matchMode);
    }

    private UnmodifiableIterator<DataSegmentPlus> retrieveSegmentsPlusInIntervalsBatch(String dataSource, Collection<Interval> intervals, IntervalMode matchMode, boolean used, @Nullable Integer limit, @Nullable String lastSegmentId, @Nullable SortOrder sortOrder, @Nullable DateTime maxUsedStatusLastUpdatedTime) {
        Query<Map<String, Object>> sql = this.buildSegmentsTableQuery(dataSource, intervals, matchMode, used, limit, lastSegmentId, sortOrder, maxUsedStatusLastUpdatedTime, true);
        ResultIterator<DataSegmentPlus> resultIterator = this.getDataSegmentPlusResultIterator(sql);
        return this.filterDataSegmentPlusIteratorByInterval(resultIterator, intervals, matchMode);
    }

    private Query<Map<String, Object>> buildSegmentsTableQuery(String dataSource, Collection<Interval> intervals, IntervalMode matchMode, boolean used, @Nullable Integer limit, @Nullable String lastSegmentId, @Nullable SortOrder sortOrder, @Nullable DateTime maxUsedStatusLastUpdatedTime, boolean includeExtraInfo) {
        boolean addMaxUsedLastUpdatedTimeFilter;
        boolean compareAsString = intervals.stream().allMatch(Intervals::canCompareEndpointsAsStrings);
        StringBuilder sb = new StringBuilder();
        if (includeExtraInfo) {
            sb.append("SELECT payload, created_date, used_status_last_updated FROM %s WHERE used = :used AND dataSource = :dataSource");
        } else {
            sb.append("SELECT payload FROM %s WHERE used = :used AND dataSource = :dataSource");
        }
        if (compareAsString) {
            SqlSegmentsMetadataQuery.appendConditionForIntervalsAndMatchMode(sb, intervals, matchMode, this.connector);
        }
        boolean bl = addMaxUsedLastUpdatedTimeFilter = !used && maxUsedStatusLastUpdatedTime != null;
        if (addMaxUsedLastUpdatedTimeFilter) {
            sb.append(" AND (used_status_last_updated IS NOT NULL AND used_status_last_updated <= :used_status_last_updated)");
        }
        if (lastSegmentId != null) {
            sb.append(StringUtils.format((String)" AND id %s :id", (Object[])new Object[]{sortOrder == null || sortOrder == SortOrder.ASC ? ">" : "<"}));
        }
        if (sortOrder != null) {
            sb.append(StringUtils.format((String)" ORDER BY id %2$s, start %2$s, %1$send%1$s %2$s", (Object[])new Object[]{this.connector.getQuoteString(), sortOrder.toString()}));
        }
        Query sql = (Query)((Query)this.handle.createQuery(StringUtils.format((String)sb.toString(), (Object[])new Object[]{this.dbTables.getSegmentsTable()})).setFetchSize(this.connector.getStreamingFetchSize()).bind("used", used)).bind("dataSource", dataSource);
        if (addMaxUsedLastUpdatedTimeFilter) {
            sql.bind("used_status_last_updated", maxUsedStatusLastUpdatedTime.toString());
        }
        if (lastSegmentId != null) {
            sql.bind("id", lastSegmentId);
        }
        if (limit != null) {
            sql.setMaxRows(limit.intValue());
        }
        if (compareAsString) {
            SqlSegmentsMetadataQuery.bindQueryIntervals((Query<Map<String, Object>>)sql, intervals);
        }
        return sql;
    }

    private ResultIterator<DataSegment> getDataSegmentResultIterator(Query<Map<String, Object>> sql) {
        return sql.map((index, r, ctx) -> (DataSegment)JacksonUtils.readValue((ObjectMapper)this.jsonMapper, (byte[])r.getBytes(1), DataSegment.class)).iterator();
    }

    private ResultIterator<DataSegmentPlus> getDataSegmentPlusResultIterator(Query<Map<String, Object>> sql) {
        return sql.map((index, r, ctx) -> new DataSegmentPlus((DataSegment)JacksonUtils.readValue((ObjectMapper)this.jsonMapper, (byte[])r.getBytes(1), DataSegment.class), DateTimes.of((String)r.getString(2)), DateTimes.of((String)r.getString(3)))).iterator();
    }

    private UnmodifiableIterator<DataSegment> filterDataSegmentIteratorByInterval(ResultIterator<DataSegment> resultIterator, Collection<Interval> intervals, IntervalMode matchMode) {
        return Iterators.filter(resultIterator, dataSegment -> {
            if (intervals.isEmpty()) {
                return true;
            }
            for (Interval interval : intervals) {
                if (!matchMode.apply(interval, dataSegment.getInterval())) continue;
                return true;
            }
            return false;
        });
    }

    private UnmodifiableIterator<DataSegmentPlus> filterDataSegmentPlusIteratorByInterval(ResultIterator<DataSegmentPlus> resultIterator, Collection<Interval> intervals, IntervalMode matchMode) {
        return Iterators.filter(resultIterator, dataSegment -> {
            if (intervals.isEmpty()) {
                return true;
            }
            for (Interval interval : intervals) {
                if (!matchMode.apply(interval, dataSegment.getDataSegment().getInterval())) continue;
                return true;
            }
            return false;
        });
    }

    private static int computeNumChangedSegments(List<String> segmentIds, int[] segmentChanges) {
        int numChangedSegments = 0;
        for (int i = 0; i < segmentChanges.length; ++i) {
            int numUpdatedRows = segmentChanges[i];
            if (numUpdatedRows < 0) {
                log.error("ASSERTION_ERROR: Negative number of rows updated for segment id [%s]: %d", new Object[]{segmentIds.get(i), numUpdatedRows});
            } else if (numUpdatedRows > 1) {
                log.error("More than one row updated for segment id [%s]: %d, there may be more than one row for the segment id in the database", new Object[]{segmentIds.get(i), numUpdatedRows});
            }
            if (numUpdatedRows <= 0) continue;
            ++numChangedSegments;
        }
        return numChangedSegments;
    }

    static enum IntervalMode {
        CONTAINS{

            @Override
            public String makeSqlCondition(String quoteString, String startPlaceholder, String endPlaceholder) {
                return StringUtils.format((String)"(start >= %2$s and start <= %3$s and %1$send%1$s <= %3$s)", (Object[])new Object[]{quoteString, startPlaceholder, endPlaceholder});
            }

            @Override
            public boolean apply(Interval a, Interval b) {
                return a.contains((ReadableInterval)b);
            }
        }
        ,
        OVERLAPS{

            @Override
            public String makeSqlCondition(String quoteString, String startPlaceholder, String endPlaceholder) {
                return StringUtils.format((String)"(start < %3$s AND %1$send%1$s > %2$s)", (Object[])new Object[]{quoteString, startPlaceholder, endPlaceholder});
            }

            @Override
            public boolean apply(Interval a, Interval b) {
                return a.overlaps((ReadableInterval)b);
            }
        };


        public abstract String makeSqlCondition(String var1, String var2, String var3);

        public abstract boolean apply(Interval var1, Interval var2);
    }
}

