/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.lookup;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.server.metrics.DataSourceTaskIdHolder;

class LookupListeningAnnouncerConfig {
    public static final String DEFAULT_TIER = "__default";
    private final DataSourceTaskIdHolder dataSourceTaskIdHolder;
    @JsonProperty(value="lookupTier")
    private String lookupTier = null;
    @JsonProperty(value="lookupTierIsDatasource")
    private boolean lookupTierIsDatasource = false;

    @JsonCreator
    public LookupListeningAnnouncerConfig(@JacksonInject DataSourceTaskIdHolder dataSourceTaskIdHolder) {
        this.dataSourceTaskIdHolder = dataSourceTaskIdHolder;
    }

    public String getLookupTier() {
        Preconditions.checkArgument((!this.lookupTierIsDatasource || null == this.lookupTier ? 1 : 0) != 0, (Object)"Cannot specify both `lookupTier` and `lookupTierIsDatasource`");
        String lookupTier = this.lookupTierIsDatasource ? this.dataSourceTaskIdHolder.getDataSource() : this.lookupTier;
        return (String)Preconditions.checkNotNull((Object)(lookupTier == null ? DEFAULT_TIER : StringUtils.emptyToNullNonDruidDataString((String)lookupTier)), (String)"Cannot have empty lookup tier from %s", (Object)(this.lookupTierIsDatasource ? "bound value" : "druid.lookup"));
    }
}

