/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.rpc;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import java.util.Iterator;
import java.util.Objects;
import javax.validation.constraints.NotNull;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.server.DruidNode;
import org.apache.druid.server.coordination.DruidServerMetadata;

public class ServiceLocation {
    private final String host;
    private final int plaintextPort;
    private final int tlsPort;
    private final String basePath;
    private static final Splitter SPLITTER = Splitter.on((String)":").limit(2);

    public ServiceLocation(String host, int plaintextPort, int tlsPort, String basePath) {
        this.host = (String)Preconditions.checkNotNull((Object)host, (Object)"host");
        this.plaintextPort = plaintextPort;
        this.tlsPort = tlsPort;
        this.basePath = (String)Preconditions.checkNotNull((Object)basePath, (Object)"basePath");
    }

    public static ServiceLocation fromDruidNode(DruidNode druidNode) {
        return new ServiceLocation(druidNode.getHost(), druidNode.getPlaintextPort(), druidNode.getTlsPort(), "");
    }

    public static ServiceLocation fromDruidServerMetadata(DruidServerMetadata druidServerMetadata) {
        String host = ServiceLocation.getHostFromString((String)Preconditions.checkNotNull((Object)druidServerMetadata.getHost(), (String)"Host was null for druid server metadata[%s]", (Object)druidServerMetadata));
        int plaintextPort = ServiceLocation.getPortFromString(druidServerMetadata.getHostAndPort());
        int tlsPort = ServiceLocation.getPortFromString(druidServerMetadata.getHostAndTlsPort());
        return new ServiceLocation(host, plaintextPort, tlsPort, "");
    }

    private static String getHostFromString(@NotNull String s) {
        Iterator iterator = SPLITTER.split((CharSequence)s).iterator();
        ImmutableList strings = ImmutableList.copyOf(iterator);
        return (String)strings.get(0);
    }

    private static int getPortFromString(String s) {
        if (s == null) {
            return -1;
        }
        Iterator iterator = SPLITTER.split((CharSequence)s).iterator();
        ImmutableList strings = ImmutableList.copyOf(iterator);
        try {
            return Integer.parseInt((String)strings.get(1));
        }
        catch (NumberFormatException e) {
            throw new ISE((Throwable)e, "Unable to parse port out of %s", new Object[]{strings.get(1)});
        }
    }

    public String getHost() {
        return this.host;
    }

    public int getPlaintextPort() {
        return this.plaintextPort;
    }

    public int getTlsPort() {
        return this.tlsPort;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceLocation that = (ServiceLocation)o;
        return this.plaintextPort == that.plaintextPort && this.tlsPort == that.tlsPort && Objects.equals(this.host, that.host) && Objects.equals(this.basePath, that.basePath);
    }

    public int hashCode() {
        return Objects.hash(this.host, this.plaintextPort, this.tlsPort, this.basePath);
    }

    public String toString() {
        return "ServiceLocation{host='" + this.host + '\'' + ", plaintextPort=" + this.plaintextPort + ", tlsPort=" + this.tlsPort + ", basePath='" + this.basePath + '\'' + '}';
    }
}

