/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.join;

import com.google.common.collect.Iterators;
import com.google.inject.Inject;
import java.util.Iterator;
import java.util.Optional;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.GlobalTableDataSource;
import org.apache.druid.query.planning.DataSourceAnalysis;
import org.apache.druid.segment.join.JoinConditionAnalysis;
import org.apache.druid.segment.join.Joinable;
import org.apache.druid.segment.join.JoinableFactory;
import org.apache.druid.segment.join.table.IndexedTable;
import org.apache.druid.segment.join.table.IndexedTableJoinable;
import org.apache.druid.segment.join.table.ReferenceCountingIndexedTable;
import org.apache.druid.server.SegmentManager;

public class BroadcastTableJoinableFactory
implements JoinableFactory {
    private final SegmentManager segmentManager;

    @Inject
    public BroadcastTableJoinableFactory(SegmentManager segmentManager) {
        this.segmentManager = segmentManager;
    }

    public boolean isDirectlyJoinable(DataSource dataSource) {
        GlobalTableDataSource broadcastDatasource = (GlobalTableDataSource)dataSource;
        return broadcastDatasource != null && this.segmentManager.hasIndexedTables(broadcastDatasource.getName());
    }

    public Optional<Joinable> build(DataSource dataSource, JoinConditionAnalysis condition) {
        if (!condition.canHashJoin()) {
            return Optional.empty();
        }
        return this.getOnlyIndexedTable(dataSource).map(IndexedTableJoinable::new);
    }

    public Optional<byte[]> computeJoinCacheKey(DataSource dataSource, JoinConditionAnalysis condition) {
        if (!condition.canHashJoin()) {
            return Optional.empty();
        }
        return this.getOnlyIndexedTable(dataSource).filter(IndexedTable::isCacheable).map(IndexedTable::computeCacheKey);
    }

    private Optional<ReferenceCountingIndexedTable> getOnlyIndexedTable(DataSource dataSource) {
        GlobalTableDataSource broadcastDataSource = (GlobalTableDataSource)dataSource;
        DataSourceAnalysis analysis = dataSource.getAnalysis();
        return this.segmentManager.getIndexedTables(analysis).flatMap(tables -> {
            Iterator tableIterator = tables.iterator();
            if (!tableIterator.hasNext()) {
                return Optional.empty();
            }
            try {
                return Optional.of((ReferenceCountingIndexedTable)Iterators.getOnlyElement(tableIterator));
            }
            catch (IllegalArgumentException iae) {
                throw new ISE("Currently only single segment datasources are supported for broadcast joins, dataSource[%s] has multiple segments. Reingest the data so that it is entirely contained within a single segment to use in JOIN queries.", new Object[]{broadcastDataSource.getName()});
            }
        });
    }
}

