/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.metadata;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListMap;
import javax.annotation.Nullable;
import org.apache.druid.client.CoordinatorServerView;
import org.apache.druid.client.InternalQueryConfig;
import org.apache.druid.client.ServerView;
import org.apache.druid.client.TimelineServerView;
import org.apache.druid.guice.ManageLifecycle;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.metadata.AbstractSegmentMetadataCache;
import org.apache.druid.segment.metadata.AvailableSegmentMetadata;
import org.apache.druid.segment.metadata.CentralizedDatasourceSchemaConfig;
import org.apache.druid.segment.metadata.DataSourceInformation;
import org.apache.druid.segment.metadata.SegmentMetadataCacheConfig;
import org.apache.druid.segment.realtime.appenderator.SegmentSchemas;
import org.apache.druid.server.QueryLifecycleFactory;
import org.apache.druid.server.coordination.DruidServerMetadata;
import org.apache.druid.server.security.Escalator;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.SegmentId;

@ManageLifecycle
public class CoordinatorSegmentMetadataCache
extends AbstractSegmentMetadataCache<DataSourceInformation> {
    private static final EmittingLogger log = new EmittingLogger(CoordinatorSegmentMetadataCache.class);
    private final boolean realtimeSegmentSchemaAnnouncement;
    private final AbstractSegmentMetadataCache.ColumnTypeMergePolicy columnTypeMergePolicy;

    @Inject
    public CoordinatorSegmentMetadataCache(QueryLifecycleFactory queryLifecycleFactory, CoordinatorServerView serverView, SegmentMetadataCacheConfig config, Escalator escalator, InternalQueryConfig internalQueryConfig, ServiceEmitter emitter, CentralizedDatasourceSchemaConfig centralizedDatasourceSchemaConfig) {
        super(queryLifecycleFactory, config, escalator, internalQueryConfig, emitter);
        this.columnTypeMergePolicy = config.getMetadataColumnTypeMergePolicy();
        this.realtimeSegmentSchemaAnnouncement = centralizedDatasourceSchemaConfig.isEnabled() && centralizedDatasourceSchemaConfig.announceRealtimeSegmentSchema();
        this.initServerViewTimelineCallback(serverView);
    }

    private void initServerViewTimelineCallback(CoordinatorServerView serverView) {
        serverView.registerTimelineCallback(this.callbackExec, new TimelineServerView.TimelineCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ServerView.CallbackAction timelineInitialized() {
                Object object = CoordinatorSegmentMetadataCache.this.lock;
                synchronized (object) {
                    CoordinatorSegmentMetadataCache.this.isServerViewInitialized = true;
                    CoordinatorSegmentMetadataCache.this.lock.notifyAll();
                }
                return ServerView.CallbackAction.CONTINUE;
            }

            @Override
            public ServerView.CallbackAction segmentAdded(DruidServerMetadata server, DataSegment segment) {
                CoordinatorSegmentMetadataCache.this.addSegment(server, segment);
                return ServerView.CallbackAction.CONTINUE;
            }

            @Override
            public ServerView.CallbackAction segmentRemoved(DataSegment segment) {
                CoordinatorSegmentMetadataCache.this.removeSegment(segment);
                return ServerView.CallbackAction.CONTINUE;
            }

            @Override
            public ServerView.CallbackAction serverSegmentRemoved(DruidServerMetadata server, DataSegment segment) {
                CoordinatorSegmentMetadataCache.this.removeServerSegment(server, segment);
                return ServerView.CallbackAction.CONTINUE;
            }

            @Override
            public ServerView.CallbackAction segmentSchemasAnnounced(SegmentSchemas segmentSchemas) {
                if (CoordinatorSegmentMetadataCache.this.realtimeSegmentSchemaAnnouncement) {
                    CoordinatorSegmentMetadataCache.this.updateSchemaForSegments(segmentSchemas);
                }
                return ServerView.CallbackAction.CONTINUE;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refresh(Set<SegmentId> segmentsToRefresh, Set<String> dataSourcesToRebuild) throws IOException {
        Set<SegmentId> refreshed = this.refreshSegments(this.filterMutableSegments(segmentsToRefresh));
        Iterator<String> iterator = this.lock;
        synchronized (iterator) {
            this.segmentsNeedingRefresh.addAll(Sets.difference(segmentsToRefresh, refreshed));
            dataSourcesToRebuild.addAll(this.dataSourcesNeedingRebuild);
            refreshed.forEach(segment -> dataSourcesToRebuild.add(segment.getDataSource()));
            this.dataSourcesNeedingRebuild.clear();
        }
        for (String dataSource : dataSourcesToRebuild) {
            RowSignature rowSignature = this.buildDataSourceRowSignature(dataSource);
            if (rowSignature == null) {
                log.info("RowSignature null for dataSource [%s], implying that it no longer exists. All metadata removed.", new Object[]{dataSource});
                this.tables.remove(dataSource);
                continue;
            }
            DataSourceInformation druidTable = new DataSourceInformation(dataSource, rowSignature);
            DataSourceInformation oldTable = this.tables.put(dataSource, druidTable);
            if (oldTable == null || !oldTable.getRowSignature().equals((Object)druidTable.getRowSignature())) {
                log.info("[%s] has new signature: %s.", new Object[]{dataSource, druidTable.getRowSignature()});
                continue;
            }
            log.debug("[%s] signature is unchanged.", new Object[]{dataSource});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<SegmentId> filterMutableSegments(Set<SegmentId> segmentIds) {
        if (this.realtimeSegmentSchemaAnnouncement) {
            Object object = this.lock;
            synchronized (object) {
                segmentIds.removeAll(this.mutableSegments);
            }
        }
        return segmentIds;
    }

    @VisibleForTesting
    void updateSchemaForSegments(SegmentSchemas segmentSchemas) {
        List<SegmentSchemas.SegmentSchema> segmentSchemaList = segmentSchemas.getSegmentSchemaList();
        for (SegmentSchemas.SegmentSchema segmentSchema : segmentSchemaList) {
            String dataSource = segmentSchema.getDataSource();
            SegmentId segmentId = SegmentId.tryParse((String)dataSource, (String)segmentSchema.getSegmentId());
            if (segmentId == null) {
                log.error("Could not apply schema update. Failed parsing segmentId [%s]", new Object[]{segmentSchema.getSegmentId()});
                continue;
            }
            log.debug("Applying schema update for segmentId [%s] datasource [%s]", new Object[]{segmentId, dataSource});
            this.segmentMetadataInfo.compute(dataSource, (dataSourceKey, segmentsMap) -> {
                if (segmentsMap == null) {
                    segmentsMap = new ConcurrentSkipListMap<SegmentId, AvailableSegmentMetadata>(SEGMENT_ORDER);
                }
                segmentsMap.compute(segmentId, (id, segmentMetadata) -> {
                    if (segmentMetadata == null) {
                        log.makeAlert("Schema update [%s] for unknown segment [%s]", new Object[]{segmentSchema, segmentId}).emit();
                    } else {
                        Optional<RowSignature> rowSignature = this.mergeOrCreateRowSignature(segmentId, segmentMetadata.getRowSignature(), segmentSchema);
                        if (rowSignature.isPresent()) {
                            log.debug("Segment [%s] signature [%s] after applying schema update.", new Object[]{segmentId, rowSignature.get()});
                            this.markDataSourceAsNeedRebuild(dataSource);
                            segmentMetadata = AvailableSegmentMetadata.from(segmentMetadata).withRowSignature(rowSignature.get()).withNumRows(segmentSchema.getNumRows().intValue()).build();
                        }
                    }
                    return segmentMetadata;
                });
                return segmentsMap;
            });
        }
    }

    @VisibleForTesting
    Optional<RowSignature> mergeOrCreateRowSignature(SegmentId segmentId, @Nullable RowSignature existingSignature, SegmentSchemas.SegmentSchema segmentSchema) {
        if (!segmentSchema.isDelta()) {
            RowSignature.Builder builder = RowSignature.builder();
            Map<String, ColumnType> columnMapping = segmentSchema.getColumnTypeMap();
            for (String column : segmentSchema.getNewColumns()) {
                builder.add(column, columnMapping.get(column));
            }
            return Optional.of((RowSignature)ROW_SIGNATURE_INTERNER.intern((Object)builder.build()));
        }
        if (existingSignature != null) {
            RowSignature.Builder builder = RowSignature.builder();
            LinkedHashMap<String, ColumnType> mergedColumnTypes = new LinkedHashMap<String, ColumnType>();
            for (String column : existingSignature.getColumnNames()) {
                ColumnType columnType = (ColumnType)existingSignature.getColumnType(column).orElseThrow(() -> new ISE("Encountered null type for column [%s]", new Object[]{column}));
                mergedColumnTypes.put(column, columnType);
            }
            Map<String, ColumnType> columnMapping = segmentSchema.getColumnTypeMap();
            boolean missingUpdateColumns = false;
            boolean existingNewColumns = false;
            for (String column : segmentSchema.getUpdatedColumns()) {
                if (!mergedColumnTypes.containsKey(column)) {
                    missingUpdateColumns = true;
                    mergedColumnTypes.put(column, columnMapping.get(column));
                    continue;
                }
                mergedColumnTypes.compute(column, (c, existingType) -> this.columnTypeMergePolicy.merge((ColumnType)existingType, (ColumnType)columnMapping.get(column)));
            }
            for (String column : segmentSchema.getNewColumns()) {
                if (mergedColumnTypes.containsKey(column)) {
                    existingNewColumns = true;
                    mergedColumnTypes.compute(column, (c, existingType) -> this.columnTypeMergePolicy.merge((ColumnType)existingType, (ColumnType)columnMapping.get(column)));
                    continue;
                }
                mergedColumnTypes.put(column, columnMapping.get(column));
            }
            if (missingUpdateColumns || existingNewColumns) {
                log.makeAlert("Error merging delta schema update with existing row signature. segmentId [%s], existingSignature [%s], deltaSchema [%s], missingUpdateColumns [%s], existingNewColumns [%s].", new Object[]{segmentId, existingSignature, segmentSchema, missingUpdateColumns, existingNewColumns}).emit();
            }
            mergedColumnTypes.forEach((arg_0, arg_1) -> ((RowSignature.Builder)builder).add(arg_0, arg_1));
            return Optional.of((RowSignature)ROW_SIGNATURE_INTERNER.intern((Object)builder.build()));
        }
        log.makeAlert("Received delta schema update [%s] for a segment [%s] with no previous schema. ", new Object[]{segmentSchema, segmentId}).emit();
        return Optional.empty();
    }
}

