/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.metadata;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import org.apache.druid.segment.metadata.AbstractSegmentMetadataCache;
import org.joda.time.Period;

public class SegmentMetadataCacheConfig {
    @JsonProperty
    private boolean awaitInitializationOnStart = false;
    @JsonProperty
    private Period metadataRefreshPeriod = new Period((Object)"PT1M");
    @JsonProperty
    private AbstractSegmentMetadataCache.ColumnTypeMergePolicy metadataColumnTypeMergePolicy = new AbstractSegmentMetadataCache.LeastRestrictiveTypeMergePolicy();

    public static SegmentMetadataCacheConfig create() {
        return new SegmentMetadataCacheConfig();
    }

    public static SegmentMetadataCacheConfig create(String metadataRefreshPeriod) {
        SegmentMetadataCacheConfig config = new SegmentMetadataCacheConfig();
        config.metadataRefreshPeriod = new Period((Object)metadataRefreshPeriod);
        return config;
    }

    @VisibleForTesting
    public void setMetadataRefreshPeriod(Period metadataRefreshPeriod) {
        this.metadataRefreshPeriod = metadataRefreshPeriod;
    }

    public boolean isAwaitInitializationOnStart() {
        return this.awaitInitializationOnStart;
    }

    public AbstractSegmentMetadataCache.ColumnTypeMergePolicy getMetadataColumnTypeMergePolicy() {
        return this.metadataColumnTypeMergePolicy;
    }

    public Period getMetadataRefreshPeriod() {
        return this.metadataRefreshPeriod;
    }

    public String toString() {
        return "SegmentMetadataCacheConfig{awaitInitializationOnStart=" + this.awaitInitializationOnStart + ", metadataRefreshPeriod=" + this.metadataRefreshPeriod + ", metadataColumnTypeMergePolicy=" + this.metadataColumnTypeMergePolicy + '}';
    }
}

