/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.realtime;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.emitter.service.ServiceEventBuilder;
import org.apache.druid.java.util.emitter.service.ServiceMetricEvent;
import org.apache.druid.java.util.metrics.AbstractMonitor;
import org.apache.druid.java.util.metrics.MonitorUtils;
import org.apache.druid.segment.realtime.FireDepartment;
import org.apache.druid.segment.realtime.FireDepartmentMetrics;

public class RealtimeMetricsMonitor
extends AbstractMonitor {
    private static final EmittingLogger log = new EmittingLogger(RealtimeMetricsMonitor.class);
    private final Map<FireDepartment, FireDepartmentMetrics> previousValues;
    private final List<FireDepartment> fireDepartments;
    private final Map<String, String[]> dimensions;

    @Inject
    public RealtimeMetricsMonitor(List<FireDepartment> fireDepartments) {
        this(fireDepartments, (Map<String, String[]>)ImmutableMap.of());
    }

    public RealtimeMetricsMonitor(List<FireDepartment> fireDepartments, Map<String, String[]> dimensions) {
        this.fireDepartments = fireDepartments;
        this.previousValues = new HashMap<FireDepartment, FireDepartmentMetrics>();
        this.dimensions = ImmutableMap.copyOf(dimensions);
    }

    public boolean doMonitor(ServiceEmitter emitter) {
        for (FireDepartment fireDepartment : this.fireDepartments) {
            long maxSegmentHandoffTime;
            FireDepartmentMetrics metrics = fireDepartment.getMetrics().snapshot();
            FireDepartmentMetrics previous = this.previousValues.get(fireDepartment);
            if (previous == null) {
                previous = new FireDepartmentMetrics();
            }
            ServiceMetricEvent.Builder builder = new ServiceMetricEvent.Builder().setDimension("dataSource", (Object)fireDepartment.getDataSchema().getDataSource());
            MonitorUtils.addDimensionsToBuilder((ServiceMetricEvent.Builder)builder, this.dimensions);
            long thrownAway = metrics.thrownAway() - previous.thrownAway();
            if (thrownAway > 0L) {
                log.warn("[%,d] events thrown away. Possible causes: null events, events filtered out by transformSpec, or events outside windowPeriod.", new Object[]{thrownAway});
            }
            emitter.emit((ServiceEventBuilder)builder.setMetric("ingest/events/thrownAway", (Number)thrownAway));
            long unparseable = metrics.unparseable() - previous.unparseable();
            if (unparseable > 0L) {
                log.error("[%,d] unparseable events discarded. Turn on debug logging to see exception stack trace.", new Object[]{unparseable});
            }
            emitter.emit((ServiceEventBuilder)builder.setMetric("ingest/events/unparseable", (Number)unparseable));
            long dedup = metrics.dedup() - previous.dedup();
            if (dedup > 0L) {
                log.warn("[%,d] duplicate events!", new Object[]{dedup});
            }
            emitter.emit((ServiceEventBuilder)builder.setMetric("ingest/events/duplicate", (Number)dedup));
            emitter.emit((ServiceEventBuilder)builder.setMetric("ingest/events/processed", (Number)(metrics.processed() - previous.processed())));
            emitter.emit((ServiceEventBuilder)builder.setMetric("ingest/rows/output", (Number)(metrics.rowOutput() - previous.rowOutput())));
            emitter.emit((ServiceEventBuilder)builder.setMetric("ingest/persists/count", (Number)(metrics.numPersists() - previous.numPersists())));
            emitter.emit((ServiceEventBuilder)builder.setMetric("ingest/persists/time", (Number)(metrics.persistTimeMillis() - previous.persistTimeMillis())));
            emitter.emit((ServiceEventBuilder)builder.setMetric("ingest/persists/cpu", (Number)(metrics.persistCpuTime() - previous.persistCpuTime())));
            emitter.emit((ServiceEventBuilder)builder.setMetric("ingest/persists/backPressure", (Number)(metrics.persistBackPressureMillis() - previous.persistBackPressureMillis())));
            emitter.emit((ServiceEventBuilder)builder.setMetric("ingest/persists/failed", (Number)(metrics.failedPersists() - previous.failedPersists())));
            emitter.emit((ServiceEventBuilder)builder.setMetric("ingest/handoff/failed", (Number)(metrics.failedHandoffs() - previous.failedHandoffs())));
            emitter.emit((ServiceEventBuilder)builder.setMetric("ingest/merge/time", (Number)(metrics.mergeTimeMillis() - previous.mergeTimeMillis())));
            emitter.emit((ServiceEventBuilder)builder.setMetric("ingest/merge/cpu", (Number)(metrics.mergeCpuTime() - previous.mergeCpuTime())));
            emitter.emit((ServiceEventBuilder)builder.setMetric("ingest/handoff/count", (Number)(metrics.handOffCount() - previous.handOffCount())));
            emitter.emit((ServiceEventBuilder)builder.setMetric("ingest/sink/count", (Number)metrics.sinkCount()));
            long messageGap = metrics.messageGap();
            if (messageGap >= 0L) {
                emitter.emit((ServiceEventBuilder)builder.setMetric("ingest/events/messageGap", (Number)messageGap));
            }
            if ((maxSegmentHandoffTime = metrics.maxSegmentHandoffTime()) >= 0L) {
                emitter.emit((ServiceEventBuilder)builder.setMetric("ingest/handoff/time", (Number)maxSegmentHandoffTime));
            }
            this.previousValues.put(fireDepartment, metrics);
        }
        return true;
    }
}

