/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordination;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.AbstractFuture;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.google.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import org.apache.druid.guice.ManageLifecycle;
import org.apache.druid.guice.ServerTypeConfig;
import org.apache.druid.java.util.common.FileUtils;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.java.util.common.lifecycle.LifecycleStart;
import org.apache.druid.java.util.common.lifecycle.LifecycleStop;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.segment.loading.SegmentCacheManager;
import org.apache.druid.segment.loading.SegmentLoaderConfig;
import org.apache.druid.segment.loading.SegmentLoadingException;
import org.apache.druid.server.SegmentManager;
import org.apache.druid.server.coordination.DataSegmentAnnouncer;
import org.apache.druid.server.coordination.DataSegmentChangeCallback;
import org.apache.druid.server.coordination.DataSegmentChangeHandler;
import org.apache.druid.server.coordination.DataSegmentChangeRequest;
import org.apache.druid.server.coordination.DataSegmentServerAnnouncer;
import org.apache.druid.server.coordination.SegmentChangeRequestDrop;
import org.apache.druid.server.coordination.SegmentChangeRequestLoad;
import org.apache.druid.server.metrics.SegmentRowCountDistribution;
import org.apache.druid.timeline.DataSegment;

@ManageLifecycle
public class SegmentLoadDropHandler
implements DataSegmentChangeHandler {
    private static final EmittingLogger log = new EmittingLogger(SegmentLoadDropHandler.class);
    private final Object segmentDeleteLock = new Object();
    private final Object startStopLock = new Object();
    private final ObjectMapper jsonMapper;
    private final SegmentLoaderConfig config;
    private final DataSegmentAnnouncer announcer;
    private final DataSegmentServerAnnouncer serverAnnouncer;
    private final SegmentManager segmentManager;
    private final ScheduledExecutorService exec;
    private final ServerTypeConfig serverTypeConfig;
    private final ConcurrentSkipListSet<DataSegment> segmentsToDelete;
    private final SegmentCacheManager segmentCacheManager;
    private volatile boolean started = false;
    private final Cache<DataSegmentChangeRequest, AtomicReference<Status>> requestStatuses;
    private final Object requestStatusesLock = new Object();
    private final LinkedHashSet<CustomSettableFuture> waitingFutures = new LinkedHashSet();

    @Inject
    public SegmentLoadDropHandler(ObjectMapper jsonMapper, SegmentLoaderConfig config, DataSegmentAnnouncer announcer, DataSegmentServerAnnouncer serverAnnouncer, SegmentManager segmentManager, SegmentCacheManager segmentCacheManager, ServerTypeConfig serverTypeConfig) {
        this(jsonMapper, config, announcer, serverAnnouncer, segmentManager, segmentCacheManager, Executors.newScheduledThreadPool(config.getNumLoadingThreads(), Execs.makeThreadFactory((String)"SimpleDataSegmentChangeHandler-%s")), serverTypeConfig);
    }

    @VisibleForTesting
    SegmentLoadDropHandler(ObjectMapper jsonMapper, SegmentLoaderConfig config, DataSegmentAnnouncer announcer, DataSegmentServerAnnouncer serverAnnouncer, SegmentManager segmentManager, SegmentCacheManager segmentCacheManager, ScheduledExecutorService exec, ServerTypeConfig serverTypeConfig) {
        this.jsonMapper = jsonMapper;
        this.config = config;
        this.announcer = announcer;
        this.serverAnnouncer = serverAnnouncer;
        this.segmentManager = segmentManager;
        this.segmentCacheManager = segmentCacheManager;
        this.exec = exec;
        this.serverTypeConfig = serverTypeConfig;
        this.segmentsToDelete = new ConcurrentSkipListSet();
        this.requestStatuses = CacheBuilder.newBuilder().maximumSize((long)config.getStatusQueueMaxSize()).initialCapacity(8).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LifecycleStart
    public void start() throws IOException {
        Object object = this.startStopLock;
        synchronized (object) {
            if (this.started) {
                return;
            }
            log.info("Starting...", new Object[0]);
            try {
                if (!this.config.getLocations().isEmpty()) {
                    this.loadLocalCache();
                }
                if (this.shouldAnnounce()) {
                    this.serverAnnouncer.announce();
                }
            }
            catch (Exception e) {
                Throwables.propagateIfPossible((Throwable)e, IOException.class);
                throw new RuntimeException(e);
            }
            this.started = true;
            log.info("Started.", new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LifecycleStop
    public void stop() {
        Object object = this.startStopLock;
        synchronized (object) {
            if (!this.started) {
                return;
            }
            log.info("Stopping...", new Object[0]);
            try {
                if (this.shouldAnnounce()) {
                    this.serverAnnouncer.unannounce();
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                this.started = false;
            }
            log.info("Stopped.", new Object[0]);
        }
    }

    public boolean isStarted() {
        return this.started;
    }

    private void loadLocalCache() throws IOException {
        long start = System.currentTimeMillis();
        File baseDir = this.config.getInfoDir();
        FileUtils.mkdirp((File)baseDir);
        ArrayList<DataSegment> cachedSegments = new ArrayList<DataSegment>();
        File[] segmentsToLoad = baseDir.listFiles();
        int ignored = 0;
        for (int i = 0; i < segmentsToLoad.length; ++i) {
            File file = segmentsToLoad[i];
            log.info("Loading segment cache file [%d/%d][%s].", new Object[]{i + 1, segmentsToLoad.length, file});
            try {
                DataSegment segment = (DataSegment)this.jsonMapper.readValue(file, DataSegment.class);
                if (!segment.getId().toString().equals(file.getName())) {
                    log.warn("Ignoring cache file[%s] for segment[%s].", new Object[]{file.getPath(), segment.getId()});
                    ++ignored;
                    continue;
                }
                if (this.segmentCacheManager.isSegmentCached(segment)) {
                    cachedSegments.add(segment);
                    continue;
                }
                log.warn("Unable to find cache file for %s. Deleting lookup entry", new Object[]{segment.getId()});
                File segmentInfoCacheFile = new File(baseDir, segment.getId().toString());
                if (segmentInfoCacheFile.delete()) continue;
                log.warn("Unable to delete segmentInfoCacheFile[%s]", new Object[]{segmentInfoCacheFile});
                continue;
            }
            catch (Exception e) {
                log.makeAlert((Throwable)e, "Failed to load segment from segmentInfo file", new Object[0]).addData("file", (Object)file).emit();
            }
        }
        if (ignored > 0) {
            log.makeAlert("Ignored misnamed segment cache files on startup.", new Object[0]).addData("numIgnored", (Object)ignored).emit();
        }
        this.addSegments(cachedSegments, () -> log.info("Cache load took %,d ms", new Object[]{System.currentTimeMillis() - start}));
    }

    private void loadSegment(DataSegment segment, DataSegmentChangeCallback callback, boolean lazy) throws SegmentLoadingException {
        this.loadSegment(segment, callback, lazy, null);
    }

    private void loadSegment(DataSegment segment, DataSegmentChangeCallback callback, boolean lazy, @Nullable ExecutorService loadSegmentIntoPageCacheExec) throws SegmentLoadingException {
        File segmentInfoCacheFile;
        boolean loaded;
        try {
            loaded = this.segmentManager.loadSegment(segment, lazy, () -> this.removeSegment(segment, DataSegmentChangeCallback.NOOP, false), loadSegmentIntoPageCacheExec);
        }
        catch (Exception e) {
            this.removeSegment(segment, callback, false);
            throw new SegmentLoadingException((Throwable)e, "Exception loading segment[%s]", new Object[]{segment.getId()});
        }
        if (loaded && !(segmentInfoCacheFile = new File(this.config.getInfoDir(), segment.getId().toString())).exists()) {
            try {
                this.jsonMapper.writeValue(segmentInfoCacheFile, (Object)segment);
            }
            catch (IOException e) {
                this.removeSegment(segment, callback, false);
                throw new SegmentLoadingException((Throwable)e, "Failed to write to disk segment info cache file[%s]", new Object[]{segmentInfoCacheFile});
            }
        }
    }

    public Map<String, Long> getAverageNumOfRowsPerSegmentForDatasource() {
        return this.segmentManager.getAverageRowCountForDatasource();
    }

    public Map<String, SegmentRowCountDistribution> getRowCountDistributionPerDatasource() {
        return this.segmentManager.getRowCountDistribution();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addSegment(DataSegment segment, @Nullable DataSegmentChangeCallback callback) {
        Status result = null;
        try {
            log.info("Loading segment %s", new Object[]{segment.getId()});
            if (this.segmentsToDelete.contains(segment)) {
                Object object = this.segmentDeleteLock;
                synchronized (object) {
                    this.segmentsToDelete.remove(segment);
                }
            }
            this.loadSegment(segment, DataSegmentChangeCallback.NOOP, false);
            try {
                this.announcer.announceSegment(segment);
            }
            catch (IOException e) {
                throw new SegmentLoadingException((Throwable)e, "Failed to announce segment[%s]", new Object[]{segment.getId()});
            }
            result = Status.SUCCESS;
            this.updateRequestStatus(new SegmentChangeRequestLoad(segment), result);
            if (null != callback) {
                callback.execute();
            }
        }
        catch (Throwable e) {
            try {
                log.makeAlert(e, "Failed to load segment for dataSource", new Object[0]).addData("segment", (Object)segment).emit();
                result = Status.failed(e.toString());
                this.updateRequestStatus(new SegmentChangeRequestLoad(segment), result);
                if (null != callback) {
                    callback.execute();
                }
            }
            catch (Throwable throwable) {
                this.updateRequestStatus(new SegmentChangeRequestLoad(segment), result);
                if (null != callback) {
                    callback.execute();
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSegments(Collection<DataSegment> segments, DataSegmentChangeCallback callback) {
        ExecutorService loadingExecutor = null;
        ExecutorService loadSegmentsIntoPageCacheOnBootstrapExec = this.config.getNumThreadsToLoadSegmentsIntoPageCacheOnBootstrap() != 0 ? Execs.multiThreaded((int)this.config.getNumThreadsToLoadSegmentsIntoPageCacheOnBootstrap(), (String)"Load-Segments-Into-Page-Cache-On-Bootstrap-%s") : null;
        try (BackgroundSegmentAnnouncer backgroundSegmentAnnouncer = new BackgroundSegmentAnnouncer(this.announcer, this.exec, this.config.getAnnounceIntervalMillis());){
            backgroundSegmentAnnouncer.startAnnouncing();
            loadingExecutor = Execs.multiThreaded((int)this.config.getNumBootstrapThreads(), (String)"Segment-Load-Startup-%s");
            int numSegments = segments.size();
            CountDownLatch latch = new CountDownLatch(numSegments);
            AtomicInteger counter = new AtomicInteger(0);
            CopyOnWriteArrayList failedSegments = new CopyOnWriteArrayList();
            for (DataSegment segment : segments) {
                loadingExecutor.submit(() -> {
                    try {
                        log.info("Loading segment[%d/%d][%s]", new Object[]{counter.incrementAndGet(), numSegments, segment.getId()});
                        this.loadSegment(segment, callback, this.config.isLazyLoadOnStart(), loadSegmentsIntoPageCacheOnBootstrapExec);
                        try {
                            backgroundSegmentAnnouncer.announceSegment(segment);
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            throw new SegmentLoadingException((Throwable)e, "Loading Interrupted", new Object[0]);
                        }
                    }
                    catch (SegmentLoadingException e) {
                        log.error((Throwable)e, "[%s] failed to load", new Object[]{segment.getId()});
                        failedSegments.add(segment);
                    }
                    finally {
                        latch.countDown();
                    }
                });
            }
            try {
                latch.await();
                if (failedSegments.size() > 0) {
                    log.makeAlert("%,d errors seen while loading segments", new Object[]{failedSegments.size()}).addData("failedSegments", failedSegments).emit();
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                log.makeAlert((Throwable)e, "LoadingInterrupted", new Object[0]).emit();
            }
            backgroundSegmentAnnouncer.finishAnnouncing();
        }
        catch (SegmentLoadingException e) {
            log.makeAlert((Throwable)e, "Failed to load segments -- likely problem with announcing.", new Object[0]).addData("numSegments", (Object)segments.size()).emit();
        }
        finally {
            callback.execute();
            if (loadingExecutor != null) {
                loadingExecutor.shutdownNow();
            }
            if (loadSegmentsIntoPageCacheOnBootstrapExec != null) {
                loadSegmentsIntoPageCacheOnBootstrapExec.shutdown();
            }
        }
    }

    @Override
    public void removeSegment(DataSegment segment, @Nullable DataSegmentChangeCallback callback) {
        this.removeSegment(segment, callback, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void removeSegment(DataSegment segment, @Nullable DataSegmentChangeCallback callback, boolean scheduleDrop) {
        Status result = null;
        try {
            this.announcer.unannounceSegment(segment);
            this.segmentsToDelete.add(segment);
            Runnable runnable = () -> {
                try {
                    Object object = this.segmentDeleteLock;
                    synchronized (object) {
                        if (this.segmentsToDelete.remove(segment)) {
                            this.segmentManager.dropSegment(segment);
                            File segmentInfoCacheFile = new File(this.config.getInfoDir(), segment.getId().toString());
                            if (!segmentInfoCacheFile.delete()) {
                                log.warn("Unable to delete segmentInfoCacheFile[%s]", new Object[]{segmentInfoCacheFile});
                            }
                        }
                    }
                }
                catch (Exception e) {
                    log.makeAlert((Throwable)e, "Failed to remove segment! Possible resource leak!", new Object[0]).addData("segment", (Object)segment).emit();
                }
            };
            if (scheduleDrop) {
                log.info("Completely removing [%s] in [%,d] millis", new Object[]{segment.getId(), this.config.getDropSegmentDelayMillis()});
                this.exec.schedule(runnable, (long)this.config.getDropSegmentDelayMillis(), TimeUnit.MILLISECONDS);
            } else {
                runnable.run();
            }
            result = Status.SUCCESS;
            this.updateRequestStatus(new SegmentChangeRequestDrop(segment), result);
            if (null != callback) {
                callback.execute();
            }
        }
        catch (Exception e) {
            try {
                log.makeAlert((Throwable)e, "Failed to remove segment", new Object[0]).addData("segment", (Object)segment).emit();
                result = Status.failed(e.getMessage());
                this.updateRequestStatus(new SegmentChangeRequestDrop(segment), result);
                if (null != callback) {
                    callback.execute();
                }
            }
            catch (Throwable throwable) {
                this.updateRequestStatus(new SegmentChangeRequestDrop(segment), result);
                if (null != callback) {
                    callback.execute();
                }
                throw throwable;
            }
        }
    }

    public Collection<DataSegment> getPendingDeleteSnapshot() {
        return ImmutableList.copyOf(this.segmentsToDelete);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListenableFuture<List<DataSegmentChangeRequestAndStatus>> processBatch(List<DataSegmentChangeRequest> changeRequests) {
        boolean isAnyRequestDone = false;
        HashMap statuses = Maps.newHashMapWithExpectedSize((int)changeRequests.size());
        for (DataSegmentChangeRequest cr : changeRequests) {
            AtomicReference<Status> status = this.processRequest(cr);
            if (status.get().getState() != Status.STATE.PENDING) {
                isAnyRequestDone = true;
            }
            statuses.put(cr, status);
        }
        CustomSettableFuture future = new CustomSettableFuture(this.waitingFutures, statuses);
        if (isAnyRequestDone) {
            future.resolve();
        } else {
            LinkedHashSet<CustomSettableFuture> linkedHashSet = this.waitingFutures;
            synchronized (linkedHashSet) {
                this.waitingFutures.add(future);
            }
        }
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AtomicReference<Status> processRequest(final DataSegmentChangeRequest changeRequest) {
        Object object = this.requestStatusesLock;
        synchronized (object) {
            AtomicReference status = (AtomicReference)this.requestStatuses.getIfPresent((Object)changeRequest);
            if (status == null || ((Status)status.get()).getState() == Status.STATE.FAILED) {
                changeRequest.go(new DataSegmentChangeHandler(){

                    @Override
                    public void addSegment(DataSegment segment, DataSegmentChangeCallback callback) {
                        SegmentLoadDropHandler.this.requestStatuses.put((Object)changeRequest, new AtomicReference<Status>(Status.PENDING));
                        SegmentLoadDropHandler.this.exec.submit(() -> SegmentLoadDropHandler.this.addSegment(((SegmentChangeRequestLoad)changeRequest).getSegment(), () -> SegmentLoadDropHandler.this.resolveWaitingFutures()));
                    }

                    @Override
                    public void removeSegment(DataSegment segment, DataSegmentChangeCallback callback) {
                        SegmentLoadDropHandler.this.requestStatuses.put((Object)changeRequest, new AtomicReference<Status>(Status.PENDING));
                        SegmentLoadDropHandler.this.removeSegment(((SegmentChangeRequestDrop)changeRequest).getSegment(), () -> SegmentLoadDropHandler.this.resolveWaitingFutures(), true);
                    }
                }, this::resolveWaitingFutures);
            } else if (((Status)status.get()).getState() == Status.STATE.SUCCESS) {
                this.requestStatuses.invalidate((Object)changeRequest);
                return status;
            }
            return (AtomicReference)this.requestStatuses.getIfPresent((Object)changeRequest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateRequestStatus(DataSegmentChangeRequest changeRequest, Status result) {
        if (result == null) {
            result = Status.failed("Unknown reason. Check server logs.");
        }
        Object object = this.requestStatusesLock;
        synchronized (object) {
            AtomicReference statusRef = (AtomicReference)this.requestStatuses.getIfPresent((Object)changeRequest);
            if (statusRef != null) {
                statusRef.set(result);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resolveWaitingFutures() {
        LinkedHashSet<CustomSettableFuture> waitingFuturesCopy;
        LinkedHashSet<CustomSettableFuture> linkedHashSet = this.waitingFutures;
        synchronized (linkedHashSet) {
            waitingFuturesCopy = new LinkedHashSet<CustomSettableFuture>(this.waitingFutures);
            this.waitingFutures.clear();
        }
        for (CustomSettableFuture future : waitingFuturesCopy) {
            future.resolve();
        }
    }

    private boolean shouldAnnounce() {
        return this.serverTypeConfig.getServerType().isSegmentServer() || !this.config.getLocations().isEmpty();
    }

    public static class DataSegmentChangeRequestAndStatus {
        private final DataSegmentChangeRequest request;
        private final Status status;

        @JsonCreator
        public DataSegmentChangeRequestAndStatus(@JsonProperty(value="request") DataSegmentChangeRequest request, @JsonProperty(value="status") Status status) {
            this.request = request;
            this.status = status;
        }

        @JsonProperty
        public DataSegmentChangeRequest getRequest() {
            return this.request;
        }

        @JsonProperty
        public Status getStatus() {
            return this.status;
        }

        public String toString() {
            return "DataSegmentChangeRequestAndStatus{request=" + this.request + ", status=" + this.status + '}';
        }
    }

    public static class Status {
        private final STATE state;
        @Nullable
        private final String failureCause;
        public static final Status SUCCESS = new Status(STATE.SUCCESS, null);
        public static final Status PENDING = new Status(STATE.PENDING, null);

        @JsonCreator
        Status(@JsonProperty(value="state") STATE state, @JsonProperty(value="failureCause") @Nullable String failureCause) {
            Preconditions.checkNotNull((Object)((Object)state), (Object)"state must be non-null");
            this.state = state;
            this.failureCause = failureCause;
        }

        public static Status failed(String cause) {
            return new Status(STATE.FAILED, cause);
        }

        @JsonProperty
        public STATE getState() {
            return this.state;
        }

        @Nullable
        @JsonProperty
        public String getFailureCause() {
            return this.failureCause;
        }

        public String toString() {
            return "Status{state=" + (Object)((Object)this.state) + ", failureCause='" + this.failureCause + '\'' + '}';
        }

        public static enum STATE {
            SUCCESS,
            FAILED,
            PENDING;

        }
    }

    private class CustomSettableFuture
    extends AbstractFuture<List<DataSegmentChangeRequestAndStatus>> {
        private final LinkedHashSet<CustomSettableFuture> waitingFutures;
        private final Map<DataSegmentChangeRequest, AtomicReference<Status>> statusRefs;

        private CustomSettableFuture(LinkedHashSet<CustomSettableFuture> waitingFutures, Map<DataSegmentChangeRequest, AtomicReference<Status>> statusRefs) {
            this.waitingFutures = waitingFutures;
            this.statusRefs = statusRefs;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resolve() {
            Object object = SegmentLoadDropHandler.this.requestStatusesLock;
            synchronized (object) {
                if (this.isDone()) {
                    return;
                }
                ArrayList result = new ArrayList(this.statusRefs.size());
                this.statusRefs.forEach((request, statusRef) -> {
                    Status status = (Status)statusRef.get();
                    if (status != null && status.getState() != Status.STATE.PENDING) {
                        SegmentLoadDropHandler.this.requestStatuses.invalidate(request);
                    }
                    result.add(new DataSegmentChangeRequestAndStatus((DataSegmentChangeRequest)request, status));
                });
                this.set(result);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean cancel(boolean interruptIfRunning) {
            LinkedHashSet<CustomSettableFuture> linkedHashSet = this.waitingFutures;
            synchronized (linkedHashSet) {
                this.waitingFutures.remove((Object)this);
            }
            return true;
        }
    }

    private static class BackgroundSegmentAnnouncer
    implements AutoCloseable {
        private static final EmittingLogger log = new EmittingLogger(BackgroundSegmentAnnouncer.class);
        private final int intervalMillis;
        private final DataSegmentAnnouncer announcer;
        private final ScheduledExecutorService exec;
        private final LinkedBlockingQueue<DataSegment> queue;
        private final SettableFuture<Boolean> doneAnnouncing;
        private final Object lock = new Object();
        private volatile boolean finished = false;
        @Nullable
        private volatile ScheduledFuture startedAnnouncing = null;
        @Nullable
        private volatile ScheduledFuture nextAnnoucement = null;

        public BackgroundSegmentAnnouncer(DataSegmentAnnouncer announcer, ScheduledExecutorService exec, int intervalMillis) {
            this.announcer = announcer;
            this.exec = exec;
            this.intervalMillis = intervalMillis;
            this.queue = new LinkedBlockingQueue();
            this.doneAnnouncing = SettableFuture.create();
        }

        public void announceSegment(DataSegment segment) throws InterruptedException {
            if (this.finished) {
                throw new ISE("Announce segment called after finishAnnouncing", new Object[0]);
            }
            this.queue.put(segment);
        }

        public void startAnnouncing() {
            if (this.intervalMillis <= 0) {
                return;
            }
            log.info("Starting background segment announcing task", new Object[0]);
            this.nextAnnoucement = this.startedAnnouncing = this.exec.schedule(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object = lock;
                    synchronized (object) {
                        try {
                            if (!finished || !queue.isEmpty()) {
                                ArrayList<DataSegment> segments = new ArrayList<DataSegment>();
                                queue.drainTo(segments);
                                try {
                                    announcer.announceSegments(segments);
                                    nextAnnoucement = exec.schedule(this, (long)intervalMillis, TimeUnit.MILLISECONDS);
                                }
                                catch (IOException e) {
                                    doneAnnouncing.setException((Throwable)new SegmentLoadingException((Throwable)e, "Failed to announce segments[%s]", new Object[]{segments}));
                                }
                            } else {
                                doneAnnouncing.set((Object)true);
                            }
                        }
                        catch (Exception e) {
                            doneAnnouncing.setException((Throwable)e);
                        }
                    }
                }
            }, (long)this.intervalMillis, TimeUnit.MILLISECONDS);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void finishAnnouncing() throws SegmentLoadingException {
            Object object = this.lock;
            synchronized (object) {
                this.finished = true;
                try {
                    ArrayList<DataSegment> segments = new ArrayList<DataSegment>();
                    this.queue.drainTo(segments);
                    this.announcer.announceSegments(segments);
                }
                catch (Exception e) {
                    throw new SegmentLoadingException((Throwable)e, "Failed to announce segments[%s]", new Object[]{this.queue});
                }
                try {
                    if (this.startedAnnouncing != null) {
                        this.startedAnnouncing.cancel(false);
                    }
                    if (this.doneAnnouncing.isDone()) {
                        this.doneAnnouncing.get();
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new SegmentLoadingException((Throwable)e, "Loading Interrupted", new Object[0]);
                }
                catch (ExecutionException e) {
                    throw new SegmentLoadingException(e.getCause(), "Background Announcing Task Failed", new Object[0]);
                }
            }
            log.info("Completed background segment announcing", new Object[0]);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            Object object = this.lock;
            synchronized (object) {
                this.finished = true;
                if (this.nextAnnoucement != null) {
                    this.nextAnnoucement.cancel(false);
                }
            }
        }
    }
}

