/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator.compact;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.commons.lang.ArrayUtils;
import org.apache.druid.client.indexing.ClientCompactionTaskGranularitySpec;
import org.apache.druid.client.indexing.ClientCompactionTaskQueryTuningConfig;
import org.apache.druid.client.indexing.ClientCompactionTaskTransformSpec;
import org.apache.druid.common.config.Configs;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.indexer.partitions.DynamicPartitionsSpec;
import org.apache.druid.indexer.partitions.PartitionsSpec;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.segment.IndexSpec;
import org.apache.druid.server.coordinator.DataSourceCompactionConfig;
import org.apache.druid.server.coordinator.UserCompactionTaskGranularityConfig;
import org.apache.druid.server.coordinator.compact.SegmentsToCompact;
import org.apache.druid.timeline.CompactionState;
import org.apache.druid.utils.CollectionUtils;

public class CompactionStatus {
    private static final CompactionStatus COMPLETE = new CompactionStatus(true, null);
    private static final List<Function<Evaluator, CompactionStatus>> CHECKS = Arrays.asList(rec$ -> Evaluator.access$1400((Evaluator)rec$), rec$ -> Evaluator.access$1300((Evaluator)rec$), rec$ -> Evaluator.access$1200((Evaluator)rec$), rec$ -> Evaluator.access$1100((Evaluator)rec$), rec$ -> Evaluator.access$1000((Evaluator)rec$), rec$ -> Evaluator.access$900((Evaluator)rec$), rec$ -> Evaluator.access$800((Evaluator)rec$), rec$ -> Evaluator.access$700((Evaluator)rec$), rec$ -> Evaluator.access$600((Evaluator)rec$), rec$ -> Evaluator.access$500((Evaluator)rec$));
    private final boolean complete;
    private final String reasonToCompact;

    private CompactionStatus(boolean complete, String reason) {
        this.complete = complete;
        this.reasonToCompact = reason;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public String getReasonToCompact() {
        return this.reasonToCompact;
    }

    private static CompactionStatus incomplete(String reasonFormat, Object ... args) {
        return new CompactionStatus(false, StringUtils.format((String)reasonFormat, (Object[])args));
    }

    private static CompactionStatus completeIfEqual(String field, Object configured, Object current) {
        if (configured == null || configured.equals(current)) {
            return COMPLETE;
        }
        return CompactionStatus.configChanged(field, configured, current);
    }

    private static CompactionStatus configChanged(String field, Object configured, Object current) {
        return CompactionStatus.incomplete("Configured %s[%s] is different from current %s[%s]", field, configured, field, current);
    }

    static CompactionStatus of(SegmentsToCompact candidateSegments, DataSourceCompactionConfig config, ObjectMapper objectMapper) {
        Evaluator evaluator = new Evaluator(candidateSegments, config, objectMapper);
        return CHECKS.stream().map(f -> (CompactionStatus)f.apply(evaluator)).filter(status -> !status.isComplete()).findFirst().orElse(COMPLETE);
    }

    static PartitionsSpec findPartitionsSpecFromConfig(ClientCompactionTaskQueryTuningConfig tuningConfig) {
        PartitionsSpec partitionsSpecFromTuningConfig = tuningConfig.getPartitionsSpec();
        if (partitionsSpecFromTuningConfig == null) {
            long maxTotalRows = Configs.valueOrDefault((Long)tuningConfig.getMaxTotalRows(), (long)Long.MAX_VALUE);
            return new DynamicPartitionsSpec(tuningConfig.getMaxRowsPerSegment(), Long.valueOf(maxTotalRows));
        }
        if (partitionsSpecFromTuningConfig instanceof DynamicPartitionsSpec) {
            return new DynamicPartitionsSpec(partitionsSpecFromTuningConfig.getMaxRowsPerSegment(), Long.valueOf(((DynamicPartitionsSpec)partitionsSpecFromTuningConfig).getMaxTotalRowsOr(Long.MAX_VALUE)));
        }
        return partitionsSpecFromTuningConfig;
    }

    private static class Evaluator {
        private final ObjectMapper objectMapper;
        private final DataSourceCompactionConfig compactionConfig;
        private final SegmentsToCompact candidateSegments;
        private final CompactionState lastCompactionState;
        private final ClientCompactionTaskQueryTuningConfig tuningConfig;
        private final ClientCompactionTaskGranularitySpec existingGranularitySpec;
        private final UserCompactionTaskGranularityConfig configuredGranularitySpec;

        private Evaluator(SegmentsToCompact candidateSegments, DataSourceCompactionConfig compactionConfig, ObjectMapper objectMapper) {
            Preconditions.checkArgument((!candidateSegments.isEmpty() ? 1 : 0) != 0, (Object)"Empty candidates");
            this.candidateSegments = candidateSegments;
            this.objectMapper = objectMapper;
            this.lastCompactionState = candidateSegments.getFirst().getLastCompactionState();
            this.compactionConfig = compactionConfig;
            this.tuningConfig = ClientCompactionTaskQueryTuningConfig.from(compactionConfig.getTuningConfig(), compactionConfig.getMaxRowsPerSegment(), null);
            this.configuredGranularitySpec = compactionConfig.getGranularitySpec();
            this.existingGranularitySpec = this.lastCompactionState == null ? null : this.convertIfNotNull(this.lastCompactionState.getGranularitySpec(), ClientCompactionTaskGranularitySpec.class);
        }

        private CompactionStatus segmentsHaveBeenCompactedAtLeastOnce() {
            if (this.lastCompactionState == null) {
                return CompactionStatus.incomplete("Not compacted yet", new Object[0]);
            }
            return COMPLETE;
        }

        private CompactionStatus allCandidatesHaveSameCompactionState() {
            boolean allHaveSameCompactionState = this.candidateSegments.getSegments().stream().allMatch(segment -> this.lastCompactionState.equals((Object)segment.getLastCompactionState()));
            if (allHaveSameCompactionState) {
                return COMPLETE;
            }
            return CompactionStatus.incomplete("Candidate segments have different last compaction states.", new Object[0]);
        }

        private CompactionStatus partitionsSpecIsUpToDate() {
            return CompactionStatus.completeIfEqual("partitionsSpec", CompactionStatus.findPartitionsSpecFromConfig(this.tuningConfig), this.lastCompactionState.getPartitionsSpec());
        }

        private CompactionStatus indexSpecIsUpToDate() {
            return CompactionStatus.completeIfEqual("indexSpec", Configs.valueOrDefault((Object)this.tuningConfig.getIndexSpec(), (Object)IndexSpec.DEFAULT), this.objectMapper.convertValue((Object)this.lastCompactionState.getIndexSpec(), IndexSpec.class));
        }

        private CompactionStatus segmentGranularityIsUpToDate() {
            Granularity existingSegmentGranularity;
            if (this.configuredGranularitySpec == null || this.configuredGranularitySpec.getSegmentGranularity() == null) {
                return COMPLETE;
            }
            Granularity configuredSegmentGranularity = this.configuredGranularitySpec.getSegmentGranularity();
            Granularity granularity = existingSegmentGranularity = this.existingGranularitySpec == null ? null : this.existingGranularitySpec.getSegmentGranularity();
            if (configuredSegmentGranularity.equals(existingSegmentGranularity)) {
                return COMPLETE;
            }
            if (existingSegmentGranularity == null) {
                boolean needsCompaction = this.candidateSegments.getSegments().stream().anyMatch(segment -> !configuredSegmentGranularity.isAligned(segment.getInterval()));
                if (needsCompaction) {
                    return CompactionStatus.incomplete("Configured segmentGranularity[%s] does not align with segment intervals.", new Object[]{configuredSegmentGranularity});
                }
            } else {
                return CompactionStatus.configChanged("segmentGranularity", configuredSegmentGranularity, existingSegmentGranularity);
            }
            return COMPLETE;
        }

        private CompactionStatus rollupIsUpToDate() {
            if (this.configuredGranularitySpec == null) {
                return COMPLETE;
            }
            return CompactionStatus.completeIfEqual("rollup", this.configuredGranularitySpec.isRollup(), this.existingGranularitySpec == null ? null : this.existingGranularitySpec.isRollup());
        }

        private CompactionStatus queryGranularityIsUpToDate() {
            if (this.configuredGranularitySpec == null) {
                return COMPLETE;
            }
            return CompactionStatus.completeIfEqual("queryGranularity", this.configuredGranularitySpec.getQueryGranularity(), this.existingGranularitySpec == null ? null : this.existingGranularitySpec.getQueryGranularity());
        }

        private CompactionStatus dimensionsSpecIsUpToDate() {
            if (this.compactionConfig.getDimensionsSpec() == null) {
                return COMPLETE;
            }
            DimensionsSpec existingDimensionsSpec = this.lastCompactionState.getDimensionsSpec();
            return CompactionStatus.completeIfEqual("dimensionsSpec", this.compactionConfig.getDimensionsSpec().getDimensions(), existingDimensionsSpec == null ? null : existingDimensionsSpec.getDimensions());
        }

        private CompactionStatus metricsSpecIsUpToDate() {
            Object[] existingMetricsSpec;
            Object[] configuredMetricsSpec = this.compactionConfig.getMetricsSpec();
            if (ArrayUtils.isEmpty((Object[])configuredMetricsSpec)) {
                return COMPLETE;
            }
            List metricSpecList = this.lastCompactionState.getMetricsSpec();
            Object[] objectArray = existingMetricsSpec = CollectionUtils.isNullOrEmpty((Collection)metricSpecList) ? null : (AggregatorFactory[])this.objectMapper.convertValue((Object)metricSpecList, AggregatorFactory[].class);
            if (existingMetricsSpec == null || !Arrays.deepEquals(configuredMetricsSpec, existingMetricsSpec)) {
                return CompactionStatus.configChanged("metricsSpec", Arrays.toString(configuredMetricsSpec), Arrays.toString(existingMetricsSpec));
            }
            return COMPLETE;
        }

        private CompactionStatus transformSpecFilterIsUpToDate() {
            if (this.compactionConfig.getTransformSpec() == null) {
                return COMPLETE;
            }
            ClientCompactionTaskTransformSpec existingTransformSpec = this.convertIfNotNull(this.lastCompactionState.getTransformSpec(), ClientCompactionTaskTransformSpec.class);
            return CompactionStatus.completeIfEqual("transformSpec filter", this.compactionConfig.getTransformSpec().getFilter(), existingTransformSpec == null ? null : existingTransformSpec.getFilter());
        }

        @Nullable
        private <T> T convertIfNotNull(Object object, Class<T> clazz) {
            if (object == null) {
                return null;
            }
            return (T)this.objectMapper.convertValue(object, clazz);
        }
    }
}

