/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator.duty;

import com.google.common.util.concurrent.AtomicDouble;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.druid.client.ImmutableDruidDataSource;
import org.apache.druid.client.ImmutableDruidServer;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.server.coordinator.DruidCluster;
import org.apache.druid.server.coordinator.DruidCoordinatorRuntimeParams;
import org.apache.druid.server.coordinator.ServerHolder;
import org.apache.druid.server.coordinator.duty.CoordinatorDuty;
import org.apache.druid.server.coordinator.loading.LoadQueuePeon;
import org.apache.druid.server.coordinator.loading.LoadQueueTaskMaster;
import org.apache.druid.server.coordinator.stats.CoordinatorRunStats;
import org.apache.druid.server.coordinator.stats.Dimension;
import org.apache.druid.server.coordinator.stats.RowKey;
import org.apache.druid.server.coordinator.stats.Stats;

public class CollectSegmentAndServerStats
implements CoordinatorDuty {
    private static final Logger log = new Logger(CollectSegmentAndServerStats.class);
    private final LoadQueueTaskMaster taskMaster;

    public CollectSegmentAndServerStats(LoadQueueTaskMaster taskMaster) {
        this.taskMaster = taskMaster;
    }

    @Override
    public DruidCoordinatorRuntimeParams run(DruidCoordinatorRuntimeParams params) {
        params.getDruidCluster().getHistoricals().forEach(this::logHistoricalTierStats);
        this.logServerDebuggingInfo(params.getDruidCluster());
        this.collectLoadQueueStats(params.getCoordinatorStats());
        return params;
    }

    private void collectLoadQueueStats(CoordinatorRunStats stats) {
        this.taskMaster.getAllPeons().forEach((serverName, queuePeon) -> {
            RowKey rowKey = RowKey.of(Dimension.SERVER, serverName);
            stats.add(Stats.SegmentQueue.BYTES_TO_LOAD, rowKey, queuePeon.getSizeOfSegmentsToLoad());
            stats.add(Stats.SegmentQueue.NUM_TO_LOAD, rowKey, queuePeon.getSegmentsToLoad().size());
            stats.add(Stats.SegmentQueue.NUM_TO_DROP, rowKey, queuePeon.getSegmentsToDrop().size());
            queuePeon.getAndResetStats().forEachStat((stat, key, statValue) -> stats.add(stat, this.createRowKeyForServer((String)serverName, key.getValues()), statValue));
        });
    }

    private RowKey createRowKeyForServer(String serverName, Map<Dimension, String> dimensionValues) {
        RowKey.Builder builder = RowKey.with(Dimension.SERVER, serverName);
        dimensionValues.forEach(builder::with);
        return builder.build();
    }

    private void logHistoricalTierStats(String tier, Set<ServerHolder> historicals) {
        AtomicInteger servedCount = new AtomicInteger();
        AtomicInteger loadingCount = new AtomicInteger();
        AtomicInteger droppingCount = new AtomicInteger();
        AtomicDouble usageSum = new AtomicDouble();
        AtomicLong currentBytesSum = new AtomicLong();
        historicals.forEach(serverHolder -> {
            ImmutableDruidServer server = serverHolder.getServer();
            servedCount.addAndGet(server.getNumSegments());
            currentBytesSum.addAndGet(server.getCurrSize());
            usageSum.addAndGet((double)(100.0f * (float)server.getCurrSize() / (float)server.getMaxSize()));
            LoadQueuePeon queuePeon = serverHolder.getPeon();
            loadingCount.addAndGet(queuePeon.getSegmentsToLoad().size());
            droppingCount.addAndGet(queuePeon.getSegmentsToDrop().size());
        });
        int numHistoricals = historicals.size();
        log.info("Tier[%s] is serving [%,d], loading [%,d] and dropping [%,d] segments across [%d] historicals with average usage[%d GBs], [%.1f%%].", new Object[]{tier, servedCount.get(), loadingCount.get(), droppingCount.get(), numHistoricals, (currentBytesSum.get() >> 30) / (long)numHistoricals, usageSum.get() / (double)numHistoricals});
    }

    private void logServerDebuggingInfo(DruidCluster cluster) {
        if (log.isDebugEnabled()) {
            log.debug("Servers", new Object[0]);
            for (ServerHolder serverHolder : cluster.getAllServers()) {
                ImmutableDruidServer druidServer = serverHolder.getServer();
                log.debug("  %s", new Object[]{druidServer});
                log.debug("    -- DataSources", new Object[0]);
                for (ImmutableDruidDataSource druidDataSource : druidServer.getDataSources()) {
                    log.debug("    %s", new Object[]{druidDataSource});
                }
            }
        }
    }
}

