/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator.duty;

import org.apache.druid.audit.AuditManager;
import org.apache.druid.server.coordinator.DruidCoordinatorConfig;
import org.apache.druid.server.coordinator.duty.MetadataCleanupDuty;
import org.apache.druid.server.coordinator.stats.Stats;
import org.joda.time.DateTime;

public class KillAuditLog
extends MetadataCleanupDuty {
    private final AuditManager auditManager;

    public KillAuditLog(DruidCoordinatorConfig config, AuditManager auditManager) {
        super("audit logs", "druid.coordinator.kill.audit", config.isAuditKillEnabled(), config.getCoordinatorAuditKillPeriod(), config.getCoordinatorAuditKillDurationToRetain(), Stats.Kill.AUDIT_LOGS, config);
        this.auditManager = auditManager;
    }

    @Override
    protected int cleanupEntriesCreatedBefore(DateTime minCreatedTime) {
        return this.auditManager.removeAuditLogsOlderThan(minCreatedTime.getMillis());
    }
}

