/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator.duty;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.metadata.MetadataSupervisorManager;
import org.apache.druid.server.coordinator.DruidCoordinatorConfig;
import org.apache.druid.server.coordinator.duty.CoordinatorCustomDuty;
import org.apache.druid.server.coordinator.duty.MetadataCleanupDuty;
import org.apache.druid.server.coordinator.stats.Stats;
import org.joda.time.DateTime;
import org.joda.time.Duration;

public class KillSupervisorsCustomDuty
extends MetadataCleanupDuty
implements CoordinatorCustomDuty {
    private static final Logger log = new Logger(KillSupervisorsCustomDuty.class);
    private final MetadataSupervisorManager metadataSupervisorManager;

    @JsonCreator
    public KillSupervisorsCustomDuty(@JsonProperty(value="durationToRetain") Duration retainDuration, @JacksonInject MetadataSupervisorManager metadataSupervisorManager, @JacksonInject DruidCoordinatorConfig coordinatorConfig) {
        super("supervisors", "KillSupervisorsCustomDuty", true, coordinatorConfig.getCoordinatorMetadataStoreManagementPeriod(), retainDuration, Stats.Kill.SUPERVISOR_SPECS, coordinatorConfig);
        this.metadataSupervisorManager = metadataSupervisorManager;
        log.warn("This is only an example implementation of a custom duty and must not be used in production. Use KillSupervisors duty instead.", new Object[0]);
    }

    @Override
    protected int cleanupEntriesCreatedBefore(DateTime minCreatedTime) {
        return this.metadataSupervisorManager.removeTerminatedSupervisorsOlderThan(minCreatedTime.getMillis());
    }
}

