/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator.duty;

import com.google.common.collect.ImmutableSet;
import java.time.Duration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.druid.client.ImmutableDruidDataSource;
import org.apache.druid.client.ImmutableDruidServer;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.server.coordinator.DruidCluster;
import org.apache.druid.server.coordinator.DruidCoordinatorRuntimeParams;
import org.apache.druid.server.coordinator.ServerHolder;
import org.apache.druid.server.coordinator.duty.CoordinatorDuty;
import org.apache.druid.server.coordinator.duty.SegmentDeleteHandler;
import org.apache.druid.server.coordinator.stats.CoordinatorRunStats;
import org.apache.druid.server.coordinator.stats.Dimension;
import org.apache.druid.server.coordinator.stats.RowKey;
import org.apache.druid.server.coordinator.stats.Stats;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.SegmentId;
import org.apache.druid.timeline.SegmentTimeline;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

public class MarkOvershadowedSegmentsAsUnused
implements CoordinatorDuty {
    private static final Logger log = new Logger(MarkOvershadowedSegmentsAsUnused.class);
    private final SegmentDeleteHandler deleteHandler;

    public MarkOvershadowedSegmentsAsUnused(SegmentDeleteHandler deleteHandler) {
        this.deleteHandler = deleteHandler;
    }

    @Override
    public DruidCoordinatorRuntimeParams run(DruidCoordinatorRuntimeParams params) {
        DateTime coordinatorStartTime = params.getCoordinatorStartTime();
        long delayMillis = params.getCoordinatorDynamicConfig().getMarkSegmentAsUnusedDelayMillis();
        if (DateTimes.nowUtc().isBefore((ReadableInstant)coordinatorStartTime.plus(delayMillis))) {
            log.info("Skipping MarkAsUnused until [%s] have elapsed after coordinator start [%s].", new Object[]{Duration.ofMillis(delayMillis), coordinatorStartTime});
            return params;
        }
        ImmutableSet<DataSegment> allOvershadowedSegments = params.getDataSourcesSnapshot().getOvershadowedSegments();
        if (allOvershadowedSegments.isEmpty()) {
            log.info("Skipping MarkAsUnused as there are no overshadowed segments.", new Object[0]);
            return params;
        }
        DruidCluster cluster = params.getDruidCluster();
        HashMap timelines = new HashMap();
        cluster.getHistoricals().values().forEach(historicals -> historicals.forEach(historical -> this.addSegmentsFromServer((ServerHolder)historical, timelines)));
        cluster.getBrokers().forEach(broker -> this.addSegmentsFromServer((ServerHolder)broker, timelines));
        HashMap<String, Set> datasourceToUnusedSegments = new HashMap<String, Set>();
        for (DataSegment dataSegment : allOvershadowedSegments) {
            SegmentTimeline timeline = (SegmentTimeline)timelines.get(dataSegment.getDataSource());
            if (timeline == null || !timeline.isOvershadowed(dataSegment)) continue;
            datasourceToUnusedSegments.computeIfAbsent(dataSegment.getDataSource(), ds -> new HashSet()).add(dataSegment.getId());
        }
        CoordinatorRunStats stats = params.getCoordinatorStats();
        datasourceToUnusedSegments.forEach((datasource, unusedSegments) -> {
            RowKey datasourceKey = RowKey.of(Dimension.DATASOURCE, datasource);
            stats.add(Stats.Segments.OVERSHADOWED, datasourceKey, unusedSegments.size());
            int updatedCount = this.deleteHandler.markSegmentsAsUnused((Set<SegmentId>)unusedSegments);
            log.info("Successfully marked [%d] segments of datasource[%s] as unused.", new Object[]{updatedCount, datasource});
        });
        return params;
    }

    private void addSegmentsFromServer(ServerHolder serverHolder, Map<String, SegmentTimeline> timelines) {
        ImmutableDruidServer server = serverHolder.getServer();
        for (ImmutableDruidDataSource dataSource : server.getDataSources()) {
            timelines.computeIfAbsent(dataSource.getName(), dsName -> new SegmentTimeline()).addSegments(dataSource.getSegments().iterator());
        }
    }
}

