/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.http;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import com.sun.jersey.spi.container.ResourceFilters;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.druid.audit.AuditEntry;
import org.apache.druid.audit.AuditInfo;
import org.apache.druid.audit.AuditManager;
import org.apache.druid.common.config.ConfigManager;
import org.apache.druid.common.utils.ServletResourceUtils;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.server.coordinator.CoordinatorCompactionConfig;
import org.apache.druid.server.coordinator.CoordinatorConfigManager;
import org.apache.druid.server.coordinator.DataSourceCompactionConfig;
import org.apache.druid.server.coordinator.DataSourceCompactionConfigHistory;
import org.apache.druid.server.http.security.ConfigResourceFilter;
import org.apache.druid.server.security.AuthorizationUtils;
import org.joda.time.Interval;

@Path(value="/druid/coordinator/v1/config/compaction")
@ResourceFilters(value={ConfigResourceFilter.class})
public class CoordinatorCompactionConfigsResource {
    private static final Logger LOG = new Logger(CoordinatorCompactionConfigsResource.class);
    private static final long UPDATE_RETRY_DELAY = 1000L;
    static final int UPDATE_NUM_RETRY = 5;
    private final CoordinatorConfigManager configManager;
    private final AuditManager auditManager;

    @Inject
    public CoordinatorCompactionConfigsResource(CoordinatorConfigManager configManager, AuditManager auditManager) {
        this.configManager = configManager;
        this.auditManager = auditManager;
    }

    @GET
    @Produces(value={"application/json"})
    public Response getCompactionConfig() {
        return Response.ok((Object)this.configManager.getCurrentCompactionConfig()).build();
    }

    @POST
    @Path(value="/taskslots")
    @Consumes(value={"application/json"})
    public Response setCompactionTaskLimit(@QueryParam(value="ratio") Double compactionTaskSlotRatio, @QueryParam(value="max") Integer maxCompactionTaskSlots, @QueryParam(value="useAutoScaleSlots") Boolean useAutoScaleSlots, @Context HttpServletRequest req) {
        UnaryOperator operator = current -> CoordinatorCompactionConfig.from(current, compactionTaskSlotRatio, maxCompactionTaskSlots, useAutoScaleSlots);
        return this.updateConfigHelper(operator, AuthorizationUtils.buildAuditInfo(req));
    }

    @POST
    @Consumes(value={"application/json"})
    public Response addOrUpdateCompactionConfig(DataSourceCompactionConfig newConfig, @Context HttpServletRequest req) {
        UnaryOperator callable = current -> {
            Map newConfigs = current.getCompactionConfigs().stream().collect(Collectors.toMap(DataSourceCompactionConfig::getDataSource, Function.identity()));
            newConfigs.put(newConfig.getDataSource(), newConfig);
            CoordinatorCompactionConfig newCompactionConfig = CoordinatorCompactionConfig.from(current, (List<DataSourceCompactionConfig>)ImmutableList.copyOf(newConfigs.values()));
            return newCompactionConfig;
        };
        return this.updateConfigHelper(callable, AuthorizationUtils.buildAuditInfo(req));
    }

    @GET
    @Path(value="/{dataSource}")
    @Produces(value={"application/json"})
    public Response getCompactionConfig(@PathParam(value="dataSource") String dataSource) {
        CoordinatorCompactionConfig current = this.configManager.getCurrentCompactionConfig();
        Map configs = current.getCompactionConfigs().stream().collect(Collectors.toMap(DataSourceCompactionConfig::getDataSource, Function.identity()));
        DataSourceCompactionConfig config = (DataSourceCompactionConfig)configs.get(dataSource);
        if (config == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return Response.ok().entity((Object)config).build();
    }

    @GET
    @Path(value="/{dataSource}/history")
    @Produces(value={"application/json"})
    public Response getCompactionConfigHistory(@PathParam(value="dataSource") String dataSource, @QueryParam(value="interval") String interval, @QueryParam(value="count") Integer count) {
        Interval theInterval = interval == null ? null : Intervals.of((String)interval);
        try {
            List auditEntries = theInterval == null && count != null ? this.auditManager.fetchAuditHistory("coordinator.compaction.config", "coordinator.compaction.config", count.intValue()) : this.auditManager.fetchAuditHistory("coordinator.compaction.config", "coordinator.compaction.config", theInterval);
            DataSourceCompactionConfigHistory history = new DataSourceCompactionConfigHistory(dataSource);
            for (AuditEntry audit : auditEntries) {
                CoordinatorCompactionConfig coordinatorCompactionConfig = this.configManager.convertBytesToCompactionConfig(audit.getPayload().serialized().getBytes(StandardCharsets.UTF_8));
                history.add(coordinatorCompactionConfig, audit.getAuditInfo(), audit.getAuditTime());
            }
            return Response.ok(history.getHistory()).build();
        }
        catch (IllegalArgumentException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ServletResourceUtils.sanitizeException((Throwable)e)).build();
        }
    }

    @DELETE
    @Path(value="/{dataSource}")
    @Produces(value={"application/json"})
    public Response deleteCompactionConfig(@PathParam(value="dataSource") String dataSource, @Context HttpServletRequest req) {
        UnaryOperator callable = current -> {
            Map configs = current.getCompactionConfigs().stream().collect(Collectors.toMap(DataSourceCompactionConfig::getDataSource, Function.identity()));
            DataSourceCompactionConfig config = (DataSourceCompactionConfig)configs.remove(dataSource);
            if (config == null) {
                throw new NoSuchElementException("datasource not found");
            }
            return CoordinatorCompactionConfig.from(current, (List<DataSourceCompactionConfig>)ImmutableList.copyOf(configs.values()));
        };
        return this.updateConfigHelper(callable, AuthorizationUtils.buildAuditInfo(req));
    }

    private Response updateConfigHelper(UnaryOperator<CoordinatorCompactionConfig> configOperator, AuditInfo auditInfo) {
        ConfigManager.SetResult setResult = null;
        try {
            for (int attemps = 0; attemps < 5 && !(setResult = this.configManager.getAndUpdateCompactionConfig(configOperator, auditInfo)).isOk() && setResult.isRetryable(); ++attemps) {
                this.updateRetryDelay();
            }
        }
        catch (NoSuchElementException e) {
            LOG.warn((Throwable)e, "Update compaction config failed", new Object[0]);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (Exception e) {
            LOG.warn((Throwable)e, "Update compaction config failed", new Object[0]);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)ImmutableMap.of((Object)"error", (Object)this.createErrorMessage(e))).build();
        }
        if (setResult.isOk()) {
            return Response.ok().build();
        }
        if (setResult.getException() instanceof NoSuchElementException) {
            LOG.warn((Throwable)setResult.getException(), "Update compaction config failed", new Object[0]);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        LOG.warn((Throwable)setResult.getException(), "Update compaction config failed", new Object[0]);
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ImmutableMap.of((Object)"error", (Object)this.createErrorMessage(setResult.getException()))).build();
    }

    private void updateRetryDelay() {
        try {
            Thread.sleep(ThreadLocalRandom.current().nextLong(1000L));
        }
        catch (InterruptedException ie) {
            throw new RuntimeException(ie);
        }
    }

    private String createErrorMessage(Exception e) {
        if (e.getMessage() == null) {
            return "Unknown Error";
        }
        return e.getMessage();
    }
}

