/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.catalog.model.table;

import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.Map;
import org.apache.druid.catalog.model.Columns;
import org.apache.druid.catalog.model.ResolvedTable;
import org.apache.druid.catalog.model.TableDefnRegistry;
import org.apache.druid.catalog.model.TableMetadata;
import org.apache.druid.catalog.model.table.BaseExternTableTest;
import org.apache.druid.catalog.model.table.TableBuilder;
import org.apache.druid.data.input.InputFormat;
import org.apache.druid.data.input.impl.CsvInputFormat;
import org.apache.druid.data.input.impl.HttpInputSource;
import org.apache.druid.data.input.impl.HttpInputSourceConfig;
import org.apache.druid.data.input.impl.InlineInputSource;
import org.apache.druid.data.input.impl.JsonInputFormat;
import org.apache.druid.data.input.impl.LocalInputSource;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.metadata.DefaultPasswordProvider;
import org.apache.druid.metadata.PasswordProvider;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class ExternalTableTest
extends BaseExternTableTest {
    private static final Logger LOG = new Logger(ExternalTableTest.class);
    private final TableDefnRegistry registry;

    public ExternalTableTest() {
        this.registry = new TableDefnRegistry(this.mapper);
    }

    @Test
    public void testValidateEmptyTable() {
        TableMetadata table = TableBuilder.external((String)"foo").build();
        ResolvedTable resolved = this.registry.resolve(table.spec());
        Assert.assertThrows(IAE.class, () -> resolved.validate());
    }

    @Test
    public void testValidateMissingSourceType() {
        TableMetadata table = TableBuilder.external((String)"foo").inputSource((Map)ImmutableMap.of()).build();
        ResolvedTable resolved = this.registry.resolve(table.spec());
        Assert.assertThrows(IAE.class, () -> resolved.validate());
    }

    @Test
    public void testValidateUnknownSourceType() {
        TableMetadata table = TableBuilder.external((String)"foo").inputSource((Map)ImmutableMap.of((Object)"type", (Object)"unknown")).build();
        ResolvedTable resolved = this.registry.resolve(table.spec());
        Assert.assertThrows(IAE.class, () -> resolved.validate());
    }

    @Test
    public void testValidateSourceOnly() {
        LocalInputSource inputSource = new LocalInputSource(new File("/tmp"), "*");
        TableMetadata table = TableBuilder.external((String)"foo").inputSource(this.toMap(inputSource)).build();
        ResolvedTable resolved = this.registry.resolve(table.spec());
        resolved.validate();
    }

    @Test
    public void testValidateMissingFormatType() {
        TableMetadata table = TableBuilder.external((String)"foo").inputSource(this.toMap(new InlineInputSource("a\n"))).inputFormat((Map)ImmutableMap.of()).build();
        ResolvedTable resolved = this.registry.resolve(table.spec());
        Assert.assertThrows(IAE.class, () -> resolved.validate());
    }

    @Test
    public void testValidateUnknownFormatType() {
        TableMetadata table = TableBuilder.external((String)"foo").inputSource(this.toMap(new InlineInputSource("a\n"))).inputFormat((Map)ImmutableMap.of((Object)"type", (Object)"unknown")).build();
        ResolvedTable resolved = this.registry.resolve(table.spec());
        Assert.assertThrows(IAE.class, () -> resolved.validate());
    }

    @Test
    public void testValidateSourceAndFormat() {
        CsvInputFormat format = new CsvInputFormat(Collections.singletonList("a"), ";", Boolean.valueOf(false), Boolean.valueOf(false), 0);
        TableMetadata table = TableBuilder.external((String)"foo").inputSource(this.toMap(new InlineInputSource("a\n"))).inputFormat(this.formatToMap((InputFormat)format)).column("a", Columns.STRING).build();
        ResolvedTable resolved = this.registry.resolve(table.spec());
        resolved.validate();
    }

    @Test
    @Ignore
    public void wikipediaDocExample() {
        JsonInputFormat format = new JsonInputFormat(null, null, Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false));
        LocalInputSource inputSource = new LocalInputSource(new File("/Users/bob/druid/quickstart/tutorial"), "wikiticker-*-sampled.json");
        TableMetadata table = TableBuilder.external((String)"foo").inputSource(this.toMap(inputSource)).inputFormat(this.formatToMap((InputFormat)format)).description("Sample Wikipedia data").column("timetamp", Columns.STRING).column("page", Columns.STRING).column("language", Columns.STRING).column("unpatrolled", Columns.STRING).column("newPage", Columns.STRING).column("robot", Columns.STRING).column("added", Columns.STRING).column("namespace", Columns.LONG).column("deleted", Columns.LONG).column("delta", Columns.LONG).build();
        LOG.info(table.spec().toString(), new Object[0]);
    }

    @Test
    @Ignore
    public void httpDocExample() throws URISyntaxException {
        HttpInputSource inputSource = new HttpInputSource(Collections.singletonList(new URI("https://example.com/my.csv")), "bob", (PasswordProvider)new DefaultPasswordProvider("secret"), null, new HttpInputSourceConfig(null));
        Map<String, Object> sourceMap = this.toMap(inputSource);
        sourceMap.remove("uris");
        TableMetadata table = TableBuilder.external((String)"koala").inputSource(sourceMap).inputFormat(CSV_FORMAT).property("uriTemplate", (Object)"https://example.com/{}").description("Example parameterized external table").column("timetamp", Columns.STRING).column("metric", Columns.STRING).column("value", Columns.LONG).build();
        LOG.info(table.spec().toString(), new Object[0]);
    }

    @Test
    @Ignore
    public void httpConnDocExample() throws URISyntaxException {
        HttpInputSource inputSource = new HttpInputSource(Collections.singletonList(new URI("https://example.com/")), "bob", (PasswordProvider)new DefaultPasswordProvider("secret"), null, new HttpInputSourceConfig(null));
        TableMetadata table = TableBuilder.external((String)"koala").inputSource(this.toMap(inputSource)).description("Example connection").build();
        LOG.info(table.spec().toString(), new Object[0]);
    }

    @Test
    @Ignore
    public void localDocExample() {
        ImmutableMap sourceMap = ImmutableMap.of((Object)"type", (Object)"local", (Object)"baseDir", (Object)"/var/data");
        TableMetadata table = TableBuilder.external((String)"koala").inputSource((Map)sourceMap).build();
        LOG.info(table.spec().toString(), new Object[0]);
    }
}

