/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.client;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.AbstractFuture;
import com.google.common.util.concurrent.Futures;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.druid.client.JsonParserIterator;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryCapacityExceededException;
import org.apache.druid.query.QueryContext;
import org.apache.druid.query.QueryException;
import org.apache.druid.query.QueryInterruptedException;
import org.apache.druid.query.QueryTimeoutException;
import org.apache.druid.query.QueryUnsupportedException;
import org.apache.druid.query.ResourceLimitExceededException;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.runners.Enclosed;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

@RunWith(value=Enclosed.class)
public class JsonParserIteratorTest {
    private static final JavaType JAVA_TYPE = (JavaType)Mockito.mock(JavaType.class);
    private static final String URL = "url";
    private static final String HOST = "host";
    private static final ObjectMapper OBJECT_MAPPER = new DefaultObjectMapper();

    private static InputStream mockErrorResponse(Exception e) throws JsonProcessingException {
        return new ByteArrayInputStream(OBJECT_MAPPER.writeValueAsBytes((Object)e));
    }

    private static InputStream mockErrorResponse(String errMsg) throws JsonProcessingException {
        return new ByteArrayInputStream(OBJECT_MAPPER.writeValueAsBytes((Object)errMsg));
    }

    public static class IAEExceptionConversionTest {
        @Rule
        public ExpectedException expectedException = ExpectedException.none();
        private String errorMessage = "pstream connect error or disconnect/reset before header";
        private String nullErrMsg = null;

        @Test
        public void testNullErrorMsg() throws JsonProcessingException {
            JsonParserIterator iterator = new JsonParserIterator(JAVA_TYPE, (Future)Futures.immediateFuture((Object)JsonParserIteratorTest.mockErrorResponse(this.nullErrMsg)), JsonParserIteratorTest.URL, null, JsonParserIteratorTest.HOST, OBJECT_MAPPER);
            this.expectedException.expect(QueryInterruptedException.class);
            this.expectedException.expectMessage("");
            iterator.hasNext();
        }

        @Test
        public void testParsingError() throws JsonProcessingException {
            JsonParserIterator iterator = new JsonParserIterator(JAVA_TYPE, (Future)Futures.immediateFuture((Object)JsonParserIteratorTest.mockErrorResponse(this.errorMessage)), JsonParserIteratorTest.URL, null, JsonParserIteratorTest.HOST, OBJECT_MAPPER);
            this.expectedException.expect(QueryInterruptedException.class);
            this.expectedException.expectMessage(this.errorMessage);
            iterator.hasNext();
        }
    }

    public static class TimeoutExceptionConversionTest {
        @Rule
        public ExpectedException expectedException = ExpectedException.none();

        @Test
        public void testTimeoutBeforeCallingFuture() {
            JsonParserIterator iterator = new JsonParserIterator(JAVA_TYPE, (Future)Mockito.mock(Future.class), JsonParserIteratorTest.URL, this.mockQuery("qid", 0L), JsonParserIteratorTest.HOST, OBJECT_MAPPER);
            this.expectedException.expect(QueryTimeoutException.class);
            this.expectedException.expectMessage(StringUtils.format((String)"url[%s] timed out", (Object[])new Object[]{JsonParserIteratorTest.URL}));
            iterator.hasNext();
        }

        @Test
        public void testTimeoutWhileCallingFuture() {
            AbstractFuture<InputStream> future = new AbstractFuture<InputStream>(){

                public InputStream get(long timeout, TimeUnit unit) throws InterruptedException {
                    Thread.sleep(2000L);
                    return null;
                }
            };
            JsonParserIterator iterator = new JsonParserIterator(JAVA_TYPE, (Future)future, JsonParserIteratorTest.URL, this.mockQuery("qid", System.currentTimeMillis() + 500L), JsonParserIteratorTest.HOST, OBJECT_MAPPER);
            this.expectedException.expect(QueryTimeoutException.class);
            this.expectedException.expectMessage(StringUtils.format((String)"url[%s] timed out", (Object[])new Object[]{JsonParserIteratorTest.URL}));
            iterator.hasNext();
        }

        @Test
        public void testTimeoutAfterCallingFuture() {
            ExecutorService service = Execs.singleThreaded((String)"timeout-test");
            try {
                JsonParserIterator iterator = new JsonParserIterator(JAVA_TYPE, service.submit(() -> {
                    Thread.sleep(2000L);
                    return null;
                }), JsonParserIteratorTest.URL, this.mockQuery("qid", System.currentTimeMillis() + 500L), JsonParserIteratorTest.HOST, OBJECT_MAPPER);
                this.expectedException.expect(QueryTimeoutException.class);
                this.expectedException.expectMessage("Query [qid] timed out");
                iterator.hasNext();
            }
            finally {
                service.shutdownNow();
            }
        }

        private Query<?> mockQuery(String queryId, long timeoutAt) {
            Query query = (Query)Mockito.mock(Query.class);
            QueryContext context = (QueryContext)Mockito.mock(QueryContext.class);
            Mockito.when((Object)query.getId()).thenReturn((Object)queryId);
            Mockito.when((Object)query.context()).thenReturn((Object)QueryContext.of((Map)ImmutableMap.of((Object)"queryFailTime", (Object)timeoutAt)));
            return query;
        }
    }

    public static class QueryInterruptedExceptionConversionTest {
        @Rule
        public ExpectedException expectedException = ExpectedException.none();

        @Test
        public void testConvertQueryExceptionWithNullErrorCodeToQueryInterruptedException() throws JsonProcessingException {
            JsonParserIterator iterator = new JsonParserIterator(JAVA_TYPE, (Future)Futures.immediateFuture((Object)JsonParserIteratorTest.mockErrorResponse((Exception)new QueryException(null, "query exception test", null, null))), JsonParserIteratorTest.URL, null, JsonParserIteratorTest.HOST, OBJECT_MAPPER);
            this.expectedException.expect(QueryInterruptedException.class);
            this.expectedException.expectMessage("query exception test");
            iterator.hasNext();
        }

        @Test
        public void testConvertQueryExceptionWithNonNullErrorCodeToQueryInterruptedException() throws JsonProcessingException {
            JsonParserIterator iterator = new JsonParserIterator(JAVA_TYPE, (Future)Futures.immediateFuture((Object)JsonParserIteratorTest.mockErrorResponse((Exception)new QueryException("test error", "query exception test", null, null))), JsonParserIteratorTest.URL, null, JsonParserIteratorTest.HOST, OBJECT_MAPPER);
            this.expectedException.expect(QueryInterruptedException.class);
            this.expectedException.expectMessage("query exception test");
            iterator.hasNext();
        }
    }

    @RunWith(value=Parameterized.class)
    public static class NonQueryInterruptedExceptionRestoreTest {
        @Rule
        public ExpectedException expectedException = ExpectedException.none();
        private final Exception exception;

        @Parameterized.Parameters(name="{0}")
        public static Iterable<Object[]> constructorFeeder() {
            return ImmutableList.of((Object)new Object[]{new QueryTimeoutException()}, (Object)new Object[]{QueryCapacityExceededException.withErrorMessageAndResolvedHost((String)"capacity exceeded exception test")}, (Object)new Object[]{new QueryUnsupportedException("unsupported exception test")}, (Object)new Object[]{new ResourceLimitExceededException("resource limit exceeded exception test")});
        }

        public NonQueryInterruptedExceptionRestoreTest(Exception exception) {
            this.exception = exception;
        }

        @Test
        public void testRestoreException() throws JsonProcessingException {
            JsonParserIterator iterator = new JsonParserIterator(JAVA_TYPE, (Future)Futures.immediateFuture((Object)JsonParserIteratorTest.mockErrorResponse(this.exception)), JsonParserIteratorTest.URL, null, JsonParserIteratorTest.HOST, OBJECT_MAPPER);
            this.expectedException.expect(this.exception.getClass());
            this.expectedException.expectMessage(this.exception.getMessage());
            iterator.hasNext();
        }
    }

    public static class FutureExceptionTest {
        @Rule
        public ExpectedException expectedException = ExpectedException.none();

        @Test
        public void testConvertFutureTimeoutToQueryTimeoutException() {
            JsonParserIterator iterator = new JsonParserIterator(JAVA_TYPE, (Future)Futures.immediateFailedFuture((Throwable)new QueryException("Query timeout", "timeout exception conversion test", null, JsonParserIteratorTest.HOST)), JsonParserIteratorTest.URL, null, JsonParserIteratorTest.HOST, OBJECT_MAPPER);
            this.expectedException.expect(QueryTimeoutException.class);
            this.expectedException.expectMessage("timeout exception conversion test");
            iterator.hasNext();
        }

        @Test
        public void testConvertFutureCancellationToQueryInterruptedException() {
            JsonParserIterator iterator = new JsonParserIterator(JAVA_TYPE, (Future)Futures.immediateCancelledFuture(), JsonParserIteratorTest.URL, null, JsonParserIteratorTest.HOST, OBJECT_MAPPER);
            this.expectedException.expect(QueryInterruptedException.class);
            this.expectedException.expectMessage("Task was cancelled.");
            iterator.hasNext();
        }

        @Test
        public void testConvertFutureInterruptedToQueryInterruptedException() {
            JsonParserIterator iterator = new JsonParserIterator(JAVA_TYPE, (Future)Futures.immediateFailedFuture((Throwable)new InterruptedException("interrupted future")), JsonParserIteratorTest.URL, null, JsonParserIteratorTest.HOST, OBJECT_MAPPER);
            this.expectedException.expect(QueryInterruptedException.class);
            this.expectedException.expectMessage("interrupted future");
            iterator.hasNext();
        }

        @Test
        public void testConvertIOExceptionToQueryInterruptedException() throws IOException {
            InputStream exceptionThrowingStream = (InputStream)Mockito.mock(InputStream.class);
            IOException ioException = new IOException("ioexception test");
            Mockito.when((Object)exceptionThrowingStream.read()).thenThrow(new Throwable[]{ioException});
            Mockito.when((Object)exceptionThrowingStream.read((byte[])ArgumentMatchers.any())).thenThrow(new Throwable[]{ioException});
            Mockito.when((Object)exceptionThrowingStream.read((byte[])ArgumentMatchers.any(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt())).thenThrow(new Throwable[]{ioException});
            JsonParserIterator iterator = new JsonParserIterator(JAVA_TYPE, (Future)Futures.immediateFuture((Object)exceptionThrowingStream), JsonParserIteratorTest.URL, null, JsonParserIteratorTest.HOST, OBJECT_MAPPER);
            this.expectedException.expect(QueryInterruptedException.class);
            this.expectedException.expectMessage("ioexception test");
            iterator.hasNext();
        }
    }
}

