/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.discovery;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.druid.discovery.DataServerClient;
import org.apache.druid.discovery.DruidServiceTestUtils;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.query.Druids;
import org.apache.druid.query.Query;
import org.apache.druid.query.SegmentDescriptor;
import org.apache.druid.query.context.DefaultResponseContext;
import org.apache.druid.query.context.ResponseContext;
import org.apache.druid.query.scan.ScanQuery;
import org.apache.druid.query.scan.ScanResultValue;
import org.apache.druid.query.spec.MultipleSpecificSegmentSpec;
import org.apache.druid.query.spec.QuerySegmentSpec;
import org.apache.druid.rpc.MockServiceClient;
import org.apache.druid.rpc.RequestBuilder;
import org.apache.druid.rpc.ServiceClientFactory;
import org.apache.druid.rpc.ServiceLocation;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class DataServerClientTest {
    MockServiceClient serviceClient;
    ServiceClientFactory serviceClientFactory;
    ObjectMapper jsonMapper;
    ScanQuery query;
    DataServerClient target;

    @Before
    public void setUp() {
        this.jsonMapper = DruidServiceTestUtils.newJsonMapper();
        this.serviceClient = new MockServiceClient();
        this.serviceClientFactory = (serviceName, serviceLocator, retryPolicy) -> this.serviceClient;
        this.query = Druids.newScanQueryBuilder().dataSource("dataSource1").intervals((QuerySegmentSpec)new MultipleSpecificSegmentSpec((List)ImmutableList.of((Object)new SegmentDescriptor(Intervals.of((String)"2003/2004"), "v0", 1)))).columns(new String[]{"__time", "cnt", "dim1", "dim2", "m1", "m2", "unique_dim1"}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).build();
        this.target = new DataServerClient(this.serviceClientFactory, (ServiceLocation)Mockito.mock(ServiceLocation.class), this.jsonMapper, Execs.scheduledSingleThreaded((String)"query-cancellation-executor"));
    }

    @Test
    public void testFetchSegmentFromDataServer() throws JsonProcessingException {
        ScanResultValue scanResultValue = new ScanResultValue(null, (List)ImmutableList.of((Object)"id", (Object)"name"), (Object)ImmutableList.of((Object)ImmutableList.of((Object)1, (Object)"abc"), (Object)ImmutableList.of((Object)5, (Object)"efg")));
        RequestBuilder requestBuilder = new RequestBuilder(HttpMethod.POST, "/druid/v2/").jsonContent(this.jsonMapper, (Object)this.query);
        this.serviceClient.expectAndRespond(requestBuilder, HttpResponseStatus.OK, (Map<String, String>)ImmutableMap.of((Object)"Content-Type", (Object)"application/json"), this.jsonMapper.writeValueAsBytes(Collections.singletonList(scanResultValue)));
        DefaultResponseContext responseContext = new DefaultResponseContext();
        Sequence result = this.target.run((Query)this.query, (ResponseContext)responseContext, this.jsonMapper.getTypeFactory().constructType(ScanResultValue.class), Closer.create());
        Assert.assertEquals((Object)ImmutableList.of((Object)scanResultValue), (Object)result.toList());
    }
}

