/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.initialization;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Binder;
import com.google.inject.ConfigurationException;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.druid.discovery.NodeRole;
import org.apache.druid.guice.ExtensionsLoader;
import org.apache.druid.guice.JsonConfigProvider;
import org.apache.druid.guice.StartupInjectorBuilder;
import org.apache.druid.guice.annotations.LoadScope;
import org.apache.druid.guice.annotations.Self;
import org.apache.druid.initialization.DruidModule;
import org.apache.druid.initialization.ServerInjectorBuilder;
import org.apache.druid.server.DruidNode;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class ServerInjectorBuilderTest {
    @Rule
    public final TemporaryFolder temporaryFolder = new TemporaryFolder();

    private Injector startupInjector() {
        return new StartupInjectorBuilder().withEmptyProperties().withExtensions().build();
    }

    @Test
    public void test03ClassLoaderExtensionsLoading() {
        Injector startupInjector = this.startupInjector();
        ExtensionsLoader extnLoader = ExtensionsLoader.instance((Injector)startupInjector);
        Function<DruidModule, String> fnClassName = new Function<DruidModule, String>(){

            @Nullable
            public String apply(@Nullable DruidModule input) {
                return input.getClass().getName();
            }
        };
        Collection modules = extnLoader.getFromExtensions(DruidModule.class);
        Assert.assertTrue((String)"modules contains TestDruidModule", (boolean)Collections2.transform((Collection)modules, (Function)fnClassName).contains(TestDruidModule.class.getName()));
    }

    @Test
    public void test05MakeInjectorWithModules() {
        Injector startupInjector = this.startupInjector();
        ExtensionsLoader extnLoader = ExtensionsLoader.instance((Injector)startupInjector);
        Injector injector = ServerInjectorBuilder.makeServerInjector((Injector)startupInjector, (Set)ImmutableSet.of(), (Iterable)ImmutableList.of((Object)new Module(){

            public void configure(Binder binder) {
                JsonConfigProvider.bindInstance((Binder)binder, (Key)Key.get(DruidNode.class, Self.class), (Object)new DruidNode("test-inject", null, false, null, null, true, false));
            }
        }));
        Assert.assertNotNull((Object)injector);
        Assert.assertNotNull((Object)ExtensionsLoader.instance((Injector)injector));
        Assert.assertSame((Object)extnLoader, (Object)ExtensionsLoader.instance((Injector)injector));
    }

    @Test
    public void testCreateInjectorWithNodeRoles() {
        DruidNode expected = new DruidNode("test-inject", null, false, null, null, true, false);
        Injector startupInjector = this.startupInjector();
        Injector injector = ServerInjectorBuilder.makeServerInjector((Injector)startupInjector, (Set)ImmutableSet.of((Object)new NodeRole("role1"), (Object)new NodeRole("role2")), (Iterable)ImmutableList.of(binder -> JsonConfigProvider.bindInstance((Binder)binder, (Key)Key.get(DruidNode.class, Self.class), (Object)expected)));
        Assert.assertNotNull((Object)injector);
        Assert.assertEquals((Object)expected, (Object)injector.getInstance(Key.get(DruidNode.class, Self.class)));
    }

    @Test
    public void testCreateInjectorWithEmptyNodeRolesAndRoleInjection() {
        DruidNode expected = new DruidNode("test-inject", null, false, null, null, true, false);
        Injector startupInjector = this.startupInjector();
        Injector injector = ServerInjectorBuilder.makeServerInjector((Injector)startupInjector, (Set)ImmutableSet.of(), (Iterable)ImmutableList.of((Object)new DruidModule(){

            @Inject
            public void setNodeRoles(@Self Set<NodeRole> nodeRoles) {
                Assert.assertTrue((boolean)nodeRoles.isEmpty());
            }

            public void configure(Binder binder) {
            }
        }, binder -> JsonConfigProvider.bindInstance((Binder)binder, (Key)Key.get(DruidNode.class, Self.class), (Object)expected)));
        Assert.assertNotNull((Object)injector);
    }

    @Test
    public void testCreateInjectorWithNodeRoleFilter_moduleNotLoaded() {
        DruidNode expected = new DruidNode("test-inject", null, false, null, null, true, false);
        Injector startupInjector = this.startupInjector();
        Injector injector = ServerInjectorBuilder.makeServerInjector((Injector)startupInjector, (Set)ImmutableSet.of((Object)new NodeRole("role1"), (Object)new NodeRole("role2")), (Iterable)ImmutableList.of(binder -> JsonConfigProvider.bindInstance((Binder)binder, (Key)Key.get(DruidNode.class, Self.class), (Object)expected), (Object)new LoadOnAnnotationTestModule()));
        Assert.assertNotNull((Object)injector);
        Assert.assertEquals((Object)expected, (Object)injector.getInstance(Key.get(DruidNode.class, Self.class)));
        Assert.assertThrows((String)"Guice configuration errors", ConfigurationException.class, () -> injector.getInstance(Key.get(String.class, (Annotation)Names.named((String)"emperor"))));
    }

    @Test
    public void testCreateInjectorWithNodeRoleFilterUsingAnnotation_moduleLoaded() {
        DruidNode expected = new DruidNode("test-inject", null, false, null, null, true, false);
        Injector startupInjector = this.startupInjector();
        Injector injector = ServerInjectorBuilder.makeServerInjector((Injector)startupInjector, (Set)ImmutableSet.of((Object)new NodeRole("role1"), (Object)new NodeRole("druid")), (Iterable)ImmutableList.of(binder -> JsonConfigProvider.bindInstance((Binder)binder, (Key)Key.get(DruidNode.class, Self.class), (Object)expected), (Object)new LoadOnAnnotationTestModule()));
        Assert.assertNotNull((Object)injector);
        Assert.assertEquals((Object)expected, (Object)injector.getInstance(Key.get(DruidNode.class, Self.class)));
        Assert.assertEquals((Object)"I am Druid", (Object)injector.getInstance(Key.get(String.class, (Annotation)Names.named((String)"emperor"))));
    }

    @Test
    public void testCreateInjectorWithNodeRoleFilterUsingInject_moduleNotLoaded() {
        ImmutableSet nodeRoles = ImmutableSet.of((Object)new NodeRole("role1"), (Object)new NodeRole("role2"));
        DruidNode expected = new DruidNode("test-inject", null, false, null, null, true, false);
        Injector startupInjector = this.startupInjector();
        Injector injector = ServerInjectorBuilder.makeServerInjector((Injector)startupInjector, (Set)nodeRoles, (Iterable)ImmutableList.of(binder -> JsonConfigProvider.bindInstance((Binder)binder, (Key)Key.get(DruidNode.class, Self.class), (Object)expected), (Object)new NodeRolesInjectTestModule()));
        Assert.assertNotNull((Object)injector);
        Assert.assertEquals((Object)expected, (Object)injector.getInstance(Key.get(DruidNode.class, Self.class)));
        Assert.assertThrows((String)"Guice configuration errors", ConfigurationException.class, () -> injector.getInstance(Key.get(String.class, (Annotation)Names.named((String)"emperor"))));
    }

    @Test
    public void testCreateInjectorWithNodeRoleFilterUsingInject_moduleLoaded() {
        ImmutableSet nodeRoles = ImmutableSet.of((Object)new NodeRole("role1"), (Object)new NodeRole("druid"));
        DruidNode expected = new DruidNode("test-inject", null, false, null, null, true, false);
        Injector startupInjector = this.startupInjector();
        Injector injector = ServerInjectorBuilder.makeServerInjector((Injector)startupInjector, (Set)nodeRoles, (Iterable)ImmutableList.of(binder -> JsonConfigProvider.bindInstance((Binder)binder, (Key)Key.get(DruidNode.class, Self.class), (Object)expected), (Object)new NodeRolesInjectTestModule()));
        Assert.assertNotNull((Object)injector);
        Assert.assertEquals((Object)expected, (Object)injector.getInstance(Key.get(DruidNode.class, Self.class)));
        Assert.assertEquals((Object)"I am Druid", (Object)injector.getInstance(Key.get(String.class, (Annotation)Names.named((String)"emperor"))));
    }

    private static class NodeRolesInjectTestModule
    implements Module {
        private Set<NodeRole> nodeRoles;

        private NodeRolesInjectTestModule() {
        }

        @Inject
        public void init(@Self Set<NodeRole> nodeRoles) {
            this.nodeRoles = nodeRoles;
        }

        public void configure(Binder binder) {
            if (this.nodeRoles.contains(new NodeRole("emperor")) || this.nodeRoles.contains(new NodeRole("druid"))) {
                binder.bind(String.class).annotatedWith((Annotation)Names.named((String)"emperor")).toInstance((Object)"I am Druid");
            }
        }
    }

    @LoadScope(roles={"emperor", "druid"})
    private static class LoadOnAnnotationTestModule
    implements Module {
        private LoadOnAnnotationTestModule() {
        }

        public void configure(Binder binder) {
            binder.bind(String.class).annotatedWith((Annotation)Names.named((String)"emperor")).toInstance((Object)"I am Druid");
        }
    }

    public static class TestDruidModule
    implements DruidModule {
        public List<? extends com.fasterxml.jackson.databind.Module> getJacksonModules() {
            return ImmutableList.of();
        }

        public void configure(Binder binder) {
        }
    }
}

