/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.metadata;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.hash.Hashing;
import com.google.common.io.BaseEncoding;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.druid.data.input.StringTuple;
import org.apache.druid.indexing.overlord.DataSourceMetadata;
import org.apache.druid.indexing.overlord.ObjectMetadata;
import org.apache.druid.indexing.overlord.SegmentCreateRequest;
import org.apache.druid.indexing.overlord.SegmentPublishResult;
import org.apache.druid.indexing.overlord.Segments;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.jackson.JacksonUtils;
import org.apache.druid.java.util.common.parsers.CloseableIterator;
import org.apache.druid.metadata.IndexerSQLMetadataStorageCoordinator;
import org.apache.druid.metadata.MetadataStorageTablesConfig;
import org.apache.druid.metadata.ReplaceTaskLock;
import org.apache.druid.metadata.SQLMetadataConnector;
import org.apache.druid.metadata.SortOrder;
import org.apache.druid.metadata.SqlSegmentsMetadataQuery;
import org.apache.druid.metadata.TestDerbyConnector;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.segment.realtime.appenderator.SegmentIdWithShardSpec;
import org.apache.druid.server.http.DataSegmentPlus;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.SegmentTimeline;
import org.apache.druid.timeline.TimelineObjectHolder;
import org.apache.druid.timeline.partition.DimensionRangeShardSpec;
import org.apache.druid.timeline.partition.HashBasedNumberedPartialShardSpec;
import org.apache.druid.timeline.partition.HashBasedNumberedShardSpec;
import org.apache.druid.timeline.partition.LinearShardSpec;
import org.apache.druid.timeline.partition.NoneShardSpec;
import org.apache.druid.timeline.partition.NumberedOverwritePartialShardSpec;
import org.apache.druid.timeline.partition.NumberedOverwriteShardSpec;
import org.apache.druid.timeline.partition.NumberedPartialShardSpec;
import org.apache.druid.timeline.partition.NumberedShardSpec;
import org.apache.druid.timeline.partition.PartialShardSpec;
import org.apache.druid.timeline.partition.ShardSpec;
import org.apache.druid.timeline.partition.SingleDimensionShardSpec;
import org.apache.druid.timeline.partition.TombstoneShardSpec;
import org.assertj.core.api.Assertions;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadableInterval;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.PreparedBatch;
import org.skife.jdbi.v2.PreparedBatchPart;
import org.skife.jdbi.v2.Query;
import org.skife.jdbi.v2.ResultIterator;
import org.skife.jdbi.v2.Update;
import org.skife.jdbi.v2.tweak.ResultSetMapper;
import org.skife.jdbi.v2.util.StringMapper;

public class IndexerSQLMetadataStorageCoordinatorTest {
    private static final int MAX_SQL_MEATADATA_RETRY_FOR_TEST = 2;
    @Rule
    public final TestDerbyConnector.DerbyConnectorRule derbyConnectorRule = new TestDerbyConnector.DerbyConnectorRule();
    private final ObjectMapper mapper = TestHelper.makeJsonMapper();
    private final DataSegment defaultSegment = new DataSegment("fooDataSource", Intervals.of((String)"2015-01-01T00Z/2015-01-02T00Z"), "version", (Map)ImmutableMap.of(), (List)ImmutableList.of((Object)"dim1"), (List)ImmutableList.of((Object)"m1"), (ShardSpec)new LinearShardSpec(Integer.valueOf(0)), Integer.valueOf(9), 100L);
    private final DataSegment eternitySegment = new DataSegment("fooDataSource", Intervals.ETERNITY, "version", (Map)ImmutableMap.of(), (List)ImmutableList.of((Object)"dim1"), (List)ImmutableList.of((Object)"m1"), (ShardSpec)new LinearShardSpec(Integer.valueOf(0)), Integer.valueOf(9), 100L);
    private final DataSegment firstHalfEternityRangeSegment = new DataSegment("fooDataSource", new Interval((ReadableInstant)DateTimes.MIN, (ReadableInstant)DateTimes.of((String)"3000")), "version", (Map)ImmutableMap.of(), (List)ImmutableList.of((Object)"dim1"), (List)ImmutableList.of((Object)"m1"), (ShardSpec)new LinearShardSpec(Integer.valueOf(0)), Integer.valueOf(9), 100L);
    private final DataSegment secondHalfEternityRangeSegment = new DataSegment("fooDataSource", new Interval((ReadableInstant)DateTimes.of((String)"1970"), (ReadableInstant)DateTimes.MAX), "version", (Map)ImmutableMap.of(), (List)ImmutableList.of((Object)"dim1"), (List)ImmutableList.of((Object)"m1"), (ShardSpec)new LinearShardSpec(Integer.valueOf(0)), Integer.valueOf(9), 100L);
    private final DataSegment defaultSegment2 = new DataSegment("fooDataSource", Intervals.of((String)"2015-01-01T00Z/2015-01-02T00Z"), "version", (Map)ImmutableMap.of(), (List)ImmutableList.of((Object)"dim1"), (List)ImmutableList.of((Object)"m1"), (ShardSpec)new LinearShardSpec(Integer.valueOf(1)), Integer.valueOf(9), 100L);
    private final DataSegment defaultSegment2WithBiggerSize = new DataSegment("fooDataSource", Intervals.of((String)"2015-01-01T00Z/2015-01-02T00Z"), "version", (Map)ImmutableMap.of(), (List)ImmutableList.of((Object)"dim1"), (List)ImmutableList.of((Object)"m1"), (ShardSpec)new LinearShardSpec(Integer.valueOf(1)), Integer.valueOf(9), 200L);
    private final DataSegment defaultSegment3 = new DataSegment("fooDataSource", Intervals.of((String)"2015-01-03T00Z/2015-01-04T00Z"), "version", (Map)ImmutableMap.of(), (List)ImmutableList.of((Object)"dim1"), (List)ImmutableList.of((Object)"m1"), (ShardSpec)NoneShardSpec.instance(), Integer.valueOf(9), 100L);
    private final DataSegment defaultSegment4 = new DataSegment("fooDataSource", Intervals.of((String)"2015-01-01T00Z/2015-01-02T00Z"), "zversion", (Map)ImmutableMap.of(), (List)ImmutableList.of((Object)"dim1"), (List)ImmutableList.of((Object)"m1"), (ShardSpec)new LinearShardSpec(Integer.valueOf(0)), Integer.valueOf(9), 100L);
    private final DataSegment numberedSegment0of0 = new DataSegment("fooDataSource", Intervals.of((String)"2015-01-01T00Z/2015-01-02T00Z"), "zversion", (Map)ImmutableMap.of(), (List)ImmutableList.of((Object)"dim1"), (List)ImmutableList.of((Object)"m1"), (ShardSpec)new NumberedShardSpec(0, 0), Integer.valueOf(9), 100L);
    private final DataSegment numberedSegment1of0 = new DataSegment("fooDataSource", Intervals.of((String)"2015-01-01T00Z/2015-01-02T00Z"), "zversion", (Map)ImmutableMap.of(), (List)ImmutableList.of((Object)"dim1"), (List)ImmutableList.of((Object)"m1"), (ShardSpec)new NumberedShardSpec(1, 0), Integer.valueOf(9), 100L);
    private final DataSegment numberedSegment2of0 = new DataSegment("fooDataSource", Intervals.of((String)"2015-01-01T00Z/2015-01-02T00Z"), "zversion", (Map)ImmutableMap.of(), (List)ImmutableList.of((Object)"dim1"), (List)ImmutableList.of((Object)"m1"), (ShardSpec)new NumberedShardSpec(2, 0), Integer.valueOf(9), 100L);
    private final DataSegment numberedSegment2of1 = new DataSegment("fooDataSource", Intervals.of((String)"2015-01-01T00Z/2015-01-02T00Z"), "zversion", (Map)ImmutableMap.of(), (List)ImmutableList.of((Object)"dim1"), (List)ImmutableList.of((Object)"m1"), (ShardSpec)new NumberedShardSpec(2, 1), Integer.valueOf(9), 100L);
    private final DataSegment numberedSegment3of1 = new DataSegment("fooDataSource", Intervals.of((String)"2015-01-01T00Z/2015-01-02T00Z"), "zversion", (Map)ImmutableMap.of(), (List)ImmutableList.of((Object)"dim1"), (List)ImmutableList.of((Object)"m1"), (ShardSpec)new NumberedShardSpec(3, 1), Integer.valueOf(9), 100L);
    private final DataSegment existingSegment1 = new DataSegment("fooDataSource", Intervals.of((String)"1994-01-01T00Z/1994-01-02T00Z"), "zversion", (Map)ImmutableMap.of(), (List)ImmutableList.of((Object)"dim1"), (List)ImmutableList.of((Object)"m1"), (ShardSpec)new NumberedShardSpec(1, 1), Integer.valueOf(9), 100L);
    private final DataSegment existingSegment2 = new DataSegment("fooDataSource", Intervals.of((String)"1994-01-02T00Z/1994-01-03T00Z"), "zversion", (Map)ImmutableMap.of(), (List)ImmutableList.of((Object)"dim1"), (List)ImmutableList.of((Object)"m1"), (ShardSpec)new NumberedShardSpec(1, 1), Integer.valueOf(9), 100L);
    private final DataSegment hugeTimeRangeSegment1 = new DataSegment("hugeTimeRangeDataSource", Intervals.of((String)"-9994-01-02T00Z/1994-01-03T00Z"), "zversion", (Map)ImmutableMap.of(), (List)ImmutableList.of((Object)"dim1"), (List)ImmutableList.of((Object)"m1"), (ShardSpec)new NumberedShardSpec(0, 1), Integer.valueOf(9), 100L);
    private final DataSegment hugeTimeRangeSegment2 = new DataSegment("hugeTimeRangeDataSource", Intervals.of((String)"2994-01-02T00Z/2994-01-03T00Z"), "zversion", (Map)ImmutableMap.of(), (List)ImmutableList.of((Object)"dim1"), (List)ImmutableList.of((Object)"m1"), (ShardSpec)new NumberedShardSpec(0, 1), Integer.valueOf(9), 100L);
    private final DataSegment hugeTimeRangeSegment3 = new DataSegment("hugeTimeRangeDataSource", Intervals.of((String)"29940-01-02T00Z/29940-01-03T00Z"), "zversion", (Map)ImmutableMap.of(), (List)ImmutableList.of((Object)"dim1"), (List)ImmutableList.of((Object)"m1"), (ShardSpec)new NumberedShardSpec(0, 1), Integer.valueOf(9), 100L);
    private final DataSegment hugeTimeRangeSegment4 = new DataSegment("hugeTimeRangeDataSource", Intervals.of((String)"1990-01-01T00Z/19940-01-01T00Z"), "zversion", (Map)ImmutableMap.of(), (List)ImmutableList.of((Object)"dim1"), (List)ImmutableList.of((Object)"m1"), (ShardSpec)new NumberedShardSpec(0, 1), Integer.valueOf(9), 100L);
    private final Set<DataSegment> SEGMENTS = ImmutableSet.of((Object)this.defaultSegment, (Object)this.defaultSegment2);
    private final AtomicLong metadataUpdateCounter = new AtomicLong();
    private final AtomicLong segmentTableDropUpdateCounter = new AtomicLong();
    private IndexerSQLMetadataStorageCoordinator coordinator;
    private TestDerbyConnector derbyConnector;

    @Before
    public void setUp() {
        this.derbyConnector = this.derbyConnectorRule.getConnector();
        this.mapper.registerSubtypes(new Class[]{LinearShardSpec.class, NumberedShardSpec.class, HashBasedNumberedShardSpec.class});
        this.derbyConnector.createDataSourceTable();
        this.derbyConnector.createTaskTables();
        this.derbyConnector.createSegmentTable();
        this.derbyConnector.createUpgradeSegmentsTable();
        this.derbyConnector.createPendingSegmentsTable();
        this.metadataUpdateCounter.set(0L);
        this.segmentTableDropUpdateCounter.set(0L);
        this.coordinator = new IndexerSQLMetadataStorageCoordinator(this.mapper, (MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get(), (SQLMetadataConnector)this.derbyConnector){

            protected IndexerSQLMetadataStorageCoordinator.DataStoreMetadataUpdateResult updateDataSourceMetadataWithHandle(Handle handle, String dataSource, DataSourceMetadata startMetadata, DataSourceMetadata endMetadata) throws IOException {
                IndexerSQLMetadataStorageCoordinatorTest.this.metadataUpdateCounter.getAndIncrement();
                return super.updateDataSourceMetadataWithHandle(handle, dataSource, startMetadata, endMetadata);
            }

            public int getSqlMetadataMaxRetry() {
                return 2;
            }
        };
    }

    private void markAllSegmentsUnused() {
        this.markAllSegmentsUnused(this.SEGMENTS, DateTimes.nowUtc());
    }

    private void markAllSegmentsUnused(Set<DataSegment> segments, DateTime usedStatusLastUpdatedTime) {
        for (DataSegment segment : segments) {
            Assert.assertEquals((long)1L, (long)((Integer)this.derbyConnector.getDBI().withHandle(handle -> {
                String request = StringUtils.format((String)"UPDATE %s SET used = false, used_status_last_updated = :used_status_last_updated WHERE id = :id", (Object[])new Object[]{((MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get()).getSegmentsTable()});
                return ((Update)((Update)handle.createStatement(request).bind("id", segment.getId().toString())).bind("used_status_last_updated", usedStatusLastUpdatedTime.toString())).execute();
            })).intValue());
        }
    }

    private List<String> retrievePendingSegmentIds() {
        String table = ((MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get()).getPendingSegmentsTable();
        return (List)this.derbyConnector.retryWithHandle(handle -> handle.createQuery("SELECT id FROM " + table + "  ORDER BY id").map((ResultSetMapper)StringMapper.FIRST).list());
    }

    private List<String> retrieveUsedSegmentIds() {
        String table = ((MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get()).getSegmentsTable();
        return (List)this.derbyConnector.retryWithHandle(handle -> handle.createQuery("SELECT id FROM " + table + " WHERE used = true ORDER BY id").map((ResultSetMapper)StringMapper.FIRST).list());
    }

    private List<DataSegment> retrieveUsedSegments() {
        String table = ((MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get()).getSegmentsTable();
        return (List)this.derbyConnector.retryWithHandle(handle -> handle.createQuery("SELECT payload FROM " + table + " WHERE used = true ORDER BY id").map((index, result, context) -> (DataSegment)JacksonUtils.readValue((ObjectMapper)this.mapper, (byte[])result.getBytes(1), DataSegment.class)).list());
    }

    private List<String> retrieveUnusedSegmentIds() {
        String table = ((MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get()).getSegmentsTable();
        return (List)this.derbyConnector.retryWithHandle(handle -> handle.createQuery("SELECT id FROM " + table + " WHERE used = false ORDER BY id").map((ResultSetMapper)StringMapper.FIRST).list());
    }

    private Boolean insertUsedSegments(Set<DataSegment> dataSegments) {
        String table = ((MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get()).getSegmentsTable();
        return (Boolean)this.derbyConnector.retryWithHandle(handle -> {
            PreparedBatch preparedBatch = handle.prepareBatch(StringUtils.format((String)"INSERT INTO %1$s (id, dataSource, created_date, start, %2$send%2$s, partitioned, version, used, payload, used_status_last_updated) VALUES (:id, :dataSource, :created_date, :start, :end, :partitioned, :version, :used, :payload, :used_status_last_updated)", (Object[])new Object[]{table, this.derbyConnector.getQuoteString()}));
            for (DataSegment segment : dataSegments) {
                ((PreparedBatchPart)((PreparedBatchPart)((PreparedBatchPart)((PreparedBatchPart)((PreparedBatchPart)((PreparedBatchPart)((PreparedBatchPart)((PreparedBatchPart)((PreparedBatchPart)preparedBatch.add().bind("id", segment.getId().toString())).bind("dataSource", segment.getDataSource())).bind("created_date", DateTimes.nowUtc().toString())).bind("start", segment.getInterval().getStart().toString())).bind("end", segment.getInterval().getEnd().toString())).bind("partitioned", !(segment.getShardSpec() instanceof NoneShardSpec))).bind("version", segment.getVersion())).bind("used", true)).bind("payload", this.mapper.writeValueAsBytes((Object)segment))).bind("used_status_last_updated", DateTimes.nowUtc().toString());
            }
            int[] affectedRows = preparedBatch.execute();
            boolean succeeded = Arrays.stream(affectedRows).allMatch(eachAffectedRows -> eachAffectedRows == 1);
            if (!succeeded) {
                throw new ISE("Failed to publish segments to DB", new Object[0]);
            }
            return true;
        });
    }

    private Boolean insertPendingSegmentAndSequenceName(Pair<SegmentIdWithShardSpec, String> pendingSegmentSequenceName) {
        SegmentIdWithShardSpec pendingSegment = (SegmentIdWithShardSpec)pendingSegmentSequenceName.lhs;
        String sequenceName = (String)pendingSegmentSequenceName.rhs;
        String table = ((MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get()).getPendingSegmentsTable();
        return (Boolean)this.derbyConnector.retryWithHandle(handle -> {
            ((Update)((Update)((Update)((Update)((Update)((Update)((Update)((Update)((Update)handle.createStatement(StringUtils.format((String)"INSERT INTO %1$s (id, dataSource, created_date, start, %2$send%2$s, sequence_name, sequence_prev_id, sequence_name_prev_id_sha1, payload) VALUES (:id, :dataSource, :created_date, :start, :end, :sequence_name, :sequence_prev_id, :sequence_name_prev_id_sha1, :payload)", (Object[])new Object[]{table, this.derbyConnector.getQuoteString()})).bind("id", pendingSegment.toString())).bind("dataSource", pendingSegment.getDataSource())).bind("created_date", DateTimes.nowUtc().toString())).bind("start", pendingSegment.getInterval().getStart().toString())).bind("end", pendingSegment.getInterval().getEnd().toString())).bind("sequence_name", sequenceName)).bind("sequence_prev_id", pendingSegment.toString())).bind("sequence_name_prev_id_sha1", BaseEncoding.base16().encode(Hashing.sha1().newHasher().putLong((long)pendingSegment.hashCode() * (long)sequenceName.hashCode()).hash().asBytes()))).bind("payload", this.mapper.writeValueAsBytes((Object)pendingSegment))).execute();
            return true;
        });
    }

    private Map<String, String> getSegmentsCommittedDuringReplaceTask(String taskId) {
        String table = ((MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get()).getUpgradeSegmentsTable();
        return (Map)this.derbyConnector.retryWithHandle(handle -> {
            String sql = StringUtils.format((String)"SELECT segment_id, lock_version FROM %1$s WHERE task_id = :task_id", (Object[])new Object[]{table});
            ResultIterator resultIterator = ((Query)handle.createQuery(sql).bind("task_id", taskId)).map((index, r, ctx) -> Pair.of((Object)r.getString("segment_id"), (Object)r.getString("lock_version"))).iterator();
            HashMap<String, String> segmentIdToLockVersion = new HashMap<String, String>();
            while (resultIterator.hasNext()) {
                Pair result = (Pair)resultIterator.next();
                segmentIdToLockVersion.put((String)result.lhs, (String)result.rhs);
            }
            return segmentIdToLockVersion;
        });
    }

    private void insertIntoUpgradeSegmentsTable(Map<DataSegment, ReplaceTaskLock> segmentToTaskLockMap) {
        String table = ((MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get()).getUpgradeSegmentsTable();
        this.derbyConnector.retryWithHandle(handle -> {
            PreparedBatch preparedBatch = handle.prepareBatch(StringUtils.format((String)StringUtils.format((String)"INSERT INTO %1$s (task_id, segment_id, lock_version) VALUES (:task_id, :segment_id, :lock_version)", (Object[])new Object[]{table}), (Object[])new Object[0]));
            for (Map.Entry entry : segmentToTaskLockMap.entrySet()) {
                DataSegment segment = (DataSegment)entry.getKey();
                ReplaceTaskLock lock = (ReplaceTaskLock)entry.getValue();
                ((PreparedBatchPart)((PreparedBatchPart)preparedBatch.add().bind("task_id", lock.getSupervisorTaskId())).bind("segment_id", segment.getId().toString())).bind("lock_version", lock.getVersion());
            }
            int[] affectedRows = preparedBatch.execute();
            boolean succeeded = Arrays.stream(affectedRows).allMatch(eachAffectedRows -> eachAffectedRows == 1);
            if (!succeeded) {
                throw new ISE("Failed to insert upgrade segments in DB", new Object[0]);
            }
            return true;
        });
    }

    @Test
    public void testCommitAppendSegments() {
        DataSegment segment;
        int i;
        String v1 = "2023-01-01";
        String v2 = "2023-01-02";
        String v3 = "2023-01-03";
        String lockVersion = "2024-01-01";
        String replaceTaskId = "replaceTask1";
        ReplaceTaskLock replaceLock = new ReplaceTaskLock("replaceTask1", Intervals.of((String)"2023-01-01/2023-01-03"), "2024-01-01");
        HashSet<DataSegment> appendSegments = new HashSet<DataSegment>();
        HashSet<DataSegment> expectedSegmentsToUpgrade = new HashSet<DataSegment>();
        for (i = 0; i < 10; ++i) {
            segment = this.createSegment(Intervals.of((String)"2023-01-01/2023-01-02"), "2023-01-01", (ShardSpec)new LinearShardSpec(Integer.valueOf(i)));
            appendSegments.add(segment);
            expectedSegmentsToUpgrade.add(segment);
        }
        for (i = 0; i < 10; ++i) {
            segment = this.createSegment(Intervals.of((String)"2023-01-02/2023-01-03"), "2023-01-02", (ShardSpec)new LinearShardSpec(Integer.valueOf(i)));
            appendSegments.add(segment);
            expectedSegmentsToUpgrade.add(segment);
        }
        for (i = 0; i < 10; ++i) {
            segment = this.createSegment(Intervals.of((String)"2023-01-03/2023-01-04"), "2023-01-03", (ShardSpec)new LinearShardSpec(Integer.valueOf(i)));
            appendSegments.add(segment);
        }
        Map<DataSegment, ReplaceTaskLock> segmentToReplaceLock = expectedSegmentsToUpgrade.stream().collect(Collectors.toMap(s -> s, s -> replaceLock));
        SegmentPublishResult commitResult = this.coordinator.commitAppendSegments(appendSegments, segmentToReplaceLock);
        Assert.assertTrue((boolean)commitResult.isSuccess());
        Assert.assertEquals(appendSegments, (Object)commitResult.getSegments());
        Assert.assertEquals(appendSegments, (Object)ImmutableSet.copyOf(this.retrieveUsedSegments()));
        Set expectedUpgradeSegmentIds = expectedSegmentsToUpgrade.stream().map(s -> s.getId().toString()).collect(Collectors.toSet());
        Map<String, String> observedSegmentToLock = this.getSegmentsCommittedDuringReplaceTask("replaceTask1");
        Assert.assertEquals(expectedUpgradeSegmentIds, observedSegmentToLock.keySet());
        HashSet<String> observedLockVersions = new HashSet<String>(observedSegmentToLock.values());
        Assert.assertEquals((long)1L, (long)observedLockVersions.size());
        Assert.assertEquals((Object)replaceLock.getVersion(), (Object)Iterables.getOnlyElement(observedLockVersions));
    }

    @Test
    public void testCommitReplaceSegments() {
        ReplaceTaskLock replaceLock = new ReplaceTaskLock("g1", Intervals.of((String)"2023-01-01/2023-02-01"), "2023-02-01");
        HashSet<DataSegment> segmentsAppendedWithReplaceLock = new HashSet<DataSegment>();
        HashMap<DataSegment, ReplaceTaskLock> appendedSegmentToReplaceLockMap = new HashMap<DataSegment, ReplaceTaskLock>();
        for (int i = 1; i < 9; ++i) {
            DataSegment segment = new DataSegment("foo", Intervals.of((String)("2023-01-0" + i + "/2023-01-0" + (i + 1))), "2023-01-0" + i, (Map)ImmutableMap.of((Object)"path", (Object)("a-" + i)), (List)ImmutableList.of((Object)"dim1"), (List)ImmutableList.of((Object)"m1"), (ShardSpec)new LinearShardSpec(Integer.valueOf(0)), Integer.valueOf(9), 100L);
            segmentsAppendedWithReplaceLock.add(segment);
            appendedSegmentToReplaceLockMap.put(segment, replaceLock);
        }
        this.insertUsedSegments(segmentsAppendedWithReplaceLock);
        this.insertIntoUpgradeSegmentsTable(appendedSegmentToReplaceLockMap);
        HashSet<DataSegment> replacingSegments = new HashSet<DataSegment>();
        for (int i = 1; i < 9; ++i) {
            DataSegment segment = new DataSegment("foo", Intervals.of((String)"2023-01-01/2023-02-01"), "2023-02-01", (Map)ImmutableMap.of((Object)"path", (Object)("b-" + i)), (List)ImmutableList.of((Object)"dim1"), (List)ImmutableList.of((Object)"m1"), (ShardSpec)new NumberedShardSpec(i, 9), Integer.valueOf(9), 100L);
            replacingSegments.add(segment);
        }
        this.coordinator.commitReplaceSegments(replacingSegments, (Set)ImmutableSet.of((Object)replaceLock));
        Assert.assertEquals((long)(2L * (long)segmentsAppendedWithReplaceLock.size() + (long)replacingSegments.size()), (long)this.retrieveUsedSegmentIds().size());
        HashSet<DataSegment> usedSegments = new HashSet<DataSegment>(this.retrieveUsedSegments());
        Assert.assertTrue((boolean)usedSegments.containsAll(segmentsAppendedWithReplaceLock));
        usedSegments.removeAll(segmentsAppendedWithReplaceLock);
        Assert.assertTrue((boolean)usedSegments.containsAll(replacingSegments));
        usedSegments.removeAll(replacingSegments);
        Assert.assertEquals((long)segmentsAppendedWithReplaceLock.size(), (long)usedSegments.size());
        for (DataSegment segmentReplicaWithNewVersion : usedSegments) {
            boolean hasBeenCarriedForward = false;
            for (DataSegment appendedSegment : segmentsAppendedWithReplaceLock) {
                if (!appendedSegment.getLoadSpec().equals(segmentReplicaWithNewVersion.getLoadSpec())) continue;
                hasBeenCarriedForward = true;
                break;
            }
            Assert.assertTrue((boolean)hasBeenCarriedForward);
        }
    }

    @Test
    public void testSimpleAnnounce() throws IOException {
        this.coordinator.commitSegments(this.SEGMENTS);
        for (DataSegment segment : this.SEGMENTS) {
            Assert.assertArrayEquals((byte[])this.mapper.writeValueAsString((Object)segment).getBytes(StandardCharsets.UTF_8), (byte[])this.derbyConnector.lookup(((MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get()).getSegmentsTable(), "id", "payload", segment.getId().toString()));
        }
        Assert.assertEquals((Object)ImmutableList.of((Object)this.defaultSegment.getId().toString(), (Object)this.defaultSegment2.getId().toString()), this.retrieveUsedSegmentIds());
        Assert.assertEquals((long)0L, (long)this.metadataUpdateCounter.get());
    }

    @Test
    public void testAnnounceHistoricalSegments() throws IOException {
        HashSet<DataSegment> segments = new HashSet<DataSegment>();
        for (int i = 0; i < 105; ++i) {
            segments.add(new DataSegment("fooDataSource", Intervals.of((String)"2015-01-01T00Z/2015-01-02T00Z"), "version", (Map)ImmutableMap.of(), (List)ImmutableList.of((Object)"dim1"), (List)ImmutableList.of((Object)"m1"), (ShardSpec)new LinearShardSpec(Integer.valueOf(i)), Integer.valueOf(9), 100L));
        }
        this.coordinator.commitSegments(segments);
        for (DataSegment segment2 : segments) {
            Assert.assertArrayEquals((byte[])this.mapper.writeValueAsString((Object)segment2).getBytes(StandardCharsets.UTF_8), (byte[])this.derbyConnector.lookup(((MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get()).getSegmentsTable(), "id", "payload", segment2.getId().toString()));
        }
        List segmentIds = segments.stream().map(segment -> segment.getId().toString()).sorted(Comparator.naturalOrder()).collect(Collectors.toList());
        Assert.assertEquals(segmentIds, this.retrieveUsedSegmentIds());
        Assert.assertEquals((long)0L, (long)this.metadataUpdateCounter.get());
    }

    @Test
    public void testOvershadowingAnnounce() throws IOException {
        ImmutableSet segments = ImmutableSet.of((Object)this.defaultSegment, (Object)this.defaultSegment2, (Object)this.defaultSegment4);
        this.coordinator.commitSegments((Set)segments);
        for (DataSegment segment : segments) {
            Assert.assertArrayEquals((byte[])this.mapper.writeValueAsString((Object)segment).getBytes(StandardCharsets.UTF_8), (byte[])this.derbyConnector.lookup(((MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get()).getSegmentsTable(), "id", "payload", segment.getId().toString()));
        }
        Assert.assertEquals((Object)ImmutableList.of((Object)this.defaultSegment4.getId().toString()), this.retrieveUsedSegmentIds());
    }

    @Test
    public void testTransactionalAnnounceSuccess() throws IOException {
        SegmentPublishResult result1 = this.coordinator.commitSegmentsAndMetadata((Set)ImmutableSet.of((Object)this.defaultSegment), (DataSourceMetadata)new ObjectMetadata(null), (DataSourceMetadata)new ObjectMetadata((Object)ImmutableMap.of((Object)"foo", (Object)"bar")));
        Assert.assertEquals((Object)SegmentPublishResult.ok((Set)ImmutableSet.of((Object)this.defaultSegment)), (Object)result1);
        Assert.assertArrayEquals((byte[])this.mapper.writeValueAsString((Object)this.defaultSegment).getBytes(StandardCharsets.UTF_8), (byte[])this.derbyConnector.lookup(((MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get()).getSegmentsTable(), "id", "payload", this.defaultSegment.getId().toString()));
        SegmentPublishResult result2 = this.coordinator.commitSegmentsAndMetadata((Set)ImmutableSet.of((Object)this.defaultSegment2), (DataSourceMetadata)new ObjectMetadata((Object)ImmutableMap.of((Object)"foo", (Object)"bar")), (DataSourceMetadata)new ObjectMetadata((Object)ImmutableMap.of((Object)"foo", (Object)"baz")));
        Assert.assertEquals((Object)SegmentPublishResult.ok((Set)ImmutableSet.of((Object)this.defaultSegment2)), (Object)result2);
        Assert.assertArrayEquals((byte[])this.mapper.writeValueAsString((Object)this.defaultSegment2).getBytes(StandardCharsets.UTF_8), (byte[])this.derbyConnector.lookup(((MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get()).getSegmentsTable(), "id", "payload", this.defaultSegment2.getId().toString()));
        Assert.assertEquals((Object)new ObjectMetadata((Object)ImmutableMap.of((Object)"foo", (Object)"baz")), (Object)this.coordinator.retrieveDataSourceMetadata("fooDataSource"));
        Assert.assertEquals((long)2L, (long)this.metadataUpdateCounter.get());
    }

    @Test
    public void testTransactionalAnnounceRetryAndSuccess() throws IOException {
        final AtomicLong attemptCounter = new AtomicLong();
        IndexerSQLMetadataStorageCoordinator failOnceCoordinator = new IndexerSQLMetadataStorageCoordinator(this.mapper, (MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get(), (SQLMetadataConnector)this.derbyConnector){

            protected IndexerSQLMetadataStorageCoordinator.DataStoreMetadataUpdateResult updateDataSourceMetadataWithHandle(Handle handle, String dataSource, DataSourceMetadata startMetadata, DataSourceMetadata endMetadata) throws IOException {
                IndexerSQLMetadataStorageCoordinatorTest.this.metadataUpdateCounter.getAndIncrement();
                if (attemptCounter.getAndIncrement() == 0L) {
                    return new IndexerSQLMetadataStorageCoordinator.DataStoreMetadataUpdateResult(true, true, null, new Object[0]);
                }
                return super.updateDataSourceMetadataWithHandle(handle, dataSource, startMetadata, endMetadata);
            }
        };
        SegmentPublishResult result1 = failOnceCoordinator.commitSegmentsAndMetadata((Set)ImmutableSet.of((Object)this.defaultSegment), (DataSourceMetadata)new ObjectMetadata(null), (DataSourceMetadata)new ObjectMetadata((Object)ImmutableMap.of((Object)"foo", (Object)"bar")));
        Assert.assertEquals((Object)SegmentPublishResult.ok((Set)ImmutableSet.of((Object)this.defaultSegment)), (Object)result1);
        Assert.assertArrayEquals((byte[])this.mapper.writeValueAsString((Object)this.defaultSegment).getBytes(StandardCharsets.UTF_8), (byte[])this.derbyConnector.lookup(((MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get()).getSegmentsTable(), "id", "payload", this.defaultSegment.getId().toString()));
        attemptCounter.set(0L);
        SegmentPublishResult result2 = failOnceCoordinator.commitSegmentsAndMetadata((Set)ImmutableSet.of((Object)this.defaultSegment2), (DataSourceMetadata)new ObjectMetadata((Object)ImmutableMap.of((Object)"foo", (Object)"bar")), (DataSourceMetadata)new ObjectMetadata((Object)ImmutableMap.of((Object)"foo", (Object)"baz")));
        Assert.assertEquals((Object)SegmentPublishResult.ok((Set)ImmutableSet.of((Object)this.defaultSegment2)), (Object)result2);
        Assert.assertArrayEquals((byte[])this.mapper.writeValueAsString((Object)this.defaultSegment2).getBytes(StandardCharsets.UTF_8), (byte[])this.derbyConnector.lookup(((MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get()).getSegmentsTable(), "id", "payload", this.defaultSegment2.getId().toString()));
        Assert.assertEquals((Object)new ObjectMetadata((Object)ImmutableMap.of((Object)"foo", (Object)"baz")), (Object)failOnceCoordinator.retrieveDataSourceMetadata("fooDataSource"));
        Assert.assertEquals((long)4L, (long)this.metadataUpdateCounter.get());
    }

    @Test
    public void testTransactionalAnnounceFailDbNullWantNotNull() throws IOException {
        SegmentPublishResult result1 = this.coordinator.commitSegmentsAndMetadata((Set)ImmutableSet.of((Object)this.defaultSegment), (DataSourceMetadata)new ObjectMetadata((Object)ImmutableMap.of((Object)"foo", (Object)"bar")), (DataSourceMetadata)new ObjectMetadata((Object)ImmutableMap.of((Object)"foo", (Object)"baz")));
        Assert.assertEquals((Object)SegmentPublishResult.fail((String)"java.lang.RuntimeException: Failed to update the metadata Store. The new start metadata is ahead of last commited end state."), (Object)result1);
        Assert.assertEquals((long)1L, (long)this.metadataUpdateCounter.get());
    }

    @Test
    public void testTransactionalAnnounceFailDbNotNullWantNull() throws IOException {
        SegmentPublishResult result1 = this.coordinator.commitSegmentsAndMetadata((Set)ImmutableSet.of((Object)this.defaultSegment), (DataSourceMetadata)new ObjectMetadata(null), (DataSourceMetadata)new ObjectMetadata((Object)ImmutableMap.of((Object)"foo", (Object)"baz")));
        Assert.assertEquals((Object)SegmentPublishResult.ok((Set)ImmutableSet.of((Object)this.defaultSegment)), (Object)result1);
        SegmentPublishResult result2 = this.coordinator.commitSegmentsAndMetadata((Set)ImmutableSet.of((Object)this.defaultSegment2), (DataSourceMetadata)new ObjectMetadata(null), (DataSourceMetadata)new ObjectMetadata((Object)ImmutableMap.of((Object)"foo", (Object)"baz")));
        Assert.assertEquals((Object)SegmentPublishResult.fail((String)"java.lang.RuntimeException: Inconsistent metadata state. This can happen if you update input topic in a spec without changing the supervisor name. Stored state: [ObjectMetadata{theObject={foo=baz}}], Target state: [ObjectMetadata{theObject=null}]."), (Object)result2);
        Assert.assertEquals((long)2L, (long)this.metadataUpdateCounter.get());
    }

    @Test
    public void testRetrieveUsedSegmentForId() {
        this.insertUsedSegments((Set<DataSegment>)ImmutableSet.of((Object)this.defaultSegment));
        Assert.assertEquals((Object)this.defaultSegment, (Object)this.coordinator.retrieveSegmentForId(this.defaultSegment.getId().toString(), false));
    }

    @Test
    public void testRetrieveSegmentForId() {
        this.insertUsedSegments((Set<DataSegment>)ImmutableSet.of((Object)this.defaultSegment));
        this.markAllSegmentsUnused((Set<DataSegment>)ImmutableSet.of((Object)this.defaultSegment), DateTimes.nowUtc());
        Assert.assertEquals((Object)this.defaultSegment, (Object)this.coordinator.retrieveSegmentForId(this.defaultSegment.getId().toString(), true));
    }

    @Test
    public void testCleanUpgradeSegmentsTableForTask() {
        String taskToClean = "taskToClean";
        ReplaceTaskLock replaceLockToClean = new ReplaceTaskLock("taskToClean", Intervals.of((String)"2023-01-01/2023-02-01"), "2023-03-01");
        DataSegment segmentToClean0 = this.createSegment(Intervals.of((String)"2023-01-01/2023-02-01"), "2023-02-01", (ShardSpec)new NumberedShardSpec(0, 0));
        DataSegment segmentToClean1 = this.createSegment(Intervals.of((String)"2023-01-01/2023-01-02"), "2023-01-02", (ShardSpec)new NumberedShardSpec(0, 0));
        this.insertIntoUpgradeSegmentsTable((Map<DataSegment, ReplaceTaskLock>)ImmutableMap.of((Object)segmentToClean0, (Object)replaceLockToClean, (Object)segmentToClean1, (Object)replaceLockToClean));
        Assert.assertEquals((long)0L, (long)this.coordinator.deleteUpgradeSegmentsForTask("someRandomTask"));
        Assert.assertEquals((long)2L, (long)this.coordinator.deleteUpgradeSegmentsForTask("taskToClean"));
        Assert.assertEquals((long)0L, (long)this.coordinator.deleteUpgradeSegmentsForTask("taskToClean"));
    }

    @Test
    public void testTransactionalAnnounceFailDbNotNullWantDifferent() throws IOException {
        SegmentPublishResult result1 = this.coordinator.commitSegmentsAndMetadata((Set)ImmutableSet.of((Object)this.defaultSegment), (DataSourceMetadata)new ObjectMetadata(null), (DataSourceMetadata)new ObjectMetadata((Object)ImmutableMap.of((Object)"foo", (Object)"baz")));
        Assert.assertEquals((Object)SegmentPublishResult.ok((Set)ImmutableSet.of((Object)this.defaultSegment)), (Object)result1);
        SegmentPublishResult result2 = this.coordinator.commitSegmentsAndMetadata((Set)ImmutableSet.of((Object)this.defaultSegment2), (DataSourceMetadata)new ObjectMetadata((Object)ImmutableMap.of((Object)"foo", (Object)"qux")), (DataSourceMetadata)new ObjectMetadata((Object)ImmutableMap.of((Object)"foo", (Object)"baz")));
        Assert.assertEquals((Object)SegmentPublishResult.fail((String)"java.lang.RuntimeException: Inconsistent metadata state. This can happen if you update input topic in a spec without changing the supervisor name. Stored state: [ObjectMetadata{theObject={foo=baz}}], Target state: [ObjectMetadata{theObject={foo=qux}}]."), (Object)result2);
        Assert.assertEquals((long)2L, (long)this.metadataUpdateCounter.get());
    }

    @Test
    public void testSimpleUsedList() throws IOException {
        this.coordinator.commitSegments(this.SEGMENTS);
        Assert.assertEquals(this.SEGMENTS, (Object)ImmutableSet.copyOf((Collection)this.coordinator.retrieveUsedSegmentsForInterval(this.defaultSegment.getDataSource(), this.defaultSegment.getInterval(), Segments.ONLY_VISIBLE)));
    }

    @Test
    public void testMultiIntervalUsedList() throws IOException {
        this.coordinator.commitSegments(this.SEGMENTS);
        this.coordinator.commitSegments((Set)ImmutableSet.of((Object)this.defaultSegment3));
        Assertions.assertThat((Collection)this.coordinator.retrieveUsedSegmentsForIntervals(this.defaultSegment.getDataSource(), (List)ImmutableList.of((Object)this.defaultSegment.getInterval()), Segments.ONLY_VISIBLE)).containsOnlyOnce((Object[])this.SEGMENTS.toArray(new DataSegment[0]));
        Assertions.assertThat((Collection)this.coordinator.retrieveUsedSegmentsForIntervals(this.defaultSegment.getDataSource(), (List)ImmutableList.of((Object)this.defaultSegment3.getInterval()), Segments.ONLY_VISIBLE)).containsOnlyOnce((Object[])new DataSegment[]{this.defaultSegment3});
        Assertions.assertThat((Collection)this.coordinator.retrieveUsedSegmentsForIntervals(this.defaultSegment.getDataSource(), (List)ImmutableList.of((Object)this.defaultSegment.getInterval(), (Object)this.defaultSegment3.getInterval()), Segments.ONLY_VISIBLE)).containsOnlyOnce((Object[])new DataSegment[]{this.defaultSegment, this.defaultSegment2, this.defaultSegment3});
        Assertions.assertThat((Collection)this.coordinator.retrieveUsedSegmentsForIntervals(this.defaultSegment.getDataSource(), (List)ImmutableList.of((Object)Intervals.of((String)"2015-01-03T00Z/2015-01-03T05Z"), (Object)Intervals.of((String)"2015-01-03T09Z/2015-01-04T00Z")), Segments.ONLY_VISIBLE)).containsOnlyOnce((Object[])new DataSegment[]{this.defaultSegment3});
    }

    @Test
    public void testRetrieveUsedSegmentsUsingMultipleIntervals() throws IOException {
        List<DataSegment> segments = this.createAndGetUsedYearSegments(1900, 2133);
        List intervals = segments.stream().map(DataSegment::getInterval).collect(Collectors.toList());
        Collection actualUsedSegments = this.coordinator.retrieveUsedSegmentsForIntervals("wiki", intervals, Segments.ONLY_VISIBLE);
        Assert.assertEquals((long)segments.size(), (long)actualUsedSegments.size());
        Assert.assertTrue((boolean)actualUsedSegments.containsAll(segments));
    }

    @Test
    public void testRetrieveAllUsedSegmentsUsingIntervalsOutOfRange() throws IOException {
        List<DataSegment> segments = this.createAndGetUsedYearSegments(1905, 1910);
        Interval outOfRangeInterval = Intervals.of((String)"1700/1800");
        Assert.assertTrue((boolean)segments.stream().anyMatch(segment -> !segment.getInterval().overlaps((ReadableInterval)outOfRangeInterval)));
        Collection actualUsedSegments = this.coordinator.retrieveUsedSegmentsForIntervals("wiki", (List)ImmutableList.of((Object)outOfRangeInterval), Segments.ONLY_VISIBLE);
        Assert.assertEquals((long)0L, (long)actualUsedSegments.size());
    }

    @Test
    public void testRetrieveAllUsedSegmentsUsingNoIntervals() throws IOException {
        List<DataSegment> segments = this.createAndGetUsedYearSegments(1900, 2133);
        Collection actualUsedSegments = this.coordinator.retrieveAllUsedSegments("wiki", Segments.ONLY_VISIBLE);
        Assert.assertEquals((long)segments.size(), (long)actualUsedSegments.size());
        Assert.assertTrue((boolean)actualUsedSegments.containsAll(segments));
    }

    @Test
    public void testRetrieveUnusedSegmentsUsingSingleIntervalAndNoLimit() throws IOException {
        List<DataSegment> segments = this.createAndGetUsedYearSegments(1900, 2133);
        this.markAllSegmentsUnused(new HashSet<DataSegment>(segments), DateTimes.nowUtc());
        List actualUnusedSegments = this.coordinator.retrieveUnusedSegmentsForInterval("wiki", Intervals.of((String)"1900/3000"), null, null);
        Assert.assertEquals((long)segments.size(), (long)actualUnusedSegments.size());
        Assert.assertTrue((boolean)actualUnusedSegments.containsAll(segments));
    }

    @Test
    public void testRetrieveUnusedSegmentsUsingSingleIntervalAndLimitAtRange() throws IOException {
        List<DataSegment> segments = this.createAndGetUsedYearSegments(1900, 2133);
        this.markAllSegmentsUnused(new HashSet<DataSegment>(segments), DateTimes.nowUtc());
        int requestedLimit = segments.size();
        List actualUnusedSegments = this.coordinator.retrieveUnusedSegmentsForInterval("wiki", Intervals.of((String)"1900/3000"), Integer.valueOf(requestedLimit), null);
        Assert.assertEquals((long)requestedLimit, (long)actualUnusedSegments.size());
        Assert.assertTrue((boolean)actualUnusedSegments.containsAll(segments));
    }

    @Test
    public void testRetrieveUnusedSegmentsUsingSingleIntervalAndLimitInRange() throws IOException {
        List<DataSegment> segments = this.createAndGetUsedYearSegments(1900, 2133);
        this.markAllSegmentsUnused(new HashSet<DataSegment>(segments), DateTimes.nowUtc());
        int requestedLimit = segments.size() - 1;
        List actualUnusedSegments = this.coordinator.retrieveUnusedSegmentsForInterval("wiki", Intervals.of((String)"1900/3000"), Integer.valueOf(requestedLimit), null);
        Assert.assertEquals((long)requestedLimit, (long)actualUnusedSegments.size());
        Assert.assertTrue((boolean)actualUnusedSegments.containsAll(segments.stream().limit(requestedLimit).collect(Collectors.toList())));
    }

    @Test
    public void testRetrieveUnusedSegmentsUsingSingleIntervalAndLimitOutOfRange() throws IOException {
        List<DataSegment> segments = this.createAndGetUsedYearSegments(1900, 2133);
        this.markAllSegmentsUnused(new HashSet<DataSegment>(segments), DateTimes.nowUtc());
        int limit = segments.size() + 1;
        List actualUnusedSegments = this.coordinator.retrieveUnusedSegmentsForInterval("wiki", Intervals.of((String)"1900/3000"), Integer.valueOf(limit), null);
        Assert.assertEquals((long)segments.size(), (long)actualUnusedSegments.size());
        Assert.assertTrue((boolean)actualUnusedSegments.containsAll(segments));
    }

    @Test
    public void testRetrieveUnusedSegmentsUsingSingleIntervalOutOfRange() throws IOException {
        List<DataSegment> segments = this.createAndGetUsedYearSegments(1905, 1910);
        this.markAllSegmentsUnused(new HashSet<DataSegment>(segments), DateTimes.nowUtc());
        Interval outOfRangeInterval = Intervals.of((String)"1700/1800");
        Assert.assertTrue((boolean)segments.stream().anyMatch(segment -> !segment.getInterval().overlaps((ReadableInterval)outOfRangeInterval)));
        int limit = segments.size() + 1;
        List actualUnusedSegments = this.coordinator.retrieveUnusedSegmentsForInterval("wiki", outOfRangeInterval, Integer.valueOf(limit), null);
        Assert.assertEquals((long)0L, (long)actualUnusedSegments.size());
    }

    @Test
    public void testRetrieveUnusedSegmentsUsingMultipleIntervalsAndNoLimit() throws IOException {
        List<DataSegment> segments = this.createAndGetUsedYearSegments(1900, 2133);
        DateTime usedStatusLastUpdatedTime = DateTimes.nowUtc();
        this.markAllSegmentsUnused(new HashSet<DataSegment>(segments), usedStatusLastUpdatedTime);
        ImmutableList<DataSegment> actualUnusedSegments = this.retrieveUnusedSegments(segments.stream().map(DataSegment::getInterval).collect(Collectors.toList()), null, null, null, null);
        Assert.assertEquals((long)segments.size(), (long)actualUnusedSegments.size());
        Assert.assertTrue((boolean)segments.containsAll((Collection<?>)actualUnusedSegments));
        ImmutableList<DataSegmentPlus> actualUnusedSegmentsPlus = this.retrieveUnusedSegmentsPlus(segments.stream().map(DataSegment::getInterval).collect(Collectors.toList()), null, null, null, null);
        Assert.assertEquals((long)segments.size(), (long)actualUnusedSegmentsPlus.size());
        this.verifyContainsAllSegmentsPlus(segments, (List<DataSegmentPlus>)actualUnusedSegmentsPlus, usedStatusLastUpdatedTime);
    }

    @Test
    public void testRetrieveUnusedSegmentsUsingNoIntervalsNoLimitAndNoLastSegmentId() throws IOException {
        List<DataSegment> segments = this.createAndGetUsedYearSegments(1900, 2133);
        DateTime usedStatusLastUpdatedTime = DateTimes.nowUtc();
        this.markAllSegmentsUnused(new HashSet<DataSegment>(segments), usedStatusLastUpdatedTime);
        ImmutableList<DataSegment> actualUnusedSegments = this.retrieveUnusedSegments((List<Interval>)ImmutableList.of(), null, null, null, null);
        Assert.assertEquals((long)segments.size(), (long)actualUnusedSegments.size());
        Assert.assertTrue((boolean)segments.containsAll((Collection<?>)actualUnusedSegments));
        ImmutableList<DataSegmentPlus> actualUnusedSegmentsPlus = this.retrieveUnusedSegmentsPlus((List<Interval>)ImmutableList.of(), null, null, null, null);
        Assert.assertEquals((long)segments.size(), (long)actualUnusedSegmentsPlus.size());
        this.verifyContainsAllSegmentsPlus(segments, (List<DataSegmentPlus>)actualUnusedSegmentsPlus, usedStatusLastUpdatedTime);
    }

    @Test
    public void testRetrieveUnusedSegmentsUsingNoIntervalsAndNoLimitAndNoLastSegmentId() throws IOException {
        List<DataSegment> segments = this.createAndGetUsedYearSegments(2033, 2133);
        DateTime usedStatusLastUpdatedTime = DateTimes.nowUtc();
        this.markAllSegmentsUnused(new HashSet<DataSegment>(segments), usedStatusLastUpdatedTime);
        String lastSegmentId = segments.get(9).getId().toString();
        List<DataSegment> expectedSegmentsAscOrder = segments.stream().filter(s -> s.getId().toString().compareTo(lastSegmentId) > 0).collect(Collectors.toList());
        ImmutableList<DataSegment> actualUnusedSegments = this.retrieveUnusedSegments((List<Interval>)ImmutableList.of(), null, lastSegmentId, null, null);
        Assert.assertEquals((long)expectedSegmentsAscOrder.size(), (long)actualUnusedSegments.size());
        Assert.assertTrue((boolean)expectedSegmentsAscOrder.containsAll((Collection<?>)actualUnusedSegments));
        ImmutableList<DataSegmentPlus> actualUnusedSegmentsPlus = this.retrieveUnusedSegmentsPlus((List<Interval>)ImmutableList.of(), null, lastSegmentId, null, null);
        Assert.assertEquals((long)expectedSegmentsAscOrder.size(), (long)actualUnusedSegmentsPlus.size());
        this.verifyContainsAllSegmentsPlus(expectedSegmentsAscOrder, (List<DataSegmentPlus>)actualUnusedSegmentsPlus, usedStatusLastUpdatedTime);
        actualUnusedSegments = this.retrieveUnusedSegments((List<Interval>)ImmutableList.of(), null, lastSegmentId, SortOrder.ASC, null);
        Assert.assertEquals((long)expectedSegmentsAscOrder.size(), (long)actualUnusedSegments.size());
        Assert.assertEquals(expectedSegmentsAscOrder, actualUnusedSegments);
        actualUnusedSegmentsPlus = this.retrieveUnusedSegmentsPlus((List<Interval>)ImmutableList.of(), null, lastSegmentId, SortOrder.ASC, null);
        Assert.assertEquals((long)expectedSegmentsAscOrder.size(), (long)actualUnusedSegmentsPlus.size());
        this.verifyEqualsAllSegmentsPlus(expectedSegmentsAscOrder, (List<DataSegmentPlus>)actualUnusedSegmentsPlus, usedStatusLastUpdatedTime);
        List<DataSegment> expectedSegmentsDescOrder = segments.stream().filter(s -> s.getId().toString().compareTo(lastSegmentId) < 0).collect(Collectors.toList());
        Collections.reverse(expectedSegmentsDescOrder);
        actualUnusedSegments = this.retrieveUnusedSegments((List<Interval>)ImmutableList.of(), null, lastSegmentId, SortOrder.DESC, null);
        Assert.assertEquals((long)expectedSegmentsDescOrder.size(), (long)actualUnusedSegments.size());
        Assert.assertEquals(expectedSegmentsDescOrder, actualUnusedSegments);
        actualUnusedSegmentsPlus = this.retrieveUnusedSegmentsPlus((List<Interval>)ImmutableList.of(), null, lastSegmentId, SortOrder.DESC, null);
        Assert.assertEquals((long)expectedSegmentsDescOrder.size(), (long)actualUnusedSegmentsPlus.size());
        this.verifyEqualsAllSegmentsPlus(expectedSegmentsDescOrder, (List<DataSegmentPlus>)actualUnusedSegmentsPlus, usedStatusLastUpdatedTime);
    }

    @Test
    public void testRetrieveUnusedSegmentsUsingMultipleIntervalsAndLimitAtRange() throws IOException {
        List<DataSegment> segments = this.createAndGetUsedYearSegments(1900, 2133);
        DateTime usedStatusLastUpdatedTime = DateTimes.nowUtc();
        this.markAllSegmentsUnused(new HashSet<DataSegment>(segments), usedStatusLastUpdatedTime);
        ImmutableList<DataSegment> actualUnusedSegments = this.retrieveUnusedSegments(segments.stream().map(DataSegment::getInterval).collect(Collectors.toList()), segments.size(), null, null, null);
        Assert.assertEquals((long)segments.size(), (long)actualUnusedSegments.size());
        Assert.assertTrue((boolean)segments.containsAll((Collection<?>)actualUnusedSegments));
        ImmutableList<DataSegmentPlus> actualUnusedSegmentsPlus = this.retrieveUnusedSegmentsPlus((List<Interval>)ImmutableList.of(), segments.size(), null, null, null);
        Assert.assertEquals((long)segments.size(), (long)actualUnusedSegmentsPlus.size());
        this.verifyContainsAllSegmentsPlus(segments, (List<DataSegmentPlus>)actualUnusedSegmentsPlus, usedStatusLastUpdatedTime);
    }

    @Test
    public void testRetrieveUnusedSegmentsUsingMultipleIntervalsAndLimitInRange() throws IOException {
        List<DataSegment> segments = this.createAndGetUsedYearSegments(1900, 2133);
        DateTime usedStatusLastUpdatedTime = DateTimes.nowUtc();
        this.markAllSegmentsUnused(new HashSet<DataSegment>(segments), usedStatusLastUpdatedTime);
        int requestedLimit = segments.size() - 1;
        ImmutableList<DataSegment> actualUnusedSegments = this.retrieveUnusedSegments(segments.stream().map(DataSegment::getInterval).collect(Collectors.toList()), requestedLimit, null, null, null);
        List<DataSegment> expectedSegments = segments.stream().limit(requestedLimit).collect(Collectors.toList());
        Assert.assertEquals((long)requestedLimit, (long)actualUnusedSegments.size());
        Assert.assertTrue((boolean)actualUnusedSegments.containsAll(expectedSegments));
        ImmutableList<DataSegmentPlus> actualUnusedSegmentsPlus = this.retrieveUnusedSegmentsPlus((List<Interval>)ImmutableList.of(), requestedLimit, null, null, null);
        Assert.assertEquals((long)requestedLimit, (long)actualUnusedSegmentsPlus.size());
        this.verifyContainsAllSegmentsPlus(expectedSegments, (List<DataSegmentPlus>)actualUnusedSegmentsPlus, usedStatusLastUpdatedTime);
    }

    @Test
    public void testRetrieveUnusedSegmentsUsingMultipleIntervalsInSingleBatchLimitAndLastSegmentId() throws IOException {
        List<DataSegment> segments = this.createAndGetUsedYearSegments(2034, 2133);
        DateTime usedStatusLastUpdatedTime = DateTimes.nowUtc();
        this.markAllSegmentsUnused(new HashSet<DataSegment>(segments), usedStatusLastUpdatedTime);
        int requestedLimit = segments.size();
        String lastSegmentId = segments.get(4).getId().toString();
        List<DataSegment> expectedSegments = segments.stream().filter(s -> s.getId().toString().compareTo(lastSegmentId) > 0).limit(requestedLimit).collect(Collectors.toList());
        ImmutableList<DataSegment> actualUnusedSegments = this.retrieveUnusedSegments(segments.stream().map(DataSegment::getInterval).collect(Collectors.toList()), requestedLimit, lastSegmentId, null, null);
        Assert.assertEquals((long)(segments.size() - 5), (long)actualUnusedSegments.size());
        Assert.assertEquals(actualUnusedSegments, expectedSegments);
        ImmutableList<DataSegmentPlus> actualUnusedSegmentsPlus = this.retrieveUnusedSegmentsPlus((List<Interval>)ImmutableList.of(), requestedLimit, lastSegmentId, null, null);
        Assert.assertEquals((long)(segments.size() - 5), (long)actualUnusedSegmentsPlus.size());
        this.verifyEqualsAllSegmentsPlus(expectedSegments, (List<DataSegmentPlus>)actualUnusedSegmentsPlus, usedStatusLastUpdatedTime);
    }

    @Test
    public void testRetrieveUnusedSegmentsUsingMultipleIntervalsLimitAndLastSegmentId() throws IOException {
        List<DataSegment> segments = this.createAndGetUsedYearSegments(1900, 2133);
        DateTime usedStatusLastUpdatedTime = DateTimes.nowUtc();
        this.markAllSegmentsUnused(new HashSet<DataSegment>(segments), usedStatusLastUpdatedTime);
        int requestedLimit = segments.size() - 1;
        String lastSegmentId = segments.get(4).getId().toString();
        List<DataSegment> expectedSegments = segments.stream().filter(s -> s.getId().toString().compareTo(lastSegmentId) > 0).limit(requestedLimit).collect(Collectors.toList());
        ImmutableList<DataSegment> actualUnusedSegments = this.retrieveUnusedSegments(segments.stream().map(DataSegment::getInterval).collect(Collectors.toList()), requestedLimit, lastSegmentId, null, null);
        Assert.assertEquals((long)(requestedLimit - 4), (long)actualUnusedSegments.size());
        Assert.assertEquals(actualUnusedSegments, expectedSegments);
        ImmutableList<DataSegmentPlus> actualUnusedSegmentsPlus = this.retrieveUnusedSegmentsPlus(segments.stream().map(DataSegment::getInterval).collect(Collectors.toList()), requestedLimit, lastSegmentId, null, null);
        Assert.assertEquals((long)(requestedLimit - 4), (long)actualUnusedSegmentsPlus.size());
        this.verifyEqualsAllSegmentsPlus(expectedSegments, (List<DataSegmentPlus>)actualUnusedSegmentsPlus, usedStatusLastUpdatedTime);
    }

    @Test
    public void testRetrieveUnusedSegmentsUsingMultipleIntervals() throws IOException {
        List<DataSegment> segments = this.createAndGetUsedYearSegments(1900, 2133);
        DateTime usedStatusLastUpdatedTime = DateTimes.nowUtc();
        this.markAllSegmentsUnused(new HashSet<DataSegment>(segments), usedStatusLastUpdatedTime);
        ImmutableList<DataSegment> actualUnusedSegments = this.retrieveUnusedSegments(segments.stream().map(DataSegment::getInterval).collect(Collectors.toList()), segments.size() + 1, null, null, null);
        Assert.assertEquals((long)segments.size(), (long)actualUnusedSegments.size());
        Assert.assertTrue((boolean)actualUnusedSegments.containsAll(segments));
        ImmutableList<DataSegmentPlus> actualUnusedSegmentsPlus = this.retrieveUnusedSegmentsPlus(segments.stream().map(DataSegment::getInterval).collect(Collectors.toList()), segments.size() + 1, null, null, null);
        Assert.assertEquals((long)segments.size(), (long)actualUnusedSegmentsPlus.size());
        this.verifyContainsAllSegmentsPlus(segments, (List<DataSegmentPlus>)actualUnusedSegmentsPlus, usedStatusLastUpdatedTime);
    }

    @Test
    public void testRetrieveUnusedSegmentsUsingIntervalOutOfRange() throws IOException {
        List<DataSegment> segments = this.createAndGetUsedYearSegments(1905, 1910);
        this.markAllSegmentsUnused(new HashSet<DataSegment>(segments), DateTimes.nowUtc());
        Interval outOfRangeInterval = Intervals.of((String)"1700/1800");
        Assert.assertTrue((boolean)segments.stream().anyMatch(segment -> !segment.getInterval().overlaps((ReadableInterval)outOfRangeInterval)));
        ImmutableList<DataSegment> actualUnusedSegments = this.retrieveUnusedSegments((List<Interval>)ImmutableList.of((Object)outOfRangeInterval), null, null, null, null);
        Assert.assertEquals((long)0L, (long)actualUnusedSegments.size());
        ImmutableList<DataSegmentPlus> actualUnusedSegmentsPlus = this.retrieveUnusedSegmentsPlus((List<Interval>)ImmutableList.of((Object)outOfRangeInterval), null, null, null, null);
        Assert.assertEquals((long)0L, (long)actualUnusedSegmentsPlus.size());
    }

    @Test
    public void testRetrieveUnusedSegmentsWithMaxUsedStatusLastUpdatedTime() throws IOException {
        List<DataSegment> segments = this.createAndGetUsedYearSegments(1905, 1910);
        DateTime usedStatusLastUpdatedTime = DateTimes.nowUtc();
        this.markAllSegmentsUnused(new HashSet<DataSegment>(segments), usedStatusLastUpdatedTime);
        Interval interval = Intervals.of((String)"1905/1920");
        ImmutableList<DataSegment> actualUnusedSegments1 = this.retrieveUnusedSegments((List<Interval>)ImmutableList.of((Object)interval), null, null, null, DateTimes.nowUtc());
        Assert.assertEquals((long)5L, (long)actualUnusedSegments1.size());
        ImmutableList<DataSegmentPlus> actualUnusedSegmentsPlus = this.retrieveUnusedSegmentsPlus((List<Interval>)ImmutableList.of((Object)interval), null, null, null, DateTimes.nowUtc());
        Assert.assertEquals((long)5L, (long)actualUnusedSegmentsPlus.size());
        ImmutableList<DataSegment> actualUnusedSegments2 = this.retrieveUnusedSegments((List<Interval>)ImmutableList.of((Object)interval), null, null, null, DateTimes.nowUtc().minusHours(1));
        Assert.assertEquals((long)0L, (long)actualUnusedSegments2.size());
        actualUnusedSegmentsPlus = this.retrieveUnusedSegmentsPlus((List<Interval>)ImmutableList.of((Object)interval), null, null, null, DateTimes.nowUtc().minusHours(1));
        Assert.assertEquals((long)0L, (long)actualUnusedSegmentsPlus.size());
    }

    @Test
    public void testRetrieveUnusedSegmentsWithMaxUsedStatusLastUpdatedTime2() throws IOException {
        List<DataSegment> segments = this.createAndGetUsedYearSegments(1900, 1950);
        ArrayList<DataSegment> evenYearSegments = new ArrayList<DataSegment>();
        ArrayList<DataSegment> oddYearSegments = new ArrayList<DataSegment>();
        for (int i = 0; i < segments.size(); ++i) {
            DataSegment dataSegment = segments.get(i);
            if (i % 2 == 0) {
                evenYearSegments.add(dataSegment);
                continue;
            }
            oddYearSegments.add(dataSegment);
        }
        DateTime maxUsedStatusLastUpdatedTime1 = DateTimes.nowUtc();
        this.markAllSegmentsUnused(new HashSet<DataSegment>(oddYearSegments), maxUsedStatusLastUpdatedTime1);
        DateTime maxUsedStatusLastUpdatedTime2 = DateTimes.nowUtc();
        this.markAllSegmentsUnused(new HashSet<DataSegment>(evenYearSegments), maxUsedStatusLastUpdatedTime2);
        Interval interval = Intervals.of((String)"1900/1950");
        ImmutableList<DataSegment> actualUnusedSegments1 = this.retrieveUnusedSegments((List<Interval>)ImmutableList.of((Object)interval), null, null, null, maxUsedStatusLastUpdatedTime1);
        Assert.assertEquals((long)oddYearSegments.size(), (long)actualUnusedSegments1.size());
        ImmutableList<DataSegmentPlus> actualUnusedSegmentsPlus1 = this.retrieveUnusedSegmentsPlus((List<Interval>)ImmutableList.of((Object)interval), null, null, null, maxUsedStatusLastUpdatedTime1);
        Assert.assertEquals((long)oddYearSegments.size(), (long)actualUnusedSegmentsPlus1.size());
        ImmutableList<DataSegment> actualUnusedSegments2 = this.retrieveUnusedSegments((List<Interval>)ImmutableList.of((Object)interval), null, null, null, maxUsedStatusLastUpdatedTime2);
        Assert.assertEquals((long)segments.size(), (long)actualUnusedSegments2.size());
        ImmutableList<DataSegmentPlus> actualUnusedSegmentsPlus2 = this.retrieveUnusedSegmentsPlus((List<Interval>)ImmutableList.of((Object)interval), null, null, null, maxUsedStatusLastUpdatedTime2);
        Assert.assertEquals((long)segments.size(), (long)actualUnusedSegmentsPlus2.size());
    }

    @Test
    public void testSimpleUnusedList() throws IOException {
        this.coordinator.commitSegments(this.SEGMENTS);
        this.markAllSegmentsUnused();
        Assert.assertEquals(this.SEGMENTS, (Object)ImmutableSet.copyOf((Collection)this.coordinator.retrieveUnusedSegmentsForInterval(this.defaultSegment.getDataSource(), this.defaultSegment.getInterval(), null, null)));
    }

    @Test
    public void testSimpleUnusedListWithLimit() throws IOException {
        this.coordinator.commitSegments(this.SEGMENTS);
        this.markAllSegmentsUnused();
        int limit = this.SEGMENTS.size() - 1;
        ImmutableSet retreivedUnusedSegments = ImmutableSet.copyOf((Collection)this.coordinator.retrieveUnusedSegmentsForInterval(this.defaultSegment.getDataSource(), this.defaultSegment.getInterval(), Integer.valueOf(limit), null));
        Assert.assertEquals((long)limit, (long)retreivedUnusedSegments.size());
        Assert.assertTrue((boolean)this.SEGMENTS.containsAll((Collection<?>)retreivedUnusedSegments));
    }

    @Test
    public void testUsedOverlapLow() throws IOException {
        this.coordinator.commitSegments(this.SEGMENTS);
        ImmutableSet actualSegments = ImmutableSet.copyOf((Collection)this.coordinator.retrieveUsedSegmentsForInterval(this.defaultSegment.getDataSource(), Intervals.of((String)"2014-12-31T23:59:59.999Z/2015-01-01T00:00:00.001Z"), Segments.ONLY_VISIBLE));
        Assert.assertEquals(this.SEGMENTS, (Object)actualSegments);
    }

    @Test
    public void testUsedOverlapHigh() throws IOException {
        this.coordinator.commitSegments(this.SEGMENTS);
        Assert.assertEquals(this.SEGMENTS, (Object)ImmutableSet.copyOf((Collection)this.coordinator.retrieveUsedSegmentsForInterval(this.defaultSegment.getDataSource(), Intervals.of((String)"2015-1-1T23:59:59.999Z/2015-02-01T00Z"), Segments.ONLY_VISIBLE)));
    }

    @Test
    public void testUsedOutOfBoundsLow() throws IOException {
        this.coordinator.commitSegments(this.SEGMENTS);
        Assert.assertTrue((boolean)this.coordinator.retrieveUsedSegmentsForInterval(this.defaultSegment.getDataSource(), new Interval((ReadableInstant)this.defaultSegment.getInterval().getStart().minus(1L), (ReadableInstant)this.defaultSegment.getInterval().getStart()), Segments.ONLY_VISIBLE).isEmpty());
    }

    @Test
    public void testUsedOutOfBoundsHigh() throws IOException {
        this.coordinator.commitSegments(this.SEGMENTS);
        Assert.assertTrue((boolean)this.coordinator.retrieveUsedSegmentsForInterval(this.defaultSegment.getDataSource(), new Interval((ReadableInstant)this.defaultSegment.getInterval().getEnd(), (ReadableInstant)this.defaultSegment.getInterval().getEnd().plusDays(10)), Segments.ONLY_VISIBLE).isEmpty());
    }

    @Test
    public void testUsedWithinBoundsEnd() throws IOException {
        this.coordinator.commitSegments(this.SEGMENTS);
        Assert.assertEquals(this.SEGMENTS, (Object)ImmutableSet.copyOf((Collection)this.coordinator.retrieveUsedSegmentsForInterval(this.defaultSegment.getDataSource(), this.defaultSegment.getInterval().withEnd((ReadableInstant)this.defaultSegment.getInterval().getEnd().minusMillis(1)), Segments.ONLY_VISIBLE)));
    }

    @Test
    public void testUsedOverlapEnd() throws IOException {
        this.coordinator.commitSegments(this.SEGMENTS);
        Assert.assertEquals(this.SEGMENTS, (Object)ImmutableSet.copyOf((Collection)this.coordinator.retrieveUsedSegmentsForInterval(this.defaultSegment.getDataSource(), this.defaultSegment.getInterval().withEnd((ReadableInstant)this.defaultSegment.getInterval().getEnd().plusMillis(1)), Segments.ONLY_VISIBLE)));
    }

    @Test
    public void testUnusedOverlapLow() throws IOException {
        this.coordinator.commitSegments(this.SEGMENTS);
        this.markAllSegmentsUnused();
        Assert.assertTrue((boolean)this.coordinator.retrieveUnusedSegmentsForInterval(this.defaultSegment.getDataSource(), new Interval((ReadableInstant)this.defaultSegment.getInterval().getStart().minus(1L), (ReadableInstant)this.defaultSegment.getInterval().getStart().plus(1L)), null, null).isEmpty());
    }

    @Test
    public void testUnusedUnderlapLow() throws IOException {
        this.coordinator.commitSegments(this.SEGMENTS);
        this.markAllSegmentsUnused();
        Assert.assertTrue((boolean)this.coordinator.retrieveUnusedSegmentsForInterval(this.defaultSegment.getDataSource(), new Interval((ReadableInstant)this.defaultSegment.getInterval().getStart().plus(1L), (ReadableInstant)this.defaultSegment.getInterval().getEnd()), null, null).isEmpty());
    }

    @Test
    public void testUnusedUnderlapHigh() throws IOException {
        this.coordinator.commitSegments(this.SEGMENTS);
        this.markAllSegmentsUnused();
        Assert.assertTrue((boolean)this.coordinator.retrieveUnusedSegmentsForInterval(this.defaultSegment.getDataSource(), new Interval((ReadableInstant)this.defaultSegment.getInterval().getStart(), (ReadableInstant)this.defaultSegment.getInterval().getEnd().minus(1L)), null, null).isEmpty());
    }

    @Test
    public void testUnusedOverlapHigh() throws IOException {
        this.coordinator.commitSegments(this.SEGMENTS);
        this.markAllSegmentsUnused();
        Assert.assertTrue((boolean)this.coordinator.retrieveUnusedSegmentsForInterval(this.defaultSegment.getDataSource(), this.defaultSegment.getInterval().withStart((ReadableInstant)this.defaultSegment.getInterval().getEnd().minus(1L)), null, null).isEmpty());
    }

    @Test
    public void testUnusedBigOverlap() throws IOException {
        this.coordinator.commitSegments(this.SEGMENTS);
        this.markAllSegmentsUnused();
        Assert.assertEquals(this.SEGMENTS, (Object)ImmutableSet.copyOf((Collection)this.coordinator.retrieveUnusedSegmentsForInterval(this.defaultSegment.getDataSource(), Intervals.of((String)"2000/2999"), null, null)));
    }

    @Test
    public void testUnusedLowRange() throws IOException {
        this.coordinator.commitSegments(this.SEGMENTS);
        this.markAllSegmentsUnused();
        Assert.assertEquals(this.SEGMENTS, (Object)ImmutableSet.copyOf((Collection)this.coordinator.retrieveUnusedSegmentsForInterval(this.defaultSegment.getDataSource(), this.defaultSegment.getInterval().withStart((ReadableInstant)this.defaultSegment.getInterval().getStart().minus(1L)), null, null)));
        Assert.assertEquals(this.SEGMENTS, (Object)ImmutableSet.copyOf((Collection)this.coordinator.retrieveUnusedSegmentsForInterval(this.defaultSegment.getDataSource(), this.defaultSegment.getInterval().withStart((ReadableInstant)this.defaultSegment.getInterval().getStart().minusYears(1)), null, null)));
    }

    @Test
    public void testUnusedHighRange() throws IOException {
        this.coordinator.commitSegments(this.SEGMENTS);
        this.markAllSegmentsUnused();
        Assert.assertEquals(this.SEGMENTS, (Object)ImmutableSet.copyOf((Collection)this.coordinator.retrieveUnusedSegmentsForInterval(this.defaultSegment.getDataSource(), this.defaultSegment.getInterval().withEnd((ReadableInstant)this.defaultSegment.getInterval().getEnd().plus(1L)), null, null)));
        Assert.assertEquals(this.SEGMENTS, (Object)ImmutableSet.copyOf((Collection)this.coordinator.retrieveUnusedSegmentsForInterval(this.defaultSegment.getDataSource(), this.defaultSegment.getInterval().withEnd((ReadableInstant)this.defaultSegment.getInterval().getEnd().plusYears(1)), null, null)));
    }

    @Test
    public void testUsedHugeTimeRangeEternityFilter() throws IOException {
        this.coordinator.commitSegments((Set)ImmutableSet.of((Object)this.hugeTimeRangeSegment1, (Object)this.hugeTimeRangeSegment2, (Object)this.hugeTimeRangeSegment3));
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.hugeTimeRangeSegment1, (Object)this.hugeTimeRangeSegment2, (Object)this.hugeTimeRangeSegment3), (Object)ImmutableSet.copyOf((Collection)this.coordinator.retrieveUsedSegmentsForIntervals(this.hugeTimeRangeSegment1.getDataSource(), (List)Intervals.ONLY_ETERNITY, Segments.ONLY_VISIBLE)));
    }

    @Test
    public void testUsedHugeTimeRangeTrickyFilter1() throws IOException {
        this.coordinator.commitSegments((Set)ImmutableSet.of((Object)this.hugeTimeRangeSegment1, (Object)this.hugeTimeRangeSegment2, (Object)this.hugeTimeRangeSegment3));
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.hugeTimeRangeSegment2), (Object)ImmutableSet.copyOf((Collection)this.coordinator.retrieveUsedSegmentsForInterval(this.hugeTimeRangeSegment1.getDataSource(), Intervals.of((String)"2900/10000"), Segments.ONLY_VISIBLE)));
    }

    @Test
    public void testUsedHugeTimeRangeTrickyFilter2() throws IOException {
        this.coordinator.commitSegments((Set)ImmutableSet.of((Object)this.hugeTimeRangeSegment1, (Object)this.hugeTimeRangeSegment2, (Object)this.hugeTimeRangeSegment3));
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.hugeTimeRangeSegment2), (Object)ImmutableSet.copyOf((Collection)this.coordinator.retrieveUsedSegmentsForInterval(this.hugeTimeRangeSegment1.getDataSource(), Intervals.of((String)"2993/2995"), Segments.ONLY_VISIBLE)));
    }

    @Test
    public void testEternitySegmentWithStringComparison() throws IOException {
        this.coordinator.commitSegments((Set)ImmutableSet.of((Object)this.eternitySegment));
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.eternitySegment), (Object)ImmutableSet.copyOf((Collection)this.coordinator.retrieveUsedSegmentsForInterval(this.eternitySegment.getDataSource(), Intervals.of((String)"2020/2021"), Segments.ONLY_VISIBLE)));
    }

    @Test
    public void testEternityMultipleSegmentWithStringComparison() throws IOException {
        this.coordinator.commitSegments((Set)ImmutableSet.of((Object)this.numberedSegment0of0, (Object)this.eternitySegment));
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.eternitySegment, (Object)this.numberedSegment0of0), (Object)ImmutableSet.copyOf((Collection)this.coordinator.retrieveUsedSegmentsForInterval(this.eternitySegment.getDataSource(), Intervals.of((String)"2015/2016"), Segments.ONLY_VISIBLE)));
    }

    @Test
    public void testFirstHalfEternitySegmentWithStringComparison() throws IOException {
        this.coordinator.commitSegments((Set)ImmutableSet.of((Object)this.firstHalfEternityRangeSegment));
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.firstHalfEternityRangeSegment), (Object)ImmutableSet.copyOf((Collection)this.coordinator.retrieveUsedSegmentsForInterval(this.firstHalfEternityRangeSegment.getDataSource(), Intervals.of((String)"2020/2021"), Segments.ONLY_VISIBLE)));
    }

    @Test
    public void testFirstHalfEternityMultipleSegmentWithStringComparison() throws IOException {
        this.coordinator.commitSegments((Set)ImmutableSet.of((Object)this.numberedSegment0of0, (Object)this.firstHalfEternityRangeSegment));
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.numberedSegment0of0, (Object)this.firstHalfEternityRangeSegment), (Object)ImmutableSet.copyOf((Collection)this.coordinator.retrieveUsedSegmentsForInterval(this.firstHalfEternityRangeSegment.getDataSource(), Intervals.of((String)"2015/2016"), Segments.ONLY_VISIBLE)));
    }

    @Test
    public void testSecondHalfEternitySegmentWithStringComparison() throws IOException {
        this.coordinator.commitSegments((Set)ImmutableSet.of((Object)this.secondHalfEternityRangeSegment));
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.secondHalfEternityRangeSegment), (Object)ImmutableSet.copyOf((Collection)this.coordinator.retrieveUsedSegmentsForInterval(this.secondHalfEternityRangeSegment.getDataSource(), Intervals.of((String)"2020/2021"), Segments.ONLY_VISIBLE)));
    }

    @Ignore
    @Test
    public void testLargeIntervalWithStringComparison() throws IOException {
        this.coordinator.commitSegments((Set)ImmutableSet.of((Object)this.hugeTimeRangeSegment4));
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.hugeTimeRangeSegment4), (Object)ImmutableSet.copyOf((Collection)this.coordinator.retrieveUsedSegmentsForInterval(this.hugeTimeRangeSegment4.getDataSource(), Intervals.of((String)"2020/2021"), Segments.ONLY_VISIBLE)));
    }

    @Test
    public void testSecondHalfEternityMultipleSegmentWithStringComparison() throws IOException {
        this.coordinator.commitSegments((Set)ImmutableSet.of((Object)this.numberedSegment0of0, (Object)this.secondHalfEternityRangeSegment));
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.numberedSegment0of0, (Object)this.secondHalfEternityRangeSegment), (Object)ImmutableSet.copyOf((Collection)this.coordinator.retrieveUsedSegmentsForInterval(this.secondHalfEternityRangeSegment.getDataSource(), Intervals.of((String)"2015/2016"), Segments.ONLY_VISIBLE)));
    }

    @Test
    public void testDeleteDataSourceMetadata() throws IOException {
        this.coordinator.commitSegmentsAndMetadata((Set)ImmutableSet.of((Object)this.defaultSegment), (DataSourceMetadata)new ObjectMetadata(null), (DataSourceMetadata)new ObjectMetadata((Object)ImmutableMap.of((Object)"foo", (Object)"bar")));
        Assert.assertEquals((Object)new ObjectMetadata((Object)ImmutableMap.of((Object)"foo", (Object)"bar")), (Object)this.coordinator.retrieveDataSourceMetadata("fooDataSource"));
        Assert.assertFalse((String)"deleteInvalidDataSourceMetadata", (boolean)this.coordinator.deleteDataSourceMetadata("nonExistentDS"));
        Assert.assertTrue((String)"deleteValidDataSourceMetadata", (boolean)this.coordinator.deleteDataSourceMetadata("fooDataSource"));
        Assert.assertNull((String)"getDataSourceMetadataNullAfterDelete", (Object)this.coordinator.retrieveDataSourceMetadata("fooDataSource"));
    }

    @Test
    public void testDeleteSegmentsInMetaDataStorage() throws IOException {
        this.coordinator.commitSegments(this.SEGMENTS);
        Assert.assertEquals(this.SEGMENTS, (Object)ImmutableSet.copyOf((Collection)this.coordinator.retrieveUsedSegmentsForInterval(this.defaultSegment.getDataSource(), this.defaultSegment.getInterval(), Segments.ONLY_VISIBLE)));
        this.coordinator.deleteSegments(this.SEGMENTS);
        Assert.assertEquals((long)0L, (long)ImmutableSet.copyOf((Collection)this.coordinator.retrieveUsedSegmentsForInterval(this.defaultSegment.getDataSource(), this.defaultSegment.getInterval(), Segments.ONLY_VISIBLE)).size());
    }

    @Test
    public void testUpdateSegmentsInMetaDataStorage() throws IOException {
        this.coordinator.commitSegments(this.SEGMENTS);
        Assert.assertEquals(this.SEGMENTS, (Object)ImmutableSet.copyOf((Collection)this.coordinator.retrieveUsedSegmentsForInterval(this.defaultSegment.getDataSource(), this.defaultSegment.getInterval(), Segments.ONLY_VISIBLE)));
        this.coordinator.updateSegmentMetadata(Collections.singleton(this.defaultSegment2WithBiggerSize));
        Collection updated = this.coordinator.retrieveUsedSegmentsForInterval(this.defaultSegment.getDataSource(), this.defaultSegment.getInterval(), Segments.ONLY_VISIBLE);
        Assert.assertEquals((long)this.SEGMENTS.size(), (long)updated.size());
        DataSegment defaultAfterUpdate = updated.stream().filter(s -> s.equals((Object)this.defaultSegment)).findFirst().get();
        DataSegment default2AfterUpdate = updated.stream().filter(s -> s.equals((Object)this.defaultSegment2)).findFirst().get();
        Assert.assertNotNull((Object)defaultAfterUpdate);
        Assert.assertNotNull((Object)default2AfterUpdate);
        Assert.assertEquals((long)this.defaultSegment.getSize(), (long)defaultAfterUpdate.getSize());
        Assert.assertEquals((long)this.defaultSegment2WithBiggerSize.getSize(), (long)default2AfterUpdate.getSize());
    }

    @Test
    public void testSingleAdditionalNumberedShardWithNoCorePartitions() throws IOException {
        this.additionalNumberedShardTest((Set<DataSegment>)ImmutableSet.of((Object)this.numberedSegment0of0));
    }

    @Test
    public void testMultipleAdditionalNumberedShardsWithNoCorePartitions() throws IOException {
        this.additionalNumberedShardTest((Set<DataSegment>)ImmutableSet.of((Object)this.numberedSegment0of0, (Object)this.numberedSegment1of0, (Object)this.numberedSegment2of0));
    }

    @Test
    public void testSingleAdditionalNumberedShardWithOneCorePartition() throws IOException {
        this.additionalNumberedShardTest((Set<DataSegment>)ImmutableSet.of((Object)this.numberedSegment2of1));
    }

    @Test
    public void testMultipleAdditionalNumberedShardsWithOneCorePartition() throws IOException {
        this.additionalNumberedShardTest((Set<DataSegment>)ImmutableSet.of((Object)this.numberedSegment2of1, (Object)this.numberedSegment3of1));
    }

    private void additionalNumberedShardTest(Set<DataSegment> segments) throws IOException {
        this.coordinator.commitSegments(segments);
        for (DataSegment segment2 : segments) {
            Assert.assertArrayEquals((byte[])this.mapper.writeValueAsString((Object)segment2).getBytes(StandardCharsets.UTF_8), (byte[])this.derbyConnector.lookup(((MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get()).getSegmentsTable(), "id", "payload", segment2.getId().toString()));
        }
        Assert.assertEquals(segments.stream().map(segment -> segment.getId().toString()).collect(Collectors.toList()), this.retrieveUsedSegmentIds());
        Assert.assertEquals((long)0L, (long)this.metadataUpdateCounter.get());
    }

    @Test
    public void testAllocatePendingSegment() {
        NumberedPartialShardSpec partialShardSpec = NumberedPartialShardSpec.instance();
        String dataSource = "ds";
        Interval interval = Intervals.of((String)"2017-01-01/2017-02-01");
        SegmentIdWithShardSpec identifier = this.coordinator.allocatePendingSegment("ds", "seq", null, interval, (PartialShardSpec)partialShardSpec, "version", false);
        Assert.assertEquals((Object)"ds_2017-01-01T00:00:00.000Z_2017-02-01T00:00:00.000Z_version", (Object)identifier.toString());
        SegmentIdWithShardSpec identifier1 = this.coordinator.allocatePendingSegment("ds", "seq", identifier.toString(), interval, (PartialShardSpec)partialShardSpec, identifier.getVersion(), false);
        Assert.assertEquals((Object)"ds_2017-01-01T00:00:00.000Z_2017-02-01T00:00:00.000Z_version_1", (Object)identifier1.toString());
        SegmentIdWithShardSpec identifier2 = this.coordinator.allocatePendingSegment("ds", "seq", identifier1.toString(), interval, (PartialShardSpec)partialShardSpec, identifier1.getVersion(), false);
        Assert.assertEquals((Object)"ds_2017-01-01T00:00:00.000Z_2017-02-01T00:00:00.000Z_version_2", (Object)identifier2.toString());
        SegmentIdWithShardSpec identifier3 = this.coordinator.allocatePendingSegment("ds", "seq", identifier1.toString(), interval, (PartialShardSpec)partialShardSpec, identifier1.getVersion(), false);
        Assert.assertEquals((Object)"ds_2017-01-01T00:00:00.000Z_2017-02-01T00:00:00.000Z_version_2", (Object)identifier3.toString());
        Assert.assertEquals((Object)identifier2, (Object)identifier3);
        SegmentIdWithShardSpec identifier4 = this.coordinator.allocatePendingSegment("ds", "seq1", null, interval, (PartialShardSpec)partialShardSpec, "version", false);
        Assert.assertEquals((Object)"ds_2017-01-01T00:00:00.000Z_2017-02-01T00:00:00.000Z_version_3", (Object)identifier4.toString());
    }

    @Test
    public void testAllocatePendingSegmentAfterDroppingExistingSegment() {
        String maxVersion = "version_newer_newer";
        NumberedPartialShardSpec partialShardSpec = NumberedPartialShardSpec.instance();
        String dataSource = "ds";
        Interval interval = Intervals.of((String)"2017-01-01/2017-02-01");
        SegmentIdWithShardSpec identifier = this.coordinator.allocatePendingSegment("ds", "seq", null, interval, (PartialShardSpec)partialShardSpec, "version", true);
        Assert.assertEquals((Object)"ds_2017-01-01T00:00:00.000Z_2017-02-01T00:00:00.000Z_version", (Object)identifier.toString());
        Assert.assertEquals((long)0L, (long)identifier.getShardSpec().getNumCorePartitions());
        SegmentIdWithShardSpec identifier1 = this.coordinator.allocatePendingSegment("ds", "seq2", identifier.toString(), interval, (PartialShardSpec)partialShardSpec, maxVersion, true);
        Assert.assertEquals((Object)"ds_2017-01-01T00:00:00.000Z_2017-02-01T00:00:00.000Z_version_1", (Object)identifier1.toString());
        Assert.assertEquals((long)0L, (long)identifier1.getShardSpec().getNumCorePartitions());
        SegmentIdWithShardSpec identifier2 = this.coordinator.allocatePendingSegment("ds", "seq3", identifier1.toString(), interval, (PartialShardSpec)partialShardSpec, maxVersion, true);
        Assert.assertEquals((Object)"ds_2017-01-01T00:00:00.000Z_2017-02-01T00:00:00.000Z_version_2", (Object)identifier2.toString());
        Assert.assertEquals((long)0L, (long)identifier2.getShardSpec().getNumCorePartitions());
        DataSegment segment = new DataSegment("ds", Intervals.of((String)"2017-01-01T00Z/2017-02-01T00Z"), "version_new", (Map)ImmutableMap.of(), (List)ImmutableList.of((Object)"dim1"), (List)ImmutableList.of((Object)"m1"), (ShardSpec)new NumberedShardSpec(0, 1), Integer.valueOf(9), 100L);
        Assert.assertTrue((boolean)this.insertUsedSegments((Set<DataSegment>)ImmutableSet.of((Object)segment)));
        List<String> ids = this.retrieveUsedSegmentIds();
        Assert.assertEquals((Object)"ds_2017-01-01T00:00:00.000Z_2017-02-01T00:00:00.000Z_version_new", (Object)ids.get(0));
        SegmentIdWithShardSpec identifier3 = this.coordinator.allocatePendingSegment("ds", "seq4", identifier1.toString(), interval, (PartialShardSpec)partialShardSpec, maxVersion, true);
        Assert.assertEquals((Object)"ds_2017-01-01T00:00:00.000Z_2017-02-01T00:00:00.000Z_version_new_1", (Object)identifier3.toString());
        Assert.assertEquals((long)1L, (long)identifier3.getShardSpec().getNumCorePartitions());
        this.markAllSegmentsUnused((Set<DataSegment>)ImmutableSet.of((Object)segment), DateTimes.nowUtc());
        SegmentIdWithShardSpec identifier4 = this.coordinator.allocatePendingSegment("ds", "seq5", identifier1.toString(), interval, (PartialShardSpec)partialShardSpec, maxVersion, true);
        Assert.assertEquals((Object)"ds_2017-01-01T00:00:00.000Z_2017-02-01T00:00:00.000Z_version_new_2", (Object)identifier4.toString());
        Assert.assertEquals((long)0L, (long)identifier4.getShardSpec().getNumCorePartitions());
    }

    @Test
    public void testAnotherAllocatePendingSegmentAfterRevertingCompaction() {
        String maxVersion = "Z";
        NumberedPartialShardSpec partialShardSpec = NumberedPartialShardSpec.instance();
        String dataSource = "ds";
        Interval interval = Intervals.of((String)"2017-01-01/2017-02-01");
        SegmentIdWithShardSpec identifier = this.coordinator.allocatePendingSegment("ds", "seq", null, interval, (PartialShardSpec)partialShardSpec, "A", true);
        Assert.assertEquals((Object)"ds_2017-01-01T00:00:00.000Z_2017-02-01T00:00:00.000Z_A", (Object)identifier.toString());
        DataSegment segment = new DataSegment("ds", Intervals.of((String)"2017-01-01T00Z/2017-02-01T00Z"), "A", (Map)ImmutableMap.of(), (List)ImmutableList.of((Object)"dim1"), (List)ImmutableList.of((Object)"m1"), (ShardSpec)new LinearShardSpec(Integer.valueOf(0)), Integer.valueOf(9), 100L);
        Assert.assertTrue((boolean)this.insertUsedSegments((Set<DataSegment>)ImmutableSet.of((Object)segment)));
        List<String> ids = this.retrieveUsedSegmentIds();
        Assert.assertEquals((Object)"ds_2017-01-01T00:00:00.000Z_2017-02-01T00:00:00.000Z_A", (Object)ids.get(0));
        SegmentIdWithShardSpec identifier1 = this.coordinator.allocatePendingSegment("ds", "seq2", identifier.toString(), interval, (PartialShardSpec)partialShardSpec, maxVersion, true);
        Assert.assertEquals((Object)"ds_2017-01-01T00:00:00.000Z_2017-02-01T00:00:00.000Z_A_1", (Object)identifier1.toString());
        segment = new DataSegment("ds", Intervals.of((String)"2017-01-01T00Z/2017-02-01T00Z"), "A", (Map)ImmutableMap.of(), (List)ImmutableList.of((Object)"dim1"), (List)ImmutableList.of((Object)"m1"), (ShardSpec)new LinearShardSpec(Integer.valueOf(1)), Integer.valueOf(9), 100L);
        Assert.assertTrue((boolean)this.insertUsedSegments((Set<DataSegment>)ImmutableSet.of((Object)segment)));
        ids = this.retrieveUsedSegmentIds();
        Assert.assertEquals((Object)"ds_2017-01-01T00:00:00.000Z_2017-02-01T00:00:00.000Z_A_1", (Object)ids.get(1));
        SegmentIdWithShardSpec identifier2 = this.coordinator.allocatePendingSegment("ds", "seq3", identifier1.toString(), interval, (PartialShardSpec)partialShardSpec, maxVersion, true);
        Assert.assertEquals((Object)"ds_2017-01-01T00:00:00.000Z_2017-02-01T00:00:00.000Z_A_2", (Object)identifier2.toString());
        segment = new DataSegment("ds", Intervals.of((String)"2017-01-01T00Z/2017-02-01T00Z"), "A", (Map)ImmutableMap.of(), (List)ImmutableList.of((Object)"dim1"), (List)ImmutableList.of((Object)"m1"), (ShardSpec)new LinearShardSpec(Integer.valueOf(2)), Integer.valueOf(9), 100L);
        Assert.assertTrue((boolean)this.insertUsedSegments((Set<DataSegment>)ImmutableSet.of((Object)segment)));
        ids = this.retrieveUsedSegmentIds();
        Assert.assertEquals((Object)"ds_2017-01-01T00:00:00.000Z_2017-02-01T00:00:00.000Z_A_2", (Object)ids.get(2));
        DataSegment compactedSegment = new DataSegment("ds", Intervals.of((String)"2017-01-01T00Z/2017-02-01T00Z"), "B", (Map)ImmutableMap.of(), (List)ImmutableList.of((Object)"dim1"), (List)ImmutableList.of((Object)"m1"), (ShardSpec)new LinearShardSpec(Integer.valueOf(0)), Integer.valueOf(9), 100L);
        Assert.assertTrue((boolean)this.insertUsedSegments((Set<DataSegment>)ImmutableSet.of((Object)compactedSegment)));
        ids = this.retrieveUsedSegmentIds();
        Assert.assertEquals((Object)"ds_2017-01-01T00:00:00.000Z_2017-02-01T00:00:00.000Z_B", (Object)ids.get(3));
        SegmentIdWithShardSpec identifier3 = this.coordinator.allocatePendingSegment("ds", "seq4", identifier2.toString(), interval, (PartialShardSpec)partialShardSpec, maxVersion, true);
        Assert.assertEquals((Object)"ds_2017-01-01T00:00:00.000Z_2017-02-01T00:00:00.000Z_B_1", (Object)identifier3.toString());
        this.markAllSegmentsUnused((Set<DataSegment>)ImmutableSet.of((Object)compactedSegment), DateTimes.nowUtc());
        List<String> pendings = this.retrievePendingSegmentIds();
        Assert.assertEquals((long)4L, (long)pendings.size());
        List<String> used = this.retrieveUsedSegmentIds();
        Assert.assertEquals((long)3L, (long)used.size());
        List<String> unused = this.retrieveUnusedSegmentIds();
        Assert.assertEquals((long)1L, (long)unused.size());
        SegmentIdWithShardSpec identifier4 = this.coordinator.allocatePendingSegment("ds", "seq5", identifier1.toString(), interval, (PartialShardSpec)partialShardSpec, maxVersion, true);
        Assert.assertEquals((Object)"ds_2017-01-01T00:00:00.000Z_2017-02-01T00:00:00.000Z_A_3", (Object)identifier4.toString());
        segment = new DataSegment("ds", Intervals.of((String)"2017-01-01T00Z/2017-02-01T00Z"), "A", (Map)ImmutableMap.of(), (List)ImmutableList.of((Object)"dim1"), (List)ImmutableList.of((Object)"m1"), (ShardSpec)new LinearShardSpec(Integer.valueOf(3)), Integer.valueOf(9), 100L);
        Assert.assertTrue((boolean)this.insertUsedSegments((Set<DataSegment>)ImmutableSet.of((Object)segment)));
        ids = this.retrieveUsedSegmentIds();
        Assert.assertEquals((Object)"ds_2017-01-01T00:00:00.000Z_2017-02-01T00:00:00.000Z_A_3", (Object)ids.get(3));
    }

    @Test
    public void testAllocatePendingSegments() {
        NumberedPartialShardSpec partialShardSpec = NumberedPartialShardSpec.instance();
        String dataSource = "ds";
        Interval interval = Intervals.of((String)"2017-01-01/2017-02-01");
        String sequenceName = "seq";
        SegmentCreateRequest request = new SegmentCreateRequest("seq", null, "v1", (PartialShardSpec)partialShardSpec);
        SegmentIdWithShardSpec segmentId0 = (SegmentIdWithShardSpec)this.coordinator.allocatePendingSegments("ds", interval, false, Collections.singletonList(request)).get(request);
        Assert.assertEquals((Object)"ds_2017-01-01T00:00:00.000Z_2017-02-01T00:00:00.000Z_v1", (Object)segmentId0.toString());
        SegmentCreateRequest request1 = new SegmentCreateRequest("seq", segmentId0.toString(), segmentId0.getVersion(), (PartialShardSpec)partialShardSpec);
        SegmentIdWithShardSpec segmentId1 = (SegmentIdWithShardSpec)this.coordinator.allocatePendingSegments("ds", interval, false, Collections.singletonList(request1)).get(request1);
        Assert.assertEquals((Object)"ds_2017-01-01T00:00:00.000Z_2017-02-01T00:00:00.000Z_v1_1", (Object)segmentId1.toString());
        SegmentCreateRequest request2 = new SegmentCreateRequest("seq", segmentId1.toString(), segmentId1.getVersion(), (PartialShardSpec)partialShardSpec);
        SegmentIdWithShardSpec segmentId2 = (SegmentIdWithShardSpec)this.coordinator.allocatePendingSegments("ds", interval, false, Collections.singletonList(request2)).get(request2);
        Assert.assertEquals((Object)"ds_2017-01-01T00:00:00.000Z_2017-02-01T00:00:00.000Z_v1_2", (Object)segmentId2.toString());
        SegmentCreateRequest request3 = new SegmentCreateRequest("seq", segmentId1.toString(), segmentId1.getVersion(), (PartialShardSpec)partialShardSpec);
        SegmentIdWithShardSpec segmentId3 = (SegmentIdWithShardSpec)this.coordinator.allocatePendingSegments("ds", interval, false, Collections.singletonList(request3)).get(request3);
        Assert.assertEquals((Object)"ds_2017-01-01T00:00:00.000Z_2017-02-01T00:00:00.000Z_v1_2", (Object)segmentId3.toString());
        Assert.assertEquals((Object)segmentId2, (Object)segmentId3);
        SegmentCreateRequest request4 = new SegmentCreateRequest("seq1", null, "v1", (PartialShardSpec)partialShardSpec);
        SegmentIdWithShardSpec segmentId4 = (SegmentIdWithShardSpec)this.coordinator.allocatePendingSegments("ds", interval, false, Collections.singletonList(request4)).get(request4);
        Assert.assertEquals((Object)"ds_2017-01-01T00:00:00.000Z_2017-02-01T00:00:00.000Z_v1_3", (Object)segmentId4.toString());
    }

    @Test
    public void testNoPendingSegmentsAndOneUsedSegment() {
        String maxVersion = "Z";
        DataSegment segment = new DataSegment("ds", Intervals.of((String)"2017-01-01T00Z/2017-02-01T00Z"), "A", (Map)ImmutableMap.of(), (List)ImmutableList.of((Object)"dim1"), (List)ImmutableList.of((Object)"m1"), (ShardSpec)new LinearShardSpec(Integer.valueOf(0)), Integer.valueOf(9), 100L);
        Assert.assertTrue((boolean)this.insertUsedSegments((Set<DataSegment>)ImmutableSet.of((Object)segment)));
        List<String> ids = this.retrieveUsedSegmentIds();
        Assert.assertEquals((Object)"ds_2017-01-01T00:00:00.000Z_2017-02-01T00:00:00.000Z_A", (Object)ids.get(0));
        NumberedPartialShardSpec partialShardSpec = NumberedPartialShardSpec.instance();
        String dataSource = "ds";
        Interval interval = Intervals.of((String)"2017-01-01/2017-02-01");
        SegmentIdWithShardSpec identifier = this.coordinator.allocatePendingSegment("ds", "seq", null, interval, (PartialShardSpec)partialShardSpec, maxVersion, true);
        Assert.assertEquals((Object)"ds_2017-01-01T00:00:00.000Z_2017-02-01T00:00:00.000Z_A_1", (Object)identifier.toString());
    }

    @Test
    public void testDeletePendingSegment() throws InterruptedException {
        NumberedPartialShardSpec partialShardSpec = NumberedPartialShardSpec.instance();
        String dataSource = "ds";
        Interval interval = Intervals.of((String)"2017-01-01/2017-02-01");
        String prevSegmentId = null;
        DateTime begin = DateTimes.nowUtc();
        for (int i = 0; i < 10; ++i) {
            SegmentIdWithShardSpec identifier = this.coordinator.allocatePendingSegment("ds", "seq", prevSegmentId, interval, (PartialShardSpec)partialShardSpec, "version", false);
            prevSegmentId = identifier.toString();
        }
        Thread.sleep(100L);
        DateTime secondBegin = DateTimes.nowUtc();
        for (int i = 0; i < 5; ++i) {
            SegmentIdWithShardSpec identifier = this.coordinator.allocatePendingSegment("ds", "seq", prevSegmentId, interval, (PartialShardSpec)partialShardSpec, "version", false);
            prevSegmentId = identifier.toString();
        }
        int numDeleted = this.coordinator.deletePendingSegmentsCreatedInInterval("ds", new Interval((ReadableInstant)begin, (ReadableInstant)secondBegin));
        Assert.assertEquals((long)10L, (long)numDeleted);
    }

    @Test
    public void testAllocatePendingSegmentsWithOvershadowingSegments() throws IOException {
        String dataSource = "ds";
        Interval interval = Intervals.of((String)"2017-01-01/2017-02-01");
        String prevSegmentId = null;
        for (int i = 0; i < 10; ++i) {
            SegmentIdWithShardSpec identifier = this.coordinator.allocatePendingSegment("ds", "seq", prevSegmentId, interval, (PartialShardSpec)new NumberedOverwritePartialShardSpec(0, 1, (short)(i + 1)), "version", false);
            Assert.assertEquals((Object)StringUtils.format((String)"ds_2017-01-01T00:00:00.000Z_2017-02-01T00:00:00.000Z_version%s", (Object[])new Object[]{"_" + (i + 32768)}), (Object)identifier.toString());
            prevSegmentId = identifier.toString();
            Set<DataSegment> toBeAnnounced = Collections.singleton(new DataSegment(identifier.getDataSource(), identifier.getInterval(), identifier.getVersion(), null, Collections.emptyList(), Collections.emptyList(), (ShardSpec)((NumberedOverwriteShardSpec)identifier.getShardSpec()).withAtomicUpdateGroupSize(1), Integer.valueOf(0), 10L));
            Set announced = this.coordinator.commitSegments(toBeAnnounced);
            Assert.assertEquals(toBeAnnounced, (Object)announced);
        }
        Collection visibleSegments = this.coordinator.retrieveUsedSegmentsForInterval("ds", interval, Segments.ONLY_VISIBLE);
        Assert.assertEquals((long)1L, (long)visibleSegments.size());
        Assert.assertEquals((Object)new DataSegment("ds", interval, "version", null, Collections.emptyList(), Collections.emptyList(), (ShardSpec)new NumberedOverwriteShardSpec(32777, 0, 1, 9, 1), Integer.valueOf(0), 10L), (Object)Iterables.getOnlyElement((Iterable)visibleSegments));
    }

    @Test
    public void testAllocatePendingSegmentsForHashBasedNumberedShardSpec() throws IOException {
        HashBasedNumberedPartialShardSpec partialShardSpec = new HashBasedNumberedPartialShardSpec(null, 2, 5, null);
        String dataSource = "ds";
        Interval interval = Intervals.of((String)"2017-01-01/2017-02-01");
        SegmentIdWithShardSpec id = this.coordinator.allocatePendingSegment("ds", "seq", null, interval, (PartialShardSpec)partialShardSpec, "version", true);
        HashBasedNumberedShardSpec shardSpec = (HashBasedNumberedShardSpec)id.getShardSpec();
        Assert.assertEquals((long)0L, (long)shardSpec.getPartitionNum());
        Assert.assertEquals((long)0L, (long)shardSpec.getNumCorePartitions());
        Assert.assertEquals((long)5L, (long)shardSpec.getNumBuckets());
        this.coordinator.commitSegments(Collections.singleton(new DataSegment(id.getDataSource(), id.getInterval(), id.getVersion(), null, Collections.emptyList(), Collections.emptyList(), id.getShardSpec(), Integer.valueOf(0), 10L)));
        id = this.coordinator.allocatePendingSegment("ds", "seq2", null, interval, (PartialShardSpec)partialShardSpec, "version", true);
        shardSpec = (HashBasedNumberedShardSpec)id.getShardSpec();
        Assert.assertEquals((long)1L, (long)shardSpec.getPartitionNum());
        Assert.assertEquals((long)0L, (long)shardSpec.getNumCorePartitions());
        Assert.assertEquals((long)5L, (long)shardSpec.getNumBuckets());
        this.coordinator.commitSegments(Collections.singleton(new DataSegment(id.getDataSource(), id.getInterval(), id.getVersion(), null, Collections.emptyList(), Collections.emptyList(), id.getShardSpec(), Integer.valueOf(0), 10L)));
        id = this.coordinator.allocatePendingSegment("ds", "seq3", null, interval, (PartialShardSpec)new HashBasedNumberedPartialShardSpec(null, 2, 3, null), "version", true);
        shardSpec = (HashBasedNumberedShardSpec)id.getShardSpec();
        Assert.assertEquals((long)2L, (long)shardSpec.getPartitionNum());
        Assert.assertEquals((long)0L, (long)shardSpec.getNumCorePartitions());
        Assert.assertEquals((long)3L, (long)shardSpec.getNumBuckets());
    }

    @Test
    public void testAddNumberedShardSpecAfterMultiDimensionsShardSpecWithUnknownCorePartitionSize() throws IOException {
        String datasource = "datasource";
        Interval interval = Intervals.of((String)"2020-01-01/P1D");
        String version = "version";
        ImmutableList dimensions = ImmutableList.of((Object)"dim");
        ImmutableList metrics = ImmutableList.of((Object)"met");
        HashSet<DataSegment> originalSegments = new HashSet<DataSegment>();
        for (int i = 0; i < 6; ++i) {
            originalSegments.add(new DataSegment("datasource", interval, "version", (Map)ImmutableMap.of(), (List)dimensions, (List)metrics, (ShardSpec)new DimensionRangeShardSpec(Collections.singletonList("dim"), i == 0 ? null : StringTuple.create((String[])new String[]{String.valueOf(i - 1)}), i == 5 ? null : StringTuple.create((String[])new String[]{String.valueOf(i)}), i, null), Integer.valueOf(9), 10L));
        }
        this.coordinator.commitSegments(originalSegments);
        SegmentIdWithShardSpec id = this.coordinator.allocatePendingSegment("datasource", "seq", null, interval, (PartialShardSpec)NumberedPartialShardSpec.instance(), "version", false);
        Assert.assertNull((Object)id);
    }

    @Test
    public void testAddNumberedShardSpecAfterSingleDimensionsShardSpecWithUnknownCorePartitionSize() throws IOException {
        String datasource = "datasource";
        Interval interval = Intervals.of((String)"2020-01-01/P1D");
        String version = "version";
        ImmutableList dimensions = ImmutableList.of((Object)"dim");
        ImmutableList metrics = ImmutableList.of((Object)"met");
        HashSet<DataSegment> originalSegments = new HashSet<DataSegment>();
        for (int i = 0; i < 6; ++i) {
            String start = i == 0 ? null : String.valueOf(i - 1);
            String end = i == 5 ? null : String.valueOf(i);
            originalSegments.add(new DataSegment("datasource", interval, "version", (Map)ImmutableMap.of(), (List)dimensions, (List)metrics, (ShardSpec)new SingleDimensionShardSpec("dim", start, end, i, null), Integer.valueOf(9), 10L));
        }
        this.coordinator.commitSegments(originalSegments);
        SegmentIdWithShardSpec id = this.coordinator.allocatePendingSegment("datasource", "seq", null, interval, (PartialShardSpec)NumberedPartialShardSpec.instance(), "version", false);
        Assert.assertNull((Object)id);
    }

    @Test
    public void testRemoveDataSourceMetadataOlderThanDatasourceActiveShouldNotBeDeleted() throws Exception {
        this.coordinator.commitSegmentsAndMetadata((Set)ImmutableSet.of((Object)this.defaultSegment), (DataSourceMetadata)new ObjectMetadata(null), (DataSourceMetadata)new ObjectMetadata((Object)ImmutableMap.of((Object)"foo", (Object)"bar")));
        Assert.assertEquals((Object)new ObjectMetadata((Object)ImmutableMap.of((Object)"foo", (Object)"bar")), (Object)this.coordinator.retrieveDataSourceMetadata("fooDataSource"));
        int deletedCount = this.coordinator.removeDataSourceMetadataOlderThan(System.currentTimeMillis(), (Set)ImmutableSet.of((Object)"fooDataSource"));
        Assert.assertEquals((Object)new ObjectMetadata((Object)ImmutableMap.of((Object)"foo", (Object)"bar")), (Object)this.coordinator.retrieveDataSourceMetadata("fooDataSource"));
        Assert.assertEquals((long)0L, (long)deletedCount);
    }

    @Test
    public void testRemoveDataSourceMetadataOlderThanDatasourceNotActiveAndOlderThanTimeShouldBeDeleted() throws Exception {
        this.coordinator.commitSegmentsAndMetadata((Set)ImmutableSet.of((Object)this.defaultSegment), (DataSourceMetadata)new ObjectMetadata(null), (DataSourceMetadata)new ObjectMetadata((Object)ImmutableMap.of((Object)"foo", (Object)"bar")));
        Assert.assertEquals((Object)new ObjectMetadata((Object)ImmutableMap.of((Object)"foo", (Object)"bar")), (Object)this.coordinator.retrieveDataSourceMetadata("fooDataSource"));
        int deletedCount = this.coordinator.removeDataSourceMetadataOlderThan(System.currentTimeMillis(), (Set)ImmutableSet.of());
        Assert.assertNull((Object)this.coordinator.retrieveDataSourceMetadata("fooDataSource"));
        Assert.assertEquals((long)1L, (long)deletedCount);
    }

    @Test
    public void testRemoveDataSourceMetadataOlderThanDatasourceNotActiveButNotOlderThanTimeShouldNotBeDeleted() throws Exception {
        this.coordinator.commitSegmentsAndMetadata((Set)ImmutableSet.of((Object)this.defaultSegment), (DataSourceMetadata)new ObjectMetadata(null), (DataSourceMetadata)new ObjectMetadata((Object)ImmutableMap.of((Object)"foo", (Object)"bar")));
        Assert.assertEquals((Object)new ObjectMetadata((Object)ImmutableMap.of((Object)"foo", (Object)"bar")), (Object)this.coordinator.retrieveDataSourceMetadata("fooDataSource"));
        int deletedCount = this.coordinator.removeDataSourceMetadataOlderThan(DateTimes.of((String)"2012-01-01T00:00:00Z").getMillis(), (Set)ImmutableSet.of());
        Assert.assertEquals((Object)new ObjectMetadata((Object)ImmutableMap.of((Object)"foo", (Object)"bar")), (Object)this.coordinator.retrieveDataSourceMetadata("fooDataSource"));
        Assert.assertEquals((long)0L, (long)deletedCount);
    }

    @Test
    public void testMarkSegmentsAsUnusedWithinIntervalOneYear() throws IOException {
        this.coordinator.commitSegments((Set)ImmutableSet.of((Object)this.existingSegment1, (Object)this.existingSegment2));
        this.coordinator.markSegmentsAsUnusedWithinInterval(this.existingSegment1.getDataSource(), Intervals.of((String)"1994-01-01/1994-01-02T12Z"));
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.existingSegment1), (Object)ImmutableSet.copyOf((Collection)this.coordinator.retrieveUnusedSegmentsForInterval(this.existingSegment1.getDataSource(), this.existingSegment1.getInterval().withEnd((ReadableInstant)this.existingSegment1.getInterval().getEnd().plus(1L)), null, null)));
        Assert.assertEquals((Object)ImmutableSet.of(), (Object)ImmutableSet.copyOf((Collection)this.coordinator.retrieveUnusedSegmentsForInterval(this.existingSegment2.getDataSource(), this.existingSegment2.getInterval().withEnd((ReadableInstant)this.existingSegment2.getInterval().getEnd().plusYears(1)), null, null)));
    }

    @Test
    public void testMarkSegmentsAsUnusedWithinIntervalTwoYears() throws IOException {
        this.coordinator.commitSegments((Set)ImmutableSet.of((Object)this.existingSegment1, (Object)this.existingSegment2));
        this.coordinator.markSegmentsAsUnusedWithinInterval(this.existingSegment1.getDataSource(), Intervals.of((String)"1993-12-31T12Z/1994-01-02T12Z"));
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.existingSegment1), (Object)ImmutableSet.copyOf((Collection)this.coordinator.retrieveUnusedSegmentsForInterval(this.existingSegment1.getDataSource(), this.existingSegment1.getInterval().withEnd((ReadableInstant)this.existingSegment1.getInterval().getEnd().plus(1L)), null, null)));
        Assert.assertEquals((Object)ImmutableSet.of(), (Object)ImmutableSet.copyOf((Collection)this.coordinator.retrieveUnusedSegmentsForInterval(this.existingSegment2.getDataSource(), this.existingSegment2.getInterval().withEnd((ReadableInstant)this.existingSegment2.getInterval().getEnd().plusYears(1)), null, null)));
    }

    @Test
    public void testGetPendingSegmentsForIntervalWithSequencePrefixes() {
        Pair validIntervalValidSequence = Pair.of((Object)SegmentIdWithShardSpec.fromDataSegment((DataSegment)this.defaultSegment), (Object)"validLOL");
        this.insertPendingSegmentAndSequenceName((Pair<SegmentIdWithShardSpec, String>)validIntervalValidSequence);
        Pair validIntervalInvalidSequence = Pair.of((Object)SegmentIdWithShardSpec.fromDataSegment((DataSegment)this.defaultSegment2), (Object)"invalidRandom");
        this.insertPendingSegmentAndSequenceName((Pair<SegmentIdWithShardSpec, String>)validIntervalInvalidSequence);
        Pair invalidIntervalvalidSequence = Pair.of((Object)SegmentIdWithShardSpec.fromDataSegment((DataSegment)this.existingSegment1), (Object)"validStuff");
        this.insertPendingSegmentAndSequenceName((Pair<SegmentIdWithShardSpec, String>)invalidIntervalvalidSequence);
        Pair twentyFifteenWithAnotherValidSequence = Pair.of((Object)new SegmentIdWithShardSpec(this.existingSegment1.getDataSource(), Intervals.of((String)"2015/2016"), "1970-01-01", (ShardSpec)new NumberedShardSpec(1, 0)), (Object)"alsoValidAgain");
        this.insertPendingSegmentAndSequenceName((Pair<SegmentIdWithShardSpec, String>)twentyFifteenWithAnotherValidSequence);
        Pair twentyFifteenWithInvalidSequence = Pair.of((Object)new SegmentIdWithShardSpec(this.existingSegment1.getDataSource(), Intervals.of((String)"2015/2016"), "1970-01-01", (ShardSpec)new NumberedShardSpec(2, 0)), (Object)"definitelyInvalid");
        this.insertPendingSegmentAndSequenceName((Pair<SegmentIdWithShardSpec, String>)twentyFifteenWithInvalidSequence);
        HashMap<SegmentIdWithShardSpec, String> expected = new HashMap<SegmentIdWithShardSpec, String>();
        expected.put((SegmentIdWithShardSpec)validIntervalValidSequence.lhs, (String)validIntervalValidSequence.rhs);
        expected.put((SegmentIdWithShardSpec)twentyFifteenWithAnotherValidSequence.lhs, (String)twentyFifteenWithAnotherValidSequence.rhs);
        Map actual = (Map)this.derbyConnector.retryWithHandle(handle -> this.coordinator.getPendingSegmentsForIntervalWithHandle(handle, this.defaultSegment.getDataSource(), this.defaultSegment.getInterval(), (Set)ImmutableSet.of((Object)"valid", (Object)"alsoValid")));
        Assert.assertEquals(expected, (Object)actual);
    }

    @Test
    public void testRetrieveUsedSegmentsAndCreatedDates() {
        this.insertUsedSegments((Set<DataSegment>)ImmutableSet.of((Object)this.defaultSegment));
        List resultForIntervalOnTheLeft = this.coordinator.retrieveUsedSegmentsAndCreatedDates(this.defaultSegment.getDataSource(), Collections.singletonList(Intervals.of((String)"2000/2001")));
        Assert.assertTrue((boolean)resultForIntervalOnTheLeft.isEmpty());
        List resultForIntervalOnTheRight = this.coordinator.retrieveUsedSegmentsAndCreatedDates(this.defaultSegment.getDataSource(), Collections.singletonList(Intervals.of((String)"3000/3001")));
        Assert.assertTrue((boolean)resultForIntervalOnTheRight.isEmpty());
        List resultForExactInterval = this.coordinator.retrieveUsedSegmentsAndCreatedDates(this.defaultSegment.getDataSource(), Collections.singletonList(this.defaultSegment.getInterval()));
        Assert.assertEquals((long)1L, (long)resultForExactInterval.size());
        Assert.assertEquals((Object)this.defaultSegment, (Object)((Pair)resultForExactInterval.get((int)0)).lhs);
        List resultForIntervalWithLeftOverlap = this.coordinator.retrieveUsedSegmentsAndCreatedDates(this.defaultSegment.getDataSource(), Collections.singletonList(Intervals.of((String)"2000/2015-01-02")));
        Assert.assertEquals((Object)resultForExactInterval, (Object)resultForIntervalWithLeftOverlap);
        List resultForIntervalWithRightOverlap = this.coordinator.retrieveUsedSegmentsAndCreatedDates(this.defaultSegment.getDataSource(), Collections.singletonList(Intervals.of((String)"2015-01-01/3000")));
        Assert.assertEquals((Object)resultForExactInterval, (Object)resultForIntervalWithRightOverlap);
        List resultForEternity = this.coordinator.retrieveUsedSegmentsAndCreatedDates(this.defaultSegment.getDataSource(), Collections.singletonList(Intervals.ETERNITY));
        Assert.assertEquals((Object)resultForExactInterval, (Object)resultForEternity);
        List resultForFirstHalfEternity = this.coordinator.retrieveUsedSegmentsAndCreatedDates(this.defaultSegment.getDataSource(), Collections.singletonList(this.firstHalfEternityRangeSegment.getInterval()));
        Assert.assertEquals((Object)resultForExactInterval, (Object)resultForFirstHalfEternity);
        List resultForSecondHalfEternity = this.coordinator.retrieveUsedSegmentsAndCreatedDates(this.defaultSegment.getDataSource(), Collections.singletonList(this.secondHalfEternityRangeSegment.getInterval()));
        Assert.assertEquals((Object)resultForExactInterval, (Object)resultForSecondHalfEternity);
    }

    @Test
    public void testRetrieveUsedSegmentsAndCreatedDatesFetchesEternityForAnyInterval() {
        this.insertUsedSegments((Set<DataSegment>)ImmutableSet.of((Object)this.eternitySegment, (Object)this.firstHalfEternityRangeSegment, (Object)this.secondHalfEternityRangeSegment));
        List resultForRandomInterval = this.coordinator.retrieveUsedSegmentsAndCreatedDates(this.defaultSegment.getDataSource(), Collections.singletonList(this.defaultSegment.getInterval()));
        Assert.assertEquals((long)3L, (long)resultForRandomInterval.size());
        List resultForEternity = this.coordinator.retrieveUsedSegmentsAndCreatedDates(this.defaultSegment.getDataSource(), Collections.singletonList(this.eternitySegment.getInterval()));
        Assert.assertEquals((long)3L, (long)resultForEternity.size());
        List resultForFirstHalfEternity = this.coordinator.retrieveUsedSegmentsAndCreatedDates(this.defaultSegment.getDataSource(), Collections.singletonList(this.firstHalfEternityRangeSegment.getInterval()));
        Assert.assertEquals((long)3L, (long)resultForFirstHalfEternity.size());
        List resultForSecondHalfEternity = this.coordinator.retrieveUsedSegmentsAndCreatedDates(this.defaultSegment.getDataSource(), Collections.singletonList(this.secondHalfEternityRangeSegment.getInterval()));
        Assert.assertEquals((long)3L, (long)resultForSecondHalfEternity.size());
    }

    @Test
    public void testTimelineVisibilityWith0CorePartitionTombstone() throws IOException {
        Interval interval = Intervals.of((String)"2020/2021");
        DataSegment tombstoneSegment = this.createSegment(interval, "version", (ShardSpec)new TombstoneShardSpec());
        HashSet<DataSegment> tombstones = new HashSet<DataSegment>(Collections.singleton(tombstoneSegment));
        Assert.assertTrue((boolean)this.coordinator.commitSegments(tombstones).containsAll(tombstones));
        SegmentIdWithShardSpec identifier = this.coordinator.allocatePendingSegment("wiki", "seq", tombstoneSegment.getVersion(), interval, (PartialShardSpec)NumberedPartialShardSpec.instance(), "version", false);
        Assert.assertEquals((Object)"wiki_2020-01-01T00:00:00.000Z_2021-01-01T00:00:00.000Z_version_1", (Object)identifier.toString());
        Assert.assertEquals((long)0L, (long)identifier.getShardSpec().getNumCorePartitions());
        DataSegment dataSegment = this.createSegment(interval, "version", identifier.getShardSpec());
        HashSet<DataSegment> dataSegments = new HashSet<DataSegment>(Collections.singleton(dataSegment));
        Assert.assertTrue((boolean)this.coordinator.commitSegments(dataSegments).containsAll(dataSegments));
        this.markAllSegmentsUnused(tombstones, DateTimes.nowUtc());
        Collection allUsedSegments = this.coordinator.retrieveAllUsedSegments("wiki", Segments.ONLY_VISIBLE);
        SegmentTimeline segmentTimeline = SegmentTimeline.forSegments((Iterable)allUsedSegments);
        Assert.assertEquals((long)1L, (long)segmentTimeline.lookup(interval).size());
        Assert.assertEquals((Object)dataSegment, (Object)((TimelineObjectHolder)segmentTimeline.lookup(interval).get(0)).getObject().getChunk(1).getObject());
    }

    @Test
    public void testTimelineWith1CorePartitionTombstone() throws IOException {
        this.mapper.registerSubtypes(new Class[]{TombstoneShardSpecWith1CorePartition.class});
        Interval interval = Intervals.of((String)"2020/2021");
        DataSegment tombstoneSegment = this.createSegment(interval, "version", (ShardSpec)new TombstoneShardSpecWith1CorePartition());
        HashSet<DataSegment> tombstones = new HashSet<DataSegment>(Collections.singleton(tombstoneSegment));
        Assert.assertTrue((boolean)this.coordinator.commitSegments(tombstones).containsAll(tombstones));
        SegmentIdWithShardSpec identifier = this.coordinator.allocatePendingSegment("wiki", "seq", tombstoneSegment.getVersion(), interval, (PartialShardSpec)NumberedPartialShardSpec.instance(), "version", false);
        Assert.assertEquals((Object)"wiki_2020-01-01T00:00:00.000Z_2021-01-01T00:00:00.000Z_version_1", (Object)identifier.toString());
        Assert.assertEquals((long)1L, (long)identifier.getShardSpec().getNumCorePartitions());
        DataSegment dataSegment = this.createSegment(interval, "version", identifier.getShardSpec());
        HashSet<DataSegment> dataSegments = new HashSet<DataSegment>(Collections.singleton(dataSegment));
        Assert.assertTrue((boolean)this.coordinator.commitSegments(dataSegments).containsAll(dataSegments));
        this.markAllSegmentsUnused(tombstones, DateTimes.nowUtc());
        Collection allUsedSegments = this.coordinator.retrieveAllUsedSegments("wiki", Segments.ONLY_VISIBLE);
        SegmentTimeline segmentTimeline = SegmentTimeline.forSegments((Iterable)allUsedSegments);
        Assert.assertEquals((long)0L, (long)segmentTimeline.lookup(interval).size());
    }

    private DataSegment createSegment(Interval interval, String version, ShardSpec shardSpec) {
        return DataSegment.builder().dataSource("wiki").interval(interval).version(version).shardSpec(shardSpec).size(100L).build();
    }

    private List<DataSegment> createAndGetUsedYearSegments(int startYear, int endYear) throws IOException {
        ArrayList<DataSegment> segments = new ArrayList<DataSegment>();
        for (int year = startYear; year < endYear; ++year) {
            segments.add(this.createSegment(Intervals.of((String)"%d/%d", (Object[])new Object[]{year, year + 1}), "version", (ShardSpec)new LinearShardSpec(Integer.valueOf(0))));
        }
        HashSet segmentsSet = new HashSet(segments);
        Set committedSegments = this.coordinator.commitSegments(segmentsSet);
        Assert.assertTrue((boolean)committedSegments.containsAll(segmentsSet));
        return segments;
    }

    private ImmutableList<DataSegment> retrieveUnusedSegments(List<Interval> intervals, Integer limit, String lastSegmentId, SortOrder sortOrder, DateTime maxUsedStatusLastUpdatedTime) {
        return (ImmutableList)this.derbyConnector.inReadOnlyTransaction((handle, status) -> {
            try (CloseableIterator iterator = SqlSegmentsMetadataQuery.forHandle((Handle)handle, (SQLMetadataConnector)this.derbyConnector, (MetadataStorageTablesConfig)((MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get()), (ObjectMapper)this.mapper).retrieveUnusedSegments("wiki", (Collection)intervals, limit, lastSegmentId, sortOrder, maxUsedStatusLastUpdatedTime);){
                ImmutableList immutableList = ImmutableList.copyOf((Iterator)iterator);
                return immutableList;
            }
        });
    }

    private ImmutableList<DataSegmentPlus> retrieveUnusedSegmentsPlus(List<Interval> intervals, Integer limit, String lastSegmentId, SortOrder sortOrder, DateTime maxUsedStatusLastUpdatedTime) {
        return (ImmutableList)this.derbyConnector.inReadOnlyTransaction((handle, status) -> {
            try (CloseableIterator iterator = SqlSegmentsMetadataQuery.forHandle((Handle)handle, (SQLMetadataConnector)this.derbyConnector, (MetadataStorageTablesConfig)((MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get()), (ObjectMapper)this.mapper).retrieveUnusedSegmentsPlus("wiki", (Collection)intervals, limit, lastSegmentId, sortOrder, maxUsedStatusLastUpdatedTime);){
                ImmutableList immutableList = ImmutableList.copyOf((Iterator)iterator);
                return immutableList;
            }
        });
    }

    private void verifyContainsAllSegmentsPlus(List<DataSegment> expectedSegments, List<DataSegmentPlus> actualUnusedSegmentsPlus, DateTime usedStatusLastUpdatedTime) {
        Map expectedIdToSegment = expectedSegments.stream().collect(Collectors.toMap(DataSegment::getId, Function.identity()));
        Map actualIdToSegmentPlus = actualUnusedSegmentsPlus.stream().collect(Collectors.toMap(d -> d.getDataSegment().getId(), Function.identity()));
        Assert.assertTrue((boolean)expectedIdToSegment.entrySet().stream().allMatch(e -> {
            DataSegmentPlus segmentPlus = (DataSegmentPlus)actualIdToSegmentPlus.get(e.getKey());
            return segmentPlus != null && !segmentPlus.getCreatedDate().isAfter((ReadableInstant)usedStatusLastUpdatedTime) && segmentPlus.getUsedStatusLastUpdatedDate() != null && segmentPlus.getUsedStatusLastUpdatedDate().equals((Object)usedStatusLastUpdatedTime);
        }));
    }

    private void verifyEqualsAllSegmentsPlus(List<DataSegment> expectedSegments, List<DataSegmentPlus> actualUnusedSegmentsPlus, DateTime usedStatusLastUpdatedTime) {
        Assert.assertEquals((long)expectedSegments.size(), (long)actualUnusedSegmentsPlus.size());
        for (int i = 0; i < expectedSegments.size(); ++i) {
            DataSegment expectedSegment = expectedSegments.get(i);
            DataSegmentPlus actualSegmentPlus = actualUnusedSegmentsPlus.get(i);
            Assert.assertEquals((Object)expectedSegment.getId(), (Object)actualSegmentPlus.getDataSegment().getId());
            Assert.assertTrue((!actualSegmentPlus.getCreatedDate().isAfter((ReadableInstant)usedStatusLastUpdatedTime) && actualSegmentPlus.getUsedStatusLastUpdatedDate() != null && actualSegmentPlus.getUsedStatusLastUpdatedDate().equals((Object)usedStatusLastUpdatedTime) ? 1 : 0) != 0);
        }
    }

    private static class TombstoneShardSpecWith1CorePartition
    extends TombstoneShardSpec {
        private TombstoneShardSpecWith1CorePartition() {
        }

        @JsonProperty(value="partitions")
        public int getNumCorePartitions() {
            return 1;
        }
    }

    private static class DS {
        static final String WIKI = "wiki";

        private DS() {
        }
    }
}

