/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.expression;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.query.expression.LookupExprMacro;
import org.apache.druid.query.expression.TestExprMacroTable;
import org.apache.druid.query.extraction.MapLookupExtractor;
import org.apache.druid.query.lookup.LookupExtractor;
import org.apache.druid.query.lookup.LookupExtractorFactory;
import org.apache.druid.query.lookup.LookupExtractorFactoryContainer;
import org.apache.druid.query.lookup.LookupExtractorFactoryContainerProvider;
import org.apache.druid.query.lookup.LookupIntrospectHandler;

public class LookupEnabledTestExprMacroTable
extends ExprMacroTable {
    public static final ExprMacroTable INSTANCE = new LookupEnabledTestExprMacroTable();
    public static final String LOOKYLOO = "lookyloo";

    private LookupEnabledTestExprMacroTable() {
        super(LookupEnabledTestExprMacroTable.makeTestMacros((Map<String, String>)ImmutableMap.of((Object)"foo", (Object)"xfoo")));
    }

    public static List<ExprMacroTable.ExprMacro> makeTestMacros(Map<String, String> theLookup) {
        return Lists.newArrayList((Iterable)Iterables.concat((Iterable)TestExprMacroTable.INSTANCE.getMacros(), Collections.singletonList(new LookupExprMacro(LookupEnabledTestExprMacroTable.createTestLookupProvider((Map<String, LookupExtractor>)ImmutableMap.of((Object)LOOKYLOO, (Object)new MapLookupExtractor(theLookup, false)))))));
    }

    public static LookupExtractorFactoryContainerProvider createTestLookupProvider(final Map<String, LookupExtractor> lookups) {
        return new LookupExtractorFactoryContainerProvider(){

            public Set<String> getAllLookupNames() {
                return ImmutableSet.of((Object)LookupEnabledTestExprMacroTable.LOOKYLOO);
            }

            public Optional<LookupExtractorFactoryContainer> get(String lookupName) {
                LookupExtractor theLookup = (LookupExtractor)lookups.get(lookupName);
                if (theLookup != null) {
                    return Optional.of(new TestLookupContainer(theLookup));
                }
                return Optional.empty();
            }
        };
    }

    public static class TestLookupContainer
    extends LookupExtractorFactoryContainer {
        public TestLookupContainer(final LookupExtractor theLookup) {
            super("v0", new LookupExtractorFactory(){

                public boolean start() {
                    throw new UnsupportedOperationException();
                }

                public boolean close() {
                    throw new UnsupportedOperationException();
                }

                public boolean replaces(@Nullable LookupExtractorFactory other) {
                    throw new UnsupportedOperationException();
                }

                public LookupIntrospectHandler getIntrospectHandler() {
                    throw new UnsupportedOperationException();
                }

                public void awaitInitialization() {
                }

                public boolean isInitialized() {
                    return true;
                }

                public LookupExtractor get() {
                    return theLookup;
                }
            });
        }
    }
}

