/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.metadata;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.druid.client.CoordinatorServerView;
import org.apache.druid.client.DruidServer;
import org.apache.druid.client.InternalQueryConfig;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.metrics.StubServiceEmitter;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.Query;
import org.apache.druid.query.QuerySegmentWalker;
import org.apache.druid.query.TableDataSource;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.druid.query.aggregation.DoubleSumAggregatorFactory;
import org.apache.druid.query.aggregation.hyperloglog.HyperUniquesAggregatorFactory;
import org.apache.druid.query.metadata.metadata.AllColumnIncluderator;
import org.apache.druid.query.metadata.metadata.ColumnAnalysis;
import org.apache.druid.query.metadata.metadata.ColumnIncluderator;
import org.apache.druid.query.metadata.metadata.SegmentAnalysis;
import org.apache.druid.query.metadata.metadata.SegmentMetadataQuery;
import org.apache.druid.query.spec.MultipleSpecificSegmentSpec;
import org.apache.druid.query.spec.QuerySegmentSpec;
import org.apache.druid.segment.IndexBuilder;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.incremental.IncrementalIndexSchema;
import org.apache.druid.segment.metadata.AbstractSegmentMetadataCache;
import org.apache.druid.segment.metadata.AvailableSegmentMetadata;
import org.apache.druid.segment.metadata.CentralizedDatasourceSchemaConfig;
import org.apache.druid.segment.metadata.CoordinatorSegmentMetadataCache;
import org.apache.druid.segment.metadata.CoordinatorSegmentMetadataCacheCommon;
import org.apache.druid.segment.metadata.DataSourceInformation;
import org.apache.druid.segment.metadata.SegmentMetadataCacheConfig;
import org.apache.druid.segment.realtime.appenderator.SegmentSchemas;
import org.apache.druid.segment.writeout.OffHeapMemorySegmentWriteOutMediumFactory;
import org.apache.druid.segment.writeout.SegmentWriteOutMediumFactory;
import org.apache.druid.server.QueryLifecycle;
import org.apache.druid.server.QueryLifecycleFactory;
import org.apache.druid.server.QueryResponse;
import org.apache.druid.server.coordination.DruidServerMetadata;
import org.apache.druid.server.coordination.ServerType;
import org.apache.druid.server.metrics.NoopServiceEmitter;
import org.apache.druid.server.security.Access;
import org.apache.druid.server.security.AllowAllAuthenticator;
import org.apache.druid.server.security.Escalator;
import org.apache.druid.server.security.NoopEscalator;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.SegmentId;
import org.apache.druid.timeline.partition.LinearShardSpec;
import org.apache.druid.timeline.partition.ShardSpec;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CoordinatorSegmentMetadataCacheTest
extends CoordinatorSegmentMetadataCacheCommon {
    private static final ObjectMapper MAPPER = TestHelper.makeJsonMapper();
    private static final SegmentMetadataCacheConfig SEGMENT_CACHE_CONFIG_DEFAULT = SegmentMetadataCacheConfig.create((String)"PT1S");
    private CoordinatorSegmentMetadataCache runningSchema;
    private CountDownLatch buildTableLatch = new CountDownLatch(1);
    private CountDownLatch markDataSourceLatch = new CountDownLatch(1);

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
        if (this.runningSchema != null) {
            this.runningSchema.stop();
        }
    }

    public CoordinatorSegmentMetadataCache buildSchemaMarkAndTableLatch() throws InterruptedException {
        return this.buildSchemaMarkAndTableLatch(SEGMENT_CACHE_CONFIG_DEFAULT);
    }

    public CoordinatorSegmentMetadataCache buildSchemaMarkAndTableLatch(SegmentMetadataCacheConfig config) throws InterruptedException {
        Preconditions.checkState((this.runningSchema == null ? 1 : 0) != 0);
        this.runningSchema = new CoordinatorSegmentMetadataCache(this.getQueryLifecycleFactory((QuerySegmentWalker)this.walker), this.serverView, config, (Escalator)new NoopEscalator(), new InternalQueryConfig(), new NoopServiceEmitter(), CentralizedDatasourceSchemaConfig.create()){

            public RowSignature buildDataSourceRowSignature(String dataSource) {
                RowSignature table = super.buildDataSourceRowSignature(dataSource);
                CoordinatorSegmentMetadataCacheTest.this.buildTableLatch.countDown();
                return table;
            }

            public void markDataSourceAsNeedRebuild(String datasource) {
                super.markDataSourceAsNeedRebuild(datasource);
                CoordinatorSegmentMetadataCacheTest.this.markDataSourceLatch.countDown();
            }
        };
        this.runningSchema.start();
        this.runningSchema.awaitInitialization();
        return this.runningSchema;
    }

    @Test
    public void testGetTableMap() throws InterruptedException {
        CoordinatorSegmentMetadataCache schema = this.buildSchemaMarkAndTableLatch();
        Assert.assertEquals((Object)ImmutableSet.of((Object)"foo", (Object)"foo2", (Object)"some_datasource"), (Object)schema.getDatasourceNames());
        Set tableNames = schema.getDatasourceNames();
        Assert.assertEquals((Object)ImmutableSet.of((Object)"foo", (Object)"foo2", (Object)"some_datasource"), (Object)tableNames);
    }

    @Test
    public void testGetTableMapFoo() throws InterruptedException {
        CoordinatorSegmentMetadataCache schema = this.buildSchemaMarkAndTableLatch();
        DataSourceInformation fooDs = schema.getDatasource("foo");
        RowSignature fooRowSignature = fooDs.getRowSignature();
        List columnNames = fooRowSignature.getColumnNames();
        Assert.assertEquals((long)6L, (long)columnNames.size());
        Assert.assertEquals((Object)"__time", columnNames.get(0));
        Assert.assertEquals((Object)ColumnType.LONG, fooRowSignature.getColumnType((String)columnNames.get(0)).get());
        Assert.assertEquals((Object)"dim2", columnNames.get(1));
        Assert.assertEquals((Object)ColumnType.STRING, fooRowSignature.getColumnType((String)columnNames.get(1)).get());
        Assert.assertEquals((Object)"m1", columnNames.get(2));
        Assert.assertEquals((Object)ColumnType.DOUBLE, fooRowSignature.getColumnType((String)columnNames.get(2)).get());
        Assert.assertEquals((Object)"dim1", columnNames.get(3));
        Assert.assertEquals((Object)ColumnType.STRING, fooRowSignature.getColumnType((String)columnNames.get(3)).get());
        Assert.assertEquals((Object)"cnt", columnNames.get(4));
        Assert.assertEquals((Object)ColumnType.LONG, fooRowSignature.getColumnType((String)columnNames.get(4)).get());
        Assert.assertEquals((Object)"unique_dim1", columnNames.get(5));
        Assert.assertEquals((Object)ColumnType.ofComplex((String)"hyperUnique"), fooRowSignature.getColumnType((String)columnNames.get(5)).get());
    }

    @Test
    public void testGetTableMapFoo2() throws InterruptedException {
        CoordinatorSegmentMetadataCache schema = this.buildSchemaMarkAndTableLatch();
        DataSourceInformation fooDs = schema.getDatasource("foo2");
        RowSignature fooRowSignature = fooDs.getRowSignature();
        List columnNames = fooRowSignature.getColumnNames();
        Assert.assertEquals((long)3L, (long)columnNames.size());
        Assert.assertEquals((Object)"__time", columnNames.get(0));
        Assert.assertEquals((Object)ColumnType.LONG, fooRowSignature.getColumnType((String)columnNames.get(0)).get());
        Assert.assertEquals((Object)"dim2", columnNames.get(1));
        Assert.assertEquals((Object)ColumnType.STRING, fooRowSignature.getColumnType((String)columnNames.get(1)).get());
        Assert.assertEquals((Object)"m1", columnNames.get(2));
        Assert.assertEquals((Object)ColumnType.LONG, fooRowSignature.getColumnType((String)columnNames.get(2)).get());
    }

    @Test
    public void testGetTableMapSomeTable() throws InterruptedException {
        CoordinatorSegmentMetadataCache schema = this.buildSchemaMarkAndTableLatch(new SegmentMetadataCacheConfig(){

            public AbstractSegmentMetadataCache.ColumnTypeMergePolicy getMetadataColumnTypeMergePolicy() {
                return new AbstractSegmentMetadataCache.FirstTypeMergePolicy();
            }
        });
        DataSourceInformation fooDs = schema.getDatasource("some_datasource");
        RowSignature fooRowSignature = fooDs.getRowSignature();
        List columnNames = fooRowSignature.getColumnNames();
        Assert.assertEquals((long)9L, (long)columnNames.size());
        Assert.assertEquals((Object)"__time", columnNames.get(0));
        Assert.assertEquals((Object)ColumnType.LONG, fooRowSignature.getColumnType((String)columnNames.get(0)).get());
        Assert.assertEquals((Object)"numbery", columnNames.get(1));
        Assert.assertEquals((Object)ColumnType.LONG, fooRowSignature.getColumnType((String)columnNames.get(1)).get());
        Assert.assertEquals((Object)"numberyArrays", columnNames.get(2));
        Assert.assertEquals((Object)ColumnType.DOUBLE_ARRAY, fooRowSignature.getColumnType((String)columnNames.get(2)).get());
        Assert.assertEquals((Object)"stringy", columnNames.get(3));
        Assert.assertEquals((Object)ColumnType.STRING, fooRowSignature.getColumnType((String)columnNames.get(3)).get());
        Assert.assertEquals((Object)"array", columnNames.get(4));
        Assert.assertEquals((Object)ColumnType.LONG_ARRAY, fooRowSignature.getColumnType((String)columnNames.get(4)).get());
        Assert.assertEquals((Object)"nested", columnNames.get(5));
        Assert.assertEquals((Object)ColumnType.ofComplex((String)"json"), fooRowSignature.getColumnType((String)columnNames.get(5)).get());
        Assert.assertEquals((Object)"cnt", columnNames.get(6));
        Assert.assertEquals((Object)ColumnType.LONG, fooRowSignature.getColumnType((String)columnNames.get(6)).get());
        Assert.assertEquals((Object)"m1", columnNames.get(7));
        Assert.assertEquals((Object)ColumnType.DOUBLE, fooRowSignature.getColumnType((String)columnNames.get(7)).get());
        Assert.assertEquals((Object)"unique_dim1", columnNames.get(8));
        Assert.assertEquals((Object)ColumnType.ofComplex((String)"hyperUnique"), fooRowSignature.getColumnType((String)columnNames.get(8)).get());
    }

    @Test
    public void testGetTableMapSomeTableLeastRestrictiveTypeMerge() throws InterruptedException {
        CoordinatorSegmentMetadataCache schema = this.buildSchemaMarkAndTableLatch();
        DataSourceInformation fooDs = schema.getDatasource("some_datasource");
        RowSignature fooRowSignature = fooDs.getRowSignature();
        List columnNames = fooRowSignature.getColumnNames();
        Assert.assertEquals((long)9L, (long)columnNames.size());
        Assert.assertEquals((Object)"__time", columnNames.get(0));
        Assert.assertEquals((Object)ColumnType.LONG, fooRowSignature.getColumnType((String)columnNames.get(0)).get());
        Assert.assertEquals((Object)"numbery", columnNames.get(1));
        Assert.assertEquals((Object)ColumnType.DOUBLE, fooRowSignature.getColumnType((String)columnNames.get(1)).get());
        Assert.assertEquals((Object)"numberyArrays", columnNames.get(2));
        Assert.assertEquals((Object)ColumnType.DOUBLE_ARRAY, fooRowSignature.getColumnType((String)columnNames.get(2)).get());
        Assert.assertEquals((Object)"stringy", columnNames.get(3));
        Assert.assertEquals((Object)ColumnType.STRING_ARRAY, fooRowSignature.getColumnType((String)columnNames.get(3)).get());
        Assert.assertEquals((Object)"array", columnNames.get(4));
        Assert.assertEquals((Object)ColumnType.DOUBLE_ARRAY, fooRowSignature.getColumnType((String)columnNames.get(4)).get());
        Assert.assertEquals((Object)"nested", columnNames.get(5));
        Assert.assertEquals((Object)ColumnType.ofComplex((String)"json"), fooRowSignature.getColumnType((String)columnNames.get(5)).get());
        Assert.assertEquals((Object)"cnt", columnNames.get(6));
        Assert.assertEquals((Object)ColumnType.LONG, fooRowSignature.getColumnType((String)columnNames.get(6)).get());
        Assert.assertEquals((Object)"m1", columnNames.get(7));
        Assert.assertEquals((Object)ColumnType.DOUBLE, fooRowSignature.getColumnType((String)columnNames.get(7)).get());
        Assert.assertEquals((Object)"unique_dim1", columnNames.get(8));
        Assert.assertEquals((Object)ColumnType.ofComplex((String)"hyperUnique"), fooRowSignature.getColumnType((String)columnNames.get(8)).get());
    }

    @Test
    public void testAvailableSegmentMetadataNumRows() throws InterruptedException {
        CoordinatorSegmentMetadataCache schema = this.buildSchemaMarkAndTableLatch();
        Map segmentsMetadata = schema.getSegmentMetadataSnapshot();
        List segments = segmentsMetadata.values().stream().map(AvailableSegmentMetadata::getSegment).collect(Collectors.toList());
        Assert.assertEquals((long)6L, (long)segments.size());
        DataSegment existingSegment = segments.stream().filter(segment -> segment.getDataSource().equals("foo2")).findFirst().orElse(null);
        Assert.assertNotNull((Object)existingSegment);
        AvailableSegmentMetadata existingMetadata = (AvailableSegmentMetadata)segmentsMetadata.get(existingSegment.getId());
        AvailableSegmentMetadata updatedMetadata = AvailableSegmentMetadata.from((AvailableSegmentMetadata)existingMetadata).withNumRows(5L).build();
        schema.setAvailableSegmentMetadata(existingSegment.getId(), updatedMetadata);
        Pair pair = this.druidServers.stream().flatMap(druidServer -> this.serverView.getSegmentsOfServer((DruidServer)druidServer).stream().filter(segment -> segment.getId().equals((Object)existingSegment.getId())).map(segment -> Pair.of((Object)druidServer, (Object)segment))).findAny().orElse(null);
        Assert.assertNotNull((Object)pair);
        DruidServer server = (DruidServer)pair.lhs;
        Assert.assertNotNull((Object)server);
        DruidServerMetadata druidServerMetadata = server.getMetadata();
        schema.addSegment(druidServerMetadata, existingSegment);
        segmentsMetadata = schema.getSegmentMetadataSnapshot();
        DataSegment currentSegment = segments.stream().filter(segment -> segment.getDataSource().equals("foo2")).findFirst().orElse(null);
        AvailableSegmentMetadata currentMetadata = (AvailableSegmentMetadata)segmentsMetadata.get(currentSegment.getId());
        Assert.assertEquals((Object)updatedMetadata.getSegment().getId(), (Object)currentMetadata.getSegment().getId());
        Assert.assertEquals((long)updatedMetadata.getNumRows(), (long)currentMetadata.getNumRows());
        Assert.assertEquals((long)updatedMetadata.getNumReplicas(), (long)currentMetadata.getNumReplicas());
    }

    @Test
    public void testNullDatasource() throws IOException, InterruptedException {
        CoordinatorSegmentMetadataCache schema = this.buildSchemaMarkAndTableLatch();
        Map segmentMetadatas = schema.getSegmentMetadataSnapshot();
        List segments = segmentMetadatas.values().stream().map(AvailableSegmentMetadata::getSegment).collect(Collectors.toList());
        Assert.assertEquals((long)6L, (long)segments.size());
        DataSegment segmentToRemove = segments.stream().filter(segment -> segment.getDataSource().equals("foo2")).findFirst().orElse(null);
        Assert.assertNotNull((Object)segmentToRemove);
        schema.removeSegment(segmentToRemove);
        schema.refreshSegments(segments.stream().map(DataSegment::getId).collect(Collectors.toSet()));
        Assert.assertEquals((long)5L, (long)schema.getSegmentMetadataSnapshot().size());
    }

    @Test
    public void testAllDatasourcesRebuiltOnDatasourceRemoval() throws IOException, InterruptedException {
        final CountDownLatch addSegmentLatch = new CountDownLatch(7);
        CoordinatorSegmentMetadataCache schema = new CoordinatorSegmentMetadataCache(this.getQueryLifecycleFactory((QuerySegmentWalker)this.walker), this.serverView, SEGMENT_CACHE_CONFIG_DEFAULT, (Escalator)new NoopEscalator(), new InternalQueryConfig(), new NoopServiceEmitter(), CentralizedDatasourceSchemaConfig.create()){

            public void addSegment(DruidServerMetadata server, DataSegment segment) {
                super.addSegment(server, segment);
                addSegmentLatch.countDown();
            }

            public void removeSegment(DataSegment segment) {
                super.removeSegment(segment);
            }

            public void markDataSourceAsNeedRebuild(String datasource) {
                super.markDataSourceAsNeedRebuild(datasource);
                CoordinatorSegmentMetadataCacheTest.this.markDataSourceLatch.countDown();
            }

            @VisibleForTesting
            public void refresh(Set<SegmentId> segmentsToRefresh, Set<String> dataSourcesToRebuild) throws IOException {
                super.refresh(segmentsToRefresh, dataSourcesToRebuild);
            }
        };
        schema.start();
        schema.awaitInitialization();
        Map segmentMetadatas = schema.getSegmentMetadataSnapshot();
        List segments = segmentMetadatas.values().stream().map(AvailableSegmentMetadata::getSegment).collect(Collectors.toList());
        Assert.assertEquals((long)6L, (long)segments.size());
        DataSourceInformation fooDs = schema.getDatasource("foo");
        Assert.assertTrue((boolean)fooDs.getRowSignature().getColumnNames().stream().noneMatch("dim3"::equals));
        DataSegment segmentToRemove = segments.stream().filter(segment -> segment.getDataSource().equals("foo2")).findFirst().orElse(null);
        Assert.assertNotNull((Object)segmentToRemove);
        schema.removeSegment(segmentToRemove);
        DataSegment newSegment = DataSegment.builder().dataSource("foo").interval(Intervals.of((String)"2002/P1Y")).version("1").shardSpec((ShardSpec)new LinearShardSpec(Integer.valueOf(0))).size(0L).build();
        File tmpDir = this.temporaryFolder.newFolder();
        ImmutableList rows = ImmutableList.of((Object)this.createRow(ImmutableMap.of((Object)"t", (Object)"2002-01-01", (Object)"m1", (Object)"1.0", (Object)"dim1", (Object)"", (Object)"dim3", (Object)"c1")), (Object)this.createRow(ImmutableMap.of((Object)"t", (Object)"2002-01-02", (Object)"m1", (Object)"2.0", (Object)"dim1", (Object)"10.1", (Object)"dim3", (Object)"c2")), (Object)this.createRow(ImmutableMap.of((Object)"t", (Object)"2002-01-03", (Object)"m1", (Object)"3.0", (Object)"dim1", (Object)"2", (Object)"dim3", (Object)"c3")));
        QueryableIndex index = IndexBuilder.create().tmpDir(new File(tmpDir, "1")).segmentWriteOutMediumFactory((SegmentWriteOutMediumFactory)OffHeapMemorySegmentWriteOutMediumFactory.instance()).schema(new IncrementalIndexSchema.Builder().withMetrics(new AggregatorFactory[]{new CountAggregatorFactory("cnt"), new DoubleSumAggregatorFactory("m1", "m1"), new HyperUniquesAggregatorFactory("unique_dim1", "dim1")}).withRollup(false).build()).rows((Iterable)rows).buildMMappedIndex();
        this.walker.add(newSegment, index);
        this.serverView.addSegment(newSegment, ServerType.HISTORICAL);
        Assert.assertTrue((boolean)addSegmentLatch.await(1L, TimeUnit.SECONDS));
        Set dataSources = segments.stream().map(DataSegment::getDataSource).collect(Collectors.toSet());
        dataSources.remove("foo2");
        LinkedHashSet<String> dataSourcesToRefresh = new LinkedHashSet<String>();
        dataSourcesToRefresh.add("foo2");
        dataSourcesToRefresh.addAll(dataSources);
        segments = schema.getSegmentMetadataSnapshot().values().stream().map(AvailableSegmentMetadata::getSegment).collect(Collectors.toList());
        schema.refresh(segments.stream().map(DataSegment::getId).collect(Collectors.toSet()), dataSourcesToRefresh);
        Assert.assertEquals((long)6L, (long)schema.getSegmentMetadataSnapshot().size());
        fooDs = schema.getDatasource("foo");
        Assert.assertTrue((boolean)fooDs.getRowSignature().getColumnNames().stream().anyMatch("dim3"::equals));
    }

    @Test
    public void testNullAvailableSegmentMetadata() throws IOException, InterruptedException {
        CoordinatorSegmentMetadataCache schema = this.buildSchemaMarkAndTableLatch();
        Map segmentMetadatas = schema.getSegmentMetadataSnapshot();
        List segments = segmentMetadatas.values().stream().map(AvailableSegmentMetadata::getSegment).collect(Collectors.toList());
        Assert.assertEquals((long)6L, (long)segments.size());
        DataSegment segmentToRemove = segments.stream().filter(segment -> segment.getDataSource().equals("foo")).findFirst().orElse(null);
        Assert.assertNotNull((Object)segmentToRemove);
        schema.removeSegment(segmentToRemove);
        schema.refreshSegments(segments.stream().map(DataSegment::getId).collect(Collectors.toSet()));
        Assert.assertEquals((long)5L, (long)schema.getSegmentMetadataSnapshot().size());
    }

    @Test
    public void testAvailableSegmentMetadataIsRealtime() throws InterruptedException {
        CoordinatorSegmentMetadataCache schema = this.buildSchemaMarkAndTableLatch();
        Map segmentsMetadata = schema.getSegmentMetadataSnapshot();
        List segments = segmentsMetadata.values().stream().map(AvailableSegmentMetadata::getSegment).collect(Collectors.toList());
        DataSegment existingSegment = segments.stream().filter(segment -> segment.getDataSource().equals("foo3")).findFirst().orElse(null);
        Assert.assertNotNull((Object)existingSegment);
        AvailableSegmentMetadata metadata = (AvailableSegmentMetadata)segmentsMetadata.get(existingSegment.getId());
        Assert.assertEquals((long)1L, (long)metadata.isRealtime());
        DruidServer historicalServer = this.druidServers.stream().filter(s -> s.getType().equals((Object)ServerType.HISTORICAL)).findAny().orElse(null);
        Assert.assertNotNull((Object)historicalServer);
        DruidServerMetadata historicalServerMetadata = historicalServer.getMetadata();
        schema.addSegment(historicalServerMetadata, existingSegment);
        segmentsMetadata = schema.getSegmentMetadataSnapshot();
        DataSegment currentSegment = segments.stream().filter(segment -> segment.getDataSource().equals("foo3")).findFirst().orElse(null);
        Assert.assertNotNull((Object)currentSegment);
        AvailableSegmentMetadata currentMetadata = (AvailableSegmentMetadata)segmentsMetadata.get(currentSegment.getId());
        Assert.assertEquals((long)0L, (long)currentMetadata.isRealtime());
        DruidServer realtimeServer = this.druidServers.stream().filter(s -> s.getType().equals((Object)ServerType.INDEXER_EXECUTOR)).findAny().orElse(null);
        Assert.assertNotNull((Object)realtimeServer);
        schema.removeServerSegment(realtimeServer.getMetadata(), existingSegment);
        segmentsMetadata = schema.getSegmentMetadataSnapshot();
        currentSegment = segments.stream().filter(segment -> segment.getDataSource().equals("foo3")).findFirst().orElse(null);
        Assert.assertNotNull((Object)currentSegment);
        currentMetadata = (AvailableSegmentMetadata)segmentsMetadata.get(currentSegment.getId());
        Assert.assertEquals((long)0L, (long)currentMetadata.isRealtime());
    }

    @Test
    public void testSegmentAddedCallbackAddNewHistoricalSegment() throws InterruptedException {
        final String datasource = "newSegmentAddTest";
        final CountDownLatch addSegmentLatch = new CountDownLatch(1);
        CoordinatorSegmentMetadataCache schema = new CoordinatorSegmentMetadataCache(this.getQueryLifecycleFactory((QuerySegmentWalker)this.walker), this.serverView, SEGMENT_CACHE_CONFIG_DEFAULT, (Escalator)new NoopEscalator(), new InternalQueryConfig(), new NoopServiceEmitter(), CentralizedDatasourceSchemaConfig.create()){

            public void addSegment(DruidServerMetadata server, DataSegment segment) {
                super.addSegment(server, segment);
                if (datasource.equals(segment.getDataSource())) {
                    addSegmentLatch.countDown();
                }
            }
        };
        this.serverView.addSegment(this.newSegment(datasource, 1), ServerType.HISTORICAL);
        Assert.assertTrue((boolean)addSegmentLatch.await(1L, TimeUnit.SECONDS));
        Assert.assertEquals((long)7L, (long)schema.getTotalSegments());
        List metadatas = schema.getSegmentMetadataSnapshot().values().stream().filter(metadata -> datasource.equals(metadata.getSegment().getDataSource())).collect(Collectors.toList());
        Assert.assertEquals((long)1L, (long)metadatas.size());
        AvailableSegmentMetadata metadata2 = (AvailableSegmentMetadata)metadatas.get(0);
        Assert.assertEquals((long)0L, (long)metadata2.isRealtime());
        Assert.assertEquals((long)0L, (long)metadata2.getNumRows());
        Assert.assertTrue((boolean)schema.getSegmentsNeedingRefresh().contains(metadata2.getSegment().getId()));
    }

    @Test
    public void testSegmentAddedCallbackAddExistingSegment() throws InterruptedException {
        final String datasource = "newSegmentAddTest";
        final CountDownLatch addSegmentLatch = new CountDownLatch(2);
        CoordinatorSegmentMetadataCache schema = new CoordinatorSegmentMetadataCache(this.getQueryLifecycleFactory((QuerySegmentWalker)this.walker), this.serverView, SEGMENT_CACHE_CONFIG_DEFAULT, (Escalator)new NoopEscalator(), new InternalQueryConfig(), new NoopServiceEmitter(), CentralizedDatasourceSchemaConfig.create()){

            public void addSegment(DruidServerMetadata server, DataSegment segment) {
                super.addSegment(server, segment);
                if (datasource.equals(segment.getDataSource())) {
                    addSegmentLatch.countDown();
                }
            }
        };
        DataSegment segment = this.newSegment(datasource, 1);
        this.serverView.addSegment(segment, ServerType.INDEXER_EXECUTOR);
        this.serverView.addSegment(segment, ServerType.HISTORICAL);
        Assert.assertTrue((boolean)addSegmentLatch.await(1L, TimeUnit.SECONDS));
        Assert.assertEquals((long)7L, (long)schema.getTotalSegments());
        List metadatas = schema.getSegmentMetadataSnapshot().values().stream().filter(metadata -> datasource.equals(metadata.getSegment().getDataSource())).collect(Collectors.toList());
        Assert.assertEquals((long)1L, (long)metadatas.size());
        AvailableSegmentMetadata metadata2 = (AvailableSegmentMetadata)metadatas.get(0);
        Assert.assertEquals((long)0L, (long)metadata2.isRealtime());
        Assert.assertEquals((long)0L, (long)metadata2.getNumRows());
        Assert.assertEquals((long)2L, (long)metadata2.getNumReplicas());
        Assert.assertTrue((boolean)schema.getSegmentsNeedingRefresh().contains(metadata2.getSegment().getId()));
        Assert.assertFalse((boolean)schema.getMutableSegments().contains(metadata2.getSegment().getId()));
    }

    @Test
    public void testSegmentAddedCallbackAddNewRealtimeSegment() throws InterruptedException {
        final String datasource = "newSegmentAddTest";
        final CountDownLatch addSegmentLatch = new CountDownLatch(1);
        CoordinatorSegmentMetadataCache schema = new CoordinatorSegmentMetadataCache(this.getQueryLifecycleFactory((QuerySegmentWalker)this.walker), this.serverView, SEGMENT_CACHE_CONFIG_DEFAULT, (Escalator)new NoopEscalator(), new InternalQueryConfig(), new NoopServiceEmitter(), CentralizedDatasourceSchemaConfig.create()){

            public void addSegment(DruidServerMetadata server, DataSegment segment) {
                super.addSegment(server, segment);
                if (datasource.equals(segment.getDataSource())) {
                    addSegmentLatch.countDown();
                }
            }
        };
        this.serverView.addSegment(this.newSegment(datasource, 1), ServerType.INDEXER_EXECUTOR);
        Assert.assertTrue((boolean)addSegmentLatch.await(1L, TimeUnit.SECONDS));
        Assert.assertEquals((long)7L, (long)schema.getTotalSegments());
        List metadatas = schema.getSegmentMetadataSnapshot().values().stream().filter(metadata -> datasource.equals(metadata.getSegment().getDataSource())).collect(Collectors.toList());
        Assert.assertEquals((long)1L, (long)metadatas.size());
        AvailableSegmentMetadata metadata2 = (AvailableSegmentMetadata)metadatas.get(0);
        Assert.assertEquals((long)1L, (long)metadata2.isRealtime());
        Assert.assertEquals((long)0L, (long)metadata2.getNumRows());
        Assert.assertTrue((boolean)schema.getSegmentsNeedingRefresh().contains(metadata2.getSegment().getId()));
        Assert.assertTrue((boolean)schema.getMutableSegments().contains(metadata2.getSegment().getId()));
    }

    @Test
    public void testSegmentAddedCallbackAddNewBroadcastSegment() throws InterruptedException {
        final String datasource = "newSegmentAddTest";
        final CountDownLatch addSegmentLatch = new CountDownLatch(1);
        CoordinatorSegmentMetadataCache schema = new CoordinatorSegmentMetadataCache(this.getQueryLifecycleFactory((QuerySegmentWalker)this.walker), this.serverView, SEGMENT_CACHE_CONFIG_DEFAULT, (Escalator)new NoopEscalator(), new InternalQueryConfig(), new NoopServiceEmitter(), CentralizedDatasourceSchemaConfig.create()){

            public void addSegment(DruidServerMetadata server, DataSegment segment) {
                super.addSegment(server, segment);
                if (datasource.equals(segment.getDataSource())) {
                    addSegmentLatch.countDown();
                }
            }
        };
        this.serverView.addSegment(this.newSegment(datasource, 1), ServerType.BROKER);
        Assert.assertTrue((boolean)addSegmentLatch.await(1L, TimeUnit.SECONDS));
        Assert.assertEquals((long)6L, (long)schema.getTotalSegments());
        List metadatas = schema.getSegmentMetadataSnapshot().values().stream().filter(metadata -> datasource.equals(metadata.getSegment().getDataSource())).collect(Collectors.toList());
        Assert.assertEquals((long)0L, (long)metadatas.size());
        Assert.assertTrue((boolean)schema.getDataSourcesNeedingRebuild().contains(datasource));
    }

    @Test
    public void testSegmentRemovedCallbackEmptyDataSourceAfterRemove() throws InterruptedException, IOException {
        final String datasource = "segmentRemoveTest";
        final CountDownLatch addSegmentLatch = new CountDownLatch(1);
        final CountDownLatch removeSegmentLatch = new CountDownLatch(1);
        CoordinatorSegmentMetadataCache schema = new CoordinatorSegmentMetadataCache(this.getQueryLifecycleFactory((QuerySegmentWalker)this.walker), this.serverView, SEGMENT_CACHE_CONFIG_DEFAULT, (Escalator)new NoopEscalator(), new InternalQueryConfig(), new NoopServiceEmitter(), CentralizedDatasourceSchemaConfig.create()){

            public void addSegment(DruidServerMetadata server, DataSegment segment) {
                super.addSegment(server, segment);
                if (datasource.equals(segment.getDataSource())) {
                    addSegmentLatch.countDown();
                }
            }

            public void removeSegment(DataSegment segment) {
                super.removeSegment(segment);
                if (datasource.equals(segment.getDataSource())) {
                    removeSegmentLatch.countDown();
                }
            }
        };
        DataSegment segment = this.newSegment(datasource, 1);
        this.serverView.addSegment(segment, ServerType.INDEXER_EXECUTOR);
        Assert.assertTrue((boolean)addSegmentLatch.await(1L, TimeUnit.SECONDS));
        schema.refresh((Set)Sets.newHashSet((Object[])new SegmentId[]{segment.getId()}), (Set)Sets.newHashSet((Object[])new String[]{datasource}));
        this.serverView.removeSegment(segment, ServerType.INDEXER_EXECUTOR);
        Assert.assertTrue((boolean)removeSegmentLatch.await(1L, TimeUnit.SECONDS));
        Assert.assertEquals((long)6L, (long)schema.getTotalSegments());
        List metadatas = schema.getSegmentMetadataSnapshot().values().stream().filter(metadata -> datasource.equals(metadata.getSegment().getDataSource())).collect(Collectors.toList());
        Assert.assertEquals((long)0L, (long)metadatas.size());
        Assert.assertFalse((boolean)schema.getSegmentsNeedingRefresh().contains(segment.getId()));
        Assert.assertFalse((boolean)schema.getMutableSegments().contains(segment.getId()));
        Assert.assertFalse((boolean)schema.getDataSourcesNeedingRebuild().contains(datasource));
        Assert.assertFalse((boolean)schema.getDatasourceNames().contains(datasource));
    }

    @Test
    public void testSegmentRemovedCallbackNonEmptyDataSourceAfterRemove() throws InterruptedException, IOException {
        final String datasource = "segmentRemoveTest";
        final CountDownLatch addSegmentLatch = new CountDownLatch(2);
        final CountDownLatch removeSegmentLatch = new CountDownLatch(1);
        CoordinatorSegmentMetadataCache schema = new CoordinatorSegmentMetadataCache(this.getQueryLifecycleFactory((QuerySegmentWalker)this.walker), this.serverView, SEGMENT_CACHE_CONFIG_DEFAULT, (Escalator)new NoopEscalator(), new InternalQueryConfig(), new NoopServiceEmitter(), CentralizedDatasourceSchemaConfig.create()){

            public void addSegment(DruidServerMetadata server, DataSegment segment) {
                super.addSegment(server, segment);
                if (datasource.equals(segment.getDataSource())) {
                    addSegmentLatch.countDown();
                }
            }

            public void removeSegment(DataSegment segment) {
                super.removeSegment(segment);
                if (datasource.equals(segment.getDataSource())) {
                    removeSegmentLatch.countDown();
                }
            }
        };
        ImmutableList segments = ImmutableList.of((Object)this.newSegment(datasource, 1), (Object)this.newSegment(datasource, 2));
        this.serverView.addSegment((DataSegment)segments.get(0), ServerType.INDEXER_EXECUTOR);
        this.serverView.addSegment((DataSegment)segments.get(1), ServerType.HISTORICAL);
        Assert.assertTrue((boolean)addSegmentLatch.await(1L, TimeUnit.SECONDS));
        schema.refresh(segments.stream().map(DataSegment::getId).collect(Collectors.toSet()), (Set)Sets.newHashSet((Object[])new String[]{datasource}));
        this.serverView.removeSegment((DataSegment)segments.get(0), ServerType.INDEXER_EXECUTOR);
        Assert.assertTrue((boolean)removeSegmentLatch.await(1L, TimeUnit.SECONDS));
        Assert.assertEquals((long)7L, (long)schema.getTotalSegments());
        List metadatas = schema.getSegmentMetadataSnapshot().values().stream().filter(metadata -> datasource.equals(metadata.getSegment().getDataSource())).collect(Collectors.toList());
        Assert.assertEquals((long)1L, (long)metadatas.size());
        Assert.assertFalse((boolean)schema.getSegmentsNeedingRefresh().contains(((DataSegment)segments.get(0)).getId()));
        Assert.assertFalse((boolean)schema.getMutableSegments().contains(((DataSegment)segments.get(0)).getId()));
        Assert.assertTrue((boolean)schema.getDataSourcesNeedingRebuild().contains(datasource));
        Assert.assertTrue((boolean)schema.getDatasourceNames().contains(datasource));
    }

    @Test
    public void testServerSegmentRemovedCallbackRemoveUnknownSegment() throws InterruptedException {
        final String datasource = "serverSegmentRemoveTest";
        final CountDownLatch removeServerSegmentLatch = new CountDownLatch(1);
        CoordinatorSegmentMetadataCache schema = new CoordinatorSegmentMetadataCache(this.getQueryLifecycleFactory((QuerySegmentWalker)this.walker), this.serverView, SEGMENT_CACHE_CONFIG_DEFAULT, (Escalator)new NoopEscalator(), new InternalQueryConfig(), new NoopServiceEmitter(), CentralizedDatasourceSchemaConfig.create()){

            public void removeServerSegment(DruidServerMetadata server, DataSegment segment) {
                super.removeServerSegment(server, segment);
                if (datasource.equals(segment.getDataSource())) {
                    removeServerSegmentLatch.countDown();
                }
            }
        };
        this.serverView.addSegment(this.newSegment(datasource, 1), ServerType.BROKER);
        this.serverView.removeSegment(this.newSegment(datasource, 1), ServerType.HISTORICAL);
        Assert.assertTrue((boolean)removeServerSegmentLatch.await(1L, TimeUnit.SECONDS));
        Assert.assertEquals((long)6L, (long)schema.getTotalSegments());
    }

    @Test
    public void testServerSegmentRemovedCallbackRemoveBrokerSegment() throws InterruptedException {
        final String datasource = "serverSegmentRemoveTest";
        final CountDownLatch addSegmentLatch = new CountDownLatch(1);
        final CountDownLatch removeServerSegmentLatch = new CountDownLatch(1);
        CoordinatorSegmentMetadataCache schema = new CoordinatorSegmentMetadataCache(this.getQueryLifecycleFactory((QuerySegmentWalker)this.walker), this.serverView, SEGMENT_CACHE_CONFIG_DEFAULT, (Escalator)new NoopEscalator(), new InternalQueryConfig(), new NoopServiceEmitter(), CentralizedDatasourceSchemaConfig.create()){

            public void addSegment(DruidServerMetadata server, DataSegment segment) {
                super.addSegment(server, segment);
                if (datasource.equals(segment.getDataSource())) {
                    addSegmentLatch.countDown();
                }
            }

            public void removeServerSegment(DruidServerMetadata server, DataSegment segment) {
                super.removeServerSegment(server, segment);
                if (datasource.equals(segment.getDataSource())) {
                    removeServerSegmentLatch.countDown();
                }
            }
        };
        DataSegment segment = this.newSegment(datasource, 1);
        this.serverView.addSegment(segment, ServerType.HISTORICAL);
        this.serverView.addSegment(segment, ServerType.BROKER);
        Assert.assertTrue((boolean)addSegmentLatch.await(1L, TimeUnit.SECONDS));
        this.serverView.removeSegment(segment, ServerType.BROKER);
        Assert.assertTrue((boolean)removeServerSegmentLatch.await(1L, TimeUnit.SECONDS));
        Assert.assertEquals((long)7L, (long)schema.getTotalSegments());
        Assert.assertTrue((boolean)schema.getDataSourcesNeedingRebuild().contains(datasource));
    }

    @Test
    public void testServerSegmentRemovedCallbackRemoveHistoricalSegment() throws InterruptedException {
        final String datasource = "serverSegmentRemoveTest";
        final CountDownLatch addSegmentLatch = new CountDownLatch(1);
        final CountDownLatch removeServerSegmentLatch = new CountDownLatch(1);
        CoordinatorSegmentMetadataCache schema = new CoordinatorSegmentMetadataCache(this.getQueryLifecycleFactory((QuerySegmentWalker)this.walker), this.serverView, SEGMENT_CACHE_CONFIG_DEFAULT, (Escalator)new NoopEscalator(), new InternalQueryConfig(), new NoopServiceEmitter(), CentralizedDatasourceSchemaConfig.create()){

            public void addSegment(DruidServerMetadata server, DataSegment segment) {
                super.addSegment(server, segment);
                if (datasource.equals(segment.getDataSource())) {
                    addSegmentLatch.countDown();
                }
            }

            public void removeServerSegment(DruidServerMetadata server, DataSegment segment) {
                super.removeServerSegment(server, segment);
                if (datasource.equals(segment.getDataSource())) {
                    removeServerSegmentLatch.countDown();
                }
            }
        };
        DataSegment segment = this.newSegment(datasource, 1);
        this.serverView.addSegment(segment, ServerType.HISTORICAL);
        this.serverView.addSegment(segment, ServerType.BROKER);
        Assert.assertTrue((boolean)addSegmentLatch.await(1L, TimeUnit.SECONDS));
        this.serverView.removeSegment(segment, ServerType.HISTORICAL);
        Assert.assertTrue((boolean)removeServerSegmentLatch.await(1L, TimeUnit.SECONDS));
        Assert.assertEquals((long)7L, (long)schema.getTotalSegments());
        List metadatas = schema.getSegmentMetadataSnapshot().values().stream().filter(metadata -> datasource.equals(metadata.getSegment().getDataSource())).collect(Collectors.toList());
        Assert.assertEquals((long)1L, (long)metadatas.size());
        AvailableSegmentMetadata metadata2 = (AvailableSegmentMetadata)metadatas.get(0);
        Assert.assertEquals((long)0L, (long)metadata2.isRealtime());
        Assert.assertEquals((long)0L, (long)metadata2.getNumRows());
        Assert.assertEquals((long)0L, (long)metadata2.getNumReplicas());
    }

    @Test
    public void testRunSegmentMetadataQueryWithContext() throws Exception {
        String brokerInternalQueryConfigJson = "{\"context\": { \"priority\": 5} }";
        TestHelper.makeJsonMapper();
        InternalQueryConfig internalQueryConfig = (InternalQueryConfig)MAPPER.readValue(MAPPER.writeValueAsString(MAPPER.readValue(brokerInternalQueryConfigJson, InternalQueryConfig.class)), InternalQueryConfig.class);
        QueryLifecycleFactory factoryMock = (QueryLifecycleFactory)EasyMock.createMock(QueryLifecycleFactory.class);
        QueryLifecycle lifecycleMock = (QueryLifecycle)EasyMock.createMock(QueryLifecycle.class);
        CoordinatorSegmentMetadataCache schema = new CoordinatorSegmentMetadataCache(factoryMock, (CoordinatorServerView)this.serverView, SEGMENT_CACHE_CONFIG_DEFAULT, (Escalator)new NoopEscalator(), internalQueryConfig, (ServiceEmitter)new NoopServiceEmitter(), CentralizedDatasourceSchemaConfig.create());
        ImmutableMap queryContext = ImmutableMap.of((Object)"priority", (Object)5, (Object)"enableParallelMerge", (Object)false);
        DataSegment segment = this.newSegment("test", 0);
        ImmutableList segmentIterable = ImmutableList.of((Object)segment.getId());
        SegmentMetadataQuery expectedMetadataQuery = new SegmentMetadataQuery((DataSource)new TableDataSource(segment.getDataSource()), (QuerySegmentSpec)new MultipleSpecificSegmentSpec(segmentIterable.stream().map(SegmentId::toDescriptor).collect(Collectors.toList())), (ColumnIncluderator)new AllColumnIncluderator(), Boolean.valueOf(false), (Map)queryContext, EnumSet.noneOf(SegmentMetadataQuery.AnalysisType.class), Boolean.valueOf(false), null, null);
        EasyMock.expect((Object)factoryMock.factorize()).andReturn((Object)lifecycleMock).once();
        EasyMock.expect((Object)lifecycleMock.runSimple((Query)expectedMetadataQuery, AllowAllAuthenticator.ALLOW_ALL_RESULT, Access.OK)).andReturn((Object)QueryResponse.withEmptyContext((Sequence)Sequences.empty()));
        EasyMock.replay((Object[])new Object[]{factoryMock, lifecycleMock});
        schema.runSegmentMetadataQuery((Iterable)segmentIterable);
        EasyMock.verify((Object[])new Object[]{factoryMock, lifecycleMock});
    }

    @Test
    public void testSegmentMetadataColumnType() {
        LinkedHashMap<String, ColumnAnalysis> columns = new LinkedHashMap<String, ColumnAnalysis>();
        columns.put("a", new ColumnAnalysis(ColumnType.STRING, ColumnType.STRING.asTypeString(), false, true, 1234L, Integer.valueOf(26), (Comparable)((Object)"a"), (Comparable)((Object)"z"), null));
        columns.put("count", new ColumnAnalysis(ColumnType.LONG, ColumnType.LONG.asTypeString(), false, true, 1234L, Integer.valueOf(26), (Comparable)((Object)"a"), (Comparable)((Object)"z"), null));
        columns.put("b", new ColumnAnalysis(ColumnType.DOUBLE, ColumnType.DOUBLE.asTypeString(), false, true, 1234L, Integer.valueOf(26), null, null, null));
        RowSignature signature = AbstractSegmentMetadataCache.analysisToRowSignature((SegmentAnalysis)new SegmentAnalysis("id", (List)ImmutableList.of((Object)Intervals.utc((long)1L, (long)2L)), columns, 1234L, 100L, null, null, null, null));
        Assert.assertEquals((Object)RowSignature.builder().add("a", ColumnType.STRING).add("count", ColumnType.LONG).add("b", ColumnType.DOUBLE).build(), (Object)signature);
    }

    @Test
    public void testSegmentMetadataFallbackType() {
        RowSignature signature = AbstractSegmentMetadataCache.analysisToRowSignature((SegmentAnalysis)new SegmentAnalysis("id", (List)ImmutableList.of((Object)Intervals.utc((long)1L, (long)2L)), new LinkedHashMap(ImmutableMap.of((Object)"a", (Object)new ColumnAnalysis(null, ColumnType.STRING.asTypeString(), false, true, 1234L, Integer.valueOf(26), (Comparable)((Object)"a"), (Comparable)((Object)"z"), null), (Object)"count", (Object)new ColumnAnalysis(null, ColumnType.LONG.asTypeString(), false, true, 1234L, null, null, null, null), (Object)"distinct", (Object)new ColumnAnalysis(null, "hyperUnique", false, true, 1234L, null, null, null, null))), 1234L, 100L, null, null, null, null));
        Assert.assertEquals((Object)RowSignature.builder().add("a", ColumnType.STRING).add("count", ColumnType.LONG).add("distinct", ColumnType.ofComplex((String)"hyperUnique")).build(), (Object)signature);
    }

    @Test
    public void testStaleDatasourceRefresh() throws IOException, InterruptedException {
        CoordinatorSegmentMetadataCache schema = this.buildSchemaMarkAndTableLatch();
        HashSet segments = new HashSet();
        HashSet<String> datasources = new HashSet<String>();
        datasources.add("wat");
        Assert.assertNull((Object)schema.getDatasource("wat"));
        schema.refresh(segments, datasources);
        Assert.assertNull((Object)schema.getDatasource("wat"));
    }

    @Test
    public void testRefreshShouldEmitMetrics() throws InterruptedException, IOException {
        final String dataSource = "xyz";
        final CountDownLatch addSegmentLatch = new CountDownLatch(2);
        StubServiceEmitter emitter = new StubServiceEmitter("broker", "host");
        CoordinatorSegmentMetadataCache schema = new CoordinatorSegmentMetadataCache(this.getQueryLifecycleFactory((QuerySegmentWalker)this.walker), this.serverView, SEGMENT_CACHE_CONFIG_DEFAULT, (Escalator)new NoopEscalator(), new InternalQueryConfig(), (ServiceEmitter)emitter, CentralizedDatasourceSchemaConfig.create()){

            public void addSegment(DruidServerMetadata server, DataSegment segment) {
                super.addSegment(server, segment);
                if (dataSource.equals(segment.getDataSource())) {
                    addSegmentLatch.countDown();
                }
            }

            public void removeSegment(DataSegment segment) {
                super.removeSegment(segment);
            }
        };
        ImmutableList segments = ImmutableList.of((Object)this.newSegment(dataSource, 1), (Object)this.newSegment(dataSource, 2));
        this.serverView.addSegment((DataSegment)segments.get(0), ServerType.HISTORICAL);
        this.serverView.addSegment((DataSegment)segments.get(1), ServerType.INDEXER_EXECUTOR);
        Assert.assertTrue((boolean)addSegmentLatch.await(1L, TimeUnit.SECONDS));
        schema.refresh(segments.stream().map(DataSegment::getId).collect(Collectors.toSet()), (Set)Sets.newHashSet((Object[])new String[]{dataSource}));
        emitter.verifyEmitted("metadatacache/refresh/time", (Map)ImmutableMap.of((Object)"dataSource", (Object)dataSource), 1);
        emitter.verifyEmitted("metadatacache/refresh/count", (Map)ImmutableMap.of((Object)"dataSource", (Object)dataSource), 1);
    }

    @Test
    public void testMergeOrCreateRowSignatureDeltaSchemaNoPreviousSignature() throws InterruptedException {
        CoordinatorSegmentMetadataCache schema = this.buildSchemaMarkAndTableLatch();
        EmittingLogger.registerEmitter((ServiceEmitter)new StubServiceEmitter("coordinator", "dummy"));
        Assert.assertFalse((boolean)schema.mergeOrCreateRowSignature(this.segment1.getId(), null, new SegmentSchemas.SegmentSchema("foo", this.segment1.getId().toString(), true, Integer.valueOf(20), (List)ImmutableList.of((Object)"dim1"), Collections.emptyList(), (Map)ImmutableMap.of((Object)"dim1", (Object)ColumnType.STRING))).isPresent());
    }

    @Test
    public void testMergeOrCreateRowSignatureDeltaSchema() throws InterruptedException {
        CoordinatorSegmentMetadataCache schema = this.buildSchemaMarkAndTableLatch();
        AvailableSegmentMetadata availableSegmentMetadata = schema.getAvailableSegmentMetadata("foo", this.segment1.getId());
        Optional mergedSignature = schema.mergeOrCreateRowSignature(this.segment1.getId(), availableSegmentMetadata.getRowSignature(), new SegmentSchemas.SegmentSchema("foo", this.segment1.getId().toString(), true, Integer.valueOf(1000), (List)ImmutableList.of((Object)"dim2"), (List)ImmutableList.of((Object)"m1"), (Map)ImmutableMap.of((Object)"dim2", (Object)ColumnType.STRING, (Object)"m1", (Object)ColumnType.STRING)));
        Assert.assertTrue((boolean)mergedSignature.isPresent());
        RowSignature.Builder rowSignatureBuilder = RowSignature.builder();
        rowSignatureBuilder.add("__time", ColumnType.LONG);
        rowSignatureBuilder.add("dim1", ColumnType.STRING);
        rowSignatureBuilder.add("cnt", ColumnType.LONG);
        rowSignatureBuilder.add("m1", ColumnType.STRING);
        rowSignatureBuilder.add("unique_dim1", ColumnType.ofComplex((String)"hyperUnique"));
        rowSignatureBuilder.add("dim2", ColumnType.STRING);
        Assert.assertEquals((Object)rowSignatureBuilder.build(), mergedSignature.get());
    }

    @Test
    public void testMergeOrCreateRowSignatureDeltaSchemaNewUpdateColumnOldNewColumn() throws InterruptedException {
        CoordinatorSegmentMetadataCache schema = this.buildSchemaMarkAndTableLatch();
        EmittingLogger.registerEmitter((ServiceEmitter)new StubServiceEmitter("coordinator", "dummy"));
        AvailableSegmentMetadata availableSegmentMetadata = schema.getAvailableSegmentMetadata("foo", this.segment1.getId());
        Optional mergedSignature = schema.mergeOrCreateRowSignature(this.segment1.getId(), availableSegmentMetadata.getRowSignature(), new SegmentSchemas.SegmentSchema("foo", this.segment1.getId().toString(), true, Integer.valueOf(1000), (List)ImmutableList.of((Object)"m1"), (List)ImmutableList.of((Object)"m2"), (Map)ImmutableMap.of((Object)"m1", (Object)ColumnType.LONG, (Object)"m2", (Object)ColumnType.STRING)));
        Assert.assertTrue((boolean)mergedSignature.isPresent());
        RowSignature.Builder rowSignatureBuilder = RowSignature.builder();
        rowSignatureBuilder.add("__time", ColumnType.LONG);
        rowSignatureBuilder.add("dim1", ColumnType.STRING);
        rowSignatureBuilder.add("cnt", ColumnType.LONG);
        rowSignatureBuilder.add("m1", ColumnType.DOUBLE);
        rowSignatureBuilder.add("unique_dim1", ColumnType.ofComplex((String)"hyperUnique"));
        rowSignatureBuilder.add("m2", ColumnType.STRING);
        Assert.assertEquals((Object)rowSignatureBuilder.build(), mergedSignature.get());
    }

    @Test
    public void testMergeOrCreateRowSignatureAbsoluteSchema() throws InterruptedException {
        CoordinatorSegmentMetadataCache schema = this.buildSchemaMarkAndTableLatch();
        AvailableSegmentMetadata availableSegmentMetadata = schema.getAvailableSegmentMetadata("foo", this.segment1.getId());
        Optional mergedSignature = schema.mergeOrCreateRowSignature(this.segment1.getId(), availableSegmentMetadata.getRowSignature(), new SegmentSchemas.SegmentSchema("foo", this.segment1.getId().toString(), false, Integer.valueOf(1000), (List)ImmutableList.of((Object)"__time", (Object)"cnt", (Object)"dim2"), (List)ImmutableList.of(), (Map)ImmutableMap.of((Object)"__time", (Object)ColumnType.LONG, (Object)"dim2", (Object)ColumnType.STRING, (Object)"cnt", (Object)ColumnType.LONG)));
        Assert.assertTrue((boolean)mergedSignature.isPresent());
        RowSignature.Builder rowSignatureBuilder = RowSignature.builder();
        rowSignatureBuilder.add("__time", ColumnType.LONG);
        rowSignatureBuilder.add("cnt", ColumnType.LONG);
        rowSignatureBuilder.add("dim2", ColumnType.STRING);
        Assert.assertEquals((Object)rowSignatureBuilder.build(), mergedSignature.get());
    }

    @Test
    public void testRealtimeSchemaAnnouncement() throws InterruptedException, IOException {
        final CountDownLatch schemaAddedLatch = new CountDownLatch(1);
        CentralizedDatasourceSchemaConfig centralizedDatasourceSchemaConfig = new CentralizedDatasourceSchemaConfig();
        centralizedDatasourceSchemaConfig.setEnabled(true);
        centralizedDatasourceSchemaConfig.setAnnounceRealtimeSegmentSchema(true);
        CoordinatorSegmentMetadataCache schema = new CoordinatorSegmentMetadataCache(this.getQueryLifecycleFactory((QuerySegmentWalker)this.walker), this.serverView, SEGMENT_CACHE_CONFIG_DEFAULT, (Escalator)new NoopEscalator(), new InternalQueryConfig(), new NoopServiceEmitter(), centralizedDatasourceSchemaConfig){

            void updateSchemaForSegments(SegmentSchemas segmentSchemas) {
                super.updateSchemaForSegments(segmentSchemas);
                schemaAddedLatch.countDown();
            }
        };
        schema.start();
        schema.awaitInitialization();
        AvailableSegmentMetadata availableSegmentMetadata = schema.getAvailableSegmentMetadata("foo3", this.realtimeSegment1.getId());
        Assert.assertNull((Object)availableSegmentMetadata.getRowSignature());
        schema.refresh(this.walker.getSegments().stream().map(DataSegment::getId).collect(Collectors.toSet()), new HashSet());
        Assert.assertNull((Object)schema.getDatasource("foo3"));
        Assert.assertNotNull((Object)schema.getDatasource("foo"));
        Assert.assertNotNull((Object)schema.getDatasource("foo2"));
        Assert.assertNotNull((Object)schema.getDatasource("some_datasource"));
        this.serverView.addSegmentSchemas(new SegmentSchemas(Collections.singletonList(new SegmentSchemas.SegmentSchema("foo3", this.realtimeSegment1.getId().toString(), false, Integer.valueOf(1000), (List)ImmutableList.of((Object)"__time", (Object)"dim1", (Object)"cnt", (Object)"m1", (Object)"unique_dim1", (Object)"dim2"), (List)ImmutableList.of(), (Map)ImmutableMap.of((Object)"__time", (Object)ColumnType.LONG, (Object)"dim1", (Object)ColumnType.STRING, (Object)"cnt", (Object)ColumnType.LONG, (Object)"m1", (Object)ColumnType.STRING, (Object)"unique_dim1", (Object)ColumnType.ofComplex((String)"hyperUnique"), (Object)"dim2", (Object)ColumnType.STRING)))));
        Assert.assertTrue((boolean)schemaAddedLatch.await(1L, TimeUnit.SECONDS));
        availableSegmentMetadata = schema.getAvailableSegmentMetadata("foo3", this.realtimeSegment1.getId());
        RowSignature.Builder rowSignatureBuilder = RowSignature.builder();
        rowSignatureBuilder.add("__time", ColumnType.LONG);
        rowSignatureBuilder.add("dim1", ColumnType.STRING);
        rowSignatureBuilder.add("cnt", ColumnType.LONG);
        rowSignatureBuilder.add("m1", ColumnType.STRING);
        rowSignatureBuilder.add("unique_dim1", ColumnType.ofComplex((String)"hyperUnique"));
        rowSignatureBuilder.add("dim2", ColumnType.STRING);
        Assert.assertEquals((Object)rowSignatureBuilder.build(), (Object)availableSegmentMetadata.getRowSignature());
    }

    @Test
    public void testRealtimeSchemaAnnouncementDataSourceSchemaUpdated() throws InterruptedException {
        final CountDownLatch refresh1Latch = new CountDownLatch(1);
        final CountDownLatch refresh2Latch = new CountDownLatch(1);
        CentralizedDatasourceSchemaConfig centralizedDatasourceSchemaConfig = new CentralizedDatasourceSchemaConfig();
        centralizedDatasourceSchemaConfig.setEnabled(true);
        centralizedDatasourceSchemaConfig.setAnnounceRealtimeSegmentSchema(true);
        CoordinatorSegmentMetadataCache schema = new CoordinatorSegmentMetadataCache(this.getQueryLifecycleFactory((QuerySegmentWalker)this.walker), this.serverView, SEGMENT_CACHE_CONFIG_DEFAULT, (Escalator)new NoopEscalator(), new InternalQueryConfig(), new NoopServiceEmitter(), centralizedDatasourceSchemaConfig){

            public void refresh(Set<SegmentId> segmentsToRefresh, Set<String> dataSourcesToRebuild) throws IOException {
                super.refresh(segmentsToRefresh, dataSourcesToRebuild);
                if (refresh1Latch.getCount() == 0L) {
                    refresh2Latch.countDown();
                } else {
                    refresh1Latch.countDown();
                }
            }
        };
        schema.start();
        schema.awaitInitialization();
        Assert.assertTrue((boolean)refresh1Latch.await(10L, TimeUnit.SECONDS));
        AvailableSegmentMetadata availableSegmentMetadata = schema.getAvailableSegmentMetadata("foo3", this.realtimeSegment1.getId());
        Assert.assertNull((Object)availableSegmentMetadata.getRowSignature());
        Assert.assertNull((Object)schema.getDatasource("foo3"));
        Assert.assertNotNull((Object)schema.getDatasource("foo"));
        Assert.assertNotNull((Object)schema.getDatasource("foo2"));
        Assert.assertNotNull((Object)schema.getDatasource("some_datasource"));
        this.serverView.addSegmentSchemas(new SegmentSchemas(Collections.singletonList(new SegmentSchemas.SegmentSchema("foo3", this.realtimeSegment1.getId().toString(), false, Integer.valueOf(1000), (List)ImmutableList.of((Object)"__time", (Object)"dim1", (Object)"cnt", (Object)"m1", (Object)"unique_dim1", (Object)"dim2"), (List)ImmutableList.of(), (Map)ImmutableMap.of((Object)"__time", (Object)ColumnType.LONG, (Object)"dim1", (Object)ColumnType.STRING, (Object)"cnt", (Object)ColumnType.LONG, (Object)"m1", (Object)ColumnType.STRING, (Object)"unique_dim1", (Object)ColumnType.ofComplex((String)"hyperUnique"), (Object)"dim2", (Object)ColumnType.STRING)))));
        Assert.assertTrue((boolean)refresh2Latch.await(10L, TimeUnit.SECONDS));
        Assert.assertNotNull((Object)schema.getDatasource("foo3"));
        Assert.assertNotNull((Object)schema.getDatasource("foo"));
        Assert.assertNotNull((Object)schema.getDatasource("foo2"));
        Assert.assertNotNull((Object)schema.getDatasource("some_datasource"));
        RowSignature.Builder rowSignatureBuilder = RowSignature.builder();
        rowSignatureBuilder.add("__time", ColumnType.LONG);
        rowSignatureBuilder.add("dim1", ColumnType.STRING);
        rowSignatureBuilder.add("cnt", ColumnType.LONG);
        rowSignatureBuilder.add("m1", ColumnType.STRING);
        rowSignatureBuilder.add("unique_dim1", ColumnType.ofComplex((String)"hyperUnique"));
        rowSignatureBuilder.add("dim2", ColumnType.STRING);
        Assert.assertEquals((Object)rowSignatureBuilder.build(), (Object)schema.getDatasource("foo3").getRowSignature());
    }
}

