/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Ordering;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.MapUtils;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.query.TableDataSource;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.segment.ReferenceCountingSegment;
import org.apache.druid.segment.Segment;
import org.apache.druid.segment.SegmentLazyLoadFailCallback;
import org.apache.druid.segment.StorageAdapter;
import org.apache.druid.segment.loading.SegmentLoader;
import org.apache.druid.segment.loading.SegmentLoadingException;
import org.apache.druid.server.SegmentManager;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.SegmentId;
import org.apache.druid.timeline.VersionedIntervalTimeline;
import org.apache.druid.timeline.partition.NoneShardSpec;
import org.apache.druid.timeline.partition.NumberedOverwriteShardSpec;
import org.apache.druid.timeline.partition.ShardSpec;
import org.joda.time.Interval;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class SegmentManagerTest {
    private static final SegmentLoader SEGMENT_LOADER = new SegmentLoader(){

        public ReferenceCountingSegment getSegment(DataSegment segment, boolean lazy, SegmentLazyLoadFailCallback loadFailed) {
            return ReferenceCountingSegment.wrapSegment((Segment)new SegmentForTesting(MapUtils.getString((Map)segment.getLoadSpec(), (String)"version"), (Interval)segment.getLoadSpec().get("interval")), (ShardSpec)segment.getShardSpec());
        }

        public void cleanup(DataSegment segment) {
        }

        public void loadSegmentIntoPageCache(DataSegment segment, ExecutorService exec) {
        }
    };
    private static final List<DataSegment> SEGMENTS = ImmutableList.of((Object)new DataSegment("small_source", Intervals.of((String)"0/1000"), "0", (Map)ImmutableMap.of((Object)"interval", (Object)Intervals.of((String)"0/1000"), (Object)"version", (Object)0), new ArrayList(), new ArrayList(), (ShardSpec)NoneShardSpec.instance(), Integer.valueOf(0), 10L), (Object)new DataSegment("small_source", Intervals.of((String)"1000/2000"), "0", (Map)ImmutableMap.of((Object)"interval", (Object)Intervals.of((String)"1000/2000"), (Object)"version", (Object)0), new ArrayList(), new ArrayList(), (ShardSpec)NoneShardSpec.instance(), Integer.valueOf(0), 10L), (Object)new DataSegment("large_source", Intervals.of((String)"0/1000"), "0", (Map)ImmutableMap.of((Object)"interval", (Object)Intervals.of((String)"0/1000"), (Object)"version", (Object)0), new ArrayList(), new ArrayList(), (ShardSpec)NoneShardSpec.instance(), Integer.valueOf(0), 100L), (Object)new DataSegment("large_source", Intervals.of((String)"1000/2000"), "0", (Map)ImmutableMap.of((Object)"interval", (Object)Intervals.of((String)"1000/2000"), (Object)"version", (Object)0), new ArrayList(), new ArrayList(), (ShardSpec)NoneShardSpec.instance(), Integer.valueOf(0), 100L), (Object)new DataSegment("large_source", Intervals.of((String)"1000/2000"), "1", (Map)ImmutableMap.of((Object)"interval", (Object)Intervals.of((String)"1000/2000"), (Object)"version", (Object)1), new ArrayList(), new ArrayList(), (ShardSpec)NoneShardSpec.instance(), Integer.valueOf(1), 100L));
    private ExecutorService executor;
    private SegmentManager segmentManager;

    @Before
    public void setup() {
        this.segmentManager = new SegmentManager(SEGMENT_LOADER);
        this.executor = Execs.multiThreaded((int)SEGMENTS.size(), (String)"SegmentManagerTest-%d");
    }

    @After
    public void tearDown() {
        this.executor.shutdownNow();
    }

    @Test
    public void testLoadSegment() throws ExecutionException, InterruptedException, SegmentLoadingException {
        List futures = SEGMENTS.stream().map(segment -> this.executor.submit(() -> this.segmentManager.loadSegment(segment, false, SegmentLazyLoadFailCallback.NOOP))).collect(Collectors.toList());
        for (Future eachFuture : futures) {
            Assert.assertTrue((boolean)((Boolean)eachFuture.get()));
        }
        this.assertResult(SEGMENTS);
    }

    @Test
    public void testDropSegment() throws SegmentLoadingException, ExecutionException, InterruptedException {
        for (DataSegment eachSegment : SEGMENTS) {
            Assert.assertTrue((boolean)this.segmentManager.loadSegment(eachSegment, false, SegmentLazyLoadFailCallback.NOOP));
        }
        List futures = ImmutableList.of((Object)SEGMENTS.get(0), (Object)SEGMENTS.get(2)).stream().map(segment -> this.executor.submit(() -> {
            this.segmentManager.dropSegment(segment);
            return null;
        })).collect(Collectors.toList());
        for (Future eachFuture : futures) {
            eachFuture.get();
        }
        this.assertResult((List<DataSegment>)ImmutableList.of((Object)SEGMENTS.get(1), (Object)SEGMENTS.get(3), (Object)SEGMENTS.get(4)));
    }

    @Test
    public void testLoadDropSegment() throws SegmentLoadingException, ExecutionException, InterruptedException {
        Assert.assertTrue((boolean)this.segmentManager.loadSegment(SEGMENTS.get(0), false, SegmentLazyLoadFailCallback.NOOP));
        Assert.assertTrue((boolean)this.segmentManager.loadSegment(SEGMENTS.get(2), false, SegmentLazyLoadFailCallback.NOOP));
        List loadFutures = ImmutableList.of((Object)SEGMENTS.get(1), (Object)SEGMENTS.get(3), (Object)SEGMENTS.get(4)).stream().map(segment -> this.executor.submit(() -> this.segmentManager.loadSegment(segment, false, SegmentLazyLoadFailCallback.NOOP))).collect(Collectors.toList());
        List dropFutures = ImmutableList.of((Object)SEGMENTS.get(0), (Object)SEGMENTS.get(2)).stream().map(segment -> this.executor.submit(() -> {
            this.segmentManager.dropSegment(segment);
            return null;
        })).collect(Collectors.toList());
        for (Future eachFuture : loadFutures) {
            Assert.assertTrue((boolean)((Boolean)eachFuture.get()));
        }
        for (Future eachFuture : dropFutures) {
            eachFuture.get();
        }
        this.assertResult((List<DataSegment>)ImmutableList.of((Object)SEGMENTS.get(1), (Object)SEGMENTS.get(3), (Object)SEGMENTS.get(4)));
    }

    @Test
    public void testLoadDuplicatedSegmentsSequentially() throws SegmentLoadingException {
        for (DataSegment segment : SEGMENTS) {
            Assert.assertTrue((boolean)this.segmentManager.loadSegment(segment, false, SegmentLazyLoadFailCallback.NOOP));
        }
        Assert.assertFalse((boolean)this.segmentManager.loadSegment(SEGMENTS.get(0), false, SegmentLazyLoadFailCallback.NOOP));
        this.assertResult(SEGMENTS);
    }

    @Test
    public void testLoadDuplicatedSegmentsInParallel() throws ExecutionException, InterruptedException, SegmentLoadingException {
        List futures = ImmutableList.of((Object)SEGMENTS.get(0), (Object)SEGMENTS.get(0), (Object)SEGMENTS.get(0)).stream().map(segment -> this.executor.submit(() -> this.segmentManager.loadSegment(segment, false, SegmentLazyLoadFailCallback.NOOP))).collect(Collectors.toList());
        int numSucceededFutures = 0;
        int numFailedFutures = 0;
        for (Future future : futures) {
            numSucceededFutures += (Boolean)future.get() != false ? 1 : 0;
            numFailedFutures += (Boolean)future.get() != false ? 0 : 1;
        }
        Assert.assertEquals((long)1L, (long)numSucceededFutures);
        Assert.assertEquals((long)2L, (long)numFailedFutures);
        this.assertResult((List<DataSegment>)ImmutableList.of((Object)SEGMENTS.get(0)));
    }

    @Test
    public void testNonExistingSegmentsSequentially() throws SegmentLoadingException {
        Assert.assertTrue((boolean)this.segmentManager.loadSegment(SEGMENTS.get(0), false, SegmentLazyLoadFailCallback.NOOP));
        this.segmentManager.dropSegment(SEGMENTS.get(2));
        this.assertResult((List<DataSegment>)ImmutableList.of((Object)SEGMENTS.get(0)));
    }

    @Test
    public void testNonExistingSegmentsInParallel() throws SegmentLoadingException, ExecutionException, InterruptedException {
        this.segmentManager.loadSegment(SEGMENTS.get(0), false, SegmentLazyLoadFailCallback.NOOP);
        List futures = ImmutableList.of((Object)SEGMENTS.get(1), (Object)SEGMENTS.get(2)).stream().map(segment -> this.executor.submit(() -> {
            this.segmentManager.dropSegment(segment);
            return null;
        })).collect(Collectors.toList());
        for (Future future : futures) {
            future.get();
        }
        this.assertResult((List<DataSegment>)ImmutableList.of((Object)SEGMENTS.get(0)));
    }

    @Test
    public void testRemoveEmptyTimeline() throws SegmentLoadingException {
        this.segmentManager.loadSegment(SEGMENTS.get(0), false, SegmentLazyLoadFailCallback.NOOP);
        this.assertResult((List<DataSegment>)ImmutableList.of((Object)SEGMENTS.get(0)));
        Assert.assertEquals((long)1L, (long)this.segmentManager.getDataSources().size());
        this.segmentManager.dropSegment(SEGMENTS.get(0));
        Assert.assertEquals((long)0L, (long)this.segmentManager.getDataSources().size());
    }

    @Test
    public void testGetNonExistingTimeline() {
        Assert.assertEquals(Optional.empty(), (Object)this.segmentManager.getTimeline(new TableDataSource("nonExisting").getAnalysis()));
    }

    @Test
    public void testLoadAndDropNonRootGenerationSegment() throws SegmentLoadingException {
        DataSegment segment = new DataSegment("small_source", Intervals.of((String)"0/1000"), "0", (Map)ImmutableMap.of((Object)"interval", (Object)Intervals.of((String)"0/1000"), (Object)"version", (Object)0), new ArrayList(), new ArrayList(), (ShardSpec)new NumberedOverwriteShardSpec(32778, 10, 20, 1, 1), Integer.valueOf(0), 10L);
        this.segmentManager.loadSegment(segment, false, SegmentLazyLoadFailCallback.NOOP);
        this.assertResult((List<DataSegment>)ImmutableList.of((Object)segment));
        this.segmentManager.dropSegment(segment);
        this.assertResult((List<DataSegment>)ImmutableList.of());
    }

    private void assertResult(List<DataSegment> expectedExistingSegments) throws SegmentLoadingException {
        Map<String, Long> expectedDataSourceSizes = expectedExistingSegments.stream().collect(Collectors.toMap(DataSegment::getDataSource, DataSegment::getSize, Long::sum));
        Map<String, Long> expectedDataSourceCounts = expectedExistingSegments.stream().collect(Collectors.toMap(DataSegment::getDataSource, segment -> 1L, Long::sum));
        Set expectedDataSourceNames = expectedExistingSegments.stream().map(DataSegment::getDataSource).collect(Collectors.toSet());
        HashMap<String, VersionedIntervalTimeline> expectedTimelines = new HashMap<String, VersionedIntervalTimeline>();
        for (DataSegment segment2 : expectedExistingSegments) {
            VersionedIntervalTimeline expectedTimeline = expectedTimelines.computeIfAbsent(segment2.getDataSource(), k -> new VersionedIntervalTimeline((Comparator)Ordering.natural()));
            expectedTimeline.add(segment2.getInterval(), (Object)segment2.getVersion(), segment2.getShardSpec().createChunk((Object)ReferenceCountingSegment.wrapSegment((Segment)SEGMENT_LOADER.getSegment(segment2, false, SegmentLazyLoadFailCallback.NOOP), (ShardSpec)segment2.getShardSpec())));
        }
        Assert.assertEquals(expectedDataSourceNames, (Object)this.segmentManager.getDataSourceNames());
        Assert.assertEquals(expectedDataSourceCounts, (Object)this.segmentManager.getDataSourceCounts());
        Assert.assertEquals(expectedDataSourceSizes, (Object)this.segmentManager.getDataSourceSizes());
        Map dataSources = this.segmentManager.getDataSources();
        Assert.assertEquals((long)expectedTimelines.size(), (long)dataSources.size());
        dataSources.forEach((sourceName, dataSourceState) -> {
            Assert.assertEquals((long)((Long)expectedDataSourceCounts.get(sourceName)), (long)dataSourceState.getNumSegments());
            Assert.assertEquals((long)((Long)expectedDataSourceSizes.get(sourceName)), (long)dataSourceState.getTotalSegmentSize());
            Assert.assertEquals((Object)((VersionedIntervalTimeline)expectedTimelines.get(sourceName)).getAllTimelineEntries(), (Object)dataSourceState.getTimeline().getAllTimelineEntries());
        });
    }

    private static class SegmentForTesting
    implements Segment {
        private final String version;
        private final Interval interval;
        private final StorageAdapter storageAdapter;

        SegmentForTesting(String version, Interval interval) {
            this.version = version;
            this.interval = interval;
            this.storageAdapter = (StorageAdapter)Mockito.mock(StorageAdapter.class);
            Mockito.when((Object)this.storageAdapter.getNumRows()).thenReturn((Object)1);
        }

        public String getVersion() {
            return this.version;
        }

        public Interval getInterval() {
            return this.interval;
        }

        public SegmentId getId() {
            return SegmentId.dummy((String)this.version);
        }

        public Interval getDataInterval() {
            return this.interval;
        }

        public QueryableIndex asQueryableIndex() {
            throw new UnsupportedOperationException();
        }

        public StorageAdapter asStorageAdapter() {
            return this.storageAdapter;
        }

        public void close() {
        }
    }
}

