/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator;

import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.druid.client.ImmutableDruidServer;
import org.apache.druid.client.ImmutableDruidServerTests;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.metadata.MetadataRuleManager;
import org.apache.druid.server.coordinator.CoordinatorDynamicConfig;
import org.apache.druid.server.coordinator.DruidCluster;
import org.apache.druid.server.coordinator.DruidCoordinatorRuntimeParams;
import org.apache.druid.server.coordinator.ServerHolder;
import org.apache.druid.server.coordinator.duty.BalanceSegments;
import org.apache.druid.server.coordinator.duty.RunRules;
import org.apache.druid.server.coordinator.loading.LoadQueuePeon;
import org.apache.druid.server.coordinator.loading.SegmentLoadQueueManager;
import org.apache.druid.server.coordinator.loading.TestLoadQueuePeon;
import org.apache.druid.server.coordinator.rules.PeriodLoadRule;
import org.apache.druid.server.coordinator.rules.Rule;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.SegmentId;
import org.apache.druid.timeline.partition.NoneShardSpec;
import org.apache.druid.timeline.partition.ShardSpec;
import org.easymock.EasyMock;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.Interval;
import org.joda.time.Period;
import org.joda.time.ReadableInstant;
import org.junit.Before;

public class BalanceSegmentsProfiler {
    private static final int MAX_SEGMENTS_TO_MOVE = 5;
    private SegmentLoadQueueManager loadQueueManager;
    private ImmutableDruidServer druidServer1;
    private ImmutableDruidServer druidServer2;
    List<DataSegment> segments = new ArrayList<DataSegment>();
    ServiceEmitter emitter;
    MetadataRuleManager manager;
    PeriodLoadRule loadRule = new PeriodLoadRule(new Period((Object)"P5000Y"), null, (Map)ImmutableMap.of((Object)"normal", (Object)3), null);
    List<Rule> rules = ImmutableList.of((Object)this.loadRule);

    @Before
    public void setUp() {
        this.loadQueueManager = new SegmentLoadQueueManager(null, null);
        this.druidServer1 = (ImmutableDruidServer)EasyMock.createMock(ImmutableDruidServer.class);
        this.druidServer2 = (ImmutableDruidServer)EasyMock.createMock(ImmutableDruidServer.class);
        this.emitter = (ServiceEmitter)EasyMock.createMock(ServiceEmitter.class);
        EmittingLogger.registerEmitter((ServiceEmitter)this.emitter);
        this.manager = (MetadataRuleManager)EasyMock.createMock(MetadataRuleManager.class);
    }

    public void bigProfiler() {
        int i;
        Stopwatch watch = Stopwatch.createUnstarted();
        int numSegments = 55000;
        int numServers = 50;
        EasyMock.expect((Object)this.manager.getAllRules()).andReturn((Object)ImmutableMap.of((Object)"test", this.rules)).anyTimes();
        EasyMock.expect((Object)this.manager.getRules((String)EasyMock.anyObject())).andReturn(this.rules).anyTimes();
        EasyMock.expect((Object)this.manager.getRulesWithDefault((String)EasyMock.anyObject())).andReturn(this.rules).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.manager});
        ArrayList<ServerHolder> serverHolderList = new ArrayList<ServerHolder>();
        ArrayList<DataSegment> segments = new ArrayList<DataSegment>();
        for (i = 0; i < numSegments; ++i) {
            segments.add(new DataSegment("datasource" + i, new Interval((ReadableInstant)DateTimes.of((String)"2012-01-01"), (ReadableInstant)DateTimes.of((String)"2012-01-01").plusHours(1)), DateTimes.of((String)"2012-03-01").toString(), new HashMap(), new ArrayList(), new ArrayList(), (ShardSpec)NoneShardSpec.instance(), Integer.valueOf(0), 4L));
        }
        for (i = 0; i < numServers; ++i) {
            ImmutableDruidServer server = (ImmutableDruidServer)EasyMock.createMock(ImmutableDruidServer.class);
            EasyMock.expect((Object)server.getMetadata()).andReturn(null).anyTimes();
            EasyMock.expect((Object)server.getCurrSize()).andReturn((Object)30L).atLeastOnce();
            EasyMock.expect((Object)server.getMaxSize()).andReturn((Object)100L).atLeastOnce();
            EasyMock.expect((Object)server.getTier()).andReturn((Object)"normal").anyTimes();
            EasyMock.expect((Object)server.getName()).andReturn((Object)Integer.toString(i)).atLeastOnce();
            EasyMock.expect((Object)server.getHost()).andReturn((Object)Integer.toString(i)).anyTimes();
            if (i == 0) {
                ImmutableDruidServerTests.expectSegments(server, segments);
            } else {
                ImmutableDruidServerTests.expectSegments(server, Collections.emptyList());
            }
            EasyMock.expect((Object)server.getSegment((SegmentId)EasyMock.anyObject())).andReturn(null).anyTimes();
            EasyMock.replay((Object[])new Object[]{server});
            TestLoadQueuePeon peon = new TestLoadQueuePeon();
            serverHolderList.add(new ServerHolder(server, (LoadQueuePeon)peon));
        }
        DruidCluster druidCluster = DruidCluster.builder().addTier("normal", serverHolderList.toArray(new ServerHolder[0])).build();
        DruidCoordinatorRuntimeParams params = DruidCoordinatorRuntimeParams.newBuilder((DateTime)DateTimes.nowUtc()).withDruidCluster(druidCluster).withUsedSegments(segments).withDynamicConfigs(CoordinatorDynamicConfig.builder().withMaxSegmentsToMove(5).withReplicantLifetime(500).withReplicationThrottleLimit(5).build()).withSegmentAssignerUsing(this.loadQueueManager).withDatabaseRuleManager(this.manager).build();
        BalanceSegments tester = new BalanceSegments(Duration.standardMinutes((long)1L));
        RunRules runner = new RunRules(Set::size);
        watch.start();
        DruidCoordinatorRuntimeParams balanceParams = tester.run(params);
        DruidCoordinatorRuntimeParams assignParams = runner.run(params);
        System.out.println(watch.stop());
    }

    public void profileRun() {
        Stopwatch watch = Stopwatch.createUnstarted();
        TestLoadQueuePeon fromPeon = new TestLoadQueuePeon();
        TestLoadQueuePeon toPeon = new TestLoadQueuePeon();
        EasyMock.expect((Object)this.druidServer1.getName()).andReturn((Object)"from").atLeastOnce();
        EasyMock.expect((Object)this.druidServer1.getCurrSize()).andReturn((Object)30L).atLeastOnce();
        EasyMock.expect((Object)this.druidServer1.getMaxSize()).andReturn((Object)100L).atLeastOnce();
        ImmutableDruidServerTests.expectSegments(this.druidServer1, this.segments);
        EasyMock.expect((Object)this.druidServer1.getSegment((SegmentId)EasyMock.anyObject())).andReturn(null).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.druidServer1});
        EasyMock.expect((Object)this.druidServer2.getName()).andReturn((Object)"to").atLeastOnce();
        EasyMock.expect((Object)this.druidServer2.getTier()).andReturn((Object)"normal").anyTimes();
        EasyMock.expect((Object)this.druidServer2.getCurrSize()).andReturn((Object)0L).atLeastOnce();
        EasyMock.expect((Object)this.druidServer2.getMaxSize()).andReturn((Object)100L).atLeastOnce();
        ImmutableDruidServerTests.expectSegments(this.druidServer2, Collections.emptyList());
        EasyMock.expect((Object)this.druidServer2.getSegment((SegmentId)EasyMock.anyObject())).andReturn(null).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.druidServer2});
        DruidCoordinatorRuntimeParams params = DruidCoordinatorRuntimeParams.newBuilder((DateTime)DateTimes.nowUtc()).withDruidCluster(DruidCluster.builder().addTier("normal", new ServerHolder[]{new ServerHolder(this.druidServer1, (LoadQueuePeon)fromPeon), new ServerHolder(this.druidServer2, (LoadQueuePeon)toPeon)}).build()).withUsedSegments(this.segments).withDynamicConfigs(CoordinatorDynamicConfig.builder().withMaxSegmentsToMove(5).build()).withSegmentAssignerUsing(this.loadQueueManager).build();
        BalanceSegments tester = new BalanceSegments(Duration.standardMinutes((long)1L));
        watch.start();
        DruidCoordinatorRuntimeParams balanceParams = tester.run(params);
        System.out.println(watch.stop());
    }
}

