/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator.compact;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;
import org.apache.druid.client.indexing.ClientCompactionTaskQueryTuningConfig;
import org.apache.druid.indexer.partitions.DynamicPartitionsSpec;
import org.apache.druid.indexer.partitions.HashedPartitionsSpec;
import org.apache.druid.indexer.partitions.PartitionsSpec;
import org.apache.druid.indexer.partitions.SingleDimensionPartitionsSpec;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.server.coordinator.DataSourceCompactionConfig;
import org.apache.druid.server.coordinator.UserCompactionTaskQueryTuningConfig;
import org.apache.druid.server.coordinator.compact.CompactionStatus;
import org.apache.druid.server.coordinator.compact.NewestSegmentFirstIterator;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.Period;
import org.junit.Assert;
import org.junit.Test;

public class NewestSegmentFirstIteratorTest {
    @Test
    public void testFilterSkipIntervals() {
        Interval totalInterval = Intervals.of((String)"2018-01-01/2019-01-01");
        ImmutableList expectedSkipIntervals = ImmutableList.of((Object)Intervals.of((String)"2018-01-15/2018-03-02"), (Object)Intervals.of((String)"2018-07-23/2018-10-01"), (Object)Intervals.of((String)"2018-10-02/2018-12-25"), (Object)Intervals.of((String)"2018-12-31/2019-01-01"));
        List skipIntervals = NewestSegmentFirstIterator.filterSkipIntervals((Interval)totalInterval, (List)Lists.newArrayList((Object[])new Interval[]{Intervals.of((String)"2017-12-01/2018-01-15"), Intervals.of((String)"2018-03-02/2018-07-23"), Intervals.of((String)"2018-10-01/2018-10-02"), Intervals.of((String)"2018-12-25/2018-12-31")}));
        Assert.assertEquals((Object)expectedSkipIntervals, (Object)skipIntervals);
    }

    @Test
    public void testAddSkipIntervalFromLatestAndSort() {
        ImmutableList expectedIntervals = ImmutableList.of((Object)Intervals.of((String)"2018-12-24/2018-12-25"), (Object)Intervals.of((String)"2018-12-29/2019-01-01"));
        List fullSkipIntervals = NewestSegmentFirstIterator.sortAndAddSkipIntervalFromLatest((DateTime)DateTimes.of((String)"2019-01-01"), (Period)new Period(72, 0, 0, 0), null, (List)ImmutableList.of((Object)Intervals.of((String)"2018-12-30/2018-12-31"), (Object)Intervals.of((String)"2018-12-24/2018-12-25")));
        Assert.assertEquals((Object)expectedIntervals, (Object)fullSkipIntervals);
    }

    @Test
    public void testFindPartitionsSpecFromConfigWithNullTuningConfigReturnDynamicPartitinosSpecWithMaxTotalRowsOfLongMax() {
        DataSourceCompactionConfig config = new DataSourceCompactionConfig("datasource", null, null, null, null, null, null, null, null, null, null, null);
        Assert.assertEquals((Object)new DynamicPartitionsSpec(null, Long.valueOf(Long.MAX_VALUE)), (Object)CompactionStatus.findPartitionsSpecFromConfig((ClientCompactionTaskQueryTuningConfig)ClientCompactionTaskQueryTuningConfig.from((UserCompactionTaskQueryTuningConfig)config.getTuningConfig(), (Integer)config.getMaxRowsPerSegment(), null)));
    }

    @Test
    public void testFindPartitionsSpecFromConfigWithNullMaxTotalRowsReturnLongMaxValue() {
        DataSourceCompactionConfig config = new DataSourceCompactionConfig("datasource", null, null, null, null, new UserCompactionTaskQueryTuningConfig(null, null, null, null, null, (PartitionsSpec)new DynamicPartitionsSpec(null, null), null, null, null, null, null, null, null, null, null, null, null, null, null), null, null, null, null, null, null);
        Assert.assertEquals((Object)new DynamicPartitionsSpec(null, Long.valueOf(Long.MAX_VALUE)), (Object)CompactionStatus.findPartitionsSpecFromConfig((ClientCompactionTaskQueryTuningConfig)ClientCompactionTaskQueryTuningConfig.from((UserCompactionTaskQueryTuningConfig)config.getTuningConfig(), (Integer)config.getMaxRowsPerSegment(), null)));
    }

    @Test
    public void testFindPartitionsSpecFromConfigWithNonNullMaxTotalRowsReturnGivenValue() {
        DataSourceCompactionConfig config = new DataSourceCompactionConfig("datasource", null, null, null, null, new UserCompactionTaskQueryTuningConfig(null, null, null, null, null, (PartitionsSpec)new DynamicPartitionsSpec(null, Long.valueOf(1000L)), null, null, null, null, null, null, null, null, null, null, null, null, null), null, null, null, null, null, null);
        Assert.assertEquals((Object)new DynamicPartitionsSpec(null, Long.valueOf(1000L)), (Object)CompactionStatus.findPartitionsSpecFromConfig((ClientCompactionTaskQueryTuningConfig)ClientCompactionTaskQueryTuningConfig.from((UserCompactionTaskQueryTuningConfig)config.getTuningConfig(), (Integer)config.getMaxRowsPerSegment(), null)));
    }

    @Test
    public void testFindPartitionsSpecFromConfigWithNonNullMaxRowsPerSegmentReturnGivenValue() {
        DataSourceCompactionConfig config = new DataSourceCompactionConfig("datasource", null, null, null, null, new UserCompactionTaskQueryTuningConfig(null, null, null, null, null, (PartitionsSpec)new DynamicPartitionsSpec(Integer.valueOf(100), Long.valueOf(1000L)), null, null, null, null, null, null, null, null, null, null, null, null, null), null, null, null, null, null, null);
        Assert.assertEquals((Object)new DynamicPartitionsSpec(Integer.valueOf(100), Long.valueOf(1000L)), (Object)CompactionStatus.findPartitionsSpecFromConfig((ClientCompactionTaskQueryTuningConfig)ClientCompactionTaskQueryTuningConfig.from((UserCompactionTaskQueryTuningConfig)config.getTuningConfig(), (Integer)config.getMaxRowsPerSegment(), null)));
    }

    @Test
    public void testFindPartitionsSpecFromConfigWithDeprecatedMaxRowsPerSegmentAndMaxTotalRowsReturnGivenValues() {
        DataSourceCompactionConfig config = new DataSourceCompactionConfig("datasource", null, null, Integer.valueOf(100), null, new UserCompactionTaskQueryTuningConfig(null, null, null, Long.valueOf(1000L), null, null, null, null, null, null, null, null, null, null, null, null, null, null, null), null, null, null, null, null, null);
        Assert.assertEquals((Object)new DynamicPartitionsSpec(Integer.valueOf(100), Long.valueOf(1000L)), (Object)CompactionStatus.findPartitionsSpecFromConfig((ClientCompactionTaskQueryTuningConfig)ClientCompactionTaskQueryTuningConfig.from((UserCompactionTaskQueryTuningConfig)config.getTuningConfig(), (Integer)config.getMaxRowsPerSegment(), null)));
    }

    @Test
    public void testFindPartitionsSpecFromConfigWithDeprecatedMaxRowsPerSegmentAndPartitionsSpecIgnoreDeprecatedOne() {
        DataSourceCompactionConfig config = new DataSourceCompactionConfig("datasource", null, null, Integer.valueOf(100), null, new UserCompactionTaskQueryTuningConfig(null, null, null, null, null, (PartitionsSpec)new DynamicPartitionsSpec(null, null), null, null, null, null, null, null, null, null, null, null, null, null, null), null, null, null, null, null, null);
        Assert.assertEquals((Object)new DynamicPartitionsSpec(null, Long.valueOf(Long.MAX_VALUE)), (Object)CompactionStatus.findPartitionsSpecFromConfig((ClientCompactionTaskQueryTuningConfig)ClientCompactionTaskQueryTuningConfig.from((UserCompactionTaskQueryTuningConfig)config.getTuningConfig(), (Integer)config.getMaxRowsPerSegment(), null)));
    }

    @Test
    public void testFindPartitionsSpecFromConfigWithDeprecatedMaxTotalRowsAndPartitionsSpecIgnoreDeprecatedOne() {
        DataSourceCompactionConfig config = new DataSourceCompactionConfig("datasource", null, null, null, null, new UserCompactionTaskQueryTuningConfig(null, null, null, Long.valueOf(1000L), null, (PartitionsSpec)new DynamicPartitionsSpec(null, null), null, null, null, null, null, null, null, null, null, null, null, null, null), null, null, null, null, null, null);
        Assert.assertEquals((Object)new DynamicPartitionsSpec(null, Long.valueOf(Long.MAX_VALUE)), (Object)CompactionStatus.findPartitionsSpecFromConfig((ClientCompactionTaskQueryTuningConfig)ClientCompactionTaskQueryTuningConfig.from((UserCompactionTaskQueryTuningConfig)config.getTuningConfig(), (Integer)config.getMaxRowsPerSegment(), null)));
    }

    @Test
    public void testFindPartitionsSpecFromConfigWithHashPartitionsSpec() {
        DataSourceCompactionConfig config = new DataSourceCompactionConfig("datasource", null, null, null, null, new UserCompactionTaskQueryTuningConfig(null, null, null, null, null, (PartitionsSpec)new HashedPartitionsSpec(null, Integer.valueOf(10), (List)ImmutableList.of((Object)"dim")), null, null, null, null, null, null, null, null, null, null, null, null, null), null, null, null, null, null, null);
        Assert.assertEquals((Object)new HashedPartitionsSpec(null, Integer.valueOf(10), (List)ImmutableList.of((Object)"dim")), (Object)CompactionStatus.findPartitionsSpecFromConfig((ClientCompactionTaskQueryTuningConfig)ClientCompactionTaskQueryTuningConfig.from((UserCompactionTaskQueryTuningConfig)config.getTuningConfig(), (Integer)config.getMaxRowsPerSegment(), null)));
    }

    @Test
    public void testFindPartitionsSpecFromConfigWithRangePartitionsSpec() {
        DataSourceCompactionConfig config = new DataSourceCompactionConfig("datasource", null, null, null, null, new UserCompactionTaskQueryTuningConfig(null, null, null, null, null, (PartitionsSpec)new SingleDimensionPartitionsSpec(Integer.valueOf(10000), null, "dim", false), null, null, null, null, null, null, null, null, null, null, null, null, null), null, null, null, null, null, null);
        Assert.assertEquals((Object)new SingleDimensionPartitionsSpec(Integer.valueOf(10000), null, "dim", false), (Object)CompactionStatus.findPartitionsSpecFromConfig((ClientCompactionTaskQueryTuningConfig)ClientCompactionTaskQueryTuningConfig.from((UserCompactionTaskQueryTuningConfig)config.getTuningConfig(), (Integer)config.getMaxRowsPerSegment(), null)));
    }
}

