/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator.duty;

import org.apache.druid.metadata.MetadataRuleManager;
import org.apache.druid.server.coordinator.DruidCoordinatorConfig;
import org.apache.druid.server.coordinator.DruidCoordinatorRuntimeParams;
import org.apache.druid.server.coordinator.TestDruidCoordinatorConfig;
import org.apache.druid.server.coordinator.duty.KillRules;
import org.apache.druid.server.coordinator.stats.CoordinatorRunStats;
import org.apache.druid.server.coordinator.stats.Stats;
import org.joda.time.Duration;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class KillRulesTest {
    @Mock
    private MetadataRuleManager mockRuleManager;
    @Mock
    private DruidCoordinatorRuntimeParams mockDruidCoordinatorRuntimeParams;
    private KillRules killRules;
    private CoordinatorRunStats runStats;

    @Before
    public void setup() {
        this.runStats = new CoordinatorRunStats();
        Mockito.when((Object)this.mockDruidCoordinatorRuntimeParams.getCoordinatorStats()).thenReturn((Object)this.runStats);
    }

    @Test
    public void testRunSkipIfLastRunLessThanPeriod() {
        TestDruidCoordinatorConfig druidCoordinatorConfig = new TestDruidCoordinatorConfig.Builder().withMetadataStoreManagementPeriod(new Duration((Object)"PT5S")).withCoordinatorRuleKillPeriod(new Duration(Long.MAX_VALUE)).withCoordinatorRuleKillDurationToRetain(new Duration((Object)"PT1S")).withCoordinatorKillMaxSegments(10).withCoordinatorKillIgnoreDurationToRetain(false).build();
        this.killRules = new KillRules((DruidCoordinatorConfig)druidCoordinatorConfig, this.mockRuleManager);
        this.killRules.run(this.mockDruidCoordinatorRuntimeParams);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.mockRuleManager});
    }

    @Test
    public void testRunNotSkipIfLastRunMoreThanPeriod() {
        TestDruidCoordinatorConfig druidCoordinatorConfig = new TestDruidCoordinatorConfig.Builder().withMetadataStoreManagementPeriod(new Duration((Object)"PT5S")).withCoordinatorRuleKillPeriod(new Duration((Object)"PT6S")).withCoordinatorRuleKillDurationToRetain(new Duration((Object)"PT1S")).withCoordinatorKillMaxSegments(10).withCoordinatorKillIgnoreDurationToRetain(false).build();
        this.killRules = new KillRules((DruidCoordinatorConfig)druidCoordinatorConfig, this.mockRuleManager);
        this.killRules.run(this.mockDruidCoordinatorRuntimeParams);
        ((MetadataRuleManager)Mockito.verify((Object)this.mockRuleManager)).removeRulesForEmptyDatasourcesOlderThan(ArgumentMatchers.anyLong());
        Assert.assertTrue((boolean)this.runStats.hasStat(Stats.Kill.RULES));
    }

    @Test
    public void testConstructorFailIfInvalidPeriod() {
        TestDruidCoordinatorConfig druidCoordinatorConfig = new TestDruidCoordinatorConfig.Builder().withMetadataStoreManagementPeriod(new Duration((Object)"PT5S")).withCoordinatorRuleKillPeriod(new Duration((Object)"PT3S")).withCoordinatorRuleKillDurationToRetain(new Duration((Object)"PT1S")).withCoordinatorKillMaxSegments(10).withCoordinatorKillIgnoreDurationToRetain(false).build();
        IllegalArgumentException exception = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> {
            this.killRules = new KillRules((DruidCoordinatorConfig)druidCoordinatorConfig, this.mockRuleManager);
        });
        Assert.assertEquals((Object)"[druid.coordinator.kill.rule.period] must be greater than [druid.coordinator.period.metadataStoreManagementPeriod]", (Object)exception.getMessage());
    }

    @Test
    public void testConstructorFailIfInvalidRetainDuration() {
        TestDruidCoordinatorConfig druidCoordinatorConfig = new TestDruidCoordinatorConfig.Builder().withMetadataStoreManagementPeriod(new Duration((Object)"PT5S")).withCoordinatorRuleKillPeriod(new Duration((Object)"PT6S")).withCoordinatorRuleKillDurationToRetain(new Duration((Object)"PT-1S")).withCoordinatorKillMaxSegments(10).withCoordinatorKillIgnoreDurationToRetain(false).build();
        IllegalArgumentException exception = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> {
            this.killRules = new KillRules((DruidCoordinatorConfig)druidCoordinatorConfig, this.mockRuleManager);
        });
        Assert.assertEquals((Object)"[druid.coordinator.kill.rule.durationToRetain] must be 0 milliseconds or higher", (Object)exception.getMessage());
    }
}

