/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator.duty;

import org.apache.druid.metadata.MetadataSupervisorManager;
import org.apache.druid.server.coordinator.DruidCoordinatorConfig;
import org.apache.druid.server.coordinator.DruidCoordinatorRuntimeParams;
import org.apache.druid.server.coordinator.TestDruidCoordinatorConfig;
import org.apache.druid.server.coordinator.duty.KillSupervisors;
import org.apache.druid.server.coordinator.stats.CoordinatorRunStats;
import org.apache.druid.server.coordinator.stats.Stats;
import org.joda.time.Duration;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class KillSupervisorsTest {
    @Mock
    private MetadataSupervisorManager mockMetadataSupervisorManager;
    @Mock
    private DruidCoordinatorRuntimeParams mockDruidCoordinatorRuntimeParams;
    private KillSupervisors killSupervisors;
    private CoordinatorRunStats runStats;

    @Before
    public void setup() {
        this.runStats = new CoordinatorRunStats();
        Mockito.when((Object)this.mockDruidCoordinatorRuntimeParams.getCoordinatorStats()).thenReturn((Object)this.runStats);
    }

    @Test
    public void testRunSkipIfLastRunLessThanPeriod() {
        TestDruidCoordinatorConfig druidCoordinatorConfig = new TestDruidCoordinatorConfig.Builder().withMetadataStoreManagementPeriod(new Duration((Object)"PT5S")).withCoordinatorSupervisorKillPeriod(new Duration(Long.MAX_VALUE)).withCoordinatorSupervisorKillDurationToRetain(new Duration((Object)"PT1S")).withCoordinatorKillMaxSegments(10).withCoordinatorKillIgnoreDurationToRetain(false).build();
        this.killSupervisors = new KillSupervisors((DruidCoordinatorConfig)druidCoordinatorConfig, this.mockMetadataSupervisorManager);
        this.killSupervisors.run(this.mockDruidCoordinatorRuntimeParams);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.mockMetadataSupervisorManager});
    }

    @Test
    public void testRunNotSkipIfLastRunMoreThanPeriod() {
        TestDruidCoordinatorConfig druidCoordinatorConfig = new TestDruidCoordinatorConfig.Builder().withMetadataStoreManagementPeriod(new Duration((Object)"PT5S")).withCoordinatorSupervisorKillPeriod(new Duration((Object)"PT6S")).withCoordinatorSupervisorKillDurationToRetain(new Duration((Object)"PT1S")).withCoordinatorKillMaxSegments(10).withCoordinatorKillIgnoreDurationToRetain(false).build();
        this.killSupervisors = new KillSupervisors((DruidCoordinatorConfig)druidCoordinatorConfig, this.mockMetadataSupervisorManager);
        this.killSupervisors.run(this.mockDruidCoordinatorRuntimeParams);
        ((MetadataSupervisorManager)Mockito.verify((Object)this.mockMetadataSupervisorManager)).removeTerminatedSupervisorsOlderThan(ArgumentMatchers.anyLong());
        Assert.assertTrue((boolean)this.runStats.hasStat(Stats.Kill.SUPERVISOR_SPECS));
    }

    @Test
    public void testConstructorFailIfInvalidPeriod() {
        TestDruidCoordinatorConfig druidCoordinatorConfig = new TestDruidCoordinatorConfig.Builder().withMetadataStoreManagementPeriod(new Duration((Object)"PT5S")).withCoordinatorSupervisorKillPeriod(new Duration((Object)"PT3S")).withCoordinatorSupervisorKillDurationToRetain(new Duration((Object)"PT1S")).withCoordinatorKillMaxSegments(10).withCoordinatorKillIgnoreDurationToRetain(false).build();
        IllegalArgumentException exception = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> {
            this.killSupervisors = new KillSupervisors((DruidCoordinatorConfig)druidCoordinatorConfig, this.mockMetadataSupervisorManager);
        });
        Assert.assertEquals((Object)"[druid.coordinator.kill.supervisor.period] must be greater than [druid.coordinator.period.metadataStoreManagementPeriod]", (Object)exception.getMessage());
    }

    @Test
    public void testConstructorFailIfInvalidRetainDuration() {
        TestDruidCoordinatorConfig druidCoordinatorConfig = new TestDruidCoordinatorConfig.Builder().withMetadataStoreManagementPeriod(new Duration((Object)"PT5S")).withCoordinatorSupervisorKillPeriod(new Duration((Object)"PT6S")).withCoordinatorSupervisorKillDurationToRetain(new Duration((Object)"PT-1S")).withCoordinatorKillMaxSegments(10).withCoordinatorKillIgnoreDurationToRetain(false).build();
        IllegalArgumentException exception = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> {
            this.killSupervisors = new KillSupervisors((DruidCoordinatorConfig)druidCoordinatorConfig, this.mockMetadataSupervisorManager);
        });
        Assert.assertEquals((Object)"[druid.coordinator.kill.supervisor.durationToRetain] must be 0 milliseconds or higher", (Object)exception.getMessage());
    }
}

