/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator.duty;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.Futures;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.druid.client.indexing.IndexingTotalWorkerCapacityInfo;
import org.apache.druid.indexer.RunnerTaskState;
import org.apache.druid.indexer.TaskLocation;
import org.apache.druid.indexer.TaskState;
import org.apache.druid.indexer.TaskStatusPlus;
import org.apache.druid.java.util.common.CloseableIterators;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.metadata.SegmentsMetadataManager;
import org.apache.druid.rpc.indexing.OverlordClient;
import org.apache.druid.server.coordinator.CoordinatorDynamicConfig;
import org.apache.druid.server.coordinator.DruidCoordinatorConfig;
import org.apache.druid.server.coordinator.DruidCoordinatorRuntimeParams;
import org.apache.druid.server.coordinator.duty.KillUnusedSegments;
import org.apache.druid.server.coordinator.stats.CoordinatorRunStats;
import org.apache.druid.server.coordinator.stats.Stats;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.partition.NoneShardSpec;
import org.apache.druid.timeline.partition.ShardSpec;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.Interval;
import org.joda.time.Period;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePeriod;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class KillUnusedSegmentsTest {
    private static final Duration INDEXING_PERIOD = Duration.standardSeconds((long)1L);
    private static final Duration COORDINATOR_KILL_PERIOD = Duration.standardSeconds((long)1L);
    private static final Duration DURATION_TO_RETAIN = Duration.standardDays((long)1L);
    private static final int MAX_SEGMENTS_TO_KILL = 10;
    private static final String DATASOURCE = "DS1";
    @Mock
    private SegmentsMetadataManager segmentsMetadataManager;
    @Mock
    private OverlordClient overlordClient;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private DruidCoordinatorConfig config;
    @Mock
    private CoordinatorRunStats stats;
    @Mock
    private DruidCoordinatorRuntimeParams params;
    @Mock
    private CoordinatorDynamicConfig coordinatorDynamicConfig;
    private DataSegment yearOldSegment;
    private DataSegment monthOldSegment;
    private DataSegment dayOldSegment;
    private DataSegment hourOldSegment;
    private DataSegment nextDaySegment;
    private DataSegment nextMonthSegment;
    private KillUnusedSegments target;

    @Before
    public void setup() {
        ((DruidCoordinatorRuntimeParams)Mockito.doReturn((Object)this.coordinatorDynamicConfig).when((Object)this.params)).getCoordinatorDynamicConfig();
        ((DruidCoordinatorRuntimeParams)Mockito.doReturn((Object)this.stats).when((Object)this.params)).getCoordinatorStats();
        ((DruidCoordinatorConfig)Mockito.doReturn((Object)COORDINATOR_KILL_PERIOD).when((Object)this.config)).getCoordinatorKillPeriod();
        ((DruidCoordinatorConfig)Mockito.doReturn((Object)DURATION_TO_RETAIN).when((Object)this.config)).getCoordinatorKillDurationToRetain();
        ((DruidCoordinatorConfig)Mockito.doReturn((Object)INDEXING_PERIOD).when((Object)this.config)).getCoordinatorIndexingPeriod();
        ((DruidCoordinatorConfig)Mockito.doReturn((Object)10).when((Object)this.config)).getCoordinatorKillMaxSegments();
        ((DruidCoordinatorConfig)Mockito.doReturn((Object)Duration.parse((String)"PT3154000000S")).when((Object)this.config)).getCoordinatorKillBufferPeriod();
        ((CoordinatorDynamicConfig)Mockito.doReturn(Collections.singleton(DATASOURCE)).when((Object)this.coordinatorDynamicConfig)).getSpecificDataSourcesToKillUnusedSegmentsIn();
        DateTime now = DateTimes.nowUtc();
        this.yearOldSegment = this.createSegmentWithEnd(now.minusDays(365));
        this.monthOldSegment = this.createSegmentWithEnd(now.minusDays(30));
        this.dayOldSegment = this.createSegmentWithEnd(now.minusDays(1));
        this.hourOldSegment = this.createSegmentWithEnd(now.minusHours(1));
        this.nextDaySegment = this.createSegmentWithEnd(now.plusDays(1));
        this.nextMonthSegment = this.createSegmentWithEnd(now.plusDays(30));
        ImmutableList unusedSegments = ImmutableList.of((Object)this.yearOldSegment, (Object)this.monthOldSegment, (Object)this.dayOldSegment, (Object)this.hourOldSegment, (Object)this.nextDaySegment, (Object)this.nextMonthSegment);
        Mockito.when((Object)this.segmentsMetadataManager.getUnusedSegmentIntervals(ArgumentMatchers.anyString(), (DateTime)ArgumentMatchers.any(), (DateTime)ArgumentMatchers.any(), ArgumentMatchers.anyInt(), (DateTime)ArgumentMatchers.any())).thenAnswer(arg_0 -> KillUnusedSegmentsTest.lambda$setup$1((List)unusedSegments, arg_0));
        this.target = new KillUnusedSegments(this.segmentsMetadataManager, this.overlordClient, this.config);
    }

    @Test
    public void testRunWithNoIntervalShouldNotKillAnySegments() {
        ((SegmentsMetadataManager)Mockito.doReturn(null).when((Object)this.segmentsMetadataManager)).getUnusedSegmentIntervals(ArgumentMatchers.anyString(), (DateTime)ArgumentMatchers.any(), (DateTime)ArgumentMatchers.any(), ArgumentMatchers.anyInt(), (DateTime)ArgumentMatchers.any());
        this.mockTaskSlotUsage(1.0, Integer.MAX_VALUE, 1, 10);
        this.target.run(this.params);
        ((OverlordClient)Mockito.verify((Object)this.overlordClient, (VerificationMode)Mockito.never())).runKillTask(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), (Interval)ArgumentMatchers.any(Interval.class), Integer.valueOf(ArgumentMatchers.anyInt()), (DateTime)ArgumentMatchers.any(DateTime.class));
    }

    @Test
    public void testRunWithSpecificDatasourceAndNoIntervalShouldNotKillAnySegments() {
        ((DruidCoordinatorConfig)Mockito.doReturn((Object)Duration.standardDays((long)400L)).when((Object)this.config)).getCoordinatorKillDurationToRetain();
        this.target = new KillUnusedSegments(this.segmentsMetadataManager, this.overlordClient, this.config);
        this.mockTaskSlotUsage(1.0, Integer.MAX_VALUE, 1, 10);
        this.target.run(this.params);
        ((OverlordClient)Mockito.verify((Object)this.overlordClient, (VerificationMode)Mockito.never())).runKillTask(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), (Interval)ArgumentMatchers.any(Interval.class), Integer.valueOf(ArgumentMatchers.anyInt()), (DateTime)ArgumentMatchers.any(DateTime.class));
    }

    @Test
    public void testDurationToRetain() {
        Interval expectedKillInterval = new Interval((ReadableInstant)this.yearOldSegment.getInterval().getStart(), (ReadableInstant)this.dayOldSegment.getInterval().getEnd());
        this.mockTaskSlotUsage(1.0, Integer.MAX_VALUE, 1, 10);
        this.runAndVerifyKillInterval(expectedKillInterval);
        this.verifyState((Map<String, DateTime>)ImmutableMap.of((Object)DATASOURCE, (Object)this.dayOldSegment.getInterval().getEnd()));
        this.verifyStats(9, 1, 10);
    }

    @Test
    public void testNegativeDurationToRetain() {
        ((DruidCoordinatorConfig)Mockito.doReturn((Object)DURATION_TO_RETAIN.negated()).when((Object)this.config)).getCoordinatorKillDurationToRetain();
        this.target = new KillUnusedSegments(this.segmentsMetadataManager, this.overlordClient, this.config);
        Interval expectedKillInterval = new Interval((ReadableInstant)this.yearOldSegment.getInterval().getStart(), (ReadableInstant)this.nextDaySegment.getInterval().getEnd());
        this.mockTaskSlotUsage(1.0, Integer.MAX_VALUE, 1, 10);
        this.runAndVerifyKillInterval(expectedKillInterval);
        this.verifyState((Map<String, DateTime>)ImmutableMap.of((Object)DATASOURCE, (Object)this.nextDaySegment.getInterval().getEnd()));
        this.verifyStats(9, 1, 10);
    }

    @Test
    public void testIgnoreDurationToRetain() {
        ((DruidCoordinatorConfig)Mockito.doReturn((Object)true).when((Object)this.config)).getCoordinatorKillIgnoreDurationToRetain();
        this.target = new KillUnusedSegments(this.segmentsMetadataManager, this.overlordClient, this.config);
        Interval expectedKillInterval = new Interval((ReadableInstant)this.yearOldSegment.getInterval().getStart(), (ReadableInstant)this.nextMonthSegment.getInterval().getEnd());
        this.mockTaskSlotUsage(1.0, Integer.MAX_VALUE, 1, 10);
        this.runAndVerifyKillInterval(expectedKillInterval);
        this.verifyState((Map<String, DateTime>)ImmutableMap.of((Object)DATASOURCE, (Object)this.nextMonthSegment.getInterval().getEnd()));
        this.verifyStats(9, 1, 10);
    }

    @Test
    public void testMaxSegmentsToKill() {
        ((DruidCoordinatorConfig)Mockito.doReturn((Object)1).when((Object)this.config)).getCoordinatorKillMaxSegments();
        this.target = new KillUnusedSegments(this.segmentsMetadataManager, this.overlordClient, this.config);
        this.mockTaskSlotUsage(1.0, Integer.MAX_VALUE, 1, 10);
        this.runAndVerifyKillInterval(this.yearOldSegment.getInterval());
        this.verifyState((Map<String, DateTime>)ImmutableMap.of((Object)DATASOURCE, (Object)this.yearOldSegment.getInterval().getEnd()));
        this.verifyStats(9, 1, 10);
    }

    @Test
    public void testMultipleRuns() {
        ((DruidCoordinatorConfig)Mockito.doReturn((Object)true).when((Object)this.config)).getCoordinatorKillIgnoreDurationToRetain();
        ((DruidCoordinatorConfig)Mockito.doReturn((Object)2).when((Object)this.config)).getCoordinatorKillMaxSegments();
        this.target = new KillUnusedSegments(this.segmentsMetadataManager, this.overlordClient, this.config);
        this.mockTaskSlotUsage(1.0, Integer.MAX_VALUE, 1, 10);
        this.runAndVerifyKillInterval(new Interval((ReadableInstant)this.yearOldSegment.getInterval().getStart(), (ReadableInstant)this.monthOldSegment.getInterval().getEnd()));
        this.verifyState((Map<String, DateTime>)ImmutableMap.of((Object)DATASOURCE, (Object)this.monthOldSegment.getInterval().getEnd()));
        this.mockTaskSlotUsage(1.0, Integer.MAX_VALUE, 1, 10);
        this.runAndVerifyKillInterval(new Interval((ReadableInstant)this.dayOldSegment.getInterval().getStart(), (ReadableInstant)this.hourOldSegment.getInterval().getEnd()));
        this.verifyState((Map<String, DateTime>)ImmutableMap.of((Object)DATASOURCE, (Object)this.hourOldSegment.getInterval().getEnd()));
        this.mockTaskSlotUsage(1.0, Integer.MAX_VALUE, 1, 10);
        this.runAndVerifyKillInterval(new Interval((ReadableInstant)this.nextDaySegment.getInterval().getStart(), (ReadableInstant)this.nextMonthSegment.getInterval().getEnd()));
        this.verifyState((Map<String, DateTime>)ImmutableMap.of((Object)DATASOURCE, (Object)this.nextMonthSegment.getInterval().getEnd()));
        this.verifyStats(9, 1, 10, 3);
    }

    @Test
    public void testKillTaskSlotRatioNoAvailableTaskCapacityForKill() {
        this.mockTaskSlotUsage(0.1, 10, 1, 5);
        this.runAndVerifyNoKill();
        this.verifyState((Map<String, DateTime>)ImmutableMap.of());
        this.verifyStats(0, 0, 0);
    }

    @Test
    public void testMaxKillTaskSlotsNoAvailableTaskCapacityForKill() {
        this.mockTaskSlotUsage(1.0, 3, 3, 10);
        this.runAndVerifyNoKill();
        this.verifyState((Map<String, DateTime>)ImmutableMap.of());
        this.verifyStats(0, 0, 3);
    }

    @Test
    public void testGetKillTaskCapacity() {
        Assert.assertEquals((long)10L, (long)KillUnusedSegments.getKillTaskCapacity((int)10, (double)1.0, (int)Integer.MAX_VALUE));
        Assert.assertEquals((long)0L, (long)KillUnusedSegments.getKillTaskCapacity((int)10, (double)0.0, (int)Integer.MAX_VALUE));
        Assert.assertEquals((long)10L, (long)KillUnusedSegments.getKillTaskCapacity((int)10, (double)Double.POSITIVE_INFINITY, (int)Integer.MAX_VALUE));
        Assert.assertEquals((long)0L, (long)KillUnusedSegments.getKillTaskCapacity((int)10, (double)1.0, (int)0));
        Assert.assertEquals((long)1L, (long)KillUnusedSegments.getKillTaskCapacity((int)10, (double)0.1, (int)3));
        Assert.assertEquals((long)2L, (long)KillUnusedSegments.getKillTaskCapacity((int)10, (double)0.3, (int)2));
    }

    private void runAndVerifyKillInterval(Interval expectedKillInterval) {
        int limit = this.config.getCoordinatorKillMaxSegments();
        ((OverlordClient)Mockito.doReturn((Object)Futures.immediateFuture((Object)"ok")).when((Object)this.overlordClient)).runKillTask(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), (Interval)ArgumentMatchers.any(Interval.class), Integer.valueOf(ArgumentMatchers.anyInt()), (DateTime)ArgumentMatchers.any(DateTime.class));
        this.target.runInternal(this.params);
        ((OverlordClient)Mockito.verify((Object)this.overlordClient, (VerificationMode)Mockito.times((int)1))).runKillTask(ArgumentMatchers.anyString(), (String)ArgumentMatchers.eq((Object)DATASOURCE), (Interval)ArgumentMatchers.eq((Object)expectedKillInterval), Integer.valueOf(ArgumentMatchers.eq((int)limit)), (DateTime)ArgumentMatchers.any());
    }

    private void verifyStats(int availableSlots, int submittedTasks, int maxSlots) {
        this.verifyStats(availableSlots, submittedTasks, maxSlots, 1);
    }

    private void verifyStats(int availableSlots, int submittedTasks, int maxSlots, int times) {
        ((CoordinatorRunStats)Mockito.verify((Object)this.stats, (VerificationMode)Mockito.times((int)times))).add(Stats.Kill.AVAILABLE_SLOTS, (long)availableSlots);
        ((CoordinatorRunStats)Mockito.verify((Object)this.stats, (VerificationMode)Mockito.times((int)times))).add(Stats.Kill.SUBMITTED_TASKS, (long)submittedTasks);
        ((CoordinatorRunStats)Mockito.verify((Object)this.stats, (VerificationMode)Mockito.times((int)times))).add(Stats.Kill.MAX_SLOTS, (long)maxSlots);
    }

    private void verifyState(Map<String, DateTime> expectedDatasourceToLastKillIntervalEnd) {
        Assert.assertEquals(expectedDatasourceToLastKillIntervalEnd, (Object)this.target.getDatasourceToLastKillIntervalEnd());
    }

    private void runAndVerifyNoKill() {
        this.target.run(this.params);
        ((OverlordClient)Mockito.verify((Object)this.overlordClient, (VerificationMode)Mockito.never())).runKillTask(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), (Interval)ArgumentMatchers.any(Interval.class), Integer.valueOf(ArgumentMatchers.anyInt()), (DateTime)ArgumentMatchers.any(DateTime.class));
    }

    private void mockTaskSlotUsage(double killTaskSlotRatio, int maxKillTaskSlots, int numPendingCoordKillTasks, int maxWorkerCapacity) {
        ((CoordinatorDynamicConfig)Mockito.doReturn((Object)killTaskSlotRatio).when((Object)this.coordinatorDynamicConfig)).getKillTaskSlotRatio();
        ((CoordinatorDynamicConfig)Mockito.doReturn((Object)maxKillTaskSlots).when((Object)this.coordinatorDynamicConfig)).getMaxKillTaskSlots();
        ((OverlordClient)Mockito.doReturn((Object)Futures.immediateFuture((Object)new IndexingTotalWorkerCapacityInfo(1, maxWorkerCapacity))).when((Object)this.overlordClient)).getTotalWorkerCapacity();
        ArrayList<TaskStatusPlus> runningCoordinatorIssuedKillTasks = new ArrayList<TaskStatusPlus>();
        for (int i = 0; i < numPendingCoordKillTasks; ++i) {
            runningCoordinatorIssuedKillTasks.add(new TaskStatusPlus("coordinator-issued_taskId_" + i, "groupId_" + i, "kill", DateTimes.EPOCH, DateTimes.EPOCH, TaskState.RUNNING, RunnerTaskState.RUNNING, Long.valueOf(-1L), TaskLocation.unknown(), "datasource", null));
        }
        ((OverlordClient)Mockito.doReturn((Object)Futures.immediateFuture((Object)CloseableIterators.withEmptyBaggage(runningCoordinatorIssuedKillTasks.iterator()))).when((Object)this.overlordClient)).taskStatuses(null, null, Integer.valueOf(0));
    }

    private DataSegment createSegmentWithEnd(DateTime endTime) {
        return new DataSegment(DATASOURCE, new Interval((ReadablePeriod)Period.days((int)1), (ReadableInstant)endTime), DateTimes.nowUtc().toString(), new HashMap(), new ArrayList(), new ArrayList(), (ShardSpec)NoneShardSpec.instance(), Integer.valueOf(1), 0L);
    }

    private static /* synthetic */ Object lambda$setup$1(List unusedSegments, InvocationOnMock invocation) throws Throwable {
        DateTime minStartTime = (DateTime)invocation.getArgument(1);
        DateTime maxEndTime = (DateTime)invocation.getArgument(2);
        long maxEndMillis = maxEndTime.getMillis();
        Long minStartMillis = minStartTime != null ? Long.valueOf(minStartTime.getMillis()) : null;
        List unusedIntervals = unusedSegments.stream().map(DataSegment::getInterval).filter(i -> i.getEnd().getMillis() <= maxEndMillis && (null == minStartMillis || i.getStart().getMillis() >= minStartMillis)).collect(Collectors.toList());
        int limit = (Integer)invocation.getArgument(3);
        return unusedIntervals.size() <= limit ? unusedIntervals : unusedIntervals.subList(0, limit);
    }
}

