/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator.duty;

import com.google.common.collect.Sets;
import java.util.HashSet;
import junitparams.JUnitParamsRunner;
import junitparams.Parameters;
import org.apache.druid.client.DruidServer;
import org.apache.druid.client.ImmutableDruidServer;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.server.coordination.ServerType;
import org.apache.druid.server.coordinator.CoordinatorDynamicConfig;
import org.apache.druid.server.coordinator.DruidCluster;
import org.apache.druid.server.coordinator.DruidCoordinatorRuntimeParams;
import org.apache.druid.server.coordinator.ServerHolder;
import org.apache.druid.server.coordinator.balancer.BalancerStrategy;
import org.apache.druid.server.coordinator.balancer.RandomBalancerStrategy;
import org.apache.druid.server.coordinator.duty.MarkOvershadowedSegmentsAsUnused;
import org.apache.druid.server.coordinator.loading.LoadQueuePeon;
import org.apache.druid.server.coordinator.loading.SegmentLoadQueueManager;
import org.apache.druid.server.coordinator.loading.TestLoadQueuePeon;
import org.apache.druid.server.coordinator.simulate.TestSegmentsMetadataManager;
import org.apache.druid.server.coordinator.stats.CoordinatorRunStats;
import org.apache.druid.server.coordinator.stats.Dimension;
import org.apache.druid.server.coordinator.stats.RowKey;
import org.apache.druid.server.coordinator.stats.Stats;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.SegmentTimeline;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=JUnitParamsRunner.class)
public class MarkOvershadowedSegmentsAsUnusedTest {
    private final DateTime start = DateTimes.of((String)"2012-01-01");
    private final DataSegment segmentV0 = DataSegment.builder().dataSource("test").interval(new Interval((ReadableInstant)this.start, (ReadableInstant)this.start.plusHours(1))).version("0").size(0L).build();
    private final DataSegment segmentV1 = this.segmentV0.withVersion("1");
    private final DataSegment segmentV2 = this.segmentV0.withVersion("2");
    private TestSegmentsMetadataManager segmentsMetadataManager;

    @Before
    public void setup() {
        this.segmentsMetadataManager = new TestSegmentsMetadataManager();
    }

    @Test
    @Parameters(value={"historical", "broker"})
    public void testRun(String serverType) {
        this.segmentsMetadataManager.addSegment(this.segmentV0);
        this.segmentsMetadataManager.addSegment(this.segmentV1);
        this.segmentsMetadataManager.addSegment(this.segmentV2);
        ImmutableDruidServer druidServer = new DruidServer("", "", "", 0L, ServerType.fromString((String)serverType), "", 0).addDataSegment(this.segmentV1).addDataSegment(this.segmentV2).toImmutableDruidServer();
        DruidCluster druidCluster = DruidCluster.builder().add(new ServerHolder(druidServer, (LoadQueuePeon)new TestLoadQueuePeon())).build();
        DruidCoordinatorRuntimeParams params = DruidCoordinatorRuntimeParams.newBuilder((DateTime)DateTimes.nowUtc()).withDataSourcesSnapshot(this.segmentsMetadataManager.getSnapshotOfDataSourcesWithAllUsedSegments()).withDruidCluster(druidCluster).withDynamicConfigs(CoordinatorDynamicConfig.builder().withMarkSegmentAsUnusedDelayMillis(0L).build()).withBalancerStrategy((BalancerStrategy)new RandomBalancerStrategy()).withSegmentAssignerUsing(new SegmentLoadQueueManager(null, null)).build();
        SegmentTimeline timeline = (SegmentTimeline)this.segmentsMetadataManager.getSnapshotOfDataSourcesWithAllUsedSegments().getUsedSegmentsTimelinesPerDataSource().get("test");
        Assert.assertTrue((boolean)timeline.isOvershadowed(this.segmentV0));
        Assert.assertTrue((boolean)timeline.isOvershadowed(this.segmentV1));
        params = new MarkOvershadowedSegmentsAsUnused(this.segmentsMetadataManager::markSegmentsAsUnused).run(params);
        HashSet updatedUsedSegments = Sets.newHashSet(this.segmentsMetadataManager.iterateAllUsedSegments());
        Assert.assertEquals((long)1L, (long)updatedUsedSegments.size());
        Assert.assertTrue((boolean)updatedUsedSegments.contains(this.segmentV2));
        CoordinatorRunStats runStats = params.getCoordinatorStats();
        Assert.assertEquals((long)2L, (long)runStats.get(Stats.Segments.OVERSHADOWED, RowKey.of((Dimension)Dimension.DATASOURCE, (String)"test")));
    }
}

