/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator.rules;

import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.druid.client.DruidServer;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.server.coordination.ServerType;
import org.apache.druid.server.coordinator.CoordinatorDynamicConfig;
import org.apache.druid.server.coordinator.CreateDataSegments;
import org.apache.druid.server.coordinator.DruidCluster;
import org.apache.druid.server.coordinator.DruidCoordinatorRuntimeParams;
import org.apache.druid.server.coordinator.ServerHolder;
import org.apache.druid.server.coordinator.balancer.BalancerStrategy;
import org.apache.druid.server.coordinator.balancer.CachingCostBalancerStrategy;
import org.apache.druid.server.coordinator.balancer.ClusterCostCache;
import org.apache.druid.server.coordinator.balancer.CostBalancerStrategy;
import org.apache.druid.server.coordinator.loading.LoadQueuePeon;
import org.apache.druid.server.coordinator.loading.SegmentLoadQueueManager;
import org.apache.druid.server.coordinator.loading.StrategicSegmentAssigner;
import org.apache.druid.server.coordinator.loading.TestLoadQueuePeon;
import org.apache.druid.server.coordinator.rules.ForeverLoadRule;
import org.apache.druid.server.coordinator.rules.LoadRule;
import org.apache.druid.server.coordinator.rules.SegmentActionHandler;
import org.apache.druid.server.coordinator.stats.CoordinatorRunStats;
import org.apache.druid.server.coordinator.stats.Stats;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.partition.NoneShardSpec;
import org.apache.druid.timeline.partition.ShardSpec;
import org.joda.time.DateTime;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class LoadRuleTest {
    private static final String DS_WIKI = "wiki";
    private ListeningExecutorService exec;
    private BalancerStrategy balancerStrategy;
    private SegmentLoadQueueManager loadQueueManager;
    private final boolean useRoundRobinAssignment;
    private final AtomicInteger serverId = new AtomicInteger();

    @Parameterized.Parameters(name="useRoundRobin = {0}")
    public static List<Boolean> getTestParams() {
        return Arrays.asList(true, false);
    }

    public LoadRuleTest(boolean useRoundRobinAssignment) {
        this.useRoundRobinAssignment = useRoundRobinAssignment;
    }

    @Before
    public void setUp() {
        this.exec = MoreExecutors.listeningDecorator((ExecutorService)Execs.multiThreaded((int)1, (String)"LoadRuleTest-%d"));
        this.balancerStrategy = new CostBalancerStrategy(this.exec);
        this.loadQueueManager = new SegmentLoadQueueManager(null, null);
    }

    @After
    public void tearDown() {
        this.exec.shutdown();
    }

    @Test
    public void testLoadRuleAssignsSegments() {
        ServerHolder server1 = this.createServer("tier1", new DataSegment[0]);
        ServerHolder server2 = this.createServer("tier2", new DataSegment[0]);
        DruidCluster druidCluster = DruidCluster.builder().addTier("tier1", new ServerHolder[]{server1}).addTier("tier2", new ServerHolder[]{server2}).build();
        DataSegment segment = this.createDataSegment(DS_WIKI);
        LoadRule rule = LoadRuleTest.loadForever((Map<String, Integer>)ImmutableMap.of((Object)"tier1", (Object)1, (Object)"tier2", (Object)2));
        Assert.assertTrue((boolean)rule.shouldMatchingSegmentBeLoaded());
        CoordinatorRunStats stats = this.runRuleAndGetStats(rule, segment, druidCluster);
        Assert.assertEquals((long)1L, (long)stats.getSegmentStat(Stats.Segments.ASSIGNED, "tier1", DS_WIKI));
        Assert.assertEquals((long)1L, (long)stats.getSegmentStat(Stats.Segments.ASSIGNED, "tier2", DS_WIKI));
    }

    private CoordinatorRunStats runRuleAndGetStats(LoadRule rule, DataSegment segment, DruidCluster cluster) {
        return this.runRuleAndGetStats(rule, segment, this.makeCoordinatorRuntimeParams(cluster, segment));
    }

    private CoordinatorRunStats runRuleAndGetStats(LoadRule rule, DataSegment segment, DruidCoordinatorRuntimeParams params) {
        StrategicSegmentAssigner segmentAssigner = params.getSegmentAssigner();
        rule.run(segment, (SegmentActionHandler)segmentAssigner);
        return params.getCoordinatorStats();
    }

    private DruidCoordinatorRuntimeParams makeCoordinatorRuntimeParams(DruidCluster druidCluster, DataSegment ... usedSegments) {
        return DruidCoordinatorRuntimeParams.newBuilder((DateTime)DateTimes.nowUtc()).withDruidCluster(druidCluster).withBalancerStrategy(this.balancerStrategy).withUsedSegments(usedSegments).withDynamicConfigs(CoordinatorDynamicConfig.builder().withSmartSegmentLoading(false).withUseRoundRobinSegmentAssignment(this.useRoundRobinAssignment).build()).withSegmentAssignerUsing(this.loadQueueManager).build();
    }

    @Test
    public void testLoadPrimaryAssignDoesNotOverAssign() {
        ServerHolder server1 = this.createServer("tier1", new DataSegment[0]);
        ServerHolder server2 = this.createServer("tier1", new DataSegment[0]);
        DruidCluster druidCluster = DruidCluster.builder().addTier("tier1", new ServerHolder[]{server1, server2}).build();
        LoadRule rule = LoadRuleTest.loadForever((Map<String, Integer>)ImmutableMap.of((Object)"tier1", (Object)1));
        DataSegment segment = this.createDataSegment(DS_WIKI);
        CoordinatorRunStats firstRunStats = this.runRuleAndGetStats(rule, segment, druidCluster);
        Assert.assertEquals((long)1L, (long)firstRunStats.getSegmentStat(Stats.Segments.ASSIGNED, "tier1", segment.getDataSource()));
        Assert.assertEquals((long)1L, (long)(server1.getLoadingSegments().size() + server2.getLoadingSegments().size()));
        CoordinatorRunStats secondRunStats = this.runRuleAndGetStats(rule, segment, druidCluster);
        Assert.assertFalse((boolean)secondRunStats.hasStat(Stats.Segments.ASSIGNED));
        Assert.assertEquals((long)1L, (long)(server1.getLoadingSegments().size() + server2.getLoadingSegments().size()));
    }

    @Test
    @Ignore(value="Enable this test when timeout behaviour is fixed")
    public void testOverAssignForTimedOutSegments() {
        ServerHolder server1 = this.createServer("tier1", new DataSegment[0]);
        ServerHolder server2 = this.createServer("tier1", new DataSegment[0]);
        DruidCluster druidCluster = DruidCluster.builder().addTier("tier1", new ServerHolder[]{server1, server2}).build();
        LoadRule rule = LoadRuleTest.loadForever((Map<String, Integer>)ImmutableMap.of((Object)"tier1", (Object)1));
        DataSegment segment = this.createDataSegment(DS_WIKI);
        CoordinatorRunStats stats = this.runRuleAndGetStats(rule, segment, druidCluster);
        Assert.assertEquals((long)1L, (long)stats.getSegmentStat(Stats.Segments.ASSIGNED, "tier1", segment.getDataSource()));
        CoordinatorRunStats statsAfterLoadPrimary = this.runRuleAndGetStats(rule, segment, druidCluster);
        Assert.assertEquals((long)1L, (long)statsAfterLoadPrimary.getSegmentStat(Stats.Segments.ASSIGNED, "tier1", DS_WIKI));
    }

    @Test
    public void testSkipReplicationForTimedOutSegments() {
        ServerHolder server1 = this.createServer("tier1", new DataSegment[0]);
        ServerHolder server2 = this.createServer("tier1", new DataSegment[0]);
        DruidCluster druidCluster = DruidCluster.builder().addTier("tier1", new ServerHolder[]{server1, server2}).build();
        LoadRule rule = LoadRuleTest.loadForever((Map<String, Integer>)ImmutableMap.of((Object)"tier1", (Object)1));
        DataSegment segment = this.createDataSegment(DS_WIKI);
        CoordinatorRunStats stats = this.runRuleAndGetStats(rule, segment, druidCluster);
        Assert.assertEquals((long)1L, (long)stats.getSegmentStat(Stats.Segments.ASSIGNED, "tier1", segment.getDataSource()));
        CoordinatorRunStats statsAfterLoadPrimary = this.runRuleAndGetStats(rule, segment, druidCluster);
        Assert.assertFalse((boolean)statsAfterLoadPrimary.hasStat(Stats.Segments.ASSIGNED));
    }

    @Test
    public void testLoadUsedSegmentsForAllSegmentGranularityAndCachingCostBalancerStrategy() {
        List<DataSegment> segments = CreateDataSegments.ofDatasource(DS_WIKI).forIntervals(1, Granularities.ALL).withNumPartitions(2).eachOfSizeInMb(100L);
        ServerHolder server1 = this.createServer("tier1", new DataSegment[0]);
        DruidCluster druidCluster = DruidCluster.builder().addTier("tier1", new ServerHolder[]{server1}).build();
        this.balancerStrategy = new CachingCostBalancerStrategy(ClusterCostCache.builder().build(), this.exec);
        LoadRule rule = LoadRuleTest.loadForever((Map<String, Integer>)ImmutableMap.of((Object)"tier1", (Object)1));
        CoordinatorRunStats stats = this.runRuleAndGetStats(rule, segments.get(1), this.makeCoordinatorRuntimeParams(druidCluster, segments.toArray(new DataSegment[0])));
        Assert.assertEquals((long)1L, (long)stats.getSegmentStat(Stats.Segments.ASSIGNED, "tier1", DS_WIKI));
    }

    @Test
    public void testSegmentsAreDroppedIfLoadRuleHasZeroReplicas() {
        DataSegment segment = this.createDataSegment(DS_WIKI);
        ServerHolder serverT11 = this.createServer("tier1", segment);
        ServerHolder serverT12 = this.createServer("tier2", segment);
        ServerHolder serverT21 = this.createServer("tier2", segment);
        DruidCluster druidCluster = DruidCluster.builder().addTier("tier1", new ServerHolder[]{serverT11}).addTier("tier2", new ServerHolder[]{serverT12, serverT21}).build();
        LoadRule rule = LoadRuleTest.loadForever((Map<String, Integer>)ImmutableMap.of((Object)"tier1", (Object)0, (Object)"tier2", (Object)0));
        Assert.assertFalse((boolean)rule.shouldMatchingSegmentBeLoaded());
        CoordinatorRunStats stats = this.runRuleAndGetStats(rule, segment, druidCluster);
        Assert.assertEquals((long)1L, (long)stats.getSegmentStat(Stats.Segments.DROPPED, "tier1", DS_WIKI));
        Assert.assertEquals((long)2L, (long)stats.getSegmentStat(Stats.Segments.DROPPED, "tier2", DS_WIKI));
    }

    @Test
    public void testLoadIgnoresInvalidTiers() {
        ServerHolder server = this.createServer("tier1", new DataSegment[0]);
        DruidCluster druidCluster = DruidCluster.builder().addTier("tier1", new ServerHolder[]{server}).build();
        DataSegment segment = this.createDataSegment(DS_WIKI);
        LoadRule rule = LoadRuleTest.loadForever((Map<String, Integer>)ImmutableMap.of((Object)"invalidTier", (Object)1, (Object)"tier1", (Object)1));
        Assert.assertTrue((boolean)rule.shouldMatchingSegmentBeLoaded());
        CoordinatorRunStats stats = this.runRuleAndGetStats(rule, segment, druidCluster);
        Assert.assertEquals((long)1L, (long)stats.getSegmentStat(Stats.Segments.ASSIGNED, "tier1", DS_WIKI));
        Assert.assertEquals((long)0L, (long)stats.getSegmentStat(Stats.Segments.ASSIGNED, "invalidTier", DS_WIKI));
    }

    @Test
    public void testDropIgnoresInvalidTiers() {
        DataSegment segment = this.createDataSegment(DS_WIKI);
        ServerHolder server1 = this.createServer("tier1", segment);
        ServerHolder server2 = this.createServer("tier1", segment);
        DruidCluster druidCluster = DruidCluster.builder().addTier("tier1", new ServerHolder[]{server1, server2}).build();
        LoadRule rule = LoadRuleTest.loadForever((Map<String, Integer>)ImmutableMap.of((Object)"invalidTier", (Object)1, (Object)"tier1", (Object)1));
        CoordinatorRunStats stats = this.runRuleAndGetStats(rule, segment, druidCluster);
        Assert.assertEquals((long)1L, (long)stats.getSegmentStat(Stats.Segments.DROPPED, "tier1", DS_WIKI));
        Assert.assertEquals((long)0L, (long)stats.getSegmentStat(Stats.Segments.DROPPED, "invalidTier", DS_WIKI));
    }

    @Test
    public void testMaxLoadingQueueSize() {
        TestLoadQueuePeon peon = new TestLoadQueuePeon();
        int maxSegmentsInQueue = 2;
        DruidCluster druidCluster = DruidCluster.builder().addTier("tier1", new ServerHolder[]{new ServerHolder(this.createDruidServer("tier1").toImmutableDruidServer(), (LoadQueuePeon)peon, false, 2, 10)}).build();
        DataSegment dataSegment1 = this.createDataSegment("ds1");
        DataSegment dataSegment2 = this.createDataSegment("ds2");
        DataSegment dataSegment3 = this.createDataSegment("ds3");
        DruidCoordinatorRuntimeParams params = DruidCoordinatorRuntimeParams.newBuilder((DateTime)DateTimes.nowUtc()).withDruidCluster(druidCluster).withBalancerStrategy(this.balancerStrategy).withUsedSegments(new DataSegment[]{dataSegment1, dataSegment2, dataSegment3}).withDynamicConfigs(CoordinatorDynamicConfig.builder().withSmartSegmentLoading(false).withMaxSegmentsInNodeLoadingQueue(2).withUseRoundRobinSegmentAssignment(this.useRoundRobinAssignment).build()).withSegmentAssignerUsing(this.loadQueueManager).build();
        LoadRule rule = LoadRuleTest.loadForever((Map<String, Integer>)ImmutableMap.of((Object)"tier1", (Object)1));
        Assert.assertTrue((boolean)rule.shouldMatchingSegmentBeLoaded());
        CoordinatorRunStats stats1 = this.runRuleAndGetStats(rule, dataSegment1, params);
        CoordinatorRunStats stats2 = this.runRuleAndGetStats(rule, dataSegment2, params);
        CoordinatorRunStats stats3 = this.runRuleAndGetStats(rule, dataSegment3, params);
        Assert.assertEquals((long)1L, (long)stats1.getSegmentStat(Stats.Segments.ASSIGNED, "tier1", dataSegment1.getDataSource()));
        Assert.assertEquals((long)1L, (long)stats2.getSegmentStat(Stats.Segments.ASSIGNED, "tier1", dataSegment2.getDataSource()));
        Assert.assertEquals((long)0L, (long)stats3.getSegmentStat(Stats.Segments.ASSIGNED, "tier1", dataSegment3.getDataSource()));
    }

    @Test
    public void testSegmentIsAssignedOnlyToActiveServer() {
        ServerHolder decommServerT1 = this.createDecommissioningServer("tier1", new DataSegment[0]);
        ServerHolder serverT2 = this.createServer("tier2", new DataSegment[0]);
        DruidCluster druidCluster = DruidCluster.builder().addTier("tier1", new ServerHolder[]{decommServerT1}).addTier("tier2", new ServerHolder[]{serverT2}).build();
        LoadRule rule = LoadRuleTest.loadForever((Map<String, Integer>)ImmutableMap.of((Object)"tier1", (Object)1, (Object)"tier2", (Object)1));
        Assert.assertTrue((boolean)rule.shouldMatchingSegmentBeLoaded());
        DataSegment segment = this.createDataSegment(DS_WIKI);
        CoordinatorRunStats stats = this.runRuleAndGetStats(rule, segment, druidCluster);
        Assert.assertEquals((long)1L, (long)stats.getSegmentStat(Stats.Segments.ASSIGNED, "tier2", DS_WIKI));
        Assert.assertEquals((long)0L, (long)decommServerT1.getLoadingSegments().size());
        Assert.assertTrue((boolean)serverT2.getLoadingSegments().contains(segment));
    }

    @Test
    public void testSegmentIsAssignedOnlyToActiveServers() {
        ServerHolder decommServerT11 = this.createDecommissioningServer("tier1", new DataSegment[0]);
        ServerHolder serverT12 = this.createServer("tier1", new DataSegment[0]);
        ServerHolder serverT21 = this.createServer("tier2", new DataSegment[0]);
        ServerHolder serverT22 = this.createServer("tier2", new DataSegment[0]);
        DataSegment segment = this.createDataSegment(DS_WIKI);
        DruidCluster druidCluster = DruidCluster.builder().addTier("tier1", new ServerHolder[]{decommServerT11, serverT12}).addTier("tier2", new ServerHolder[]{serverT21, serverT22}).build();
        LoadRule rule = LoadRuleTest.loadForever((Map<String, Integer>)ImmutableMap.of((Object)"tier1", (Object)2, (Object)"tier2", (Object)2));
        CoordinatorRunStats stats = this.runRuleAndGetStats(rule, segment, druidCluster);
        Assert.assertEquals((long)1L, (long)stats.getSegmentStat(Stats.Segments.ASSIGNED, "tier1", DS_WIKI));
        Assert.assertTrue((boolean)decommServerT11.getLoadingSegments().isEmpty());
        Assert.assertEquals((long)0L, (long)decommServerT11.getLoadingSegments().size());
        Assert.assertEquals((long)2L, (long)stats.getSegmentStat(Stats.Segments.ASSIGNED, "tier2", DS_WIKI));
    }

    @Test
    public void testDropDuringDecommissioning() {
        DataSegment segment1 = this.createDataSegment("foo1");
        DataSegment segment2 = this.createDataSegment("foo2");
        ServerHolder server1 = this.createDecommissioningServer("tier1", segment1);
        ServerHolder server2 = this.createServer("tier1", segment2);
        DruidCluster druidCluster = DruidCluster.builder().addTier("tier1", new ServerHolder[]{server1, server2}).build();
        DruidCoordinatorRuntimeParams params = this.makeCoordinatorRuntimeParams(druidCluster, segment1, segment2);
        LoadRule rule = LoadRuleTest.loadForever((Map<String, Integer>)ImmutableMap.of((Object)"tier1", (Object)0));
        Assert.assertFalse((boolean)rule.shouldMatchingSegmentBeLoaded());
        CoordinatorRunStats stats = this.runRuleAndGetStats(rule, segment1, params);
        Assert.assertEquals((long)1L, (long)stats.getSegmentStat(Stats.Segments.DROPPED, "tier1", segment1.getDataSource()));
        Assert.assertTrue((boolean)server1.getPeon().getSegmentsToDrop().contains(segment1));
        stats = this.runRuleAndGetStats(rule, segment2, params);
        Assert.assertEquals((long)1L, (long)stats.getSegmentStat(Stats.Segments.DROPPED, "tier1", segment2.getDataSource()));
        Assert.assertTrue((boolean)server2.getPeon().getSegmentsToDrop().contains(segment2));
    }

    @Test
    public void testExtraReplicasAreDroppedFromDecommissioningServer() {
        DataSegment segment1 = this.createDataSegment(DS_WIKI);
        ServerHolder server1 = this.createServer("tier1", segment1);
        ServerHolder server2 = this.createDecommissioningServer("tier1", segment1);
        ServerHolder server3 = this.createServer("tier1", segment1);
        DruidCluster druidCluster = DruidCluster.builder().addTier("tier1", new ServerHolder[]{server1, server2, server3}).build();
        LoadRule rule = LoadRuleTest.loadForever((Map<String, Integer>)ImmutableMap.of((Object)"tier1", (Object)2));
        CoordinatorRunStats stats = this.runRuleAndGetStats(rule, segment1, this.makeCoordinatorRuntimeParams(druidCluster, segment1));
        Assert.assertEquals((long)1L, (long)stats.getSegmentStat(Stats.Segments.DROPPED, "tier1", DS_WIKI));
        Assert.assertEquals((long)0L, (long)server1.getPeon().getSegmentsToDrop().size());
        Assert.assertEquals((long)1L, (long)server2.getPeon().getSegmentsToDrop().size());
        Assert.assertEquals((long)0L, (long)server3.getPeon().getSegmentsToDrop().size());
    }

    private DataSegment createDataSegment(String dataSource) {
        return new DataSegment(dataSource, Intervals.of((String)"0/3000"), DateTimes.nowUtc().toString(), Collections.emptyMap(), Collections.emptyList(), Collections.emptyList(), (ShardSpec)NoneShardSpec.instance(), Integer.valueOf(0), 0L);
    }

    private static LoadRule loadForever(Map<String, Integer> tieredReplicants) {
        return new ForeverLoadRule(tieredReplicants, null);
    }

    private DruidServer createDruidServer(String tier) {
        String serverName = "hist_" + tier + "_" + this.serverId.incrementAndGet();
        return new DruidServer(serverName, serverName, null, 0x280000000L, ServerType.HISTORICAL, tier, 0);
    }

    private ServerHolder createServer(String tier, DataSegment ... segments) {
        DruidServer server = this.createDruidServer(tier);
        for (DataSegment segment : segments) {
            server.addDataSegment(segment);
        }
        return new ServerHolder(server.toImmutableDruidServer(), (LoadQueuePeon)new TestLoadQueuePeon());
    }

    private ServerHolder createDecommissioningServer(String tier, DataSegment ... segments) {
        DruidServer server = this.createDruidServer(tier);
        for (DataSegment segment : segments) {
            server.addDataSegment(segment);
        }
        return new ServerHolder(server.toImmutableDruidServer(), (LoadQueuePeon)new TestLoadQueuePeon(), true);
    }

    @Test
    public void testEquals() {
        EqualsVerifier.forClass(LoadRule.class).withNonnullFields(new String[]{"tieredReplicants"}).withIgnoredFields(new String[]{"shouldSegmentBeLoaded"}).usingGetClass().verify();
    }

    private static class Tier {
        static final String T1 = "tier1";
        static final String T2 = "tier2";

        private Tier() {
        }
    }
}

