/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.catalog.model.table;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Strings;
import java.util.Arrays;
import java.util.List;
import org.apache.druid.catalog.model.CatalogUtils;
import org.apache.druid.catalog.model.ColumnSpec;
import org.apache.druid.catalog.model.Columns;
import org.apache.druid.catalog.model.ModelProperties;
import org.apache.druid.catalog.model.ResolvedTable;
import org.apache.druid.catalog.model.TableDefn;
import org.apache.druid.catalog.model.table.ClusterKeySpec;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.StringUtils;

public class DatasourceDefn
extends TableDefn {
    public static final String SEGMENT_GRANULARITY_PROPERTY = "segmentGranularity";
    public static final String ALL_GRANULARITY = "ALL";
    public static final String TARGET_SEGMENT_ROWS_PROPERTY = "targetSegmentRows";
    public static final String CLUSTER_KEYS_PROPERTY = "clusterKeys";
    public static final String HIDDEN_COLUMNS_PROPERTY = "hiddenColumns";
    public static final String SEALED_PROPERTY = "sealed";
    public static final String TABLE_TYPE = "datasource";

    public DatasourceDefn() {
        super("Datasource", TABLE_TYPE, Arrays.asList(new SegmentGranularityFieldDefn(), new ModelProperties.IntPropertyDefn(TARGET_SEGMENT_ROWS_PROPERTY), new ModelProperties.ListPropertyDefn<ClusterKeySpec>(CLUSTER_KEYS_PROPERTY, "cluster keys", new TypeReference<List<ClusterKeySpec>>(){}), new HiddenColumnsDefn(), new ModelProperties.BooleanPropertyDefn(SEALED_PROPERTY)), null);
    }

    @Override
    protected void validateColumn(ColumnSpec spec) {
        super.validateColumn(spec);
        if (!Columns.isTimeColumn(spec.name()) || spec.dataType() != null) {
            // empty if block
        }
    }

    public static boolean isDatasource(String tableType) {
        return TABLE_TYPE.equals(tableType);
    }

    public static boolean isDatasource(ResolvedTable table) {
        return table.defn() instanceof DatasourceDefn;
    }

    public static class HiddenColumnsDefn
    extends ModelProperties.StringListPropertyDefn {
        public HiddenColumnsDefn() {
            super(DatasourceDefn.HIDDEN_COLUMNS_PROPERTY);
        }

        @Override
        public void validate(Object value, ObjectMapper jsonMapper) {
            if (value == null) {
                return;
            }
            List hiddenColumns = (List)this.decode(value, jsonMapper);
            for (String col : hiddenColumns) {
                if (!"__time".equals(col)) continue;
                throw new IAE(StringUtils.format((String)"Cannot hide column %s", (Object[])new Object[]{col}), new Object[0]);
            }
        }
    }

    public static class SegmentGranularityFieldDefn
    extends ModelProperties.GranularityPropertyDefn {
        public SegmentGranularityFieldDefn() {
            super(DatasourceDefn.SEGMENT_GRANULARITY_PROPERTY);
        }

        @Override
        public void validate(Object value, ObjectMapper jsonMapper) {
            String gran = (String)this.decode(value, jsonMapper);
            if (Strings.isNullOrEmpty((String)gran)) {
                throw new IAE("Segment granularity is required.", new Object[0]);
            }
            CatalogUtils.validateGranularity(gran);
        }
    }
}

