/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.catalog.model.table;

import java.util.HashMap;
import java.util.Map;
import org.apache.druid.catalog.model.CatalogUtils;
import org.apache.druid.catalog.model.ResolvedTable;
import org.apache.druid.catalog.model.TableDefnRegistry;
import org.apache.druid.catalog.model.table.ExternalTableSpec;
import org.apache.druid.catalog.model.table.InputFormatDefn;
import org.apache.druid.catalog.model.table.InputSourceDefn;
import org.apache.druid.catalog.model.table.TableFunction;
import org.apache.druid.java.util.common.IAE;

public class ResolvedExternalTable {
    private final ResolvedTable table;
    protected final Map<String, Object> inputSourceMap;
    protected final Map<String, Object> inputFormatMap;
    private InputSourceDefn inputSourceDefn;
    private InputFormatDefn inputFormatDefn;

    public ResolvedExternalTable(ResolvedTable table) {
        this.table = table;
        Map<String, Object> map = table.mapProperty("source");
        if (map == null || map.isEmpty()) {
            throw new IAE("%s property is required", new Object[]{"source"});
        }
        this.inputSourceMap = new HashMap<String, Object>(map);
        map = table.mapProperty("format");
        this.inputFormatMap = map == null ? null : new HashMap<String, Object>(map);
    }

    public ResolvedTable resolvedTable() {
        return this.table;
    }

    public ResolvedExternalTable resolve(TableDefnRegistry registry) {
        String inputFormatType;
        String inputSourceType = CatalogUtils.getString(this.inputSourceMap, "type");
        if (inputSourceType == null) {
            throw new IAE("Input source type %s is required", new Object[]{"type"});
        }
        this.inputSourceDefn = registry.inputSourceDefnFor(inputSourceType);
        if (this.inputSourceDefn == null) {
            throw new IAE("Input source type %s is not registered", new Object[]{inputSourceType});
        }
        if (this.inputFormatMap != null && (inputFormatType = CatalogUtils.getString(this.inputFormatMap, "type")) != null) {
            this.inputFormatDefn = registry.inputFormatDefnFor(inputFormatType);
            if (this.inputFormatDefn == null) {
                throw new IAE("Input format type %s is not registered", new Object[]{inputFormatType});
            }
        }
        return this;
    }

    public void validate(TableDefnRegistry registry) {
        this.resolve(registry);
        this.inputSourceDefn.validate(this);
        if (this.inputFormatDefn != null) {
            this.inputFormatDefn.validate(this);
        }
    }

    public TableFunction tableFn() {
        return this.inputSourceDefn.partialTableFn(this);
    }

    public ExternalTableSpec convert() {
        return this.inputSourceDefn.convertTable(this);
    }
}

